/*
 * Decompiled with CFR 0.152.
 */
package com.sas.commands.olap;

import com.sas.actionprovider.ActionSupportFilter;
import com.sas.commands.olap.BaseOLAPCommand;
import com.sas.commands.olap.RB;
import com.sas.iquery.dataretrieval.convenience.olap.ShowDetail;
import com.sas.iquery.dataservices.IQDataServicesResourceBundle;
import com.sas.iquery.intelligentquery.BusinessQueryProviderInterface;
import com.sas.iquery.metadata.business.BusinessModel;
import com.sas.iquery.metadata.business.BusinessQuery;
import com.sas.iquery.metadata.business.DrillThroughToDetail;
import com.sas.storage.flattened.sasmdx.FlattenResultSetToTableModelAdapter;
import com.sas.storage.olap.CubeInterface;
import com.sas.storage.olap.Filter;
import com.sas.storage.olap.MetadataInterface;
import com.sas.storage.olap.OLAPDataSetInterface;
import com.sas.storage.olap.OLAPException;
import com.sas.storage.olap.TupleElementInterface;
import com.sas.storage.olap.TupleInterface;
import com.sas.util.log.LoggerRepository2;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.swing.table.TableModel;

public class ShowDetailDataCommand
extends BaseOLAPCommand {
    public static final String RB_KEY = "ShowDetailDataCommand.";
    private TupleElementInterface[] tupleElements;
    private TableModel tableModel;
    private int rowIndex = -1;
    private int columnIndex = -1;
    private TupleInterface[] rowTuples;
    private TupleInterface[] columnTuples;

    public ShowDetailDataCommand() {
    }

    public ShowDetailDataCommand(String name) {
        super(name);
    }

    public ShowDetailDataCommand(String name, boolean swing) {
        super(name, swing);
    }

    public void execute(Object o) {
    }

    public TupleElementInterface[] getTupleElements() {
        return this.tupleElements;
    }

    public void setRowTuples(TupleInterface[] rowTuples) {
        this.rowTuples = rowTuples;
        this.tableModel = null;
    }

    public TupleInterface[] getRowTuples() {
        return this.rowTuples;
    }

    public void setColumnTuples(TupleInterface[] columnTuples) {
        this.columnTuples = columnTuples;
        this.tableModel = null;
    }

    public TupleInterface[] getColumnTuples() {
        return this.columnTuples;
    }

    public void setTupleElements(TupleElementInterface[] tuples) {
        this.tupleElements = tuples;
        this.tableModel = null;
    }

    public int getRowIndex() {
        return this.rowIndex;
    }

    public void setRowIndex(int rowIndex) {
        this.tableModel = null;
        this.rowIndex = rowIndex;
    }

    public int getColumnIndex() {
        return this.columnIndex;
    }

    public void setColumnIndex(int columnIndex) {
        this.tableModel = null;
        this.columnIndex = columnIndex;
    }

    public TableModel getShowDetailDataModel() {
        if (this.tableModel == null) {
            OLAPDataSetInterface model = this.getModel();
            if (model == null) {
                throw new IllegalStateException("model not set");
            }
            TupleElementInterface[] tupleElements = null;
            try {
                tupleElements = this.getTupleElements();
            }
            catch (Exception e) {
                IllegalStateException ise = new IllegalStateException(IQDataServicesResourceBundle.getStringResource((String)"ShowDetail.ShowDetailException.Message.txt"));
                ise.initCause(e);
                throw ise;
            }
            if (tupleElements == null) {
                TupleInterface[] rowTuples = this.getRowTuples();
                TupleInterface[] columnTuples = this.getColumnTuples();
                if (rowTuples == null && columnTuples == null) {
                    throw new IllegalStateException("Neither row or column Tuples set");
                }
                int rowIndex = this.getRowIndex();
                if (rowTuples != null && rowIndex == -1) {
                    throw new IllegalStateException("rowIndex not set");
                }
                int columnIndex = this.getColumnIndex();
                if (columnTuples != null && columnIndex == -1) {
                    throw new IllegalStateException("columnIndex not set");
                }
                Vector<TupleElementInterface> tupleElementVector = new Vector<TupleElementInterface>();
                try {
                    int rt;
                    TupleElementInterface[] elements;
                    if (rowTuples != null && (elements = rowTuples[rowIndex].getElements(0, rowTuples[rowIndex].getTupleDepth())) != null) {
                        for (rt = 0; rt < elements.length; ++rt) {
                            tupleElementVector.addElement(elements[rt]);
                        }
                    }
                    if (columnTuples != null) {
                        elements = columnTuples[columnIndex].getElements(0, columnTuples[columnIndex].getTupleDepth());
                        for (rt = 0; rt < elements.length; ++rt) {
                            tupleElementVector.addElement(elements[rt]);
                        }
                    }
                }
                catch (OLAPException oe) {
                    IllegalStateException ise = new IllegalStateException(IQDataServicesResourceBundle.getStringResource((String)"ShowDetail.ShowDetailException.Message.txt"));
                    ise.initCause(oe);
                    throw ise;
                }
                Object[] objs = tupleElementVector.toArray();
                tupleElements = new TupleElementInterface[objs.length];
                for (int ob = 0; ob < objs.length; ++ob) {
                    tupleElements[ob] = (TupleElementInterface)objs[ob];
                }
            }
            try {
                TableModel tm = this.getShowDetailModel(tupleElements);
                return tm;
            }
            catch (Exception ex) {
                LoggerRepository2.getLogger((String)((Object)((Object)this)).getClass().getName(), null).error(ex.getMessage(), (Throwable)ex);
                IllegalStateException ise = new IllegalStateException(IQDataServicesResourceBundle.getStringResource((String)"ShowDetail.ShowDetailException.Message.txt"));
                ise.initCause(ex.getCause());
                throw ise;
            }
        }
        return this.tableModel;
    }

    private TableModel getShowDetailModel(TupleElementInterface[] tupleElements) {
        ResultSet fsr = null;
        try {
            fsr = ShowDetail.getDetailData((OLAPDataSetInterface)this.model, (TupleElementInterface[])tupleElements, (int)2);
            this.tableModel = new FlattenResultSetToTableModelAdapter(fsr, true);
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            IllegalStateException ise = new IllegalStateException(RB.getStringResource(RB_KEY, "showDetailError.ex.txt"));
            ise.initCause(e);
            throw ise;
        }
        finally {
            try {
                if (fsr != null) {
                    fsr.close();
                }
            }
            catch (SQLException e) {
                LoggerRepository2.getLogger((String)((Object)((Object)this)).getClass().getName(), null).error(e.getMessage(), (Throwable)e);
            }
        }
        return this.tableModel;
    }

    public void setShowDetailDataModel(TableModel tModel) {
        this.tableModel = tModel;
    }

    @Override
    public boolean isSupported(ActionSupportFilter actionFilter) {
        try {
            String cubeName;
            Object model = actionFilter.getAttribute("model");
            if (model instanceof OLAPDataSetInterface && (cubeName = ((OLAPDataSetInterface)model).getCubeName()) != null) {
                List rules;
                BusinessQuery businessQuery;
                BusinessModel businessModel;
                Filter f = new Filter();
                f.setCubeName(cubeName);
                MetadataInterface metadata = ((OLAPDataSetInterface)model).getDatabaseMetadata();
                CubeInterface[] cube = metadata.getCubes(f);
                boolean isDrillThroughEnabled = cube[0].isDrillThroughEnabled();
                if (isDrillThroughEnabled && model instanceof BusinessQueryProviderInterface && (businessModel = (businessQuery = ((BusinessQueryProviderInterface)model).getBusinessQuery()).getBusinessModel()) != null && (rules = businessModel.getObjects(true, DrillThroughToDetail.class)) != null && !rules.isEmpty()) {
                    DrillThroughToDetail dttdRule = (DrillThroughToDetail)rules.get(0);
                    isDrillThroughEnabled = dttdRule.isDrillThroughAllowed();
                }
                return isDrillThroughEnabled;
            }
        }
        catch (Exception e) {
            LoggerRepository2.getLogger((String)((Object)((Object)this)).getClass().getName(), null).error(e.getMessage(), (Throwable)e);
        }
        return false;
    }

    @Override
    public int getCommandStatus(ActionSupportFilter filter) {
        try {
            String cubeName;
            TupleElementInterface[] te;
            Object model = filter.getAttribute("model");
            TupleElementInterface tupleElement = (TupleElementInterface)filter.getAttribute("tupleElement");
            ArrayList<TupleElementInterface> teList = new ArrayList<TupleElementInterface>();
            if (tupleElement == null) {
                int i;
                TupleElementInterface[] te2;
                Object tuples = filter.getAttribute("rowTuples");
                if (tuples != null) {
                    TupleInterface[] rowTuples = (TupleInterface[])tuples;
                    int rowIndex = (Integer)filter.getAttribute("row");
                    te2 = rowTuples[rowIndex].getElements(0, -1);
                    for (i = 0; i < te2.length; ++i) {
                        teList.add(te2[i]);
                    }
                }
                if ((tuples = filter.getAttribute("columnTuples")) != null) {
                    TupleInterface[] colTuples = (TupleInterface[])tuples;
                    int colIndex = (Integer)filter.getAttribute("column");
                    te2 = colTuples[colIndex].getElements(0, -1);
                    for (i = 0; i < te2.length; ++i) {
                        teList.add(te2[i]);
                    }
                }
            } else if (tupleElement != null) {
                te = tupleElement.getTuple().getElements(0, -1);
                for (int i = 0; i < te.length; ++i) {
                    teList.add(te[i]);
                }
            }
            te = teList.toArray(new TupleElementInterface[0]);
            boolean isIQShowDetailEnabled = false;
            if (model instanceof OLAPDataSetInterface) {
                isIQShowDetailEnabled = ShowDetail.isShowDetailValid((OLAPDataSetInterface)((OLAPDataSetInterface)model), (TupleElementInterface[])te);
            }
            if (isIQShowDetailEnabled && (cubeName = ((OLAPDataSetInterface)model).getCubeName()) != null) {
                List rules;
                BusinessQuery businessQuery;
                BusinessModel businessModel;
                Filter f = new Filter();
                f.setCubeName(cubeName);
                MetadataInterface metadata = ((OLAPDataSetInterface)model).getDatabaseMetadata();
                CubeInterface[] cube = metadata.getCubes(f);
                boolean isDrillThroughEnabled = cube[0].isDrillThroughEnabled();
                if (isDrillThroughEnabled && model instanceof BusinessQueryProviderInterface && (businessModel = (businessQuery = ((BusinessQueryProviderInterface)model).getBusinessQuery()).getBusinessModel()) != null && (rules = businessModel.getObjects(true, DrillThroughToDetail.class)) != null && !rules.isEmpty()) {
                    DrillThroughToDetail dttdRule = (DrillThroughToDetail)rules.get(0);
                    isDrillThroughEnabled = dttdRule.isDrillThroughAllowed();
                }
                if (isDrillThroughEnabled) {
                    return 0;
                }
            }
        }
        catch (Exception e) {
            LoggerRepository2.getLogger((String)((Object)((Object)this)).getClass().getName(), null).error(e.getMessage(), (Throwable)e);
        }
        return 2;
    }
}

