/*
 * Decompiled with CFR 0.152.
 */
package com.sas.commands.olap;

import com.sas.actionprovider.ActionSupportFilter;
import com.sas.commands.olap.BaseTupleElementCommand;
import com.sas.commands.olap.OLAPCommandUtil;
import com.sas.iquery.intelligentquery.BusinessQueryProviderInterface;
import com.sas.iquery.metadata.business.BusinessQuery;
import com.sas.iquery.metadata.business.BusinessQueryActionType;
import com.sas.iquery.metadata.business.DataItem;
import com.sas.iquery.metadata.business.DataItemActionType;
import com.sas.iquery.metadata.business.Role;
import com.sas.iquery.metadata.business.StructureOfDataItem;
import com.sas.storage.olap.OLAPDataSetInterface;
import com.sas.storage.olap.TupleElementInterface;
import com.sas.util.log.LoggerRepository2;
import java.util.List;

public class ShiftMeasureCommand
extends BaseTupleElementCommand {
    public static int MOVE_IN = 0;
    public static int MOVE_OUT = 1;
    private int moveType;

    public ShiftMeasureCommand(String name) {
        super(name);
    }

    public ShiftMeasureCommand(String name, boolean swing) {
        super(name, swing);
    }

    public void execute(Object o) {
        this.getModel();
        if (this.model == null) {
            throw new IllegalStateException();
        }
        try {
            BusinessQuery businessQuery = ((BusinessQueryProviderInterface)this.model).getBusinessQuery();
            OLAPCommandUtil.joinMeasures(businessQuery);
            DataItem dataItem = this.getDataItem();
            Role currentRole = businessQuery.getResultItemRole(dataItem);
            List list = businessQuery.getResultItems(currentRole);
            businessQuery.removeResultItems(list);
            int index = list.indexOf(dataItem);
            list.remove(index);
            if (this.moveType == MOVE_OUT) {
                list.add(index + 1, dataItem);
            } else {
                list.add(index - 1, dataItem);
            }
            businessQuery.addResultItems(list, currentRole);
            int axisNumber = this.getAxisIndex();
            this.executeQuery(businessQuery);
            if (axisNumber == 1) {
                this.eventInfo.put("ROW", "INITIALIZE");
            } else if (axisNumber == 0) {
                this.eventInfo.put("COLUMN", "INITIALIZE");
            }
        }
        catch (Exception e) {
            LoggerRepository2.getLogger((String)((Object)((Object)this)).getClass().getName(), null).error(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public boolean isSupported(ActionSupportFilter actionFilter) {
        if (!this.isIQSupported(actionFilter, BusinessQueryActionType.RESULT_ITEM)) {
            return false;
        }
        TupleElementInterface tupleElement = (TupleElementInterface)actionFilter.getAttribute("tupleElement");
        Object model = actionFilter.getAttribute("model");
        return this.isMoveable(tupleElement, model);
    }

    @Override
    public int getCommandStatus(ActionSupportFilter filter) {
        if (!this.isIQSupported(filter, BusinessQueryActionType.RESULT_ITEM)) {
            return 1;
        }
        TupleElementInterface tupleElement = (TupleElementInterface)filter.getAttribute("tupleElement");
        Object model = filter.getAttribute("model");
        return this.getMoveableStatus(tupleElement, model);
    }

    protected boolean isMoveable(TupleElementInterface tupleElement, Object model) {
        return tupleElement != null && model != null;
    }

    protected int getMoveableStatus(TupleElementInterface tupleElement, Object model) {
        try {
            if (!(model instanceof BusinessQueryProviderInterface)) {
                return 1;
            }
            BusinessQuery bq = ((BusinessQueryProviderInterface)model).getBusinessQuery();
            DataItem di = this.getDataItem();
            if (di != null) {
                if (!this.isMeasure(di)) {
                    return 4;
                }
                Role currentRole = bq.getResultItemRole(di);
                List list = bq.getResultItems(currentRole);
                int index = list.indexOf(di);
                int size = list.size();
                int firstMeasureIndex = -1;
                int lastMeasureIndex = -1;
                for (int i = 0; i < size; ++i) {
                    DataItem ri = (DataItem)list.get(i);
                    if (!this.isMeasure(ri)) continue;
                    if (firstMeasureIndex == -1) {
                        firstMeasureIndex = i;
                        lastMeasureIndex = i;
                        continue;
                    }
                    lastMeasureIndex = i;
                }
                if (index == lastMeasureIndex && this.moveType == MOVE_OUT || index == firstMeasureIndex && this.moveType == MOVE_IN) {
                    return 8;
                }
                return 0;
            }
            return 4;
        }
        catch (Exception exception) {
            return 16;
        }
    }

    public void setMoveType(int moveType) {
        this.moveType = moveType;
    }

    public int getMoveType() {
        return this.moveType;
    }

    @Override
    public boolean isIQSupported(ActionSupportFilter actionFilter, BusinessQueryActionType actionType) {
        TupleElementInterface tupleElement = (TupleElementInterface)actionFilter.getAttribute("tupleElement");
        Object model = actionFilter.getAttribute("model");
        if (model instanceof BusinessQueryProviderInterface && model instanceof OLAPDataSetInterface && tupleElement != null) {
            BusinessQuery businessQuery = ((BusinessQueryProviderInterface)model).getBusinessQuery();
            this._dataItem = this.getDataItem(actionFilter);
            DataItem dataItem = this._dataItem;
            if (dataItem != null) {
                return businessQuery.isActionSupported(actionType);
            }
        }
        return false;
    }

    private boolean isMeasure(DataItem dataItem) {
        StructureOfDataItem dataItemStructure = dataItem.getStructure();
        if (dataItemStructure == StructureOfDataItem.STRUCTURE_MEASURE) {
            return true;
        }
        return dataItemStructure == StructureOfDataItem.STRUCTURE_COLUMN && dataItem.getExpressionType() == 2 && dataItem.getUsage() != DataItemActionType.USAGE_CATEGORY;
    }
}

