/*
 * Decompiled with CFR 0.152.
 */
package com.sas.commands.olap;

import com.sas.actionprovider.ActionSupportFilter;
import com.sas.commands.olap.SortCommand;
import com.sas.iquery.intelligentquery.BusinessQueryProviderInterface;
import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.business.BusinessQuery;
import com.sas.iquery.metadata.business.BusinessQueryActionType;
import com.sas.iquery.metadata.business.BusinessQueryProperty;
import com.sas.iquery.metadata.business.DataItem;
import com.sas.iquery.metadata.business.DataItemActionType;
import com.sas.iquery.metadata.business.Role;
import com.sas.storage.olap.OLAPException;
import com.sas.storage.olap.TupleElementInterface;
import com.sas.storage.olap.TupleElementType;
import com.sas.storage.olap.TupleInterface;
import com.sas.util.log.LoggerRepository2;
import java.util.ArrayList;
import java.util.List;

public class PreventLastTupleCellSortCommand
extends SortCommand {
    public PreventLastTupleCellSortCommand(String name) {
        super(name);
        this.sortCategory = 100;
    }

    public PreventLastTupleCellSortCommand(String name, boolean swing) {
        super(name, swing);
        this.sortCategory = 100;
    }

    @Override
    protected boolean isSortable(TupleElementInterface tupleElement) {
        return true;
    }

    @Override
    protected int getSortableStatus(TupleElementInterface tupleElement, Object model) {
        block21: {
            DataItem dataItem = null;
            if (!(model instanceof BusinessQueryProviderInterface)) {
                return 1;
            }
            BusinessQuery bq = ((BusinessQueryProviderInterface)model).getBusinessQuery();
            if (this.sortCategory == 100 && tupleElement != null) {
                try {
                    int index = tupleElement.getTupleElementIndex();
                    int depth = tupleElement.getTuple().getTupleDepth();
                    dataItem = this.getDataItem();
                    if (dataItem == null || index == depth - 1 && !this.isMeasure(dataItem)) {
                        return 4;
                    }
                }
                catch (OLAPException e) {
                    LoggerRepository2.getLogger((String)((Object)((Object)this)).getClass().getName(), null).error(e.getMessage(), (Throwable)e);
                }
            }
            if (this.sortCategory == 100 && this.getSortQueryActionType(bq) == BusinessQueryActionType.SORT_NONE) {
                if (this.isSortPresent(bq)) {
                    return 0;
                }
                return 8;
            }
            try {
                if (tupleElement != null) {
                    boolean isCellSortingPriority = bq.getQueryProperty(BusinessQueryProperty.BUSINESS_QUERY_OLAP_SORT_PRECEDENCE);
                    if (isCellSortingPriority && (dataItem = this.getDataItem()) != null && this.sortCategory == 100) {
                        Role currentRole = bq.getResultItemRole(dataItem);
                        Role sortRole = null;
                        if (currentRole == Role.ROW) {
                            sortRole = Role.COLUMN;
                        } else if (currentRole == Role.COLUMN) {
                            sortRole = Role.ROW;
                        }
                        BusinessQueryActionType bqActionType = bq.getSortDirection(sortRole);
                        BusinessQueryActionType currentType = this.getSortQueryActionType(bq);
                        if (bqActionType == currentType) {
                            int listSize;
                            int itemSize;
                            TupleInterface tuple = tupleElement.getTuple();
                            TupleElementInterface[] elements = tuple.getElements(0, -1);
                            ArrayList<String> itemList = new ArrayList<String>();
                            for (int i = 0; i < elements.length; ++i) {
                                if (elements[i].getType() != TupleElementType.MEASURE) {
                                    itemList.add(elements[i].getName());
                                    continue;
                                }
                                DataItem di = this.findDataItem((BusinessQueryProviderInterface)model, elements[i]);
                                itemList.add((String)di);
                            }
                            List list = bq.getSortCriteria(sortRole);
                            if (itemList != null && list != null && (itemSize = itemList.size()) == (listSize = list.size())) {
                                for (int i = 0; i < itemSize; ++i) {
                                    Object st1 = itemList.get(i);
                                    Object st2 = list.get(i);
                                    if (st1 == null || st2 == null) {
                                        return 0;
                                    }
                                    if (!(st1 instanceof Object[] && st2 instanceof Object[] ? ((Object[])st1).length != 1 || ((Object[])st2).length != 1 || !((Object[])st1)[0].equals(((Object[])st2)[0]) : !st1.equals(st2))) continue;
                                    return 0;
                                }
                                return 8;
                            }
                        }
                    }
                    break block21;
                }
                return 16;
            }
            catch (MetadataException e) {
                LoggerRepository2.getLogger((String)((Object)((Object)this)).getClass().getName(), null).error(e.getMessage(), (Throwable)e);
            }
            catch (OLAPException e) {
                LoggerRepository2.getLogger((String)((Object)((Object)this)).getClass().getName(), null).error(e.getMessage(), (Throwable)e);
            }
        }
        return 0;
    }

    private boolean isSortPresent(BusinessQuery businessQuery) {
        if (businessQuery != null) {
            try {
                List list = businessQuery.getSortCriteria(Role.COLUMN);
                if (list != null && list.size() > 0) {
                    return true;
                }
                list = businessQuery.getSortCriteria(Role.ROW);
                if (list != null && list.size() > 0) {
                    return true;
                }
                list = businessQuery.getResultItems(Role.COLUMN);
                list.addAll(businessQuery.getResultItems(Role.ROW));
                int size = list.size();
                for (int i = 0; i < size; ++i) {
                    DataItem resultItem = (DataItem)list.get(i);
                    if (resultItem.getSortDirection() == DataItemActionType.SORT_NONE) continue;
                    return true;
                }
            }
            catch (MetadataException e) {
                LoggerRepository2.getLogger((String)((Object)((Object)this)).getClass().getName(), null).error(e.getMessage(), (Throwable)e);
            }
        }
        return false;
    }

    private BusinessQueryActionType getSortQueryActionType(BusinessQuery model) {
        switch (this.sortType) {
            case 0: {
                return BusinessQueryActionType.SORT_ASCENDING;
            }
            case 1: {
                return BusinessQueryActionType.SORT_DESCENDING;
            }
            case 2: {
                return BusinessQueryActionType.SORT_HIERARCHICAL_ASCENDING;
            }
            case 3: {
                return BusinessQueryActionType.SORT_HIERARCHICAL_DESCENDING;
            }
            case 10: {
                return BusinessQueryActionType.SORT_NONE;
            }
        }
        return BusinessQueryActionType.SORT_ASCENDING;
    }

    @Override
    public boolean isIQSupported(ActionSupportFilter actionFilter, BusinessQueryActionType actionType) {
        Object model = actionFilter.getAttribute("model");
        if (model instanceof BusinessQueryProviderInterface) {
            BusinessQuery businessQuery = ((BusinessQueryProviderInterface)model).getBusinessQuery();
            this._dataItem = (DataItem)actionFilter.getAttribute("dataItem");
            return businessQuery.isActionSupported(actionType);
        }
        return false;
    }
}

