/*
 * Decompiled with CFR 0.152.
 */
package com.sas.commands.olap;

import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.business.BusinessQuery;
import com.sas.iquery.metadata.business.DataItem;
import com.sas.iquery.metadata.business.Role;
import com.sas.iquery.metadata.business.StructureOfDataItem;
import com.sas.storage.olap.OLAPException;
import com.sas.storage.olap.TupleElementInterface;
import com.sas.storage.olap.TupleInterface;
import com.sas.util.Util;
import java.util.ArrayList;
import java.util.List;

public class OLAPCommandUtil {
    public static void joinMeasures(BusinessQuery businessQuery) throws MetadataException {
        DataItem di;
        int i;
        List list = businessQuery.getResultItems();
        if (OLAPCommandUtil.areMeasuresTogether(list)) {
            return;
        }
        int size = list.size();
        ArrayList<DataItem> mList = new ArrayList<DataItem>(size);
        ArrayList<Role> rList = new ArrayList<Role>(size);
        int startIndex = -1;
        for (i = 0; i < size; ++i) {
            di = (DataItem)list.get(i);
            Role role = businessQuery.getResultItemRole(di);
            if (di.getStructure() == StructureOfDataItem.STRUCTURE_MEASURE) {
                if (startIndex == -1) {
                    startIndex = list.indexOf(di);
                    mList.add(startIndex, di);
                    rList.add(startIndex, role);
                    continue;
                }
                mList.add(++startIndex, di);
                rList.add(startIndex, role);
                continue;
            }
            mList.add(i, di);
            rList.add(i, role);
        }
        businessQuery.removeResultItems(list);
        size = mList.size();
        for (i = 0; i < size; ++i) {
            di = (DataItem)mList.get(i);
            businessQuery.addResultItem(di, (Role)rList.get(i));
        }
    }

    private static boolean areMeasuresTogether(List list) {
        int consecutive = -1;
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            DataItem di = (DataItem)list.get(i);
            if (di.getStructure() != StructureOfDataItem.STRUCTURE_MEASURE) continue;
            if (consecutive == -1 || consecutive == i - 1) {
                consecutive = i;
                continue;
            }
            return false;
        }
        return true;
    }

    public static boolean hasMoreElements(TupleElementInterface element) throws OLAPException {
        TupleInterface tuple = element.getTuple();
        int currentElemIndex = element.getTupleElementIndex();
        if (currentElemIndex > 0 && tuple.getElements(currentElemIndex - 1, 1)[0].isContextual()) {
            return true;
        }
        String elementName = element.getName();
        String currentLevelName = element.getUniqueLevelName();
        int maxCoordinate = element.getMaximumCoordinate();
        int minCoordinate = element.getMinimumCoordinate();
        int currentTupleIndex = tuple.getTupleIndex();
        TupleInterface[] tuples = tuple.getAxis().getTuples(-12, -18);
        if (minCoordinate == 0 && maxCoordinate == tuples.length - 1) {
            return false;
        }
        block0: for (int i = 0; i < tuples.length; ++i) {
            TupleInterface tempTuple = tuples[i];
            if (tempTuple.getTupleIndex() == currentTupleIndex) continue;
            for (int j = 0; j < tempTuple.getTupleDepth(); ++j) {
                TupleElementInterface elem = tempTuple.getElement(j);
                if (!elem.getUniqueLevelName().equals(currentLevelName)) continue;
                if (Util.equal((Object)elem.getName(), (Object)elementName)) continue block0;
                return true;
            }
        }
        return false;
    }
}

