/*
 * Decompiled with CFR 0.152.
 */
package com.sas.commands.olap;

import com.sas.actionprovider.ActionSupportFilter;
import com.sas.commands.olap.BaseTupleElementCommand;
import com.sas.iquery.intelligentquery.BusinessQueryProviderInterface;
import com.sas.iquery.metadata.business.BusinessQuery;
import com.sas.iquery.metadata.business.DataItem;
import com.sas.iquery.metadata.business.DataItemActionType;
import com.sas.iquery.metadata.business.step.StepInterface;
import com.sas.iquery.metadata.business.step.olap.DataItemNavigationFilter;
import com.sas.storage.olap.AxisInterface;
import com.sas.storage.olap.OLAPDataSetInterface;
import com.sas.storage.olap.OLAPUtil;
import com.sas.storage.olap.TupleElementInterface;
import com.sas.storage.olap.TupleElementType;
import com.sas.storage.olap.TupleInterface;
import java.util.List;

public class ExpandAllCommand
extends BaseTupleElementCommand {
    public ExpandAllCommand(String name) {
        super(name);
    }

    public ExpandAllCommand(String name, boolean swing) {
        super(name, swing);
    }

    public void execute(Object o) {
        this.getModel();
        if (this.model == null) {
            throw new IllegalStateException();
        }
        try {
            BusinessQuery businessQuery = ((BusinessQueryProviderInterface)this.model).getBusinessQuery();
            DataItem dataItem = this.getDataItem();
            this.uniqueLevelName = this.getUniqueLevelName();
            TupleElementInterface[] tupleElements = null;
            if (this.uniqueLevelName != null) {
                AxisInterface axis = this.model.getResultSetMetadata().getAxes(0, -1)[this.getAxisIndex()];
                tupleElements = OLAPUtil.getTupleElementsForLevel((int)this.getLevelIndex(this.model, this.uniqueLevelName), (TupleInterface[])axis.getTuples(0, -1), (boolean)false, (int)-1);
            } else {
                this.tupleElement = this.getTupleElement();
                if (this.tupleElement != null) {
                    TupleInterface tuple = this.tupleElement.getTuple();
                    TupleElementInterface[] elements = tuple.getElements(0, -1);
                    int level = 0;
                    for (int i = 0; i < this.tupleElement.getTupleElementIndex(); ++i) {
                        level += elements[i].getSpan();
                    }
                    tupleElements = OLAPUtil.getTupleElementsForLevel((int)level, (TupleInterface[])tuple.getAxis().getTuples(0, -1), (boolean)false, (int)-1);
                }
            }
            List steps = dataItem.getSteps();
            DataItemNavigationFilter step = null;
            for (int i = 0; i < tupleElements.length; ++i) {
                if (((TupleElementInterface)tupleElements[i]).getChildCount() <= 0 || tupleElements[i].getType() == TupleElementType.TOTAL || tupleElements[i].getType() == TupleElementType.SUBTOTAL || this.isExpandPresentForExpandAll(steps, tupleElements[i].getName()) >= 0) continue;
                step = new DataItemNavigationFilter(4, tupleElements[i].getName());
                step.setActionType(6);
                step.setLevelName(tupleElements[i].getUniqueLevelName());
                dataItem.addStep((StepInterface)step);
            }
            int axisNumber = this.getAxisIndex();
            this.executeQuery(businessQuery);
            if (axisNumber == 1) {
                this.eventInfo.put("ROW", "INITIALIZE");
            } else if (axisNumber == 0) {
                this.eventInfo.put("COLUMN", "INITIALIZE");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public boolean isSupported(ActionSupportFilter actionFilter) {
        if (!this.isIQSupported(actionFilter, DataItemActionType.STEP_NAVIGATE)) {
            return false;
        }
        String uniqueLevelName = (String)actionFilter.getAttribute("uniqueLevelName");
        OLAPDataSetInterface model = (OLAPDataSetInterface)actionFilter.getAttribute("model");
        return this.isExpandable(model, uniqueLevelName);
    }

    @Override
    public int getCommandStatus(ActionSupportFilter filter) {
        if (!this.isIQSupported(filter, DataItemActionType.STEP_NAVIGATE)) {
            return 1;
        }
        String uniqueLevelName = (String)filter.getAttribute("uniqueLevelName");
        OLAPDataSetInterface model = (OLAPDataSetInterface)filter.getAttribute("model");
        return this.getExpandableStatus(model, uniqueLevelName);
    }

    protected boolean isExpandable(OLAPDataSetInterface model, String uniqueLevelName) {
        return true;
    }

    protected int getExpandableStatus(OLAPDataSetInterface model, String uniqueLevelName) {
        try {
            AxisInterface axis = super.getAxis(model, uniqueLevelName);
            TupleInterface[] tuples = axis.getTuples(-12, -18);
            int levelIndex = super.getLevelIndex(model, uniqueLevelName);
            TupleElementInterface[] resultTuples = OLAPUtil.getTupleElementsForLevel((int)levelIndex, (TupleInterface[])tuples, (boolean)false, (int)-1);
            if (resultTuples.length == 1) {
                return 4;
            }
            resultTuples = OLAPUtil.getTupleElementsForLevel((int)levelIndex, (TupleInterface[])tuples, (boolean)true, (int)-1);
            boolean canExpand = false;
            boolean atLeastOneHasChildren = false;
            for (int i = 0; i < resultTuples.length; ++i) {
                TupleElementInterface element = resultTuples[i];
                if (element.getChildCount() <= 0 || element.getType() == TupleElementType.TOTAL || element.getType() == TupleElementType.SUBTOTAL) continue;
                atLeastOneHasChildren = true;
                if (element.isContextual()) continue;
                canExpand = true;
                break;
            }
            if (!canExpand) {
                if (atLeastOneHasChildren) {
                    return 8;
                }
                return 4;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return 0;
    }
}

