/*
 * Decompiled with CFR 0.152.
 */
package com.sas.commands.olap;

import com.sas.actionprovider.ActionSupportFilter;
import com.sas.commands.olap.BaseTupleElementCommand;
import com.sas.iquery.intelligentquery.BusinessQueryProviderInterface;
import com.sas.iquery.metadata.business.BusinessQuery;
import com.sas.iquery.metadata.business.DataItem;
import com.sas.iquery.metadata.business.step.olap.utility.DrillUtil;
import com.sas.storage.olap.TupleElementInterface;

public class DrillToLevelCommand
extends BaseTupleElementCommand {
    protected String uniqueLevelName;

    public DrillToLevelCommand(String name) {
        super(name);
    }

    public DrillToLevelCommand(String name, boolean swing) {
        super(name, swing);
    }

    public void execute(Object o) {
        this.getModel();
        if (this.model == null) {
            throw new IllegalStateException();
        }
        try {
            BusinessQuery businessQuery = ((BusinessQueryProviderInterface)this.model).getBusinessQuery();
            DataItem dataItem = this.getDataItem();
            DrillUtil.drillToLevel((DataItem)dataItem);
            int axisNumber = this.getAxisIndex();
            this.executeQuery(businessQuery);
            this.contentsChanged = true;
            this.eventInfo.clear();
            this.eventInfo.put("tupleElement", this.getTupleElement());
            this.eventInfo.put("actionType", "DRILL_TO_LEVEL_ACTION");
            this.setEventSource(this.model);
            if (axisNumber == 1) {
                this.eventInfo.put("ROW", "INITIALIZE");
            } else if (axisNumber == 0) {
                this.eventInfo.put("COLUMN", "INITIALIZE");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public boolean isSupported(ActionSupportFilter actionFilter) {
        TupleElementInterface tupleElement = (TupleElementInterface)actionFilter.getAttribute("tupleElement");
        return this.isDrillToAnyLevel(tupleElement);
    }

    @Override
    public int getCommandStatus(ActionSupportFilter filter) {
        TupleElementInterface tupleElement = (TupleElementInterface)filter.getAttribute("tupleElement");
        return this.getDrillToAnyLevelStatus(tupleElement);
    }

    protected boolean isDrillToAnyLevel(TupleElementInterface tupleElement) {
        return true;
    }

    protected int getDrillToAnyLevelStatus(TupleElementInterface tupleElement) {
        return 0;
    }

    @Override
    public void setUniqueLevelName(String uniqueLevelName) {
        this.uniqueLevelName = uniqueLevelName;
    }

    @Override
    public String getUniqueLevelName() {
        return this.uniqueLevelName;
    }
}

