/*
 * Decompiled with CFR 0.152.
 */
package com.sas.commands.olap;

import com.sas.actionprovider.ActionSupportFilter;
import com.sas.commands.olap.BaseTupleElementCommand;
import com.sas.iquery.intelligentquery.BusinessQueryProviderInterface;
import com.sas.iquery.metadata.business.BusinessQuery;
import com.sas.iquery.metadata.business.DataItem;
import com.sas.iquery.metadata.business.step.olap.utility.DrillUtil;
import com.sas.storage.olap.OLAPDataSetInterface;

public class DrillDownMemberNameCommand
extends BaseTupleElementCommand {
    protected String uniqueMemberName;

    public DrillDownMemberNameCommand(String name) {
        super(name);
    }

    public DrillDownMemberNameCommand(String name, boolean swing) {
        super(name, swing);
    }

    public void execute(Object o) {
        this.getModel();
        if (this.model == null) {
            throw new IllegalStateException();
        }
        try {
            BusinessQuery businessQuery = ((BusinessQueryProviderInterface)this.model).getBusinessQuery();
            DataItem dataItem = this.getDataItem();
            DrillUtil.drillToMember((DataItem)dataItem, (String)this.getUniqueMemberName(), (OLAPDataSetInterface)this.model);
            int axisNumber = this.getAxisIndex();
            this.executeQuery(businessQuery);
            this.contentsChanged = true;
            this.eventInfo.clear();
            this.eventInfo.put("tupleElement", this.getTupleElement());
            this.setEventSource(this.model);
            if (axisNumber == 1) {
                this.eventInfo.put("ROW", "INITIALIZE");
            } else if (axisNumber == 0) {
                this.eventInfo.put("COLUMN", "INITIALIZE");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public boolean isSupported(ActionSupportFilter actionFilter) {
        return true;
    }

    @Override
    public int getCommandStatus(ActionSupportFilter filter) {
        return 0;
    }

    protected boolean isDrillMember(String uniqueMemberName) {
        return true;
    }

    protected int getDrillMemberStatus(String uniqueMemberName) {
        return 0;
    }

    public void setUniqueMemberName(String uniqueMemberName) {
        this.uniqueMemberName = uniqueMemberName;
    }

    public String getUniqueMemberName() {
        return this.uniqueMemberName;
    }
}

