/*
 * Decompiled with CFR 0.152.
 */
package com.sas.commands.olap;

import com.sas.commands.olap.DrillToLevelCommand;
import com.sas.iquery.intelligentquery.BusinessQueryProviderInterface;
import com.sas.iquery.metadata.business.BusinessQuery;
import com.sas.iquery.metadata.business.DataItem;
import com.sas.iquery.metadata.business.step.StepInterface;
import com.sas.iquery.metadata.business.step.olap.DataItemNavigationFilter;
import java.util.List;

public class DrillDownLevelCommand
extends DrillToLevelCommand {
    public DrillDownLevelCommand(String name) {
        super(name);
    }

    public DrillDownLevelCommand(String name, boolean swing) {
        super(name, swing);
    }

    @Override
    public void execute(Object o) {
        this.getModel();
        if (this.model == null) {
            throw new IllegalStateException();
        }
        try {
            BusinessQuery businessQuery = ((BusinessQueryProviderInterface)this.model).getBusinessQuery();
            DataItem dataItem = this.getDataItem();
            List l = dataItem.getSteps(false);
            for (int i = l.size() - 1; i >= 0; --i) {
                dataItem.removeStep(i);
            }
            String uniqueLevelName = this.getUniqueLevelName();
            DataItemNavigationFilter step = new DataItemNavigationFilter(7, uniqueLevelName);
            step.setActionType(0);
            dataItem.addStep((StepInterface)step);
            int axisNumber = this.getAxisIndex();
            this.executeQuery(businessQuery);
            this.contentsChanged = true;
            this.eventInfo.clear();
            this.eventInfo.put("tupleElement", this.getTupleElement());
            this.eventInfo.put("actionType", "DRILL_TO_LEVEL_ACTION");
            this.setEventSource(this.model);
            if (axisNumber == 1) {
                this.eventInfo.put("ROW", "INITIALIZE");
            } else if (axisNumber == 0) {
                this.eventInfo.put("COLUMN", "INITIALIZE");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

