/*
 * Decompiled with CFR 0.152.
 */
package com.sas.commands.olap;

import com.sas.actionprovider.ActionSupportFilter;
import com.sas.commands.olap.BaseTupleElementCommand;
import com.sas.iquery.intelligentquery.BusinessQueryProviderInterface;
import com.sas.iquery.metadata.business.BusinessQuery;
import com.sas.iquery.metadata.business.DataItem;
import com.sas.iquery.metadata.business.DataItemActionType;
import com.sas.iquery.metadata.business.step.StepInterface;
import com.sas.iquery.metadata.business.step.olap.DataItemNavigationFilter;
import com.sas.storage.olap.AxisInterface;
import com.sas.storage.olap.OLAPDataSetInterface;
import com.sas.storage.olap.TupleElementInterface;
import com.sas.storage.olap.TupleElementType;
import com.sas.storage.olap.TupleInterface;
import java.util.List;

public class DrillDownCommand
extends BaseTupleElementCommand {
    public DrillDownCommand(String name) {
        super(name);
    }

    public DrillDownCommand(String name, boolean swing) {
        super(name, swing);
    }

    public void execute(Object o) {
        this.getModel();
        if (this.model == null) {
            throw new IllegalStateException();
        }
        if (this.model instanceof BusinessQueryProviderInterface) {
            try {
                BusinessQuery businessQuery = ((BusinessQueryProviderInterface)this.model).getBusinessQuery();
                DataItem dataItem = this.getDataItem();
                DataItemNavigationFilter step = new DataItemNavigationFilter(4, this.getTupleElement().getName());
                step.setActionType(0);
                dataItem.addStep((StepInterface)step);
                int axisNumber = this.getAxisIndex();
                this.executeQuery(businessQuery);
                if (axisNumber == 1) {
                    this.eventInfo.put("ROW", "INITIALIZE");
                } else if (axisNumber == 0) {
                    this.eventInfo.put("COLUMN", "INITIALIZE");
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public boolean isSupported(ActionSupportFilter actionFilter) {
        if (!this.isIQSupported(actionFilter, DataItemActionType.STEP_NAVIGATE)) {
            return false;
        }
        TupleElementInterface tupleElement = (TupleElementInterface)actionFilter.getAttribute("tupleElement");
        return this.isDrillDown(tupleElement);
    }

    @Override
    public int getCommandStatus(ActionSupportFilter filter) {
        if (!this.isIQSupported(filter, DataItemActionType.STEP_NAVIGATE)) {
            return 1;
        }
        TupleElementInterface tupleElement = (TupleElementInterface)filter.getAttribute("tupleElement");
        return this.checkAlignStatus(tupleElement, filter);
    }

    protected boolean isDrillDown(TupleElementInterface tupleElement) {
        try {
            if (tupleElement.getChildCount() <= 0) {
                return false;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return true;
    }

    private int checkAlignStatus(TupleElementInterface tupleElement, ActionSupportFilter filter) {
        try {
            TupleInterface[] tuples = (TupleInterface[])filter.getAttribute("rowTuples");
            boolean hasChildren = false;
            int parentIndex = tupleElement.getTupleElementIndex() - 1;
            AxisInterface axis = tupleElement.getTuple().getAxis();
            if (axis.getAxisNumber() == 1) {
                tuples = (TupleInterface[])filter.getAttribute("rowTuples");
            } else if (axis.getAxisNumber() == 0) {
                tuples = (TupleInterface[])filter.getAttribute("columnTuples");
            }
            if (parentIndex != -1) {
                block2: for (int i = 0; i < tuples.length; ++i) {
                    TupleInterface tpl = tuples[i];
                    for (int n = 0; n < tpl.getTupleDepth(); ++n) {
                        TupleElementInterface te = tpl.getElement(n);
                        if (te.getTupleElementIndex() != tupleElement.getTupleElementIndex() || te.getLevelDepth() != tupleElement.getLevelDepth() || te.getUniqueLevelName() == tupleElement.getUniqueLevelName() || te.getChildCount() <= 0) continue;
                        if (te.isContextual()) {
                            List steps = this.getSteps(this.model, te);
                            if (this.isExpandPresent(steps, te.getName()) <= 0) continue;
                            hasChildren = true;
                            continue block2;
                        }
                        hasChildren = true;
                        continue block2;
                    }
                }
            } else {
                block4: for (int i = 0; i < tuples.length && !hasChildren; ++i) {
                    TupleInterface tpl = tuples[i];
                    for (int n = 0; n < tpl.getTupleDepth(); ++n) {
                        TupleElementInterface te = tpl.getElement(n);
                        if (te.getTupleElementIndex() != tupleElement.getTupleElementIndex() || te.getLevelDepth() != tupleElement.getLevelDepth() || te.getUniqueLevelName() == tupleElement.getUniqueLevelName() || te.getChildCount() <= 0) continue;
                        if (te.isContextual()) {
                            List steps = this.getSteps(this.model, te);
                            if (this.isExpandPresent(steps, te.getName()) <= 0) continue;
                            hasChildren = true;
                            continue block4;
                        }
                        hasChildren = true;
                        continue block4;
                    }
                }
            }
            if (tupleElement.getChildCount() <= 0 || tupleElement.getType() == TupleElementType.TOTAL || tupleElement.getType() == TupleElementType.SUBTOTAL) {
                if (this.isAllMemberNotSupported(tupleElement)) {
                    return 4;
                }
                if (hasChildren && tupleElement.getType() != TupleElementType.TOTAL && tupleElement.getType() != TupleElementType.SUBTOTAL) {
                    return 16;
                }
            } else if (this.isPreSummarizedTotal(tupleElement)) {
                if (hasChildren && tupleElement.getType() != TupleElementType.TOTAL && tupleElement.getType() != TupleElementType.SUBTOTAL) {
                    return 16;
                }
            } else if (tupleElement.isContextual() && this.isExpandPresent(tupleElement) < 0) {
                if (this.isAllMemberNotSupported(tupleElement)) {
                    return 4;
                }
                if (hasChildren && tupleElement.getType() != TupleElementType.TOTAL && tupleElement.getType() != TupleElementType.SUBTOTAL) {
                    return 16;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.getDrillDownStatus(tupleElement);
    }

    protected int getDrillDownStatus(TupleElementInterface tupleElement) {
        try {
            if (tupleElement.getChildCount() <= 0 || tupleElement.getType() == TupleElementType.TOTAL || tupleElement.getType() == TupleElementType.SUBTOTAL) {
                return 4;
            }
            if (this.isPreSummarizedTotal(tupleElement)) {
                return 4;
            }
            if (tupleElement.isContextual() && this.isExpandPresent(tupleElement) < 0) {
                return 4;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return 0;
    }

    private List getSteps(OLAPDataSetInterface model, TupleElementInterface tupleElement) {
        DataItem di = this.getDataItem();
        if (di != null) {
            return di.getSteps();
        }
        return null;
    }
}

