/*
 * Decompiled with CFR 0.152.
 */
package com.sas.commands.olap;

import com.sas.actionprovider.ActionSupportFilter;
import com.sas.commands.olap.BaseTupleElementCommand;
import com.sas.iquery.intelligentquery.BusinessQueryProviderInterface;
import com.sas.iquery.metadata.business.BusinessQuery;
import com.sas.iquery.metadata.business.DataItem;
import com.sas.iquery.metadata.business.DataItemActionType;
import com.sas.iquery.metadata.business.step.StepFilterInterface;
import com.sas.iquery.metadata.business.step.StepInterface;
import com.sas.iquery.metadata.business.step.olap.DataItemNavigationFilter;
import com.sas.iquery.metadata.expr.ResourceAwareStringExpression;
import com.sas.storage.olap.AxisInterface;
import com.sas.storage.olap.OLAPDataSetInterface;
import com.sas.storage.olap.OLAPUtil;
import com.sas.storage.olap.TupleElementInterface;
import com.sas.storage.olap.TupleElementType;
import com.sas.storage.olap.TupleInterface;
import com.sas.util.Util;
import java.util.List;

public class CollapseAllCommand
extends BaseTupleElementCommand {
    public CollapseAllCommand(String name) {
        super(name);
    }

    public CollapseAllCommand(String name, boolean swing) {
        super(name, swing);
    }

    public void execute(Object o) {
        this.getModel();
        if (this.model == null) {
            throw new IllegalStateException();
        }
        try {
            BusinessQuery businessQuery = ((BusinessQueryProviderInterface)this.model).getBusinessQuery();
            DataItem dataItem = this.getDataItem();
            this.uniqueLevelName = this.getUniqueLevelName();
            TupleElementInterface[] tupleElements = null;
            if (this.uniqueLevelName != null) {
                AxisInterface axis = this.model.getResultSetMetadata().getAxes(0, -1)[this.getAxisIndex()];
                tupleElements = OLAPUtil.getTupleElementsForLevel((int)this.getLevelIndex(this.model, this.uniqueLevelName), (TupleInterface[])axis.getTuples(0, -1), (boolean)false, (int)-1);
            } else {
                this.tupleElement = this.getTupleElement();
                if (this.tupleElement != null) {
                    TupleInterface tuple = this.tupleElement.getTuple();
                    TupleElementInterface[] elements = tuple.getElements(0, -1);
                    int level = 0;
                    for (int i = 0; i < this.tupleElement.getTupleElementIndex(); ++i) {
                        level += elements[i].getSpan();
                    }
                    tupleElements = OLAPUtil.getTupleElementsForLevel((int)level, (TupleInterface[])tuple.getAxis().getTuples(0, -1), (boolean)false, (int)-1);
                }
            }
            List steps = dataItem.getSteps();
            for (int i = steps.size() - 1; i >= 0; --i) {
                StepInterface lastElementStep = (StepInterface)steps.get(i);
                if (!(lastElementStep instanceof DataItemNavigationFilter) || ((DataItemNavigationFilter)lastElementStep).getNavigationFilterType() != 4 || ((DataItemNavigationFilter)lastElementStep).getActionType() != 6 || !this.uniqueLevelName.equals(((DataItemNavigationFilter)lastElementStep).getLevelName())) continue;
                dataItem.removeStep(i);
            }
            int axisNumber = this.getAxisIndex();
            this.executeQuery(businessQuery);
            if (axisNumber == 1) {
                this.eventInfo.put("ROW", "INITIALIZE");
            } else if (axisNumber == 0) {
                this.eventInfo.put("COLUMN", "INITIALIZE");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public boolean isSupported(ActionSupportFilter actionFilter) {
        if (!this.isIQSupported(actionFilter, DataItemActionType.STEP_NAVIGATE)) {
            return false;
        }
        String uniqueLevelName = (String)actionFilter.getAttribute("uniqueLevelName");
        OLAPDataSetInterface model = (OLAPDataSetInterface)actionFilter.getAttribute("model");
        return this.isCollapseable(model, uniqueLevelName);
    }

    @Override
    public int getCommandStatus(ActionSupportFilter filter) {
        if (!this.isIQSupported(filter, DataItemActionType.STEP_NAVIGATE)) {
            return 1;
        }
        String uniqueLevelName = (String)filter.getAttribute("uniqueLevelName");
        OLAPDataSetInterface model = (OLAPDataSetInterface)filter.getAttribute("model");
        return this.getCollapseableStatus(model, uniqueLevelName);
    }

    protected boolean isCollapseable(OLAPDataSetInterface model, String uniqueLevelName) {
        return true;
    }

    protected int getCollapseableStatus(OLAPDataSetInterface model, String uniqueLevelName) {
        try {
            boolean isResourceAwareStringExpression = this.getDataItem().getExpression() instanceof ResourceAwareStringExpression;
            AxisInterface axis = super.getAxis(model, uniqueLevelName);
            boolean canCollapse = false;
            boolean atLeastOneHasChildren = false;
            TupleInterface[] tuples = axis.getTuples(-12, -18);
            TupleElementInterface[] tupleElements = OLAPUtil.getTupleElementsForLevel((int)super.getLevelIndex(model, uniqueLevelName), (TupleInterface[])tuples, (boolean)false, (int)-1);
            if (tupleElements.length > 1) {
                tupleElements = OLAPUtil.getTupleElementsForLevel((int)super.getLevelIndex(model, uniqueLevelName), (TupleInterface[])tuples, (boolean)true, (int)-1);
                for (int i = 0; i < tupleElements.length; ++i) {
                    List steps;
                    if (tupleElements[i].getChildCount() <= 0 || tupleElements[i].getType() == TupleElementType.TOTAL || tupleElements[i].getType() == TupleElementType.SUBTOTAL) continue;
                    atLeastOneHasChildren = true;
                    if (!tupleElements[i].isContextual() || !this.isExpandPresent(steps = this.getSteps(model, tupleElements[i]), isResourceAwareStringExpression, tupleElements[i].getUniqueLevelName())) continue;
                    canCollapse = true;
                    break;
                }
            }
            if (!canCollapse) {
                if (atLeastOneHasChildren) {
                    return 8;
                }
                return 4;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return 0;
    }

    private boolean isExpandPresent(List steps, boolean isResourceAwareStringExpression, String levelName) {
        if (steps != null && steps.size() > 0) {
            int lastStepIndex;
            for (int i = lastStepIndex = steps.size() - 1; i >= 0; --i) {
                StepInterface step = (StepInterface)steps.get(i);
                if (!(step instanceof DataItemNavigationFilter)) continue;
                int actionType = ((StepFilterInterface)step).getActionType();
                if (actionType == 6) {
                    if (isResourceAwareStringExpression) {
                        if (!(step instanceof DataItemNavigationFilter) || !Util.equal((Object)((DataItemNavigationFilter)step).getLevelName(), (Object)levelName)) continue;
                        return true;
                    }
                    return true;
                }
                if (actionType == 0) break;
            }
        }
        return false;
    }

    private List getSteps(OLAPDataSetInterface model, TupleElementInterface tupleElement) {
        DataItem di = this.getDataItem();
        if (di != null) {
            return di.getSteps();
        }
        return null;
    }
}

