/*
 * Decompiled with CFR 0.152.
 */
package com.sas.commands.dataselectors;

import com.sas.actionprovider.ActionSupportFilter;
import com.sas.actionprovider.CommandStatusInterface;
import com.sas.actionprovider.CommandSupportedInterface;
import com.sas.commands.dataselectors.BaseSelectorCommand;
import com.sas.dataselectors.sort.SortSelectorFactory;
import com.sas.dataselectors.sort.SortSelectorInterface;
import com.sas.iquery.intelligentquery.BusinessQueryProviderInterface;
import com.sas.iquery.intelligentquery.IntelligentQueryException;
import com.sas.iquery.metadata.InvalidIDException;
import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.business.BusinessItem;
import com.sas.iquery.metadata.business.BusinessModel;
import com.sas.iquery.metadata.business.BusinessQuery;
import com.sas.iquery.metadata.business.BusinessQueryActionType;
import com.sas.iquery.metadata.business.DataItem;
import com.sas.iquery.metadata.business.DataItemReference;
import com.sas.iquery.metadata.business.DataSelection;
import com.sas.iquery.metadata.business.Role;
import com.sas.iquery.metadata.impl.Utils;
import com.sas.swing.visuals.dataselectors.sort.SortedItem;
import com.sas.table.SortException;
import com.sas.table.SortableInterface;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.DefaultListModel;

public class SortCommand
extends BaseSelectorCommand
implements CommandSupportedInterface,
CommandStatusInterface {
    private Object adapter = null;
    private String sortByChoiceBox;
    private String sortByRadioBox;
    private String[] thenByChoiceBox;
    private String[] thenByRadioBox;
    private DefaultListModel sortedListModel;
    private DefaultListModel sortedDirections;
    private DefaultListModel choiceBoxLocations;
    public static final String SORT_SELECTOR_COMMAND_COMMITTED = "SORT_SELECTOR_COMMAND_COMMITTED";
    private boolean isJSP;

    public SortCommand() {
        this.initializeFlags();
    }

    public SortCommand(String name) {
        super(name);
        this.initializeFlags();
    }

    public SortCommand(String name, String actionClass) {
        this(name);
        this.actionClass = actionClass;
    }

    private void initializeFlags() {
        this.isJSP = true;
    }

    protected void show(Object o) {
        BusinessQuery dataModel = this.getDataModel(this.model);
        this.adapter = SortSelectorFactory.getAdapter(this.model);
        this.setSelectorModel(this.adapter);
        this.selector.setSelectorModel(this.adapter);
        super.show(o);
    }

    protected void commit(Object o) throws IOException {
        this.adapter = this.selectorModel != null ? this.selectorModel : this.getSelector().getSelectorModel();
        if (this.isJSP) {
            this.updateAdapter();
        }
        BusinessQuery dataModel = this.getDataModel(this.model);
        if (this.thenByChoiceBox != null) {
            for (int i = 0; i < this.thenByChoiceBox.length; ++i) {
                if (this.thenByChoiceBox[i] != null && this.thenByChoiceBox[i].equals(this.sortByChoiceBox)) {
                    this.thenByChoiceBox[i] = null;
                }
                for (int k = i + 1; k < this.thenByChoiceBox.length; ++k) {
                    if (this.thenByChoiceBox[k] == null || !this.thenByChoiceBox[k].equals(this.sortByChoiceBox) && !this.thenByChoiceBox[k].equals(this.thenByChoiceBox[i])) continue;
                    this.thenByChoiceBox[k] = null;
                }
            }
        }
        Object[] items = null;
        int[] dirs = null;
        this.sortedListModel = new DefaultListModel();
        this.sortedDirections = new DefaultListModel();
        if (this.adapter instanceof SortSelectorInterface) {
            Object[] allCols = ((SortSelectorInterface)this.adapter).getAllItems();
            Object[] sortedCols = ((SortSelectorInterface)this.adapter).getSortedItems();
            List allItems = new ArrayList();
            if (dataModel != null) {
                allItems = Utils.filterObjects((BusinessModel)dataModel.getBusinessModel(), (boolean)false, DataItem.class);
            }
            if (this.sortByChoiceBox != null && this.sortByChoiceBox.length() > 0 && !this.sortByChoiceBox.equalsIgnoreCase("None")) {
                Integer sortByIndex = new Integer(this.sortByChoiceBox);
                SortedItem dataItem = (SortedItem)allCols[sortByIndex];
                for (int i = 0; i < allItems.size(); ++i) {
                    if (!allItems.get(i).toString().equals(dataItem.getName()) || !(allItems.get(i) instanceof DataItem)) continue;
                    try {
                        if (dataModel == null || dataModel.getResultSetIndex(((DataItem)allItems.get(i)).getID()) != -1) continue;
                        try {
                            DataItemReference referenceItem = allItems.get(i) instanceof DataItemReference ? (DataItemReference)allItems.get(i) : dataModel.getBusinessModel().newDataItemReference((DataItem)allItems.get(i));
                            dataModel.getBusinessModel().addBusinessItem((BusinessItem)referenceItem);
                            dataModel.addResultItem((DataItem)referenceItem, Role.HIDDEN);
                        }
                        catch (MetadataException referenceItem) {}
                        continue;
                    }
                    catch (InvalidIDException referenceItem) {
                        // empty catch block
                    }
                }
                this.sortedListModel.addElement(allCols[sortByIndex]);
                if (this.sortByRadioBox != null && this.sortByRadioBox.equalsIgnoreCase("DESCENDING")) {
                    this.sortedDirections.addElement(new Integer(1));
                } else {
                    this.sortedDirections.addElement(new Integer(0));
                }
            }
            if (this.thenByChoiceBox != null) {
                for (int j = 0; j < this.thenByChoiceBox.length; ++j) {
                    if (this.thenByChoiceBox[j] == null || this.thenByChoiceBox[j].length() <= 0 || this.thenByChoiceBox[j].equalsIgnoreCase("None")) continue;
                    Integer thenByIndex = new Integer(this.thenByChoiceBox[j]);
                    SortedItem dataItem = (SortedItem)allCols[thenByIndex];
                    for (int i = 0; i < allItems.size(); ++i) {
                        if (!allItems.get(i).toString().equals(dataItem.getName()) || !(allItems.get(i) instanceof DataItem)) continue;
                        try {
                            if (dataModel == null || dataModel.getResultSetIndex(((DataItem)allItems.get(i)).getID()) != -1) continue;
                            try {
                                DataItemReference referenceItem = allItems.get(i) instanceof DataItemReference ? (DataItemReference)allItems.get(i) : dataModel.getBusinessModel().newDataItemReference((DataItem)allItems.get(i));
                                dataModel.getBusinessModel().addBusinessItem((BusinessItem)referenceItem);
                                dataModel.addResultItem((DataItem)referenceItem, Role.HIDDEN);
                            }
                            catch (MetadataException metadataException) {}
                            continue;
                        }
                        catch (InvalidIDException invalidIDException) {
                            // empty catch block
                        }
                    }
                    this.sortedListModel.addElement(allCols[thenByIndex]);
                    if (this.thenByRadioBox[j] != null && this.thenByRadioBox[j].equalsIgnoreCase("DESCENDING")) {
                        this.sortedDirections.addElement(new Integer(1));
                        continue;
                    }
                    this.sortedDirections.addElement(new Integer(0));
                }
            }
            for (int l = 0; l < sortedCols.length; ++l) {
                boolean found = false;
                for (int k = 0; k < this.sortedListModel.getSize(); ++k) {
                    if (!sortedCols[l].toString().equals(this.sortedListModel.get(k).toString())) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                for (int m = 0; m < allItems.size(); ++m) {
                    if (!allItems.get(m).toString().equals(sortedCols[l].toString())) continue;
                    try {
                        if (!(allItems.get(m) instanceof DataItem) || dataModel == null || dataModel.getResultItemRole((DataItem)allItems.get(m)) != Role.HIDDEN) continue;
                        dataModel.removeResultItem((DataItem)allItems.get(m));
                        continue;
                    }
                    catch (MetadataException metadataException) {
                        // empty catch block
                    }
                }
            }
        }
        items = this.sortedListModel.toArray();
        dirs = new int[this.sortedListModel.size()];
        String[] columnNames = new String[items.length];
        for (int i = 0; i < items.length; ++i) {
            columnNames[i] = items[i] instanceof SortedItem ? (String)((SortedItem)items[i]).getID() : items[i].toString();
            if (i >= this.sortedDirections.size()) continue;
            dirs[i] = (Integer)this.sortedDirections.get(i);
        }
        ((SortSelectorInterface)this.adapter).setSortedItems(items);
        ((SortSelectorInterface)this.adapter).setSortedDirections(dirs);
        if (this.model instanceof SortableInterface) {
            try {
                ((SortableInterface)this.model).sort(columnNames, dirs);
            }
            catch (SortException se) {
                throw new IllegalStateException(se.getMessage());
            }
        }
        try {
            if (this.model instanceof BusinessQueryProviderInterface) {
                ((BusinessQueryProviderInterface)this.model).refreshBusinessQuery(dataModel);
                this.initializeFlags();
                this.eventSource = this.model;
                this.contentsChanged = true;
                this.eventInfo.put(SORT_SELECTOR_COMMAND_COMMITTED, SORT_SELECTOR_COMMAND_COMMITTED);
            }
        }
        catch (IntelligentQueryException intelligentQueryException) {
            // empty catch block
        }
        super.commit(o);
    }

    public int getCommandStatus(ActionSupportFilter actionFilter) {
        DataSelection ds;
        boolean isOLAP;
        BusinessQueryProviderInterface bqProvider;
        Object model = actionFilter.getAttribute("model");
        if (model instanceof BusinessQueryProviderInterface && (bqProvider = (BusinessQueryProviderInterface)model).getBusinessQuery() instanceof DataSelection && (isOLAP = (ds = (DataSelection)bqProvider.getBusinessQuery()).getInputStructure().isOLAP())) {
            return 2;
        }
        return 0;
    }

    private BusinessQuery getDataModel(Object model) {
        BusinessQuery dataModel = null;
        if (model instanceof BusinessQueryProviderInterface) {
            dataModel = ((BusinessQueryProviderInterface)model).getBusinessQuery();
        }
        return dataModel;
    }

    private void updateAdapter() {
        if (this.adapter != null) {
            // empty if block
        }
    }

    public void cancel() {
        super.cancel();
    }

    public boolean isSupported(ActionSupportFilter actionFilter) {
        BusinessQuery bq;
        Object dataModel = actionFilter.getAttribute("model");
        if (dataModel instanceof BusinessQueryProviderInterface && (bq = ((BusinessQueryProviderInterface)dataModel).getBusinessQuery()) != null) {
            return bq.isActionSupported(BusinessQueryActionType.TOTAL);
        }
        if (dataModel instanceof SortableInterface) {
            return ((SortableInterface)dataModel).isSortAllowed();
        }
        return false;
    }

    public void setSortByChoiceBox(String value) {
        this.sortByChoiceBox = value;
    }

    public String getSortByChoiceBox() {
        return this.sortByChoiceBox;
    }

    public void setSortByRadioBox(String value) {
        this.sortByRadioBox = value;
    }

    public String getSortByRadioBox() {
        return this.sortByRadioBox;
    }

    public void setThenByChoiceBox(String[] values) {
        this.thenByChoiceBox = values;
    }

    public String[] getThenByChoiceBox() {
        return this.thenByChoiceBox;
    }

    public void setThenByRadioBox(String[] values) {
        this.thenByRadioBox = values;
    }

    public String[] getThenByRadioBox() {
        return this.thenByRadioBox;
    }
}

