/*
 * Decompiled with CFR 0.152.
 */
package com.sas.commands.dataselectors;

import com.sas.actionprovider.ActionSupportFilter;
import com.sas.actionprovider.CommandSupportedInterface;
import com.sas.commands.dataselectors.BaseSelectorCommand;
import com.sas.iquery.dataretrieval.convenience.olap.ShowDetail;
import com.sas.iquery.intelligentquery.BusinessQueryProviderInterface;
import com.sas.iquery.metadata.business.BusinessModel;
import com.sas.iquery.metadata.business.BusinessQuery;
import com.sas.iquery.metadata.business.DrillThroughToDetail;
import com.sas.storage.jdbc.JDBCToTableModelAdapter;
import com.sas.storage.olap.CubeInterface;
import com.sas.storage.olap.Filter;
import com.sas.storage.olap.MetadataInterface;
import com.sas.storage.olap.OLAPDataSetInterface;
import com.sas.storage.olap.TupleElementInterface;
import com.sas.util.log.LoggerRepository2;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;

public class ShowDetailSelectorCommand
extends BaseSelectorCommand
implements CommandSupportedInterface {
    protected boolean swing;
    protected boolean contentsChanged;
    protected HashMap eventInfo;
    protected Object eventSource;
    private TupleElementInterface[] tupleElements;

    public ShowDetailSelectorCommand() {
        this("");
    }

    public ShowDetailSelectorCommand(String name) {
        super(name);
        this.eventInfo = new HashMap(2);
    }

    public ShowDetailSelectorCommand(String name, boolean swing) {
        super(name);
        this.setSwing(swing);
        this.eventInfo = new HashMap(2);
    }

    public ShowDetailSelectorCommand(String name, String actionClass) {
        this(name);
        this.actionClass = actionClass;
        this.eventInfo = new HashMap(2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void show(Object o) {
        ResultSet fsr = null;
        try {
            Object model = this.getModel();
            this.tupleElements = this.getTupleElements();
            if (this.tupleElements != null) {
                fsr = ShowDetail.getDetailData((OLAPDataSetInterface)((OLAPDataSetInterface)model), (TupleElementInterface[])this.tupleElements);
                JDBCToTableModelAdapter adapter = new JDBCToTableModelAdapter(fsr);
                this.selector.setSelectorModel((Object)adapter);
            }
            super.show(o);
        }
        finally {
            try {
                if (fsr != null) {
                    fsr.close();
                }
            }
            catch (SQLException e) {
                LoggerRepository2.getLogger((String)((Object)((Object)this)).getClass().getName(), null).error(e.getMessage(), (Throwable)e);
            }
        }
    }

    protected void commit(Object o) throws IOException {
        super.commit(o);
    }

    public boolean isSupported(ActionSupportFilter actionFilter) {
        TupleElementInterface[] elements = (TupleElementInterface[])actionFilter.getAttribute("tupleElements");
        if (elements != null && elements.length > 0) {
            try {
                String cubeName;
                Object model = actionFilter.getAttribute("model");
                boolean isIQShowDetailEnabled = false;
                if (model instanceof OLAPDataSetInterface) {
                    isIQShowDetailEnabled = ShowDetail.isShowDetailValid((OLAPDataSetInterface)((OLAPDataSetInterface)model), (TupleElementInterface[])elements);
                }
                if (isIQShowDetailEnabled && (cubeName = ((OLAPDataSetInterface)model).getCubeName()) != null) {
                    List rules;
                    BusinessQuery businessQuery;
                    BusinessModel businessModel;
                    Filter f = new Filter();
                    f.setCubeName(cubeName);
                    MetadataInterface metadata = ((OLAPDataSetInterface)model).getDatabaseMetadata();
                    CubeInterface[] cube = metadata.getCubes(f);
                    boolean isDrillThroughEnabled = cube[0].isDrillThroughEnabled();
                    if (isDrillThroughEnabled && model instanceof BusinessQueryProviderInterface && (businessModel = (businessQuery = ((BusinessQueryProviderInterface)model).getBusinessQuery()).getBusinessModel()) != null && (rules = businessModel.getObjects(true, DrillThroughToDetail.class)) != null && !rules.isEmpty()) {
                        DrillThroughToDetail dttdRule = (DrillThroughToDetail)rules.get(0);
                        isDrillThroughEnabled = dttdRule.isDrillThroughAllowed();
                    }
                    return isDrillThroughEnabled;
                }
            }
            catch (Exception e) {
                LoggerRepository2.getLogger((String)((Object)((Object)this)).getClass().getName(), null).error(e.getMessage(), (Throwable)e);
            }
        }
        return false;
    }

    public TupleElementInterface[] getTupleElements() {
        return this.tupleElements;
    }

    public void setTupleElements(TupleElementInterface[] te) {
        this.tupleElements = te;
    }

    public boolean isContentsChanged() {
        return this.contentsChanged;
    }

    public HashMap getEventInfo() {
        if (this.contentsChanged) {
            return this.eventInfo;
        }
        return null;
    }

    public Object getEventSource() {
        return this.eventSource;
    }

    public void setEventSource(Object eventSource) {
        this.eventSource = eventSource;
    }

    public void setSwing(boolean swing) {
        this.swing = swing;
    }

    public boolean isSwing() {
        return this.swing;
    }
}

