/*
 * Decompiled with CFR 0.152.
 */
package com.sas.commands.dataselectors;

import com.sas.actionprovider.ActionSupportFilter;
import com.sas.actionprovider.CommandSupportedInterface;
import com.sas.commands.dataselectors.BaseSelectorCommand;
import com.sas.dataselectors.ranking.OLAPRankingSelectorInterface;
import com.sas.dataselectors.ranking.RankingSelectorAdapterFactory;
import com.sas.dataselectors.ranking.RankingSelectorInterface;
import com.sas.dataselectors.ranking.RelationalRankingSelectorInterface;
import com.sas.dataselectors.ranking.Util;
import com.sas.iquery.intelligentquery.BusinessQueryProviderInterface;
import com.sas.iquery.intelligentquery.IntelligentQueryException;
import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.business.BusinessQuery;
import com.sas.iquery.metadata.business.DataItem;
import com.sas.iquery.metadata.business.step.StepInterface;
import com.sas.iquery.metadata.business.step.relational.DataItemRankFilter;
import com.sas.iquery.metadata.expr.StringExpression;
import com.sas.iquery.metadata.physical.Measure;
import com.sas.util.Strings;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;

public class RankingCommand
extends BaseSelectorCommand
implements CommandSupportedInterface {
    protected String[] dataItem;
    protected String rankProperties;
    protected String[] whereClause;
    protected String remoteRankOrder;
    protected int remoteRankValue;
    protected int remoteRankType;
    protected String remoteIncludeTies;
    protected String remoteBasedOn;
    protected String remoteBasedOnDesc;
    protected String remoteAction;
    protected String remoteDataItemId;
    protected String remoteWhereClause;
    protected String remoteButtonRowId;
    protected String remoteWhereValue;
    public int topN;
    public int bottomN;
    public String topPercent;
    public String bottomPercent;
    public String show;
    public String basedOn;
    public String of;
    private boolean isTopNUpToDate;
    private boolean isBottomNUpToDate;
    private boolean isShowUpToDate;
    private boolean isBasedOnUpToDate;
    private boolean isOfUpToDate;
    private boolean isJSP;
    private Object adapter = null;

    public RankingCommand() {
        this.initializeFlags();
    }

    public RankingCommand(String name) {
        super(name);
        this.initializeFlags();
    }

    public RankingCommand(String name, String actionClass) {
        this(name);
        this.actionClass = actionClass;
    }

    private void initializeFlags() {
        this.isTopNUpToDate = true;
        this.isBottomNUpToDate = true;
        this.isShowUpToDate = true;
        this.isBasedOnUpToDate = true;
        this.isOfUpToDate = true;
        this.topPercent = "0";
        this.bottomPercent = "0";
        this.isJSP = false;
    }

    protected void show(Object o) {
        this.adapter = this.getBusinessQuery(this.model).getInputStructure().isOLAP() ? RankingSelectorAdapterFactory.getOLAPAdapter(this.model) : RankingSelectorAdapterFactory.getRelationalAdapter(this.model);
        ((RankingSelectorInterface)this.adapter).valuesFromDataModel(true);
        this.setSelectorModel(this.adapter);
        this.selector.setSelectorModel(this.adapter);
        super.show(o);
    }

    protected void commit(Object o) throws IOException {
        this.adapter = this.selectorModel != null ? this.selectorModel : this.getSelector().getSelectorModel();
        ((RankingSelectorInterface)this.adapter).valuesFromDataModel(false);
        if (this.isJSP) {
            this.updateAdapter();
        }
        this.removeRankings();
        if (this.isJSP) {
            String[] rankPro;
            BusinessQuery dataModel = this.getBusinessQuery(this.model);
            DataItem rankDataItem = null;
            DataItemRankFilter dataItemRankFilter = null;
            String dataItemID = null;
            int rType = -1;
            int rOrder = -1;
            String[] wheres = null;
            try {
                rankPro = URLDecoder.decode(this.rankProperties, "UTF-8").split(",");
            }
            catch (UnsupportedEncodingException uee) {
                return;
            }
            int pos = -1;
            for (int i = 0; i < this.dataItem.length; ++i) {
                int stepsN;
                String[] rankValues;
                try {
                    rankValues = URLDecoder.decode(this.dataItem[i], "UTF-8").split("\t");
                }
                catch (UnsupportedEncodingException uee) {
                    return;
                }
                pos = Strings.indexOf((String)"dataItemID", (String[])rankPro);
                if (pos < 0) continue;
                dataItemID = rankValues[pos];
                try {
                    rankDataItem = (DataItem)dataModel.getBusinessModel().getBusinessItemByID(dataItemID);
                }
                catch (MetadataException uee) {
                    // empty catch block
                }
                int rValue = Double.valueOf(rankValues[Strings.indexOf((String)"rankValue", (String[])rankPro)]).intValue();
                if (rValue > 0) {
                    boolean rTies;
                    rOrder = rankValues[Strings.indexOf((String)"rankOrder", (String[])rankPro)].equalsIgnoreCase("T") ? (dataModel.getInputStructure().isOLAP() ? 0 : 0) : (dataModel.getInputStructure().isOLAP() ? 1 : 1);
                    boolean bl = rTies = rankValues[Strings.indexOf((String)"includeTies", (String[])rankPro)].equalsIgnoreCase("1");
                    if (dataModel.getInputStructure().isOLAP()) {
                        rType = Integer.valueOf(rankValues[Strings.indexOf((String)"rankType", (String[])rankPro)]);
                        String measureName = rankValues[Strings.indexOf((String)"measureDataItemID", (String[])rankPro)];
                        String basedOnMeasureUniqueName = ((OLAPRankingSelectorInterface)this.adapter).getMeasureUniqueName(measureName);
                        Vector<Object> rQualifiers = null;
                        DataItem basedOnMeasureDataItem = null;
                        try {
                            basedOnMeasureDataItem = (DataItem)dataModel.getBusinessModel().getBusinessItemByID(basedOnMeasureUniqueName);
                        }
                        catch (MetadataException metadataException) {
                            // empty catch block
                        }
                        if (basedOnMeasureDataItem != null) {
                            rQualifiers = new Vector<Object>();
                            rQualifiers.add(basedOnMeasureDataItem);
                        }
                        if ((wheres = this.getWheres(dataItemID)) != null && basedOnMeasureDataItem != null) {
                            StringExpression where = null;
                            for (int a = 0; a < wheres.length; ++a) {
                                where = new StringExpression();
                                where.setText(wheres[a]);
                                rQualifiers.add(where);
                            }
                        }
                        dataItemRankFilter = new com.sas.iquery.metadata.business.step.olap.DataItemRankFilter(rOrder, rValue, rQualifiers, rType, rTies);
                    } else {
                        dataItemRankFilter = new DataItemRankFilter(rOrder, rValue, rTies);
                    }
                    try {
                        rankDataItem.addStep((StepInterface)dataItemRankFilter);
                    }
                    catch (MetadataException measureName) {}
                    continue;
                }
                List steps = rankDataItem.getSteps();
                if (steps == null || (stepsN = steps.size()) <= 0) continue;
                Object lastStep = steps.get(stepsN - 1);
                if ((!dataModel.getInputStructure().isOLAP() || !(lastStep instanceof com.sas.iquery.metadata.business.step.olap.DataItemRankFilter)) && (dataModel.getInputStructure().isOLAP() || !(lastStep instanceof DataItemRankFilter))) continue;
                rankDataItem.removeStep(stepsN - 1);
            }
            if (this.model instanceof BusinessQueryProviderInterface) {
                try {
                    ((BusinessQueryProviderInterface)this.model).refreshBusinessQuery(dataModel);
                    this.eventSource = this.model;
                    this.contentsChanged = true;
                    this.eventInfo.put("ROW_COLUMN", "INITIALIZE");
                }
                catch (IntelligentQueryException intelligentQueryException) {}
            }
        } else {
            int rankType;
            int rankOrder = -1;
            int rankValue = ((RankingSelectorInterface)this.adapter).rankingCount();
            boolean includeTies = ((RankingSelectorInterface)this.adapter).includeTies();
            BusinessQuery dataModel = this.getBusinessQuery(this.model);
            if (this.isJSP) {
                rankType = ((RankingSelectorInterface)this.adapter).rankType();
            } else if (dataModel.getInputStructure().isOLAP()) {
                rankType = ((RankingSelectorInterface)this.adapter).percentageRanking() ? 1 : 0;
                rankOrder = ((RankingSelectorInterface)this.adapter).topRanking() ? 0 : 1;
            } else {
                rankType = 0;
                rankOrder = ((RankingSelectorInterface)this.adapter).topRanking() ? 0 : 1;
            }
            DataItem rankDataItem = null;
            DataItemRankFilter dataItemRankFilter = null;
            String[] byRankNames = null;
            try {
                if (dataModel.getInputStructure().isOLAP()) {
                    String rankingLevelName = ((OLAPRankingSelectorInterface)this.adapter).rankingLevelName();
                    String rankingMeasureName = ((OLAPRankingSelectorInterface)this.adapter).rankingMeasureName();
                    rankDataItem = (DataItem)dataModel.getBusinessModel().getBusinessItemByID(rankingLevelName);
                    DataItem measureDataItem = (DataItem)dataModel.getBusinessModel().getBusinessItemByID(rankingMeasureName);
                    String measureUniqueName = ((Measure)measureDataItem.getExpression()).getMeasureUniqueName();
                    byRankNames = new String[]{measureUniqueName};
                    dataItemRankFilter = new com.sas.iquery.metadata.business.step.olap.DataItemRankFilter(rankOrder, rankValue, byRankNames, rankType, includeTies);
                } else {
                    String rankingColumnName = ((RelationalRankingSelectorInterface)this.adapter).rankingColumnName();
                    rankDataItem = (DataItem)dataModel.getBusinessModel().getBusinessItemByID(rankingColumnName);
                    dataItemRankFilter = new DataItemRankFilter(rankOrder, rankValue, includeTies);
                }
                rankDataItem.addStep((StepInterface)dataItemRankFilter);
                if (this.model instanceof BusinessQueryProviderInterface) {
                    ((BusinessQueryProviderInterface)this.model).refreshBusinessQuery(dataModel);
                    this.eventSource = this.model;
                    this.contentsChanged = true;
                }
            }
            catch (MetadataException metadataException) {
            }
            catch (IntelligentQueryException intelligentQueryException) {
                // empty catch block
            }
        }
        super.commit(o);
    }

    private void removeRankings() {
        BusinessQuery dataModel = this.getBusinessQuery(this.model);
        List items = dataModel.getResultItems();
        Iterator iterator = items.iterator();
        DataItem item = null;
        block0: while (iterator.hasNext()) {
            item = (DataItem)iterator.next();
            if (item == null) continue;
            List steps = item.getSteps();
            int nSteps = steps.size();
            Object step = null;
            for (int i = 0; i < nSteps; ++i) {
                step = steps.get(i);
                if (step == null) continue;
                if (dataModel.getInputStructure().isOLAP()) {
                    if (!(step instanceof com.sas.iquery.metadata.business.step.olap.DataItemRankFilter)) continue;
                    item.removeStep(i);
                    continue block0;
                }
                if (!(step instanceof DataItemRankFilter)) continue;
                item.removeStep(i);
                continue block0;
            }
        }
    }

    protected void process(Object o) {
        this.eventInfo.clear();
        this.contentsChanged = true;
        this.eventSource = this.getModel();
        this.adapter = this.selectorModel != null ? this.selectorModel : this.getSelector().getSelectorModel();
        String remoteAction = this.getRemoteAction();
        if (remoteAction.equalsIgnoreCase("COMMIT")) {
            String dataItemId = this.getRemoteDataItemId();
            String remoteBasedOn = this.getRemoteBasedOn();
            String remoteBasedOnDesc = this.getRemoteBasedOnDesc();
            this.eventInfo.put("infoText", ((RankingSelectorInterface)this.adapter).getLocalizedInfoText(this.getRemoteRankOrder(), this.getRemoteRankValue(), this.getRemoteRankType(), this.getRemoteIncludeTies(), remoteBasedOnDesc));
            if (remoteBasedOn != null && dataItemId != null) {
                ((OLAPRankingSelectorInterface)this.adapter).setBasedOnMeasureId(remoteBasedOn, dataItemId);
            }
        } else if (remoteAction.equalsIgnoreCase("CLEAR")) {
            this.eventInfo.put("infoText", ((RankingSelectorInterface)this.adapter).getLocalizedText("noRanking.txt"));
        } else if (remoteAction.equalsIgnoreCase("POPULATEBASEDON")) {
            String dataItemId = this.getRemoteDataItemId();
            String[][] measures = ((OLAPRankingSelectorInterface)this.adapter).getLocalizedBasedOnMeasures(dataItemId);
            String selectedBasedOnMeasureId = ((OLAPRankingSelectorInterface)this.adapter).getSelectedBasedOnMeasureId(dataItemId);
            String[][] measuresWhereClauses = ((OLAPRankingSelectorInterface)this.adapter).getMeasuresWhereClauses(dataItemId);
            this.eventInfo.put("measures", measures);
            this.eventInfo.put("selectedBasedOnMeasureId", selectedBasedOnMeasureId);
            this.eventInfo.put("measuresWhereClauses", measuresWhereClauses);
        } else if (remoteAction.equalsIgnoreCase("UPDATEBASEDON")) {
            String dataItemId = this.getRemoteDataItemId();
            String[] remoteWhereClauses = this.getRemoteWhereClause().split("\t");
            String[] remoteWhereValues = this.getRemoteWhereValue().split("\t");
            String remoteBasedOn = this.getRemoteBasedOn();
            ((OLAPRankingSelectorInterface)this.adapter).updateWhereClause(dataItemId, remoteBasedOn, remoteWhereClauses, remoteWhereValues);
            String[][] measures = ((OLAPRankingSelectorInterface)this.adapter).getLocalizedBasedOnMeasures(dataItemId);
            String selectedBasedOnMeasureId = ((OLAPRankingSelectorInterface)this.adapter).getSelectedBasedOnMeasureId(dataItemId);
            String[][] measuresWhereClauses = ((OLAPRankingSelectorInterface)this.adapter).getMeasuresWhereClauses(dataItemId);
            this.eventInfo.put("measures", measures);
            this.eventInfo.put("selectedBasedOnMeasureId", selectedBasedOnMeasureId);
            this.eventInfo.put("measuresWhereClauses", measuresWhereClauses);
            String localizedBasedOnMeasure = null;
            for (int i = 0; i < measures.length; ++i) {
                if (!measures[i][0].equals(selectedBasedOnMeasureId)) continue;
                localizedBasedOnMeasure = measures[i][1];
                break;
            }
            this.eventInfo.put("infoText", ((RankingSelectorInterface)this.adapter).getLocalizedInfoText(this.getRemoteRankOrder(), this.getRemoteRankValue(), this.getRemoteRankType(), this.getRemoteIncludeTies(), localizedBasedOnMeasure));
            this.eventInfo.put("remoteButtonRowId", this.getRemoteButtonRowId());
        }
        this.eventInfo.put("remoteAction", remoteAction);
        super.process(o);
    }

    private BusinessQuery getBusinessQuery(Object model) {
        BusinessQuery dataModel = null;
        if (model instanceof BusinessQueryProviderInterface) {
            dataModel = ((BusinessQueryProviderInterface)model).getBusinessQuery();
        }
        return dataModel;
    }

    private void updateAdapter() {
        if (this.adapter != null) {
            BusinessQuery dataModel;
            if (!this.isShowUpToDate) {
                if (this.show.equalsIgnoreCase("T")) {
                    ((RankingSelectorInterface)this.adapter).topRanking(true);
                } else if (this.show.equalsIgnoreCase("B")) {
                    ((RankingSelectorInterface)this.adapter).topRanking(false);
                }
            }
            if (((RankingSelectorInterface)this.adapter).topRanking()) {
                ((RankingSelectorInterface)this.adapter).percentageRanking(this.topPercent.equalsIgnoreCase("1"));
            }
            if (!((RankingSelectorInterface)this.adapter).topRanking()) {
                ((RankingSelectorInterface)this.adapter).percentageRanking(this.bottomPercent.equalsIgnoreCase("1"));
            }
            if (!this.isTopNUpToDate && ((RankingSelectorInterface)this.adapter).topRanking()) {
                ((RankingSelectorInterface)this.adapter).rankingCount(this.topN);
            }
            if (!this.isBottomNUpToDate && !((RankingSelectorInterface)this.adapter).topRanking()) {
                ((RankingSelectorInterface)this.adapter).rankingCount(this.bottomN);
            }
            if ((dataModel = this.getBusinessQuery(this.model)) != null && !this.isBasedOnUpToDate) {
                if (!dataModel.getInputStructure().isOLAP()) {
                    ((RelationalRankingSelectorInterface)this.adapter).rankingColumnName(this.basedOn);
                } else {
                    ((OLAPRankingSelectorInterface)this.adapter).rankingMeasureName(this.basedOn);
                }
            }
            if (!this.isOfUpToDate) {
                ((OLAPRankingSelectorInterface)this.adapter).rankingLevelName(this.of);
            }
        }
    }

    private String[] getWheres(String dataItemID) {
        String[] wheres = null;
        String[] where = null;
        if (this.whereClause != null) {
            for (int i = 0; i < this.whereClause.length; ++i) {
                try {
                    where = URLDecoder.decode(this.whereClause[i], "UTF-8").split("\t");
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    // empty catch block
                }
                if (where[0].equalsIgnoreCase(dataItemID)) break;
            }
            if (where != null && where.length > 1) {
                Vector<String> vals = new Vector<String>();
                for (int a = 1; a < where.length; ++a) {
                    if (where[a].equalsIgnoreCase(".") || where[a].trim().equalsIgnoreCase("")) continue;
                    vals.add(where[a]);
                }
                int nw = vals.size();
                if (nw > 0) {
                    wheres = new String[nw];
                    Iterator iterator = vals.iterator();
                    int s = 0;
                    while (iterator.hasNext()) {
                        wheres[s] = (String)iterator.next();
                        ++s;
                    }
                }
            }
        }
        return wheres;
    }

    public boolean isSupported(ActionSupportFilter actionFilter) {
        Object dataModel = actionFilter.getAttribute("model");
        if (dataModel instanceof BusinessQueryProviderInterface) {
            return Util.isRankSupported((BusinessQueryProviderInterface)dataModel);
        }
        return false;
    }

    public void setDataItem(String[] dataItem) {
        this.isJSP = true;
        this.dataItem = dataItem;
    }

    public String[] getDataItem() {
        return this.dataItem;
    }

    public void setRankProperties(String rankProperties) {
        this.isJSP = true;
        this.rankProperties = rankProperties;
    }

    public String getRankProperties() {
        return this.rankProperties;
    }

    public void setWhereClause(String[] whereClause) {
        this.isJSP = true;
        this.whereClause = whereClause;
    }

    public String[] getWhereClause() {
        return this.whereClause;
    }

    public void setRemoteRankOrder(String remoteRankOrder) {
        this.isJSP = true;
        try {
            this.remoteRankOrder = URLDecoder.decode(remoteRankOrder, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
    }

    public String getRemoteRankOrder() {
        return this.remoteRankOrder;
    }

    public void setRemoteRankValue(int value) {
        this.isJSP = true;
        this.remoteRankValue = value;
    }

    public int getRemoteRankValue() {
        return this.remoteRankValue;
    }

    public void setRemoteRankType(int value) {
        this.isJSP = true;
        this.remoteRankType = value;
    }

    public int getRemoteRankType() {
        return this.remoteRankType;
    }

    public void setRemoteIncludeTies(String value) {
        this.isJSP = true;
        try {
            this.remoteIncludeTies = URLDecoder.decode(value, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
    }

    public String getRemoteIncludeTies() {
        return this.remoteIncludeTies;
    }

    public void setRemoteBasedOn(String value) {
        this.isJSP = true;
        try {
            this.remoteBasedOn = URLDecoder.decode(value, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
    }

    public String getRemoteBasedOn() {
        return this.remoteBasedOn;
    }

    public void setRemoteBasedOnDesc(String value) {
        this.isJSP = true;
        try {
            this.remoteBasedOnDesc = URLDecoder.decode(value, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
    }

    public String getRemoteBasedOnDesc() {
        return this.remoteBasedOnDesc;
    }

    public void setRemoteAction(String value) {
        this.isJSP = true;
        try {
            this.remoteAction = URLDecoder.decode(value, "UTF-8").trim();
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
    }

    public String getRemoteAction() {
        return this.remoteAction;
    }

    public void setRemoteDataItemId(String value) {
        this.isJSP = true;
        try {
            this.remoteDataItemId = URLDecoder.decode(value, "UTF-8").trim();
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
    }

    public String getRemoteDataItemId() {
        return this.remoteDataItemId;
    }

    public void setRemoteWhereClause(String value) {
        this.isJSP = true;
        try {
            this.remoteWhereClause = URLDecoder.decode(value, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
    }

    public String getRemoteWhereClause() {
        return this.remoteWhereClause;
    }

    public void setRemoteButtonRowId(String value) {
        this.isJSP = true;
        try {
            this.remoteButtonRowId = URLDecoder.decode(value, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
    }

    public String getRemoteButtonRowId() {
        return this.remoteButtonRowId;
    }

    public void setRemoteWhereValue(String value) {
        this.isJSP = true;
        try {
            this.remoteWhereValue = URLDecoder.decode(value, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
    }

    public String getRemoteWhereValue() {
        return this.remoteWhereValue;
    }
}

