/*
 * Decompiled with CFR 0.152.
 */
package com.sas.commands.dataselectors;

import com.sas.actionprovider.ActionSupportFilter;
import com.sas.actionprovider.CommandStatusInterface;
import com.sas.commands.dataselectors.BaseSelectorCommand;
import com.sas.commands.dataselectors.RB;
import com.sas.dataselectors.DataSelectorInterface;
import com.sas.dataselectors.calculations.percent.BasePercentCalculationsSelectorAdapter;
import com.sas.dataselectors.calculations.percent.OLAPPercentCalculationsSelectorAdapter;
import com.sas.dataselectors.calculations.percent.PercentCalculationsSelectorDataSource;
import com.sas.dataselectors.calculations.percent.PercentCalculationsSelectorDataSourceInterface;
import com.sas.dataselectors.calculations.percent.PercentCalculationsSelectorInterface;
import com.sas.dataselectors.calculations.percent.PercentCalculationsSelectorOLAPDataSource;
import com.sas.iquery.intelligentquery.BusinessQueryProviderInterface;
import com.sas.iquery.metadata.business.DataItem;
import com.sas.iquery.metadata.business.DataSelection;
import com.sas.storage.iquery.BusinessQueryToOLAPDataSetAdapter;
import com.sas.storage.iquery.BusinessQueryToTableModelAdapter;
import com.sas.util.log.LoggerRepository2;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class PercentCalculationsCommand
extends BaseSelectorCommand
implements CommandStatusInterface {
    private String RB_KEY = "PercentCalculationsCommand.";
    private boolean swing;
    private List fractionalItems;
    private PercentCalculationsSelectorDataSourceInterface _dataSource = null;

    public PercentCalculationsCommand() {
    }

    public PercentCalculationsCommand(String name) {
        super(name);
    }

    public PercentCalculationsCommand(String name, String actionClass) {
        this(name);
        this.actionClass = actionClass;
    }

    public PercentCalculationsCommand(String name, boolean swing) {
        this(name);
        this.setSwing(swing);
    }

    protected void show(Object o) {
        DataSelectorInterface selector = this.getSelector();
        if (selector == null) {
            throw new IllegalStateException(RB.getStringResource((String)this.RB_KEY, (String)"noSelectorError.txt"));
        }
        PercentCalculationsSelectorInterface selectorModel = this.createAdapter(this.getModel());
        selector.setSelectorModel((Object)selectorModel);
        this.setSelectorModel(selectorModel);
        if (this.isSwing() && this._dataSource != null) {
            selectorModel.setFractionalItems(this._dataSource.getFractionalItems());
            this._dataSource = null;
        }
        this.eventInfo.clear();
        super.show(o);
    }

    public void cancel(Object o) {
        this.eventInfo.clear();
        super.cancel(o);
    }

    protected void commit(Object o) throws IOException {
        PercentCalculationsSelectorInterface selectorModel = (PercentCalculationsSelectorInterface)this.getSelectorModel();
        if (!this.isSwing()) {
            selectorModel.setFractionalItems(this.getFractionalItems());
        }
        this.updateEventInfo(selectorModel.commit());
        super.commit(o);
    }

    private List transform(String[] array) {
        if (array == null) {
            return null;
        }
        ArrayList<String> list = new ArrayList<String>();
        int size = array.length;
        for (int i = 0; i < size; ++i) {
            list.add(array[i]);
        }
        return list;
    }

    private void updateEventInfo(Map infoMap) {
        this.eventSource = this.model;
        this.contentsChanged = true;
        Exception e = (Exception)infoMap.get("EXCEPTION_OCCURRED");
        if (e != null) {
            LoggerRepository2.getLogger((String)((Object)((Object)this)).getClass().getName(), null).error(e.getMessage(), (Throwable)e);
        }
    }

    public int getCommandStatus(ActionSupportFilter actionFilter) {
        BusinessQueryProviderInterface bqProvider;
        Object model = actionFilter.getAttribute("model");
        if (model instanceof BusinessQueryProviderInterface && (bqProvider = (BusinessQueryProviderInterface)model).getBusinessQuery() instanceof DataSelection) {
            DataSelection ds = (DataSelection)bqProvider.getBusinessQuery();
            boolean isOLAP = ds.getInputStructure().isOLAP();
            for (DataItem dataItem : ds.getResultItems()) {
                if (!(isOLAP ? PercentCalculationsSelectorOLAPDataSource.isValidNumerator(dataItem, ds) : PercentCalculationsSelectorDataSource.isValidNumerator(dataItem, ds))) continue;
                return 0;
            }
        }
        return 2;
    }

    protected PercentCalculationsSelectorInterface createAdapter(Object model) {
        BasePercentCalculationsSelectorAdapter adapter = null;
        if (model instanceof BusinessQueryToOLAPDataSetAdapter) {
            this._dataSource = new PercentCalculationsSelectorOLAPDataSource((BusinessQueryProviderInterface)model);
            adapter = new OLAPPercentCalculationsSelectorAdapter(this._dataSource);
        } else if (model instanceof BusinessQueryToTableModelAdapter) {
            this._dataSource = new PercentCalculationsSelectorDataSource((BusinessQueryProviderInterface)model);
            adapter = new BasePercentCalculationsSelectorAdapter(this._dataSource);
        }
        return adapter;
    }

    public void setFractionalItems(List items) {
        this.fractionalItems = items;
    }

    public List getFractionalItems() {
        return this.fractionalItems;
    }

    public void setSwing(boolean swing) {
        this.swing = swing;
    }

    public boolean isSwing() {
        return this.swing;
    }
}

