/*
 * Decompiled with CFR 0.152.
 */
package com.sas.commands.dataselectors;

import com.sas.actionprovider.ActionSupportFilter;
import com.sas.actionprovider.CommandStatusInterface;
import com.sas.commands.dataselectors.BaseSelectorCommand;
import com.sas.commands.dataselectors.RB;
import com.sas.dataselectors.DataSelectorInterface;
import com.sas.dataselectors.filters.timebased.TimeBasedFilterAdapterInterface;
import com.sas.dataselectors.filters.timebased.olap.OLAPTimeBasedFilterAdapter;
import com.sas.dataselectors.filters.timebased.olap.OLAPTimeBasedFilterAdapterDataSource;
import com.sas.dataselectors.filters.timebased.olap.OLAPTimeBasedFilterAdapterInterface;
import com.sas.iquery.intelligentquery.BusinessQueryProviderInterface;
import com.sas.iquery.intelligentquery.IntelligentQueryException;
import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.business.BusinessQuery;
import com.sas.iquery.metadata.business.DataItem;
import com.sas.iquery.metadata.business.DataSelection;
import com.sas.iquery.metadata.business.step.StepFilterInterface;
import com.sas.iquery.metadata.business.step.StepInterface;
import com.sas.iquery.metadata.business.step.olap.DataItemMemberFilter;
import com.sas.iquery.metadata.business.step.olap.DataItemTimeFirstLastPeriodsFilter;
import com.sas.iquery.metadata.business.step.olap.DataItemTimeNPeriodsFilter;
import com.sas.iquery.metadata.business.step.olap.DataItemTimeRangeFilter;
import com.sas.util.ListFactory;
import com.sas.util.log.LoggerRepository2;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class OLAPTimeBasedFilterCommand
extends BaseSelectorCommand
implements CommandStatusInterface {
    private String RB_KEY = "OLAPTimeBasedFilterCommand.";
    protected String remoteAction;
    protected boolean isRefreshBusinessQueryOnCommit;
    private static String ENCODING = "UTF-8";
    private boolean swing;

    public OLAPTimeBasedFilterCommand() {
        this(true);
    }

    public OLAPTimeBasedFilterCommand(boolean isRefreshBusinessQueryOnCommit) {
        this.isRefreshBusinessQueryOnCommit = isRefreshBusinessQueryOnCommit;
    }

    public OLAPTimeBasedFilterCommand(String name) {
        super(name);
        this.isRefreshBusinessQueryOnCommit = true;
    }

    public OLAPTimeBasedFilterCommand(String name, String actionClass) {
        this(name);
        this.actionClass = actionClass;
        this.isRefreshBusinessQueryOnCommit = true;
    }

    public OLAPTimeBasedFilterCommand(String name, boolean swing) {
        this(name);
        this.setSwing(swing);
    }

    protected void show(Object o) {
        DataSelectorInterface selector = this.getSelector();
        if (selector == null) {
            throw new IllegalStateException(RB.getStringResource((String)this.RB_KEY, (String)"noSelectorError.txt"));
        }
        Object selectorModel = this.getSelectorModel();
        if (selectorModel == null) {
            selectorModel = this.createAdapter(this.getModel());
            this.setSelectorModel(selectorModel);
        }
        selector.setSelectorModel(selectorModel);
        this.eventInfo.clear();
        super.show(o);
    }

    public void cancel(Object o) {
        this.eventInfo.clear();
        super.cancel(o);
        this.closeSelector();
    }

    protected void commit(Object o) throws IOException {
        String showOption;
        Object dataItem;
        Object adapter = this.getSelectorModel();
        if (adapter instanceof TimeBasedFilterAdapterInterface && (dataItem = ((TimeBasedFilterAdapterInterface)adapter).getDataItem()) instanceof DataItem && (showOption = this.getShowOption()) != null) {
            StepFilterInterface filter = null;
            if (showOption.equals("NPERIODS")) {
                filter = this.newNPeriodsFilter();
            } else if (showOption.equals("ACROSS")) {
                filter = this.newNParallelPeriodsFilter();
            } else if (showOption.equals("RANGE")) {
                filter = this.newRangeFilter();
            }
            if (filter != null) {
                this.removeNotCompatibleFilters((DataItem)dataItem);
                try {
                    ((DataItem)dataItem).addStep((StepInterface)filter);
                }
                catch (MetadataException metadataException) {
                    // empty catch block
                }
                if (this.isRefreshBusinessQueryOnCommit && this.model instanceof BusinessQueryProviderInterface) {
                    try {
                        BusinessQuery businessQuery = this.getBusinessQuery(this.model);
                        ((BusinessQueryProviderInterface)this.model).refreshBusinessQuery(businessQuery);
                        this.eventSource = this.model;
                        this.contentsChanged = true;
                    }
                    catch (IntelligentQueryException intelligentQueryException) {
                        // empty catch block
                    }
                }
            }
        }
        super.commit(o);
        this.closeSelector();
    }

    private BusinessQuery getBusinessQuery(Object model) {
        BusinessQuery businessQuery = null;
        if (model instanceof BusinessQueryProviderInterface) {
            businessQuery = ((BusinessQueryProviderInterface)model).getBusinessQuery();
        }
        return businessQuery;
    }

    private void removeNotCompatibleFilters(DataItem dataItem) {
        int found;
        List steps;
        if (dataItem != null && (steps = ListFactory.newList((Collection)dataItem.getSteps())) != null && steps.size() > 0 && (found = this.indexOfNotCompatibleFilter(steps)) >= 0) {
            dataItem.removeStep(found);
            this.removeNotCompatibleFilters(dataItem);
        }
    }

    private int indexOfNotCompatibleFilter(List steps) {
        int found = -1;
        if (steps != null) {
            int nSteps = steps.size();
            Object step = null;
            for (int i = 0; i < nSteps; ++i) {
                step = steps.get(i);
                if (!(step instanceof DataItemTimeFirstLastPeriodsFilter) && !(step instanceof DataItemTimeNPeriodsFilter) && !(step instanceof DataItemTimeRangeFilter) && !(step instanceof DataItemMemberFilter)) continue;
                found = i;
                break;
            }
        }
        return found;
    }

    private StepFilterInterface newNPeriodsFilter() {
        String selectOption;
        DataItemTimeNPeriodsFilter filter = null;
        String numberOfPeriods = this.getNumberOfPeriods();
        if (numberOfPeriods != null && (selectOption = this.getSelectOption()) != null) {
            String direction = "STARTINGPERIOD".equals(selectOption) ? "FORWARD" : "BACKWARD";
            OLAPTimeBasedFilterAdapterInterface adapter = (OLAPTimeBasedFilterAdapterInterface)this.getSelectorModel();
            if (adapter != null) {
                String level = adapter.getPeriodType();
                String date = null;
                if ("FORWARD".equals(direction) && "SELECTEDPERIOD".equals(this.getStartingPeriodOption())) {
                    date = adapter.getSelectedStartingPeriod();
                } else if ("BACKWARD".equals(direction) && "SELECTEDPERIOD".equals(this.getEndingPeriodOption())) {
                    date = adapter.getSelectedEndingPeriod();
                }
                int nPeriods = -1;
                try {
                    nPeriods = new Double(Double.parseDouble(numberOfPeriods)).intValue();
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                if (nPeriods > 0) {
                    if (date != null) {
                        filter = new DataItemTimeNPeriodsFilter(nPeriods, direction, date);
                    } else if (level != null) {
                        filter = new DataItemTimeFirstLastPeriodsFilter(nPeriods, direction, level);
                    }
                }
            }
        }
        return filter;
    }

    private StepFilterInterface newNParallelPeriodsFilter() {
        StepFilterInterface filter = null;
        return filter;
    }

    private StepFilterInterface newRangeFilter() {
        DataItemTimeRangeFilter filter = null;
        String startDate = null;
        String endDate = null;
        String startingPeriodOption = this.getStartingPeriodOption();
        String endingPeriodOption = this.getEndingPeriodOption();
        OLAPTimeBasedFilterAdapterInterface adapter = (OLAPTimeBasedFilterAdapterInterface)this.getSelectorModel();
        if (startingPeriodOption != null && endingPeriodOption != null && adapter != null) {
            filter = new DataItemTimeRangeFilter();
            filter.setLevel(adapter.getPeriodType());
            startDate = "FIRSTPERIOD".equals(startingPeriodOption) ? null : adapter.getSelectedStartingPeriod();
            String string = endDate = "LASTPERIOD".equals(endingPeriodOption) ? null : adapter.getSelectedEndingPeriod();
            if (startDate != null) {
                filter.setStartDateMember(startDate);
            }
            if (endDate != null) {
                filter.setEndDateMember(endDate);
            }
        }
        return filter;
    }

    protected OLAPTimeBasedFilterAdapterInterface createAdapter(Object model) {
        OLAPTimeBasedFilterAdapter adapter = null;
        if (model instanceof BusinessQueryProviderInterface) {
            OLAPTimeBasedFilterAdapterDataSource dataSource = new OLAPTimeBasedFilterAdapterDataSource((BusinessQueryProviderInterface)model);
            adapter = new OLAPTimeBasedFilterAdapter(dataSource);
        }
        return adapter;
    }

    private void updateEventInfo(Map infoMap) {
        this.eventSource = this.model;
        this.contentsChanged = true;
        Exception e = (Exception)infoMap.get("EXCEPTION_OCCURRED");
        if (e != null) {
            LoggerRepository2.getLogger((String)((Object)((Object)this)).getClass().getName(), null).error(e.getMessage(), (Throwable)e);
        }
    }

    public int getCommandStatus(ActionSupportFilter actionFilter) {
        DataSelection ds;
        BusinessQueryProviderInterface bqProvider;
        Object model = actionFilter.getAttribute("model");
        if (model instanceof BusinessQueryProviderInterface && (bqProvider = (BusinessQueryProviderInterface)model).getBusinessQuery() instanceof DataSelection && (ds = (DataSelection)bqProvider.getBusinessQuery()).getInputStructure().isOLAP()) {
            return 0;
        }
        return 2;
    }

    public void setSwing(boolean swing) {
        this.swing = swing;
    }

    public boolean isSwing() {
        return this.swing;
    }

    protected void process(Object o) {
        this.eventInfo.clear();
        super.process(o);
        this.setRemoteAction("");
    }

    public void setPanelVisible(boolean visible) {
        OLAPTimeBasedFilterAdapterInterface adapter = null;
        Object selectorModel = this.getSelectorModel();
        if (selectorModel == null) {
            throw new IllegalStateException(RB.getStringResource((String)this.RB_KEY, (String)"nullAdapter.txt", (Locale)this.getLocale()));
        }
        if (!(selectorModel instanceof OLAPTimeBasedFilterAdapterInterface)) {
            throw new IllegalStateException(RB.getStringResource((String)this.RB_KEY, (String)"invalidAdapterType.txt", (Locale)this.getLocale()));
        }
        adapter = (OLAPTimeBasedFilterAdapterInterface)selectorModel;
        adapter.setPanelVisible(visible);
    }

    public String getPeriodType() {
        String value = null;
        OLAPTimeBasedFilterAdapterInterface adapter = (OLAPTimeBasedFilterAdapterInterface)this.getSelectorModel();
        if (adapter != null) {
            value = adapter.getPeriodType();
        }
        return value;
    }

    public void setPeriodType(String value) {
        OLAPTimeBasedFilterAdapterInterface adapter = (OLAPTimeBasedFilterAdapterInterface)this.getSelectorModel();
        if (adapter != null) {
            adapter.setPeriodType(value);
        }
    }

    public String getNumberOfPeriods() {
        String value = null;
        OLAPTimeBasedFilterAdapterInterface adapter = (OLAPTimeBasedFilterAdapterInterface)this.getSelectorModel();
        if (adapter != null) {
            value = adapter.getNumberOfPeriods();
        }
        return value;
    }

    public void setNumberOfPeriods(String value) {
        OLAPTimeBasedFilterAdapterInterface adapter = (OLAPTimeBasedFilterAdapterInterface)this.getSelectorModel();
        if (adapter != null) {
            adapter.setNumberOfPeriods(value);
        }
    }

    public String getSelectOption() {
        String value = null;
        OLAPTimeBasedFilterAdapterInterface adapter = (OLAPTimeBasedFilterAdapterInterface)this.getSelectorModel();
        if (adapter != null) {
            value = adapter.getSelectOption();
        }
        return value;
    }

    public void setSelectOption(String value) {
        OLAPTimeBasedFilterAdapterInterface adapter = (OLAPTimeBasedFilterAdapterInterface)this.getSelectorModel();
        if (adapter != null) {
            adapter.setSelectOption(value);
        }
    }

    public String getStartingPeriodOption() {
        String value = null;
        OLAPTimeBasedFilterAdapterInterface adapter = (OLAPTimeBasedFilterAdapterInterface)this.getSelectorModel();
        if (adapter != null) {
            value = adapter.getStartingPeriodOption();
        }
        return value;
    }

    public void setStartingPeriodOption(String value) {
        OLAPTimeBasedFilterAdapterInterface adapter = (OLAPTimeBasedFilterAdapterInterface)this.getSelectorModel();
        if (adapter != null) {
            adapter.setStartingPeriodOption(value);
        }
    }

    public String getEndingPeriodOption() {
        String value = null;
        OLAPTimeBasedFilterAdapterInterface adapter = (OLAPTimeBasedFilterAdapterInterface)this.getSelectorModel();
        if (adapter != null) {
            value = adapter.getEndingPeriodOption();
        }
        return value;
    }

    public void setEndingPeriodOption(String value) {
        OLAPTimeBasedFilterAdapterInterface adapter = (OLAPTimeBasedFilterAdapterInterface)this.getSelectorModel();
        if (adapter != null) {
            adapter.setEndingPeriodOption(value);
        }
    }

    public String[] getSelectedPeriods() {
        String[] value = null;
        OLAPTimeBasedFilterAdapterInterface adapter = (OLAPTimeBasedFilterAdapterInterface)this.getSelectorModel();
        if (adapter != null) {
            value = adapter.getSelectedPeriods();
        }
        return value;
    }

    public void setSelectedPeriods(String[] values) {
        OLAPTimeBasedFilterAdapterInterface adapter = (OLAPTimeBasedFilterAdapterInterface)this.getSelectorModel();
        if (adapter != null) {
            adapter.setSelectedPeriods(values);
        }
    }

    public String getShowOption() {
        String value = null;
        OLAPTimeBasedFilterAdapterInterface adapter = (OLAPTimeBasedFilterAdapterInterface)this.getSelectorModel();
        if (adapter != null) {
            value = adapter.getShowOption();
        }
        return value;
    }

    public void setShowOption(String value) {
        OLAPTimeBasedFilterAdapterInterface adapter = (OLAPTimeBasedFilterAdapterInterface)this.getSelectorModel();
        if (adapter != null) {
            adapter.setShowOption(value);
        }
    }

    public String getSelectedStartingPeriod() {
        String value = null;
        OLAPTimeBasedFilterAdapterInterface adapter = (OLAPTimeBasedFilterAdapterInterface)this.getSelectorModel();
        if (adapter != null) {
            value = adapter.getSelectedStartingPeriod();
        }
        return value;
    }

    public void setSelectedStartingPeriod(String value) {
        OLAPTimeBasedFilterAdapterInterface adapter = (OLAPTimeBasedFilterAdapterInterface)this.getSelectorModel();
        if (adapter != null) {
            adapter.setSelectedStartingPeriod(value);
        }
    }

    public String getSelectedEndingPeriod() {
        String value = null;
        OLAPTimeBasedFilterAdapterInterface adapter = (OLAPTimeBasedFilterAdapterInterface)this.getSelectorModel();
        if (adapter != null) {
            value = adapter.getSelectedEndingPeriod();
        }
        return value;
    }

    public void setSelectedEndingPeriod(String value) {
        OLAPTimeBasedFilterAdapterInterface adapter = (OLAPTimeBasedFilterAdapterInterface)this.getSelectorModel();
        if (adapter != null) {
            adapter.setSelectedEndingPeriod(value);
        }
    }

    public void setRemoteAction(String value) {
        try {
            this.remoteAction = URLDecoder.decode(value, ENCODING).trim();
        }
        catch (UnsupportedEncodingException e) {
            LoggerRepository2.getLogger((String)((Object)((Object)this)).getClass().getName(), null).error(e.getMessage(), (Throwable)e);
        }
    }

    public String getRemoteAction() {
        return this.remoteAction;
    }
}

