/*
 * Decompiled with CFR 0.152.
 */
package com.sas.commands.dataselectors;

import com.sas.actionprovider.ActionSupportFilter;
import com.sas.actionprovider.CommandStatusInterface;
import com.sas.actionprovider.CommandSupportedInterface;
import com.sas.commands.dataselectors.BaseSelectorCommand;
import com.sas.commands.dataselectors.RB;
import com.sas.dataselectors.DataSelectorInterface;
import com.sas.dataselectors.filterandrank.FilterAndRankModel;
import com.sas.dataselectors.filterandrank.FilterAndRankModelInterface;
import com.sas.dataselectors.filterandrank.FilterAxisEnum;
import com.sas.dataselectors.filterandrank.FilterOperatorEnum;
import com.sas.dataselectors.filterandrank.FilterTypeEnum;
import com.sas.dataselectors.filterandrank.RankOrderEnum;
import com.sas.dataselectors.filterandrank.RankTypeEnum;
import com.sas.iquery.intelligentquery.BusinessQueryProviderInterface;
import com.sas.iquery.intelligentquery.IntelligentQueryException;
import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.business.BusinessQuery;
import com.sas.iquery.metadata.business.DataItem;
import com.sas.iquery.metadata.business.DataItemActionType;
import com.sas.iquery.metadata.business.Role;
import com.sas.iquery.metadata.business.step.StepInterface;
import com.sas.iquery.metadata.expr.FractionOfTotalExpression;
import com.sas.storage.olap.OLAPException;
import com.sas.storage.olap.TupleElementInterface;
import com.sas.storage.olap.TupleElementType;
import com.sas.storage.olap.TupleInterface;
import com.sas.util.ChainedException;
import com.sas.util.log.CommonLoggerInterface;
import com.sas.util.log.LoggerRepository2;
import java.io.IOException;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class FilterAndRankSelectorCommand
extends BaseSelectorCommand
implements CommandSupportedInterface,
CommandStatusInterface {
    public static final String RB_KEY = "FilterAndRankSelectorCommand.";
    private String action;
    protected Map actionInfo = new HashMap();
    public static String mode = "SHOW";
    FilterAxisEnum role;
    FilterTypeEnum filterType;
    FilterOperatorEnum filterCondition;
    String filterValue;
    RankOrderEnum rankOrder;
    String rankValue;
    RankTypeEnum rankType;
    String rankOption;
    String clearRow;
    String clearCol;
    private CommonLoggerInterface log = LoggerRepository2.getLogger((String)FilterAndRankSelectorCommand.class.getName(), null);
    protected TupleElementInterface tupleElement;

    public FilterAndRankSelectorCommand() {
        this.log.debug("_DEBUG_:default constructor");
    }

    public FilterAndRankSelectorCommand(String name) {
        this(name, null);
    }

    public FilterAndRankSelectorCommand(String name, String actionClass) {
        super(name, actionClass);
        this.log.debug("_DEBUG_:name=" + name + ", actionClass=" + actionClass);
        this.role = FilterAxisEnum.COLUMNS;
        this.filterCondition = null;
    }

    protected void show(Object o) {
        mode = "SHOW";
        this.log.debug("_DEBUG_:ENTERing show method");
        Object model = this.getModel();
        if (model != null) {
            BusinessQuery businessQuery;
            this.log.debug("_DEBUG_:show: model class is ", model.getClass().getName());
            FilterAndRankModel newSelectorModel = null;
            if (model instanceof BusinessQuery || model instanceof BusinessQueryProviderInterface) {
                if (model instanceof BusinessQuery) {
                    businessQuery = (BusinessQuery)model;
                } else {
                    try {
                        businessQuery = ((BusinessQueryProviderInterface)model).getBusinessQuery();
                    }
                    catch (RuntimeException e) {
                        businessQuery = null;
                    }
                }
                if (businessQuery == null) {
                    return;
                }
                if (!businessQuery.getInputStructure().isOLAP()) {
                    throw new IllegalArgumentException(RB.getStringResource((String)RB_KEY, (String)"invalidModel.txt", (Locale)this.getLocale()));
                }
            } else {
                throw new IllegalArgumentException(RB.getStringResource((String)RB_KEY, (String)"invalidModel.txt", (Locale)this.getLocale()));
            }
            newSelectorModel = new FilterAndRankModel();
            newSelectorModel.setBusinessQuery(businessQuery);
            newSelectorModel.setTupleElement(this.getTupleElement());
            DataSelectorInterface selector = this.getSelector();
            if (selector != null && newSelectorModel != null) {
                this.setSelectorModel(newSelectorModel);
                selector.setSelectorModel((Object)newSelectorModel);
            } else {
                this.log.error(" ERROR - selector or adapter is NULL!");
            }
        } else {
            this.log.error(" ERROR - model is NULL!");
            return;
        }
        this.eventInfo.clear();
        this.actionInfo.clear();
        this.log.debug("_DEBUG_:EXITing show method");
        super.show(o);
    }

    protected void cleanUp() {
        this.getSelector().setSelectorModel(null);
        this.setSelectorModel(null);
        this.setModel(null);
    }

    protected boolean isSwing() {
        return this.getAttribute("request") == null;
    }

    protected void process(Object o) {
        this.log.debug("_DEBUG_:ENTERing process method");
        mode = "PROCESS";
        this.eventInfo.clear();
        super.process(o);
        boolean modified = false;
        BusinessQuery businessQuery = ((BusinessQueryProviderInterface)this.model).getBusinessQuery();
        if (modified) {
            this.contentsChanged = true;
            this.eventSource = this.getModel();
            this.eventInfo.put("request", this.getAttribute("request"));
            this.eventInfo.put("response", this.getAttribute("response"));
        }
        this.actionInfo.clear();
        this.log.debug("_DEBUG_:EXITing process method");
    }

    public void cancel(Object o) {
        this.log.debug("_DEBUG_:ENTERing cancel method");
        this.eventInfo.clear();
        this.cleanUp();
        super.cancel(o);
        this.log.debug("_DEBUG_:EXITing cancel method");
    }

    protected void commit(Object o) throws IOException {
        boolean commitOk;
        this.log.debug("_DEBUG_:ENTERing commit method...");
        mode = "COMMIT";
        this.eventInfo.clear();
        boolean changed = false;
        FilterAndRankModelInterface farModel = (FilterAndRankModelInterface)this.selectorModel;
        if (this.isSwing()) {
            commitOk = true;
        } else {
            commitOk = false;
            if ("Y".equalsIgnoreCase(this.clearCol)) {
                this.log.debug("_DEBUG_: Clearing COLUMN step...");
                if (farModel.clearStep(FilterAxisEnum.COLUMNS)) {
                    changed = true;
                }
            }
            if ("Y".equalsIgnoreCase(this.clearRow)) {
                this.log.debug("_DEBUG_: Clearing ROW step...");
                if (farModel.clearStep(FilterAxisEnum.ROWS)) {
                    changed = true;
                }
            }
            StepInterface step = null;
            step = FilterTypeEnum.FILTER == this.filterType ? this.createFilterStep() : this.createRankStep();
            if (null != step) {
                try {
                    this.role = farModel.getFilterAxis();
                    farModel.setStep((Object)step, this.role);
                    commitOk = true;
                }
                catch (OLAPException e) {
                    commitOk = false;
                }
            } else {
                commitOk = false;
            }
        }
        if (commitOk || changed) {
            try {
                changed = farModel.applyChanges();
            }
            catch (ChainedException e) {
                commitOk = false;
                LoggerRepository2.getLogger((String)((Object)((Object)this)).getClass().getName(), null).error("An error occurred apply model changes!", (Throwable)e);
            }
            this.contentsChanged = true;
            this.eventSource = this.getModel();
            this.eventInfo.put("request", this.getAttribute("request"));
            this.eventInfo.put("response", this.getAttribute("response"));
            this.eventInfo.put("ROW_COLUMN", "INITIALIZE");
            if (changed && this.model instanceof BusinessQueryProviderInterface) {
                try {
                    ((BusinessQueryProviderInterface)this.model).refreshBusinessQuery(((BusinessQueryProviderInterface)this.model).getBusinessQuery());
                }
                catch (IntelligentQueryException e) {
                    LoggerRepository2.getLogger((String)((Object)((Object)this)).getClass().getName(), null).error(e.getMessage(), (Throwable)e);
                }
            }
        }
        this.eventInfo.put("commit", commitOk);
        this.cleanUp();
        super.commit(o);
        this.log.debug("_DEBUG_:Leaving commit method...");
    }

    private StepInterface createRankStep() {
        FilterAndRankModelInterface farModel = null;
        boolean okToCommit = false;
        Number value = null;
        boolean includeTies = "Y".equalsIgnoreCase(this.rankOption);
        if (this.selectorModel instanceof FilterAndRankModelInterface) {
            farModel = (FilterAndRankModelInterface)this.selectorModel;
            okToCommit = true;
            if (null != this.rankValue) {
                NumberFormat formatter = NumberFormat.getIntegerInstance(this.getLocale());
                try {
                    value = formatter.parse(this.rankValue);
                }
                catch (ParseException e) {
                    okToCommit = false;
                }
            } else {
                okToCommit = false;
            }
        }
        StepInterface step = null != farModel && true == okToCommit ? (StepInterface)farModel.createRankStep(this.rankOrder, value.intValue(), includeTies, this.rankType) : null;
        return step;
    }

    private StepInterface createFilterStep() {
        FilterAndRankModelInterface farModel = null;
        boolean okToCommit = false;
        Number value = null;
        if (this.selectorModel instanceof FilterAndRankModelInterface) {
            farModel = (FilterAndRankModelInterface)this.selectorModel;
            okToCommit = false;
            if (null != this.filterValue) {
                if ("null".equalsIgnoreCase(this.filterValue) || ".".equals(this.filterValue)) {
                    this.filterValue = "NULL";
                    okToCommit = true;
                } else {
                    NumberFormat formatter = NumberFormat.getNumberInstance(this.getLocale());
                    try {
                        value = formatter.parse(this.filterValue);
                        okToCommit = true;
                    }
                    catch (ParseException parseException) {
                        // empty catch block
                    }
                }
            }
        }
        StepInterface step = null != farModel && true == okToCommit ? (StepInterface)farModel.createFilterStep(this.filterCondition, this.filterValue) : null;
        return step;
    }

    public String getFilterCondition() {
        return null == this.filterCondition ? null : this.filterCondition.toString();
    }

    public void setFilterCondition(FilterOperatorEnum filterCondition) {
        this.filterCondition = filterCondition;
    }

    public void setFilterCondition(String name) {
        this.setFilterCondition(FilterOperatorEnum.findType((String)name));
    }

    public void setAction(String value) {
        this.action = value;
    }

    public String getAction() {
        return this.action;
    }

    protected static String getID(Object object) {
        String id = null;
        if (object != null) {
            id = Integer.toHexString(System.identityHashCode(object));
        }
        return id;
    }

    public int getCommandStatus(ActionSupportFilter filter) {
        int status = 0;
        Object model = filter.getAttribute("model");
        BusinessQuery bq = null;
        if (model instanceof BusinessQueryProviderInterface) {
            bq = ((BusinessQueryProviderInterface)model).getBusinessQuery();
        } else if (model instanceof BusinessQuery) {
            bq = (BusinessQuery)model;
        } else if (model instanceof FilterAndRankModelInterface) {
            bq = (BusinessQuery)((FilterAndRankModelInterface)model).getBusinessQuery();
        }
        Object dataItem = filter.getAttribute("dataItem");
        if (dataItem != null && dataItem instanceof DataItem) {
            try {
                DataItem di = (DataItem)dataItem;
                if (di != null && di.getExpression() instanceof FractionOfTotalExpression) {
                    status = 4;
                    return status;
                }
                Object tupleElement = filter.getAttribute("tupleElement");
                if (tupleElement != null && tupleElement instanceof TupleElementInterface) {
                    TupleInterface tuple = ((TupleElementInterface)tupleElement).getTuple();
                    TupleElementInterface[] elements = tuple.getElements(0, -1);
                    for (int i = 0; i < elements.length; ++i) {
                        TupleElementType tType = elements[i].getType();
                        if (!TupleElementType.TOTAL.equals(tType) && !TupleElementType.SUBTOTAL.equals(tType)) continue;
                        status = 2;
                        return status;
                    }
                }
            }
            catch (OLAPException di) {
                // empty catch block
            }
        }
        if (null != bq) {
            if (bq.getInputStructure().isOLAP()) {
                try {
                    List items = bq.getResultItems(Role.COLUMN);
                    items.addAll(bq.getResultItems(Role.ROW));
                    status = this._getCommandStatus(items);
                }
                catch (MetadataException metadataException) {}
            } else {
                status = 2;
            }
        }
        return status;
    }

    private int _getCommandStatus(List items) {
        int size = items.size();
        for (int i = 0; i < size; ++i) {
            DataItem di = (DataItem)items.get(i);
            if (!di.isActionSupported(DataItemActionType.STEP_RANK) && !di.isActionSupported(DataItemActionType.STEP_DATABASED_FILTER)) continue;
            return 0;
        }
        return 4;
    }

    public boolean isSupported(ActionSupportFilter actionFilter) {
        Object model = actionFilter.getAttribute("model");
        BusinessQuery bq = null;
        if (model instanceof BusinessQueryProviderInterface) {
            bq = ((BusinessQueryProviderInterface)model).getBusinessQuery();
        } else if (model instanceof BusinessQuery) {
            bq = (BusinessQuery)model;
        } else if (model instanceof FilterAndRankModelInterface) {
            bq = (BusinessQuery)((FilterAndRankModelInterface)model).getBusinessQuery();
        }
        return bq != null;
    }

    public void execute(Object o) {
        super.execute(o);
    }

    public void setTupleElement(TupleElementInterface tupleElement) {
        this.tupleElement = tupleElement;
    }

    public TupleElementInterface getTupleElement() {
        return this.tupleElement;
    }

    public void setModel(Object model) {
        super.setModel(model);
    }

    public String getFilterType() {
        return null == this.filterType ? null : this.filterType.toString();
    }

    public void setFilterType(FilterTypeEnum filterType) {
        this.filterType = filterType;
    }

    public void setFilterType(String typeText) {
        this.filterType = FilterTypeEnum.findType((String)typeText);
    }

    public String getFilterValue() {
        return this.filterValue;
    }

    public void setFilterValue(String filterValue) {
        this.filterValue = filterValue;
    }

    public String getRankType() {
        return null == this.rankType ? null : this.rankType.toString();
    }

    public void setRankType(RankTypeEnum rankType) {
        this.rankType = rankType;
    }

    public void setRankType(String text) {
        this.setRankType(RankTypeEnum.findType((String)text));
    }

    public String getRankOrder() {
        return null == this.rankOrder ? null : this.rankOrder.toString();
    }

    public void setRankOrder(RankOrderEnum order) {
        this.rankOrder = order;
    }

    public void setRankOrder(String text) {
        this.setRankOrder(RankOrderEnum.findType((String)text));
    }

    public String getRankValue() {
        return this.rankValue;
    }

    public void setRankValue(String rankValue) {
        this.rankValue = rankValue;
    }

    public String getRankOption() {
        return this.rankOption;
    }

    public void setRankOption(String rankOption) {
        this.rankOption = rankOption;
    }

    public String getClearCol() {
        return this.clearCol;
    }

    public void setClearCol(String clearCol) {
        this.clearCol = clearCol;
    }

    public String getClearRow() {
        return this.clearRow;
    }

    public void setClearRow(String clearRow) {
        this.clearRow = clearRow;
    }
}

