/*
 * Decompiled with CFR 0.152.
 */
package com.sas.commands.dataselectors;

import com.sas.actionprovider.ActionSupportFilter;
import com.sas.actionprovider.CommandSupportedInterface;
import com.sas.commands.dataselectors.BaseSelectorCommand;
import com.sas.commands.dataselectors.RB;
import com.sas.dataselectors.DataSelectorInterface;
import com.sas.dataselectors.dataitems.DataItemSelectorInterface;
import com.sas.dataselectors.dataitems.DataItemSelectorModel;
import com.sas.dataselectors.dataitems.DataItemSelectorModelOLAPTable;
import com.sas.dataselectors.dataitems.DataItemSelectorModelRelationalTable;
import com.sas.iquery.intelligentquery.BusinessQueryProviderInterface;
import com.sas.iquery.metadata.InvalidIDException;
import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.StructureOfData;
import com.sas.iquery.metadata.business.BusinessModel;
import com.sas.iquery.metadata.business.BusinessQuery;
import com.sas.iquery.metadata.business.BusinessQueryActionType;
import com.sas.iquery.metadata.business.DataItem;
import com.sas.iquery.metadata.business.DataItemActionType;
import com.sas.iquery.metadata.business.DataItemReference;
import com.sas.iquery.metadata.business.Reason;
import com.sas.iquery.metadata.business.Role;
import com.sas.util.RoleInterface;
import com.sas.util.log.LoggerRepository2;
import com.sas.util.transforms.StringArrayToVectorTransform;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;

public class DataItemSelectorCommand
extends BaseSelectorCommand
implements CommandSupportedInterface {
    static final String RB_KEY = "DataItemSelector.";
    protected Object model;
    protected DataItemSelectorInterface selectorModel;
    protected String action = null;
    protected String data = null;
    public static final String SHOW_MODE = "SHOW";
    public static final String PROCESS_MODE = "PROCESS";
    public static final String CANCEL_MODE = "CANCEL";
    public static final String COMMIT_MODE = "COMMIT";
    public static final String UPDATE_ITEMS = "updateitems";
    public static final String SORT_ITEMS = "sortitems";
    public static final String MOVE_ITEMS = "moveitems";
    public static final String CHANGE_ROLE = "changerole";
    public static final String MOVE_ITEM_UP = "moveitemup";
    public static final String MOVE_ITEM_DOWN = "moveitemdown";
    public static final String CHANGE_QUERY_TYPE = "changequerytype";
    public static final String ENABLE_BUTTONS = "enablebuttons";
    public static final String COMMIT = "commit";
    private static String COLUMN_LABEL = RB.getStringResource((String)"DataItemSelector.columnRoleLabel.txt");
    private static String ROW_LABEL = RB.getStringResource((String)"DataItemSelector.rowRoleLabel.txt");
    private static String SLICER_LABEL = RB.getStringResource((String)"DataItemSelector.slicerRoleLabel.txt");
    private static String FILTER_LABEL = RB.getStringResource((String)"DataItemSelector.filterRoleLabel.txt");
    protected String[] selectedItems;
    protected String[] unselectedItems;
    protected String[] selectedIndexes;
    protected String role;
    private String mode;
    protected String queryType;
    private String actionClass;

    public DataItemSelectorCommand() {
    }

    public DataItemSelectorCommand(String name) {
        super(name);
    }

    public DataItemSelectorCommand(String name, String actionClass) {
        this(name);
        this.actionClass = actionClass;
    }

    protected void show(Object o) {
        this.model = this.getModel();
        if (this.model != null) {
            try {
                DataItemSelectorModel rpi = null;
                if (this.model instanceof BusinessQueryProviderInterface) {
                    BusinessQueryProviderInterface bqpinterface = (BusinessQueryProviderInterface)this.model;
                    BusinessQuery bquery = bqpinterface.getBusinessQuery();
                    rpi = DataItemSelectorCommand.createRoleProvider(bquery);
                }
                DataSelectorInterface rSelector = this.getSelector();
                rSelector.setSelectorModel(rpi);
            }
            catch (ClassCastException e) {
                LoggerRepository2.getLogger((String)((Object)((Object)this)).getClass().getName(), null).error(e.getMessage(), (Throwable)e);
            }
            catch (Exception e) {
                LoggerRepository2.getLogger((String)((Object)((Object)this)).getClass().getName(), null).error(e.getMessage(), (Throwable)e);
            }
        }
        this.eventInfo.clear();
        super.show(o);
    }

    protected void process(Object o) {
        this.eventInfo.clear();
        String selectordata = this.getData();
        this.eventInfo.put("action", this.action);
        this.eventInfo.put("data", selectordata);
        this.model = this.getModel();
        DataItemSelectorInterface roleProvider = (DataItemSelectorInterface)this.selector.getSelectorModel();
        RoleInterface workingRole = null;
        Object deleteRole = null;
        RoleInterface[] availableRoles = roleProvider.getRoles();
        String role = this.getRole();
        if (role != null) {
            workingRole = this.getRoleInterface(role);
        }
        int numRoles = availableRoles.length;
        int i = 0;
        if (workingRole != null) {
            Map itemmap = roleProvider.getDataItemMap();
            String action = this.getAction();
            Vector itemVector = null;
            Object obj = null;
            if (action.equalsIgnoreCase(UPDATE_ITEMS) || action.equalsIgnoreCase(MOVE_ITEMS) || action.equalsIgnoreCase(MOVE_ITEM_UP) || action.equalsIgnoreCase(MOVE_ITEM_DOWN)) {
                StringArrayToVectorTransform itemTransform = new StringArrayToVectorTransform();
                String[] selectedItems = this.getSelectedItems();
                String[] unselectedItems = this.getUnselectedItems();
                if (selectedItems != null) {
                    obj = itemTransform.transform((Object)selectedItems);
                } else if (unselectedItems != null) {
                    obj = itemTransform.transform((Object)unselectedItems);
                }
                itemVector = (Vector)obj;
            }
            if (action.equalsIgnoreCase(UPDATE_ITEMS)) {
                this.eventInfo.put("role", workingRole);
                if (this.selectedItems != null) {
                    List addItemsList = this.createAddItemsList(itemVector, itemmap);
                    List badItems = workingRole.addRoleItems(addItemsList);
                    if (badItems != null) {
                        System.out.println("badItems contains " + badItems.size() + " items");
                    }
                } else {
                    workingRole = this.getRoleInterface(selectordata);
                    List deleteItemsList = this.createItemsListByIndex(workingRole);
                    int numItems = deleteItemsList.size();
                    for (i = 0; i < numItems; ++i) {
                        workingRole.removeRoleItem(deleteItemsList.get(i));
                    }
                }
            } else if (action.equalsIgnoreCase(MOVE_ITEMS)) {
                RoleInterface targetRole = this.getRoleInterface(selectordata);
                RoleInterface removeRole = this.getRoleInterface(this.getRole());
                List itemsList = this.createItemsListByIndex(removeRole);
                if (itemsList != null) {
                    this.moveItemsToRole(itemsList, targetRole);
                }
            } else if (action.equalsIgnoreCase(MOVE_ITEM_UP) || action.equalsIgnoreCase(MOVE_ITEM_DOWN)) {
                workingRole = this.getRoleInterface(selectordata);
                List itemsList = this.createItemsListByIndex(workingRole);
                int numItems = itemsList.size();
                if (action.equalsIgnoreCase(MOVE_ITEM_DOWN)) {
                    for (int k = numItems - 1; k >= 0; --k) {
                        Object thisitem = itemsList.get(k);
                        workingRole.moveRoleItem(thisitem, 1);
                    }
                } else if (action.equalsIgnoreCase(MOVE_ITEM_UP)) {
                    for (int k = 0; k < numItems; ++k) {
                        Object thisitem = itemsList.get(k);
                        workingRole.moveRoleItem(thisitem, -1);
                    }
                }
            } else if (action.equalsIgnoreCase(CHANGE_QUERY_TYPE)) {
                roleProvider.setSelectedItemsQueryType(this.data);
            }
        } else {
            String string = this.getAction();
        }
        this.contentsChanged = true;
        this.eventSource = this.model;
        this.eventInfo.put("request", this.getAttribute("request"));
        this.eventInfo.put("response", this.getAttribute("response"));
        this.setSelectedItems(null);
        this.setUnselectedItems(null);
        this.setSelectedIndexes(null);
        super.process(o);
    }

    private List createItemsListByIndex(RoleInterface role) {
        List selectedItems = role.getRoleItems();
        String[] indexes = this.getSelectedIndexes();
        ArrayList moveList = new ArrayList();
        for (int i = 0; i < indexes.length; ++i) {
            int i1 = Integer.parseInt(indexes[i]);
            moveList.add(selectedItems.get(i1));
        }
        return moveList;
    }

    protected void moveItemsToRole(List items, RoleInterface targetRole) {
        RoleInterface measureRole = null;
        int itemsSize = items.size();
        for (int i = 0; i < itemsSize; ++i) {
            Object item = items.get(i);
            RoleInterface itemRole = this.findRoleForItem(item);
            if (!this.isMeasure(item)) continue;
            measureRole = itemRole;
            break;
        }
        if (measureRole != null) {
            List measureRoleItems = measureRole.getRoleItems();
            int size = measureRoleItems.size();
            for (int i = 0; i < size; ++i) {
                Object item = measureRoleItems.get(i);
                if (!this.isMeasure(item) || items.contains(item)) continue;
                items.add(item);
            }
        }
        int numItems = items.size();
        for (int i = 0; i < numItems; ++i) {
            Object thisitem = items.get(i);
            RoleInterface currentRole = this.findRoleForItem(thisitem);
            currentRole.removeRoleItem(thisitem);
            List targetAvailable = targetRole.getAvailableRoleItems();
            if (thisitem instanceof DataItemReference && !targetAvailable.contains(thisitem)) {
                thisitem = ((DataItemReference)thisitem).getBaseDataItem();
            }
            targetRole.addRoleItem(thisitem);
        }
    }

    private RoleInterface findRole(DataItem thisitem) {
        DataItemSelectorInterface roleProvider = (DataItemSelectorInterface)this.selector.getSelectorModel();
        RoleInterface[] availableRoles = roleProvider.getRoles();
        int numRoles = availableRoles.length;
        int i = 0;
        for (i = 0; i < numRoles; ++i) {
            RoleInterface thisrole = availableRoles[i];
            List selectedItems = thisrole.getRoleItems();
            if (!selectedItems.contains(thisitem)) continue;
            return thisrole;
        }
        return null;
    }

    private RoleInterface getRoleInterface(String roleString) {
        DataItemSelectorInterface roleProvider = (DataItemSelectorInterface)this.selector.getSelectorModel();
        RoleInterface[] availableRoles = roleProvider.getRoles();
        int numRoles = availableRoles.length;
        int i = 0;
        if (!roleString.equalsIgnoreCase("row") && !roleString.equalsIgnoreCase("column")) {
            return availableRoles[0];
        }
        for (i = 0; i < numRoles; ++i) {
            if (!availableRoles[i].getRoleName().equalsIgnoreCase(roleString)) continue;
            return availableRoles[i];
        }
        return null;
    }

    private List createAddItemsList(Vector itemVector, Map itemmap) {
        Collection valueSet = itemmap.values();
        ArrayList<DataItem> itemsList = new ArrayList<DataItem>();
        int numItems = itemVector.size();
        for (int i = 0; i < numItems; ++i) {
            String itemid = (String)itemVector.get(i);
            if (itemid.substring(0, 1).equalsIgnoreCase("_")) {
                itemid = itemid.substring(1);
            }
            DataItem addItem = null;
            addItem = (DataItem)itemmap.get(itemid);
            if (addItem == null) {
                for (DataItem item : valueSet) {
                    if (!(item instanceof DataItemReference)) continue;
                    DataItem parentItem = ((DataItemReference)item).getBaseDataItem();
                    try {
                        if (!itemid.equals(parentItem.getID())) continue;
                        addItem = item;
                    }
                    catch (InvalidIDException e) {
                        LoggerRepository2.getLogger((String)((Object)((Object)this)).getClass().getName(), null).error(e.getMessage(), (Throwable)e);
                    }
                }
            }
            itemsList.add(addItem);
        }
        return itemsList;
    }

    public void cancel(Object o) {
        this.eventInfo.clear();
        DataItemSelectorInterface roleProvider = (DataItemSelectorInterface)this.selector.getSelectorModel();
        if (roleProvider != null) {
            roleProvider.cleanUp(CANCEL_MODE);
        }
        super.cancel(o);
    }

    protected void commit(Object o) throws IOException {
        this.eventInfo.clear();
        DataItemSelectorInterface roleProvider = (DataItemSelectorInterface)this.selector.getSelectorModel();
        this.model = this.getModel();
        HashMap oldResultItemsMap = new HashMap();
        if (this.model != null) {
            try {
                this.eventInfo.put("action", COMMIT);
                BusinessQueryProviderInterface bqpinterface = (BusinessQueryProviderInterface)this.model;
                BusinessQuery bquery = bqpinterface.getBusinessQuery();
                BusinessModel bmodel = bquery.getBusinessModel();
                RoleInterface[] rolesUsed = roleProvider.getRoles();
                List resultItems = null;
                Role currentRole = null;
                String qType = this.getQueryType();
                if (qType == null) {
                    qType = roleProvider.getQueryType();
                }
                this.deleteResultItemsFromQuery(rolesUsed, bquery, oldResultItemsMap);
                int count = rolesUsed.length;
                for (int i = 0; i < count; ++i) {
                    if (rolesUsed[i].getRoleName().equalsIgnoreCase("column")) {
                        resultItems = bquery.getResultItems(Role.COLUMN);
                        currentRole = Role.COLUMN;
                    } else if (rolesUsed[i].getRoleName().equalsIgnoreCase("row")) {
                        resultItems = bquery.getResultItems(Role.ROW);
                        currentRole = Role.ROW;
                    }
                    List selectedItems = rolesUsed[i].getRoleItems();
                    if (selectedItems == null) continue;
                    if (qType != null) {
                        this.setUsageOnResultItems(selectedItems, qType);
                    }
                    bquery.addResultItems(selectedItems, currentRole);
                }
                if (!bquery.isValid()) {
                    List reasonsNotValid = bquery.getReasonsNotValid();
                    if (reasonsNotValid.size() > 0) {
                        Reason r = (Reason)reasonsNotValid.get(0);
                        this.eventInfo.put("data", r.getReasonString());
                    }
                    this.deleteResultItemsFromQuery(rolesUsed, bquery, null);
                    this.rollBackBusinessQuery(bquery, oldResultItemsMap);
                } else {
                    if (bquery.isActionSupported(BusinessQueryActionType.SORT_CRITERIA)) {
                        bquery.setSortCriteria(new ArrayList(), Role.ROW);
                        bquery.setSortCriteria(new ArrayList(), Role.COLUMN);
                    }
                    if (bquery.isActionSupported(BusinessQueryActionType.SORT_NONE)) {
                        bquery.setSortDirection(BusinessQueryActionType.SORT_NONE, Role.ROW);
                        bquery.setSortDirection(BusinessQueryActionType.SORT_NONE, Role.COLUMN);
                    }
                    ((BusinessQueryProviderInterface)this.model).refreshBusinessQuery(bquery);
                    this.eventInfo.put("ROW_COLUMN", "INITIALIZE");
                    super.commit(o);
                }
            }
            catch (ClassCastException e) {
                LoggerRepository2.getLogger((String)((Object)((Object)this)).getClass().getName(), null).error(e.getMessage(), (Throwable)e);
            }
            catch (Exception e) {
                LoggerRepository2.getLogger((String)((Object)((Object)this)).getClass().getName(), null).error(e.getMessage(), (Throwable)e);
            }
        }
        this.contentsChanged = true;
        this.eventSource = this.model;
        this.eventInfo.put("request", this.getAttribute("request"));
        this.eventInfo.put("response", this.getAttribute("response"));
    }

    private void deleteResultItemsFromQuery(RoleInterface[] rolesUsed, BusinessQuery bquery, Map oldResultItemsMap) {
        List resultItems = null;
        Role thisrole = null;
        try {
            int count = rolesUsed.length;
            for (int i = 0; i < count; ++i) {
                if (rolesUsed[i].getRoleName().equalsIgnoreCase("column")) {
                    thisrole = Role.COLUMN;
                    resultItems = bquery.getResultItems(thisrole);
                } else if (rolesUsed[i].getRoleName().equalsIgnoreCase("row")) {
                    thisrole = Role.ROW;
                    resultItems = bquery.getResultItems(thisrole);
                }
                if (resultItems == null) continue;
                if (oldResultItemsMap != null) {
                    oldResultItemsMap.put(thisrole, resultItems);
                }
                bquery.removeResultItems(resultItems);
            }
        }
        catch (MetadataException metadataException) {
            // empty catch block
        }
    }

    private void rollBackBusinessQuery(BusinessQuery bquery, Map itemmap) {
        Set rolekeys = itemmap.keySet();
        for (Role thisrole : rolekeys) {
            List roleitems;
            if (thisrole == null || (roleitems = (List)itemmap.get(thisrole)) == null) continue;
            try {
                bquery.addResultItems(roleitems, thisrole);
            }
            catch (MetadataException metadataException) {}
        }
    }

    protected void setUsageOnResultItems(List itemlist, String querytype) {
        int numberOfItems = itemlist.size();
        for (int i = 0; i < numberOfItems; ++i) {
            DataItem item = (DataItem)itemlist.get(i);
            try {
                if (querytype.equalsIgnoreCase("detail")) {
                    if (item.isActionSupported(DataItemActionType.USAGE_DETAIL)) {
                        item.setUsage(DataItemActionType.USAGE_DETAIL);
                    }
                    continue;
                }
                if (!querytype.equalsIgnoreCase("group")) continue;
                if (item instanceof DataItemReference) {
                    DataItem baseitem = ((DataItemReference)item).getBaseDataItem();
                    item.setUsage(baseitem.getUsage());
                    continue;
                }
                if (item.isActionSupported(DataItemActionType.USAGE_CATEGORY)) {
                    item.setUsage(DataItemActionType.USAGE_CATEGORY);
                    continue;
                }
                if (item.isActionSupported(DataItemActionType.USAGE_AGGREGATE)) {
                    item.setUsage(DataItemActionType.USAGE_AGGREGATE);
                    continue;
                }
                throw new IllegalArgumentException(RB.getStringResource((String)"DataItemSelector.invalidUsage.txt"));
            }
            catch (MetadataException e) {
                LoggerRepository2.getLogger((String)((Object)((Object)this)).getClass().getName(), null).error(e.getMessage(), (Throwable)e);
            }
        }
    }

    public static DataItemSelectorModel createRoleProvider(BusinessQuery query) throws MetadataException {
        StructureOfData sod = query.getInputStructure();
        DataItemSelectorModel roleProvider = sod.isOLAP() ? new DataItemSelectorModelOLAPTable(query) : new DataItemSelectorModelRelationalTable(query);
        RoleInterface[] rolesUsed = roleProvider.getRoles();
        List resultItems = null;
        int count = rolesUsed.length;
        for (int i = 0; i < count; ++i) {
            if (rolesUsed[i].getRoleName().equalsIgnoreCase("column")) {
                resultItems = query.getResultItems(Role.COLUMN);
            } else if (rolesUsed[i].getRoleName().equalsIgnoreCase("row")) {
                resultItems = query.getResultItems(Role.ROW);
            }
            if (resultItems == null) continue;
            rolesUsed[i].addRoleItems(resultItems);
        }
        return roleProvider;
    }

    public boolean isSupported(ActionSupportFilter actionFilter) {
        Object dataModel = actionFilter.getAttribute("model");
        if (dataModel instanceof BusinessQueryProviderInterface) {
            BusinessQuery bq = ((BusinessQueryProviderInterface)dataModel).getBusinessQuery();
            return bq.isActionSupported(BusinessQueryActionType.RESULT_ITEM);
        }
        return false;
    }

    protected boolean isMeasure(Object item) {
        if (!(item instanceof DataItem)) {
            return false;
        }
        DataItem dataItem = (DataItem)item;
        DataItemActionType usage = dataItem.getUsage();
        while (usage == DataItemActionType.USAGE_DETAIL && dataItem instanceof DataItemReference) {
            dataItem = ((DataItemReference)dataItem).getBaseDataItem();
            usage = dataItem.getUsage();
        }
        return usage == DataItemActionType.USAGE_AGGREGATE;
    }

    public void setRole(String role) {
        this.role = role;
    }

    public String getRole() {
        return this.role;
    }

    public void setSelectedItems(String[] items) {
        this.selectedItems = items;
        DataItemSelectorInterface roleProvider = (DataItemSelectorInterface)this.selector.getSelectorModel();
        if (roleProvider != null && items != null) {
            roleProvider.setSelectedItems(items);
        }
    }

    public String[] getSelectedItems() {
        return this.selectedItems;
    }

    public void setSelectedIndexes(String[] indexes) {
        this.selectedIndexes = indexes;
    }

    public String[] getSelectedIndexes() {
        return this.selectedIndexes;
    }

    public void setUnselectedItems(String[] items) {
        this.unselectedItems = items;
    }

    public String[] getUnselectedItems() {
        return this.unselectedItems;
    }

    public void setAction(String actionstr) {
        this.action = actionstr;
    }

    public String getAction() {
        return this.action;
    }

    public void setData(String datastr) {
        this.data = datastr;
    }

    public String getData() {
        return this.data;
    }

    public void setQueryType(String queryType) {
        this.queryType = queryType;
    }

    public String getQueryType() {
        return this.queryType;
    }

    protected RoleInterface findRoleForItem(Object thisitem) {
        DataItemSelectorInterface roleProvider = (DataItemSelectorInterface)this.selector.getSelectorModel();
        RoleInterface[] availableRoles = roleProvider.getRoles();
        int numRoles = availableRoles.length;
        int i = 0;
        for (i = 0; i < numRoles; ++i) {
            RoleInterface thisrole = availableRoles[i];
            List selectedItems = thisrole.getRoleItems();
            if (!selectedItems.contains(thisitem)) continue;
            return thisrole;
        }
        return null;
    }
}

