/*
 * Decompiled with CFR 0.152.
 */
package com.sas.commands.dataselectors;

import com.sas.actionprovider.ActionSupportFilter;
import com.sas.actionprovider.CommandStatusInterface;
import com.sas.actionprovider.CommandSupportedInterface;
import com.sas.commands.dataselectors.BaseSelectorCommand;
import com.sas.commands.dataselectors.RB;
import com.sas.dataselectors.DataSelectorInterface;
import com.sas.dataselectors.filters.AdvancedFilterModelInterface;
import com.sas.dataselectors.filters.BaseFilterObjectFactory;
import com.sas.dataselectors.filters.BusinessModelToAdvancedFilterModelAdapter;
import com.sas.dataselectors.filters.BusinessQueryToAdvancedFilterModelAdapter;
import com.sas.dataselectors.filters.BusinessQueryToFilterableListModelAdapter;
import com.sas.dataselectors.filters.DefaultAdvancedFilterModelAdapter;
import com.sas.dataselectors.filters.DefaultFilterLogicTestNode;
import com.sas.dataselectors.filters.DefaultFilterValue;
import com.sas.dataselectors.filters.FilterConditionInterface;
import com.sas.dataselectors.filters.FilterItemInterface;
import com.sas.dataselectors.filters.FilterLogicEditableTestNodeInterface;
import com.sas.dataselectors.filters.FilterLogicTestNodeInterface;
import com.sas.dataselectors.filters.FilterLogicTestNodeObjectMap;
import com.sas.dataselectors.filters.FilterObjectFactoryInterface;
import com.sas.dataselectors.filters.FilterQualifierInterface;
import com.sas.dataselectors.filters.FilterValueInterface;
import com.sas.dataselectors.filters.FilterableItemInterface;
import com.sas.dataselectors.filters.FilterableListModelInterface;
import com.sas.dataselectors.filters.PersistentFilterInterface;
import com.sas.dataselectors.filters.PersistentFilterProviderModelInterface;
import com.sas.dataselectors.filters.SearchValueProviderModelInterface;
import com.sas.dataselectors.filters.SimpleFilterLogicTreeInterface;
import com.sas.dataselectors.filters.timebased.olap.OLAPTimeBasedFilterAdapterInterface;
import com.sas.dataselectors.filters.timebased.olap.OLAPTimeFilterUtil;
import com.sas.dataselectors.qualifiers.QualifiersEditorFactory;
import com.sas.dataselectors.qualifiers.QualifiersSelectorAdapter;
import com.sas.iquery.intelligentquery.BusinessQueryProviderInterface;
import com.sas.iquery.intelligentquery.IntelligentQueryException;
import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.business.BusinessModel;
import com.sas.iquery.metadata.business.BusinessQuery;
import com.sas.iquery.metadata.business.BusinessQueryActionType;
import com.sas.iquery.metadata.business.DataItem;
import com.sas.iquery.metadata.business.DataItemActionType;
import com.sas.iquery.metadata.business.DataSelection;
import com.sas.iquery.metadata.business.Prompt;
import com.sas.iquery.metadata.business.Role;
import com.sas.storage.olap.OLAPException;
import com.sas.storage.valueprovider.ValueProviderInterface;
import com.sas.swing.dataselectors.editors.EditorInterface;
import com.sas.swing.dataselectors.editors.ExpressionValueEditorInterface;
import com.sas.swing.dataselectors.editors.FilterItemEditorInterface;
import com.sas.swing.dataselectors.editors.PromptValueEditorInterface;
import com.sas.swing.dataselectors.editors.QualifiersEditorInterface;
import com.sas.swing.visuals.dataselectors.calculateditems.ExpressionValueEditorAdapter;
import com.sas.swing.visuals.dataselectors.calculateditems.FilterItemEditorAdapter;
import com.sas.swing.visuals.dataselectors.filters.OLAPRelativeTimeFilterPanel;
import com.sas.swing.visuals.dataselectors.filters.PendingActionSelector;
import com.sas.util.ValueItem;
import com.sas.util.log.CommonLoggerInterface;
import com.sas.util.log.LoggerRepository2;
import java.awt.Frame;
import java.io.IOException;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;

public class AdvancedFilterSelectorCommand
extends BaseSelectorCommand
implements CommandSupportedInterface,
CommandStatusInterface {
    public static final String RB_KEY = "AdvancedFilterSelectorCommand.";
    public static final String RB_KEY2 = "AdvancedFilterSelectorPanel.";
    public static final String SELECTED_CONDITION = "selectedCondition";
    private static final String SELECTED_ITEM = "selectedItem";
    public static final String ADD_ACTION = "addAction";
    public static final String UPDATE_ACTION = "updateAction";
    public static final String DELETE_ACTION = "deleteAction";
    public static final String DELETEALL_ACTION = "delAllAction";
    public static final String SET_ACTION = "setAction";
    public static final String EDIT_ACTION = "editAction";
    public static final String AND_ACTION = "andAction";
    public static final String OR_ACTION = "orAction";
    public static final String NOT_ACTION = "notAction";
    public static final String SPLIT_ACTION = "splitAction";
    public static final String GROUP_ACTION = "groupAction";
    public static final String UP_ACTION = "upAction";
    public static final String DOWN_ACTION = "downAction";
    public static final String QUALIFIER_ACTION = "qualifierAction";
    public static final String CLEAR_ACTION = "clearAction";
    public static final String CLEARALL_ACTION = "clearAllAction";
    public static final String CANCEL_ACTION = "cancelAction";
    public static final String OLAPOK_ACTION = "olapOKAction";
    public static final String VALUEPICKER_UPDATE_ACTION = "valuePickerUpdateAction";
    public static final String IMPORT_ACTION = "importAction";
    public static final String FILTERITEM_CHANGED = "filterItemChanged";
    public static final String CONDITION_CHANGED = "conditionChanged";
    public static final String QUALIFIER_CHANGED = "qualifierChanged";
    public static final String QUALIFIER_CHECKED = "qualifierChecked";
    public static final String QUALIFIER_APPLIED = "qualifierApplied";
    private String action;
    private boolean validFilterValue = true;
    protected HashMap actionInfo = new HashMap();
    private static final String ERROR = "ERROR";
    private Map _filterItemMap;
    private QualifiersEditorInterface qualifierEditor;
    private AdvancedFilterModelInterface validatedModel;
    private CommonLoggerInterface log = null;
    private String valueEntryType;

    public AdvancedFilterSelectorCommand() {
        this.log = LoggerRepository2.getLogger((String)AdvancedFilterSelectorCommand.class.getName(), null);
        this.log.debug("_DEBUG_:default constructor");
    }

    public AdvancedFilterSelectorCommand(String name) {
        super(name);
        this.log = this.log = LoggerRepository2.getLogger((String)AdvancedFilterSelectorCommand.class.getName(), null);
        this.log.debug("_DEBUG_:second constructor, name is", name);
    }

    public AdvancedFilterSelectorCommand(String name, String actionClass) {
        super(name, actionClass);
        this.log = this.log = LoggerRepository2.getLogger((String)AdvancedFilterSelectorCommand.class.getName(), null);
        this.log.debug("_DEBUG_:third constructor, actionClass is", actionClass);
        this.log.debug("_DEBUG_:leaving third constructor");
    }

    protected void show(Object o) {
        this.log.debug("_DEBUG_:show: ENTERing method");
        Object myModel = this.getModel();
        if (myModel != null) {
            this.log.debug("_DEBUG_:show: model class is " + myModel.getClass().getName());
            Object newSelectorModel = null;
            if (myModel instanceof AdvancedFilterModelInterface) {
                newSelectorModel = (AdvancedFilterModelInterface)myModel;
            } else if (myModel instanceof FilterableListModelInterface) {
                newSelectorModel = (FilterableListModelInterface)myModel;
            } else if (myModel instanceof BusinessQuery || myModel instanceof BusinessQueryProviderInterface) {
                ArrayList<Object> editorList;
                BusinessQuery businessQuery;
                BusinessQuery businessQuery2 = businessQuery = myModel instanceof BusinessQuery ? (BusinessQuery)myModel : ((BusinessQueryProviderInterface)myModel).getBusinessQuery();
                if (businessQuery.getInputStructure().isOLAP()) {
                    newSelectorModel = new BusinessQueryToFilterableListModelAdapter(businessQuery, this.isSwing() ? 1 : 2);
                    editorList = new ArrayList<Object>();
                    String title = RB.getStringResource((String)RB_KEY, (String)"qualifierEditorTitle.txt");
                    if (this.isSwing()) {
                        QualifiersEditorInterface aQualifierEditor = QualifiersEditorFactory.newSwingEditor(businessQuery, title);
                        editorList.add(aQualifierEditor);
                        ExpressionValueEditorAdapter exprValueEditor = new ExpressionValueEditorAdapter(businessQuery.getBusinessModel(), null){

                            @Override
                            protected void layoutDialog(Frame parent) {
                                if (this._editDialog != null) {
                                    this._editDialog.setSaveInvalidExpressionsEnabled(false);
                                }
                                super.layoutDialog(parent);
                            }
                        };
                        editorList.add(exprValueEditor);
                    } else {
                        this.qualifierEditor = new QualifiersSelectorAdapter(businessQuery);
                        QualifiersEditorFactory.setProperties(this.qualifierEditor, "QualifiersEditorBQ.", Locale.getDefault());
                        editorList.add(this.qualifierEditor);
                    }
                    this.setEditors((FilterableListModelInterface)newSelectorModel, editorList);
                } else {
                    newSelectorModel = new BusinessQueryToAdvancedFilterModelAdapter(businessQuery);
                    ((BusinessQueryToAdvancedFilterModelAdapter)((Object)newSelectorModel)).setEnvironment(this.isSwing() ? 1 : 2);
                    if (this.isSwing()) {
                        editorList = new ArrayList();
                        ExpressionValueEditorAdapter exprValueEditor = new ExpressionValueEditorAdapter(businessQuery.getBusinessModel(), null){

                            @Override
                            protected void layoutDialog(Frame parent) {
                                if (this._editDialog != null) {
                                    this._editDialog.setSaveInvalidExpressionsEnabled(false);
                                }
                                super.layoutDialog(parent);
                            }
                        };
                        editorList.add(exprValueEditor);
                        FilterItemEditorAdapter filterItemEditor = new FilterItemEditorAdapter(businessQuery.getBusinessModel(), null){

                            @Override
                            protected void layoutDialog(Frame parent) {
                                if (this._editDialog != null) {
                                    this._editDialog.setSaveInvalidExpressionsEnabled(false);
                                }
                                super.layoutDialog(parent);
                            }
                        };
                        editorList.add(filterItemEditor);
                        this.setEditors((AdvancedFilterModelInterface)newSelectorModel, (List)editorList);
                    }
                }
            } else if (myModel instanceof BusinessModel) {
                BusinessModel bModel = (BusinessModel)myModel;
                newSelectorModel = new BusinessModelToAdvancedFilterModelAdapter(bModel);
                ((BusinessModelToAdvancedFilterModelAdapter)((Object)newSelectorModel)).setEnvironment(this.isSwing() ? 1 : 2);
            } else {
                throw new IllegalArgumentException(RB.getStringResource((String)RB_KEY, (String)"invalidModel.txt"));
            }
            DataSelectorInterface mySelector = this.getSelector();
            if (newSelectorModel instanceof FilterableListModelInterface) {
                this.setFilterItemMap(((FilterableListModelInterface)newSelectorModel).getFilterableItems());
            }
            if (mySelector != null && newSelectorModel != null) {
                this.setSelectorModel(newSelectorModel);
                this.getSelector().setSelectorModel(newSelectorModel);
                Object mySelectorModel = null;
                if (newSelectorModel instanceof AdvancedFilterModelInterface) {
                    mySelectorModel = newSelectorModel;
                }
                if (mySelector != null && mySelectorModel != null) {
                    mySelector.setSelectorModel(mySelectorModel);
                    if (mySelectorModel.getFilterLogicList().getFilterList().size() > 0) {
                        mySelectorModel.setSelectionCursor(0);
                    } else {
                        mySelectorModel.setSelectionCursor(-1);
                    }
                    if (!this.isSwing()) {
                        mySelectorModel.setSelectionCursor(-1);
                    }
                }
            } else {
                this.log.error("_DEBUG_:show: ERROR - selector or adapter is NULL!");
            }
        } else {
            this.log.error("_DEBUG_:show: ERROR - model is NULL!");
            return;
        }
        this.eventInfo.clear();
        this.actionInfo.clear();
        this.log.debug("_DEBUG_:show: EXITing method");
        super.show(o);
    }

    protected void setEditors(FilterableListModelInterface filterableList, List editors) {
        if (filterableList != null && editors != null) {
            List filterableItems = filterableList.getFilterableItems();
            for (FilterableItemInterface filterItem : filterableItems) {
                AdvancedFilterModelInterface filterModel = filterItem.getFilterModel();
                this.setEditors(filterModel, editors);
            }
        }
    }

    protected void cleanUp() {
        this.closeSelector();
        this.qualifierEditor = null;
        this._filterItemMap = null;
        this.validatedModel = null;
        if (this.getSelectorModel() instanceof AdvancedFilterModelInterface) {
            ((AdvancedFilterModelInterface)this.getSelectorModel()).setApplicationData(null);
        }
        this.getSelector().setSelectorModel(null);
        this.setSelectorModel(null);
        this.setModel(null);
    }

    protected void setEditors(AdvancedFilterModelInterface filterModel, List editors) {
        if (filterModel != null && editors != null) {
            for (Object editor : editors) {
                if (!(editor instanceof EditorInterface)) continue;
                this.setEditor(filterModel, (EditorInterface)editor);
            }
        }
    }

    protected void setEditor(AdvancedFilterModelInterface filterModel, EditorInterface editor) {
        if (filterModel != null && editor instanceof EditorInterface) {
            if (editor instanceof ExpressionValueEditorInterface) {
                filterModel.setExpressionValueEditor((ExpressionValueEditorInterface)editor);
            } else if (editor instanceof FilterItemEditorInterface) {
                filterModel.setFilterItemEditor((FilterItemEditorInterface)editor);
            } else if (editor instanceof QualifiersEditorInterface) {
                filterModel.setFilterQualifierEditor((QualifiersEditorInterface)editor);
            } else if (editor instanceof PromptValueEditorInterface) {
                filterModel.setPromptValueEditor((PromptValueEditorInterface)editor);
            }
        }
    }

    protected boolean isSwing() {
        return this.getAttribute("request") == null;
    }

    protected void process(Object o) {
        String[] cmd;
        this.log.debug("_DEBUG_:process: ENTERing method");
        this.validFilterValue = true;
        this.eventInfo.clear();
        super.process(o);
        this.eventInfo.put(QUALIFIER_CHECKED, this.actionInfo.get(QUALIFIER_CHECKED));
        boolean modified = false;
        if (!this.isSwing()) {
            modified = this.updateSelectionModel();
        }
        if ((cmd = (String[])this.actionInfo.get("action")) != null && cmd.length >= 2 && "getValues".equals(cmd[0])) {
            this.eventInfo.put("action", "getValues");
            this.eventInfo.put("data", cmd[1]);
        }
        if (modified) {
            this.contentsChanged = true;
            this.eventSource = this.getModel();
            this.eventInfo.put("request", this.getAttribute("request"));
            this.eventInfo.put("response", this.getAttribute("response"));
            this.eventInfo.put("selectionModel", this.getSelectionModel());
        }
        this.actionInfo.clear();
        if (!this.isSwing() && this.isOlap() && OLAPOK_ACTION.equals(this.getPendingAction())) {
            AdvancedFilterModelInterface validModel = this.getValidatedModel(false);
            if (validModel != null) {
                this.log.debug("_DEBUG_:process: Committing filter changes...");
                boolean bl = validModel.commitChanges();
            }
        }
        this.log.debug("_DEBUG_:process: EXITing method");
    }

    public void cancel(Object o) {
        this.log.debug("_DEBUG_:cancel: Entering method");
        this.eventInfo.clear();
        this.cleanUp();
        super.cancel(o);
        this.log.debug("_DEBUG_:cancel: Leaving method");
    }

    protected void commit(Object o) throws IOException {
        this.log.debug("_DEBUG_:commit: Entering method...");
        this.eventInfo.clear();
        boolean commitOk = false;
        Object aModel = this.getSelectorModel();
        if (aModel == null) {
            aModel = this.getSelector().getSelectorModel();
        }
        if (aModel != null && aModel instanceof FilterableListModelInterface) {
            FilterableListModelInterface filterableList = (FilterableListModelInterface)aModel;
            commitOk = filterableList.commitChanges();
        }
        AdvancedFilterModelInterface validModel = null;
        validModel = this.isSwing() && !(aModel instanceof FilterableListModelInterface) ? this._validateModel() : this.getValidatedModel(false);
        String error = null;
        if (validModel != null) {
            if (!validModel.isOLAP() && !this.isSwing() && validModel.getSelectionCount() < 1 || this.isSwing()) {
                boolean updated = this.updateSelectionModel();
                error = (String)this.eventInfo.get(ERROR);
            }
            this.log.debug("_DEBUG_:commit: Applying filter data source...");
            commitOk = error == null ? validModel.commitChanges() : true;
        }
        if (commitOk) {
            this.contentsChanged = true;
            this.eventSource = this.getModel();
            this.eventInfo.put("request", this.getAttribute("request"));
            this.eventInfo.put("response", this.getAttribute("response"));
            this.eventInfo.put("ROW_COLUMN", "INITIALIZE");
            if (this.model instanceof BusinessQueryProviderInterface) {
                try {
                    ((BusinessQueryProviderInterface)this.model).refreshBusinessQuery(((BusinessQueryProviderInterface)this.model).getBusinessQuery());
                }
                catch (IntelligentQueryException ex) {
                    this.log.error(ex.getMessage(), (Throwable)ex);
                    commitOk = false;
                }
                catch (Throwable t) {
                    this.log.error(t.getMessage(), t);
                    commitOk = false;
                }
            }
        }
        this.eventInfo.put("commit", commitOk);
        if (error == null) {
            this.cleanUp();
            super.commit(o);
        }
        this.log.debug("_DEBUG_:commit: Leaving method...");
    }

    protected void setSelection(FilterLogicTestNodeInterface selection) {
        AdvancedFilterModelInterface myModel = this.isSwing() ? this._validateModel() : this.getValidatedModel(false);
        if (myModel != null) {
            myModel.setSelection(selection);
        }
    }

    protected FilterLogicTestNodeInterface getSelection() {
        AdvancedFilterModelInterface myModel = this.isSwing() ? this._validateModel() : this.getValidatedModel(false);
        if (myModel != null) {
            return myModel.getSelection();
        }
        return null;
    }

    public boolean updateSelectionModel() {
        AdvancedFilterModelInterface myModel;
        this.log.debug("_DEBUG_:updateSelectionModel: ENTERing method...");
        String pendingAction = this.getPendingAction();
        if (pendingAction == CLEAR_ACTION) {
            Object sModel;
            this.eventInfo.put(CLEAR_ACTION, CLEAR_ACTION);
            String value = (String)this.actionInfo.get(CLEAR_ACTION);
            int selectedRow = -1;
            if (value != null) {
                selectedRow = Integer.parseInt(value);
            }
            if (selectedRow > -1 && (sModel = this.getSelectorModel()) instanceof FilterableListModelInterface) {
                List list = ((FilterableListModelInterface)sModel).getFilterableItems();
                FilterableItemInterface item = (FilterableItemInterface)list.get(selectedRow);
                item.clearFilter();
                return true;
            }
        } else if (pendingAction == CLEARALL_ACTION) {
            this.eventInfo.put(CLEARALL_ACTION, CLEARALL_ACTION);
            Object sModel = this.getSelectorModel();
            if (sModel instanceof FilterableListModelInterface) {
                ((FilterableListModelInterface)sModel).clearAll();
                return true;
            }
        } else if (pendingAction == OLAPOK_ACTION) {
            this.eventInfo.put(OLAPOK_ACTION, OLAPOK_ACTION);
        } else if (pendingAction == VALUEPICKER_UPDATE_ACTION) {
            this.eventInfo.put(VALUEPICKER_UPDATE_ACTION, VALUEPICKER_UPDATE_ACTION);
        } else if (pendingAction == IMPORT_ACTION) {
            this.eventInfo.put(IMPORT_ACTION, IMPORT_ACTION);
            myModel = this.getValidatedModel(false);
            String filterToImportID = (String)this.actionInfo.get(IMPORT_ACTION);
            FilterLogicTestNodeObjectMap objectMap = (FilterLogicTestNodeObjectMap)myModel.getApplicationData();
            PersistentFilterInterface pFilter = (PersistentFilterInterface)objectMap.getPersistentFilterMap().get(filterToImportID);
            if (pFilter != null && myModel instanceof PersistentFilterProviderModelInterface) {
                this.doImportFilter(myModel, pFilter, objectMap);
                return true;
            }
            this.log.error("_DEBUG_:Unable to locate persistent filter with ID: " + filterToImportID);
        } else if (this.getAction() != null && this.getAction().equals(CANCEL_ACTION)) {
            this.eventInfo.put(CANCEL_ACTION, CANCEL_ACTION);
            AdvancedFilterModelInterface myModel2 = this.getValidatedModel(false);
            if (myModel2 != null) {
                myModel2.cancel();
                myModel2.setSelectionCursor(-1);
            }
            return false;
        }
        myModel = this.getValidatedModel(false);
        if (myModel == null) {
            return false;
        }
        if (this.action != null && this.action.equalsIgnoreCase(QUALIFIER_CHECKED)) {
            myModel.setSelectionCursor(-1);
            this.getSelector().setSelectorModel((Object)myModel);
        }
        FilterLogicEditableTestNodeInterface changableSelection = this.getChangableSelectionModel();
        boolean modified = false;
        if (this.getAttribute("request") != null) {
            modified = this.updateSelectionModel(changableSelection, myModel);
        }
        if (modified) {
            this.log.debug("_DEBUG_:updateSelectionModel: Setting modified selection model...");
        }
        this.log.debug("_DEBUG_:updateSelectionModel: EXITing method...");
        return modified;
    }

    private void doImportFilter(AdvancedFilterModelInterface afsModel, PersistentFilterInterface pFilter, FilterLogicTestNodeObjectMap objectMap) {
        PersistentFilterProviderModelInterface pfpModel = (PersistentFilterProviderModelInterface)afsModel;
        SimpleFilterLogicTreeInterface pTree = pfpModel.getSelectionTree(pFilter);
        if (this.isOlap() || pTree.getUnderstoodTestNodeList().size() == 1) {
            Object valueData;
            FilterLogicTestNodeInterface iNode = pTree.getLeafAt(0);
            if (this.isOlap() && afsModel.getSelectionCount() == 1) {
                afsModel.setSelectionCursor(0);
            } else {
                afsModel.setSelectionCursor(-1);
            }
            FilterLogicEditableTestNodeInterface changableSelection = this.getChangableSelectionModel();
            changableSelection.setFilterLabel(iNode.getFilterLabel());
            changableSelection.setFilterDescription(iNode.getFilterDescription());
            changableSelection.setFilterItem(iNode.getFilterItem());
            changableSelection.setCondition(iNode.getCondition());
            List valuesList = this.convertPromptValuesToDefaultValues(afsModel, iNode.getTestValuesList(), (FilterLogicTestNodeInterface)changableSelection);
            if (OLAPTimeFilterUtil.isOLAPRelativeTimeCondition(iNode) && (valueData = OLAPTimeFilterUtil.getTestNodeValueObject(iNode)) instanceof OLAPTimeBasedFilterAdapterInterface) {
                ((OLAPTimeBasedFilterAdapterInterface)valueData).setModified(true);
            }
            changableSelection.setTestValuesList(valuesList);
            changableSelection.setFilterItemQualifiers(iNode.getFilterItemQualifiers());
            try {
                if (!this.isOlap()) {
                    if (afsModel instanceof SearchValueProviderModelInterface) {
                        SearchValueProviderModelInterface vpModel = (SearchValueProviderModelInterface)afsModel;
                        int valueIndex = 0;
                        ValueProviderInterface vp = vpModel.getValueProvider((FilterLogicTestNodeInterface)changableSelection, valueIndex);
                        objectMap.mapValues(changableSelection.getFilterItem(), vp, this.getLocale());
                    } else {
                        objectMap.mapValues(changableSelection.getFilterItem());
                    }
                } else {
                    objectMap.mapOLAPValues(changableSelection.getFilterItem());
                }
            }
            catch (Exception e) {
                this.log.error("_DEBUG_:Error while mapping filter values!", (Throwable)e);
            }
            this.getSelector().setSelectorModel((Object)afsModel);
        } else {
            SimpleFilterLogicTreeInterface mTree = afsModel.getSelectionTree();
            mTree.add(pTree);
            afsModel.setSelectionCursor(-1);
            this.eventInfo.put("comboState", "active");
        }
    }

    private List convertPromptValuesToDefaultValues(AdvancedFilterModelInterface afsModel, List values, FilterLogicTestNodeInterface testNode) {
        if (values == null || afsModel == null) {
            return values;
        }
        ArrayList<Object> valueList = new ArrayList<Object>();
        int size = values.size();
        for (int i = 0; i < size; ++i) {
            Object value = values.get(i);
            if (value instanceof FilterValueInterface) {
                FilterValueInterface filterValue = (FilterValueInterface)value;
                Object unformattedValue = filterValue.getUnformattedValue();
                if (unformattedValue instanceof Prompt && afsModel instanceof DefaultAdvancedFilterModelAdapter) {
                    Prompt prompt = (Prompt)unformattedValue;
                    FilterObjectFactoryInterface factory = ((DefaultAdvancedFilterModelAdapter)afsModel).getFilterObjectFactory();
                    if (factory instanceof BaseFilterObjectFactory) {
                        BaseFilterObjectFactory objectFactory = (BaseFilterObjectFactory)factory;
                        Object defaultPromptValue2 = prompt.getPromptDefinition().getDefaultValue();
                        if (defaultPromptValue2 instanceof List) {
                            List defaultList = (List)defaultPromptValue2;
                            for (Object defaultPromptValue2 : defaultList) {
                                filterValue = objectFactory.createFilterValueFromNative(defaultPromptValue2, testNode);
                                valueList.add(filterValue);
                            }
                            filterValue = null;
                        } else {
                            filterValue = objectFactory.createFilterValueFromNative(defaultPromptValue2, testNode);
                        }
                    }
                }
                if (filterValue == null) continue;
                valueList.add(filterValue);
                continue;
            }
            valueList.add(value);
        }
        return valueList;
    }

    protected boolean updatable(FilterLogicEditableTestNodeInterface changableSelection) {
        long type;
        boolean update = false;
        String selectedItem = (String)this.actionInfo.get(SELECTED_ITEM);
        String selectedQualifier = (String)this.actionInfo.get("selectedQualifier");
        String selectedCondition = (String)this.actionInfo.get(SELECTED_CONDITION);
        if (changableSelection.getFilterItem() == null) {
            return update;
        }
        AdvancedFilterModelInterface afsModel = this.getValidatedModel(false);
        if (afsModel == null) {
            return update;
        }
        FilterLogicTestNodeObjectMap objectMap = (FilterLogicTestNodeObjectMap)afsModel.getApplicationData();
        boolean emptyAllowed = false;
        String valueListKey = null;
        switch (this.getConditionArgumentCount((FilterLogicTestNodeInterface)changableSelection)) {
            case -1: {
                if (this.isOlap()) {
                    List csQualifiers = changableSelection.getFilterItemQualifiers();
                    if (csQualifiers != null && csQualifiers.size() > 0) {
                        valueListKey = "filterValueTextTyped";
                        break;
                    }
                    valueListKey = "filterValuesInList";
                    break;
                }
                if (objectMap.getFilterValues() != null) {
                    valueListKey = "filterValuesInList";
                    break;
                }
                valueListKey = "filterValueTextTyped";
                break;
            }
            case 1: {
                if (objectMap.getFilterValues() != null || this.isOlap()) {
                    valueListKey = "filterValueSingle";
                    break;
                }
                valueListKey = "filterValueTextTyped";
                break;
            }
            case 2: {
                if (objectMap.getFilterValues() != null) {
                    valueListKey = "filterValuesBetween";
                    break;
                }
                valueListKey = "filterValuesBetweenTextTyped";
                break;
            }
            case 3: {
                valueListKey = "filterValueTyped";
                break;
            }
            case 0: {
                emptyAllowed = true;
            }
        }
        if (!(this.isOlap() || (type = changableSelection.getFilterItem().getItemType()) != 4L && type != 5L && type != 6L)) {
            valueListKey = "startCalendar";
        }
        if (this.valueEntryType != null && this.valueEntryType.trim().length() > 0) {
            if ("valueList".equals(this.valueEntryType)) {
                valueListKey = "filterValuesInList";
            } else if ("betweenTyped".equals(this.valueEntryType)) {
                valueListKey = "filterValuesBetweenTextTyped";
            } else if ("betweenCombo".equals(this.valueEntryType)) {
                valueListKey = "filterValuesBetween";
            } else if ("valueCombo".equals(this.valueEntryType)) {
                valueListKey = "filterValueSingle";
            } else if ("valueTyped".equals(this.valueEntryType)) {
                valueListKey = "filterValueTextTyped";
            }
        }
        Object valueList = null;
        if (valueListKey != null && (valueList = this.actionInfo.get(valueListKey)) instanceof List) {
            this.processValueList((List)valueList);
        }
        if (OLAPTimeFilterUtil.isOLAPRelativeTimeCondition(true, this.getValidatedModel(false), this.getSelectedCondition())) {
            emptyAllowed = true;
        }
        if (selectedItem != null && selectedCondition != null && (valueList != null || emptyAllowed)) {
            update = true;
        }
        return update;
    }

    protected boolean updateSelectionModel(FilterLogicEditableTestNodeInterface changableSelection, AdvancedFilterModelInterface afsModel) {
        if (afsModel == null) {
            return false;
        }
        this.log.debug("_DEBUG_:updateSelectionModel#2: selection model = " + changableSelection);
        boolean modified = false;
        boolean olapModel = this.isOlap();
        FilterLogicTestNodeObjectMap objectMap = (FilterLogicTestNodeObjectMap)afsModel.getApplicationData();
        objectMap.setTestNode(changableSelection);
        String pendingAction = this.getPendingAction();
        if (pendingAction == null || pendingAction == OLAPOK_ACTION || pendingAction == ADD_ACTION || pendingAction.equals(UPDATE_ACTION) || pendingAction == VALUEPICKER_UPDATE_ACTION) {
            Map valueMap;
            FilterQualifierInterface item;
            Map map;
            long itemType = 0L;
            String value = null;
            value = (String)this.actionInfo.get("filterName");
            if (value != null) {
                this.log.debug("_DEBUG_:updateSelectionModel#2: setting name to " + value);
                changableSelection.setFilterLabel(value);
                this.eventInfo.put("filterName", value);
                modified = true;
            }
            value = (String)this.actionInfo.get(SELECTED_ITEM);
            String anAction = this.getAction();
            if (anAction == null) {
                return modified;
            }
            if (anAction.equals(QUALIFIER_CHECKED)) {
                String checkVal = this.actionInfo.get(QUALIFIER_CHECKED) == null ? "off" : "on";
                this.eventInfo.put(QUALIFIER_CHECKED, checkVal);
                modified = true;
            }
            if (value != null && objectMap != null) {
                map = null;
                map = olapModel ? this.getFilterItemMap() : objectMap.getFilterItemMap();
                if (map != null) {
                    this.log.debug("_DEBUG_:updateSelectionModel#2: finding item mapped to " + value);
                    item = (FilterItemInterface)map.get(value);
                    if (item != null) {
                        itemType = item.getItemType();
                        FilterItemInterface oldItem = changableSelection.getFilterItem();
                        if (item != oldItem) {
                            changableSelection.setFilterItem((FilterItemInterface)item);
                            changableSelection.setTestValuesList(new ArrayList(0));
                            objectMap.mapCondition((FilterItemInterface)item);
                            if (olapModel) {
                                objectMap.mapQualifier((FilterItemInterface)item);
                            } else if (objectMap.getMappedFilterItem() != item || objectMap.getFilterValuesList() == null || objectMap.getFilterValuesList().size() == 0) {
                                try {
                                    if (afsModel instanceof SearchValueProviderModelInterface) {
                                        SearchValueProviderModelInterface vpModel = (SearchValueProviderModelInterface)afsModel;
                                        int valueIndex = 0;
                                        ValueProviderInterface vp = vpModel.getValueProvider((FilterLogicTestNodeInterface)changableSelection, valueIndex);
                                        objectMap.mapValues(changableSelection.getFilterItem(), vp, this.getLocale());
                                    } else {
                                        objectMap.mapValues((FilterItemInterface)item);
                                    }
                                }
                                catch (Exception vpModel) {
                                    // empty catch block
                                }
                            }
                        }
                        if (anAction.equalsIgnoreCase(FILTERITEM_CHANGED)) {
                            if (olapModel) {
                                objectMap.mapOLAPValues((FilterItemInterface)item);
                            }
                            this.eventInfo.put(SELECTED_ITEM, value);
                        }
                        modified = true;
                    }
                }
            }
            if (olapModel && this.action.equalsIgnoreCase(FILTERITEM_CHANGED)) {
                return true;
            }
            value = (String)this.actionInfo.get("selectedQualifier");
            if (value != null && objectMap != null && (map = objectMap.getFilterQualifierMap()) != null) {
                Map map2;
                item = (FilterQualifierInterface)map.get(value);
                if (item == null && (map2 = objectMap.getQualifiedMeasure()) != null) {
                    item = (FilterQualifierInterface)map2.get(value);
                }
                this.log.debug("_DEBUG_:updateSelectionModel#2: setting qualifier item to " + item);
                if (item != null) {
                    changableSelection.setFilterItemQualifiers(Collections.singletonList(item));
                    if (anAction.equalsIgnoreCase(QUALIFIER_CHANGED)) {
                        this.eventInfo.put("selectedQualifier", item);
                    }
                }
                modified = true;
            }
            if ((value = (String)this.actionInfo.get(SELECTED_CONDITION)) != null && objectMap != null) {
                map = objectMap.getFilterConditionMap();
                if (map != null && map.get(value) == null && olapModel) {
                    map = objectMap.getFilterQualifiedConditionMap();
                }
                if (map != null) {
                    FilterConditionInterface condition = (FilterConditionInterface)map.get(value);
                    this.log.debug("_DEBUG_:updateSelectionModel#2: setting condition to " + condition);
                    FilterConditionInterface csCondition = changableSelection.getCondition();
                    if (condition != csCondition && (condition != null && condition.getCondition() == OLAPRelativeTimeFilterPanel.class || csCondition != null && csCondition.getCondition() == OLAPRelativeTimeFilterPanel.class)) {
                        changableSelection.setTestValuesList(null);
                    }
                    changableSelection.setCondition(condition);
                    if (anAction.equalsIgnoreCase(CONDITION_CHANGED)) {
                        this.eventInfo.put(SELECTED_CONDITION, condition);
                    }
                    modified = true;
                }
            }
            if (olapModel && anAction.equalsIgnoreCase(QUALIFIER_APPLIED) && (valueMap = (Map)this.actionInfo.get("qualifiedMeasure")) != null) {
                this.qualifierEditor = this.getQualifierEditor();
                if (this.qualifierEditor != null) {
                    afsModel.setFilterQualifierEditor(this.qualifierEditor);
                    FilterQualifierInterface newFilterQualifier = ((DefaultAdvancedFilterModelAdapter)afsModel).applyFilterQualifierEditorChanges((FilterLogicTestNodeInterface)changableSelection, valueMap);
                    objectMap.setQualifiedMeasure(newFilterQualifier);
                    changableSelection.setFilterItemQualifiers(Collections.singletonList(newFilterQualifier));
                    this.eventInfo.put("selectedQualifier", newFilterQualifier);
                    modified = true;
                    this.getSelector().setSelectorModel((Object)afsModel);
                }
            }
            if (!(this.isOlap() || itemType != 4L && itemType != 5L && itemType != 6L)) {
                if (!this.action.equalsIgnoreCase(FILTERITEM_CHANGED)) {
                    changableSelection.setTestValuesList(this.getCalendar(itemType));
                    modified = true;
                }
            } else {
                String valueListKey = null;
                switch (this.getConditionArgumentCount((FilterLogicTestNodeInterface)changableSelection)) {
                    case -1: {
                        if (this.isOlap()) {
                            List csQualifiers = changableSelection.getFilterItemQualifiers();
                            if (csQualifiers != null && csQualifiers.size() > 0) {
                                valueListKey = "filterValueTextTyped";
                                break;
                            }
                            valueListKey = "filterValuesInList";
                            break;
                        }
                        if (objectMap.getFilterValues() != null) {
                            valueListKey = "filterValuesInList";
                            break;
                        }
                        valueListKey = "filterValueTextTyped";
                        break;
                    }
                    case 1: {
                        if (objectMap.getFilterValues() != null || this.isOlap()) {
                            valueListKey = "filterValueSingle";
                            break;
                        }
                        valueListKey = "filterValueTextTyped";
                        break;
                    }
                    case 2: {
                        if (objectMap.getFilterValues() != null) {
                            valueListKey = "filterValuesBetween";
                            break;
                        }
                        valueListKey = "filterValuesBetweenTextTyped";
                        break;
                    }
                    case 3: {
                        valueListKey = "filterValueTyped";
                    }
                }
                if (OLAPTimeFilterUtil.isOLAPRelativeTimeCondition(true, this.getValidatedModel(false), this.getSelectedCondition())) {
                    valueListKey = "filterValuesInList";
                }
                if (this.valueEntryType != null && this.valueEntryType.trim().length() > 0) {
                    if ("valueList".equals(this.valueEntryType)) {
                        valueListKey = "filterValuesInList";
                    } else if ("betweenTyped".equals(this.valueEntryType)) {
                        valueListKey = "filterValuesBetweenTextTyped";
                    } else if ("betweenCombo".equals(this.valueEntryType)) {
                        valueListKey = "filterValuesBetween";
                    } else if ("valueCombo".equals(this.valueEntryType)) {
                        valueListKey = "filterValueSingle";
                    } else if ("valueTyped".equals(this.valueEntryType)) {
                        valueListKey = "filterValueTextTyped";
                    }
                }
                List valueList = null;
                boolean canUpdate = this.updatable(changableSelection);
                if (valueListKey != null && canUpdate && (pendingAction == ADD_ACTION || pendingAction == UPDATE_ACTION || pendingAction == OLAPOK_ACTION || pendingAction == VALUEPICKER_UPDATE_ACTION || this.mode.equals("COMMIT"))) {
                    valueList = (List)this.actionInfo.get(valueListKey);
                    this.processValueList(valueList);
                    if (!canUpdate) {
                        if (!anAction.equals(CANCEL_ACTION)) {
                            this.eventInfo.put(ERROR, this.getErrorMessage(itemType, valueList, afsModel.getLocale()));
                        }
                    } else {
                        if (valueList != null) {
                            ArrayList newList = new ArrayList(valueList);
                            changableSelection.setTestValuesList(newList);
                        }
                        if (olapModel && pendingAction == OLAPOK_ACTION || itemType != 0L) {
                            this.eventInfo.remove(ERROR);
                            try {
                                boolean bl = this.validFilterValue = OLAPTimeFilterUtil.isOLAPRelativeTimeCondition(true, this.getValidatedModel(false), this.getSelectedCondition()) ? true : afsModel.isValidFilter((FilterLogicTestNodeInterface)changableSelection);
                                if (!this.validFilterValue) {
                                    changableSelection.setTestValuesList(null);
                                    this.eventInfo.put(ERROR, this.getErrorMessage(itemType, valueList, afsModel.getLocale()));
                                }
                            }
                            catch (Exception ex) {
                                this.eventInfo.put(ERROR, this.getErrorMessage(itemType, valueList, afsModel.getLocale()));
                                changableSelection.setTestValuesList(null);
                                this.validFilterValue = false;
                            }
                        }
                        if (!this.validFilterValue) {
                            return true;
                        }
                        this.eventInfo.put("filterValues", valueList);
                        modified = true;
                    }
                }
            }
        }
        if (pendingAction != null && pendingAction != OLAPOK_ACTION && pendingAction != VALUEPICKER_UPDATE_ACTION) {
            modified = this.updateSelectionCombination(afsModel, changableSelection, objectMap);
        } else {
            boolean updatable = this.updatable(changableSelection);
            if (updatable) {
                if (afsModel.getSelectionCount() < 1 && this.mode.equals("COMMIT") || afsModel.getSelectionCount() < 1 && pendingAction == OLAPOK_ACTION) {
                    afsModel.addSelection((FilterLogicTestNodeInterface)changableSelection);
                    afsModel.setSelectionCursor(-1);
                } else if (afsModel.getSelectionCount() == 1 && (pendingAction == OLAPOK_ACTION || pendingAction == VALUEPICKER_UPDATE_ACTION)) {
                    afsModel.setSelectionCursor(0);
                    afsModel.setSelection((FilterLogicTestNodeInterface)changableSelection);
                }
            }
        }
        this.log.debug("_DEBUG_:updateSelectionModel#2: EXITing method, modified=" + modified);
        return modified;
    }

    private String getErrorMessage(long itemType, List valueList, Locale locale) {
        String message = com.sas.swing.visuals.dataselectors.filters.RB.getStringResource((String)RB_KEY2, (String)"invalidFilterValue.txt", (Locale)locale);
        if (valueList == null || valueList.size() == 0 || valueList.size() == 1 && valueList.get(0) == null || valueList.get(0).equals("")) {
            message = com.sas.swing.visuals.dataselectors.filters.RB.getStringResource((String)RB_KEY2, (String)"filterIncomplete.txt", (Locale)locale);
        } else if (itemType == 3L) {
            message = message + " " + com.sas.swing.visuals.dataselectors.filters.RB.getStringResource((String)RB_KEY2, (String)"stringMayNeedQuotes.txt", (Locale)locale);
        }
        return message;
    }

    protected List getCalendar(long type) {
        String endCal;
        String startCal = (String)this.actionInfo.get("startCalendar");
        ArrayList<Date> list = new ArrayList<Date>();
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTimeZone(TimeZone.getTimeZone("GMT"));
        if (startCal != null && startCal.length() > 2) {
            cal.clear();
            String[] values = startCal.split(",");
            if (values != null && values.length == 6 && type == 6L) {
                cal.set(Integer.parseInt(values[2]), Integer.parseInt(values[1]), Integer.parseInt(values[0]), Integer.parseInt(values[3]), Integer.parseInt(values[4]), Integer.parseInt(values[5]));
            } else if (values.length == 3 && type == 4L) {
                cal.set(Integer.parseInt(values[2]), Integer.parseInt(values[1]), Integer.parseInt(values[0]));
            } else if (values.length == 3 && type == 5L) {
                cal.set(-1, -1, -1, Integer.parseInt(values[0]), Integer.parseInt(values[1]), Integer.parseInt(values[2]));
            }
            list.add(0, cal.getTime());
        }
        if ((endCal = (String)this.actionInfo.get("endCalendar")) != null && endCal.length() > 2) {
            cal.clear();
            String[] values = endCal.split(",");
            if (values.length == 6 && type == 6L) {
                cal.set(Integer.parseInt(values[2]), Integer.parseInt(values[1]), Integer.parseInt(values[0]), Integer.parseInt(values[3]), Integer.parseInt(values[4]), Integer.parseInt(values[5]));
            } else if (values.length == 3 && type == 4L) {
                cal.set(Integer.parseInt(values[2]), Integer.parseInt(values[1]), Integer.parseInt(values[0]));
            } else if (values.length == 3 && type == 5L) {
                cal.set(-1, -1, -1, Integer.parseInt(values[0]), Integer.parseInt(values[1]), Integer.parseInt(values[2]));
            }
            list.add(1, cal.getTime());
        }
        return list;
    }

    protected QualifiersEditorInterface getQualifierEditor() {
        return this.qualifierEditor;
    }

    public void setQualifiedMeasure(String[] values) {
        HashMap<String, String> map = new HashMap<String, String>();
        if (values != null) {
            for (int i = 0; i < values.length; ++i) {
                map.put(values[i], values[i]);
            }
        }
        this.actionInfo.put("qualifiedMeasure", map);
    }

    public String[] getQualifiedMeasure() {
        return null;
    }

    public boolean updateSelectionCombination(AdvancedFilterModelInterface afsModel, FilterLogicEditableTestNodeInterface changableSelection, FilterLogicTestNodeObjectMap objectMap) {
        boolean modified = false;
        try {
            int selectedRow;
            int selectedRow2;
            if (afsModel == null) {
                return false;
            }
            String pendingAction = this.getPendingAction();
            String value = null;
            this.log.debug("_DEBUG_:updateSelectionModel: Pending Action: " + pendingAction);
            if (pendingAction == ADD_ACTION) {
                this.log.debug("_DEBUG_:updateSelectionModel: processing 'add filter' request...");
                changableSelection = new DefaultFilterLogicTestNode((FilterLogicTestNodeInterface)changableSelection);
                int cursor = afsModel.getSelectionCursor();
                this.log.debug("_DEBUG_:updateSelectionModel: selection cursor is at " + cursor);
                afsModel.addSelection((FilterLogicTestNodeInterface)changableSelection);
                afsModel.setSelectionCursor(-1);
                this.eventInfo.put("addFilter", changableSelection);
                this.eventInfo.put("combinationUpdate", "update");
                this.log.debug("_DEBUG_:updateSelectionModel: mapping changable selection to " + FilterLogicTestNodeObjectMap.getID(changableSelection));
                this.log.debug("_DEBUG_:updateSelectionModel: adding filter: " + changableSelection);
                this.getSelector().setSelectorModel((Object)afsModel);
                modified = true;
            }
            if (pendingAction == EDIT_ACTION) {
                value = (String)this.actionInfo.get("editFilterAction");
                selectedRow2 = Integer.parseInt(value);
                if (selectedRow2 > -1) {
                    afsModel.setSelectionCursor(selectedRow2);
                }
                if (!this.isOlap()) {
                    FilterLogicTestNodeInterface editNode = afsModel.getSelection();
                    if (afsModel instanceof SearchValueProviderModelInterface) {
                        SearchValueProviderModelInterface vpModel = (SearchValueProviderModelInterface)afsModel;
                        int valueIndex = 0;
                        ValueProviderInterface vp = vpModel.getValueProvider(editNode, valueIndex);
                        objectMap.mapValues(editNode.getFilterItem(), vp, this.getLocale());
                    } else {
                        objectMap.mapValues(editNode.getFilterItem());
                    }
                }
                afsModel.setSelection((FilterLogicTestNodeInterface)new DefaultFilterLogicTestNode(afsModel.getSelection()));
                this.getSelector().setSelectorModel((Object)afsModel);
                this.eventInfo.put("editFilter", changableSelection);
                modified = true;
            }
            if (pendingAction == UPDATE_ACTION) {
                value = (String)this.actionInfo.get("updateFilterAction");
                this.log.debug("_DEBUG_:updateSelectionModel: PROCESSING UPDATE REQUEST, item ID=" + value);
                selectedRow2 = -1;
                if (value != null) {
                    selectedRow2 = Integer.parseInt(value);
                }
                if (selectedRow2 > -1) {
                    afsModel.setSelectionCursor(selectedRow2);
                    afsModel.setSelection((FilterLogicTestNodeInterface)new DefaultFilterLogicTestNode((FilterLogicTestNodeInterface)changableSelection));
                    this.getSelector().setSelectorModel((Object)afsModel);
                    this.eventInfo.put("updateFilter", changableSelection);
                    this.eventInfo.put("combinationUpdate", "update");
                    modified = true;
                }
            }
            if (pendingAction == DELETE_ACTION) {
                value = (String)this.actionInfo.get("deleteFilterAction");
                selectedRow2 = -1;
                if (value != null) {
                    selectedRow2 = Integer.parseInt(value);
                }
                if (selectedRow2 > -1) {
                    SimpleFilterLogicTreeInterface tree = afsModel.getSelectionTree();
                    this.eventInfo.put("deleteFilter", changableSelection);
                    this.eventInfo.put("combinationUpdate", "update");
                    if (afsModel.getSelectionCount() > 0) {
                        tree.removeLeafAt(selectedRow2);
                    }
                    afsModel.setSelectionCursor(-1);
                    this.getSelector().setSelectorModel((Object)afsModel);
                    modified = true;
                }
            }
            SimpleFilterLogicTreeInterface tree = afsModel.getSelectionTree();
            if (pendingAction == AND_ACTION) {
                value = (String)this.actionInfo.get("andFilterAction");
                int selectedRow3 = Integer.parseInt(value);
                if (selectedRow3 > -1) {
                    tree.setLeafConditionalRelationType(selectedRow3, "AND");
                    tree.refreshNodeList();
                    modified = true;
                    this.eventInfo.put("combinationUpdate", "update");
                }
            } else if (pendingAction == OR_ACTION) {
                value = (String)this.actionInfo.get("orFilterAction");
                int selectedRow4 = -1;
                if (value != null) {
                    selectedRow4 = Integer.parseInt(value);
                }
                if (selectedRow4 > -1) {
                    tree.setLeafConditionalRelationType(selectedRow4, "OR");
                    tree.refreshNodeList();
                    modified = true;
                    this.eventInfo.put("combinationUpdate", "update");
                }
            } else if (pendingAction == NOT_ACTION) {
                value = (String)this.actionInfo.get("notFilterAction");
                int selectedRow5 = Integer.parseInt(value);
                if (selectedRow5 > -1) {
                    boolean currentState = tree.isLeafNegated(selectedRow5);
                    tree.setLeafNegated(selectedRow5, !currentState);
                    tree.refreshNodeList();
                    this.eventInfo.put("combinationUpdate", "update");
                    modified = true;
                }
            } else if (pendingAction == GROUP_ACTION) {
                int maxValue;
                int minValue = Integer.parseInt((String)this.actionInfo.get("groupFilterMin"));
                if (minValue > (maxValue = Integer.parseInt((String)this.actionInfo.get("groupFilterMax")))) {
                    tree.groupLeaves(maxValue, minValue);
                } else {
                    tree.groupLeaves(minValue, maxValue);
                }
                tree.refreshNodeList();
                this.eventInfo.put("combinationUpdate", "update");
                modified = true;
            } else if (pendingAction == SPLIT_ACTION) {
                value = (String)this.actionInfo.get("splitFilterAction");
                int selectedRow6 = Integer.parseInt(value);
                if (selectedRow6 > -1) {
                    tree.splitGroup(selectedRow6);
                    tree.refreshNodeList();
                    this.eventInfo.put("combinationUpdate", "update");
                    modified = true;
                }
            } else if (pendingAction == UP_ACTION) {
                value = (String)this.actionInfo.get("upFilterAction");
                int selectedRow7 = Integer.parseInt(value);
                if (selectedRow7 > -1) {
                    int oldSelectionCursor = afsModel.getSelectionCursor();
                    afsModel.setSelectionCursor(selectedRow7);
                    FilterLogicTestNodeInterface movedTestNode = afsModel.getSelection();
                    tree.moveLeafUp(selectedRow7);
                    tree.refreshNodeList();
                    int movedIndex = this._findNodeIndex(movedTestNode);
                    afsModel.setSelectionCursor(oldSelectionCursor);
                    this.eventInfo.put(UP_ACTION, new Integer(movedIndex));
                    modified = true;
                }
            } else if (pendingAction == DOWN_ACTION && (selectedRow = Integer.parseInt(value = (String)this.actionInfo.get("downFilterAction"))) > -1) {
                int oldSelectionCursor = afsModel.getSelectionCursor();
                afsModel.setSelectionCursor(selectedRow);
                FilterLogicTestNodeInterface movedTestNode = afsModel.getSelection();
                tree.moveLeafDown(selectedRow);
                tree.refreshNodeList();
                int movedIndex = this._findNodeIndex(movedTestNode);
                afsModel.setSelectionCursor(oldSelectionCursor);
                this.eventInfo.put(DOWN_ACTION, new Integer(movedIndex));
                modified = true;
            }
        }
        catch (Exception ex) {
            this.log.error("_DEBUG_:updateSelectionModel: Exception thrown!", (Throwable)ex);
        }
        this.log.debug("_DEBUG_:updateSelectionModel: EXITing method, modified=" + modified);
        return modified;
    }

    private int _findNodeIndex(FilterLogicTestNodeInterface testNode) {
        AdvancedFilterModelInterface afsModel = this.getValidatedModel(false);
        if (afsModel != null) {
            int count = afsModel.getSelectionCount();
            for (int i = 0; i < count; ++i) {
                afsModel.setSelectionCursor(i);
                FilterLogicTestNodeInterface currentNode = afsModel.getSelection();
                if (testNode != currentNode) continue;
                return i;
            }
        }
        return -1;
    }

    private AdvancedFilterModelInterface _validateModel() {
        if (this.getSelector() == null) {
            this.log.warn("_DEBUG_:_validateModel: selector is null - aborting");
            return null;
        }
        Object myModel = this.getSelectorModel();
        if (myModel == null) {
            myModel = this.getSelector().getSelectorModel();
        }
        if (myModel == null) {
            this.log.warn("_DEBUG_:_validateModel: selector model is null - aborting");
            return null;
        }
        return (AdvancedFilterModelInterface)myModel;
    }

    protected FilterLogicTestNodeInterface getSelectionModel() {
        return this.getSelection();
    }

    public void setFilterName(String name) {
        this.log.debug("_DEBUG_:setFilterName: ENTERing method");
        this.actionInfo.put("filterName", name);
        this.log.debug("_DEBUG_:setFilterName: EXITing method");
    }

    public String getFilterName() {
        return this.getSelectionModel().getFilterLabel();
    }

    public void setFilterDescription(String description) {
        this.log.debug("_DEBUG_:setFilterDescription: ENTERing method");
        this.actionInfo.put("filterDescription", description);
        this.log.debug("_DEBUG_:setFilterDescription: EXITing method");
    }

    public String getFilterDescription() {
        return null;
    }

    public void setSelectedQualifier(String itemID) {
        this.log.debug("_DEBUG_:setSelectedQualifier: ENTERing method");
        this.actionInfo.put("selectedQualifier", itemID);
        this.log.debug("_DEBUG_:setSelectedQualifier: EXITing method");
    }

    public String getSelectedQualifier() {
        return (String)this.actionInfo.get("selectedQualifier");
    }

    public void setSelectedCondition(String itemID) {
        this.log.debug("_DEBUG_:setSelectedCondition: ENTERing method");
        this.actionInfo.put(SELECTED_CONDITION, itemID);
        this.log.debug("_DEBUG_:setSelectedCondition: EXITing method");
    }

    public String getSelectedCondition() {
        return (String)this.actionInfo.get(SELECTED_CONDITION);
    }

    public void setSelectedFilterValues(String[] values) {
        this.log.debug("_DEBUG_:setSelectedFilterValues: ENTERing method");
        AdvancedFilterModelInterface afsModel = this.getValidatedModel(false);
        if (values != null) {
            if (afsModel != null && this.isOlap()) {
                DataItem dataItem = BaseFilterObjectFactory.getDataItem(afsModel.getSelection().getFilterItem());
                if (dataItem == null) {
                    return;
                }
                ArrayList<Object> list = new ArrayList<Object>();
                for (int i = 0; i < values.length; ++i) {
                    String value = values[i];
                    if (value.length() > 0 && value.charAt(0) == '*') {
                        this.addAllChildrenToList(value.substring(1), afsModel, list);
                        continue;
                    }
                    ValueItem valueItem = null;
                    try {
                        valueItem = BaseFilterObjectFactory.createValueItemFromUniqueMemberID(dataItem, value);
                    }
                    catch (MetadataException me) {
                        this.log.error("_DEBUG_:setSelectedFilterValues: MetadataException thrown!", (Throwable)me);
                    }
                    catch (OLAPException oe) {
                        this.log.error("_DEBUG_:setSelectedFilterValues: OLAPException thrown!", (Throwable)oe);
                    }
                    if (valueItem != null) {
                        list.add(valueItem);
                        continue;
                    }
                    list.add(value);
                }
                this.actionInfo.put("filterValuesInList", list);
            } else {
                ArrayList<String> vList = new ArrayList<String>(values.length);
                vList.addAll(Arrays.asList(values));
                this.actionInfo.put("filterValuesInList", vList);
            }
        }
        this.log.debug("_DEBUG_:setSelectedFilterValues: EXITing method");
    }

    public void setSelectedFilterValues(List values) {
        this.actionInfo.put("filterValuesInList", values);
    }

    private void addAllChildrenToList(String value, AdvancedFilterModelInterface afsModel, List list) {
        FilterLogicTestNodeObjectMap objectMap = (FilterLogicTestNodeObjectMap)afsModel.getApplicationData();
        Map map = objectMap.getFilterValueMap();
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.getFilterValue(value, afsModel);
        Enumeration<TreeNode> nodes = node.breadthFirstEnumeration();
        nodes.nextElement();
        while (nodes.hasMoreElements()) {
            TreeNode cnode = nodes.nextElement();
            list.add(cnode);
            String id = Integer.toHexString(System.identityHashCode(cnode));
            map.put(id, cnode);
        }
    }

    private FilterValueInterface getFilterValue(String uniqueId, AdvancedFilterModelInterface afsModel) {
        FilterLogicTestNodeObjectMap objectMap;
        Map values;
        FilterValueInterface fvi = null;
        if (afsModel != null && uniqueId != null && uniqueId.startsWith("@") && (values = (objectMap = (FilterLogicTestNodeObjectMap)afsModel.getApplicationData()).getFilterValueMap()) != null) {
            String tempId = uniqueId.substring(1, uniqueId.length() - 1);
            Object itemObject = values.get(tempId);
            if (itemObject instanceof ValueItem) {
                ValueItem vi = (ValueItem)itemObject;
                int dataType = (int)objectMap.getMappedFilterItem().getItemType();
                Object format = null;
                fvi = new DefaultFilterValue(vi.getValue(), vi.getLabel(), dataType, format, vi.getValue());
            }
            if (itemObject instanceof FilterValueInterface) {
                fvi = (FilterValueInterface)itemObject;
            }
        }
        return fvi;
    }

    protected Object getFilterValueObject(String uniqueId, AdvancedFilterModelInterface afsModel) {
        FilterLogicTestNodeObjectMap objectMap;
        Map values;
        Object fvi = null;
        if (afsModel != null && uniqueId != null && uniqueId.startsWith("@") && (values = (objectMap = (FilterLogicTestNodeObjectMap)afsModel.getApplicationData()).getFilterValueMap()) != null) {
            String tempId = uniqueId.substring(1, uniqueId.length() - 1);
            Object itemObject = values.get(tempId);
            if (itemObject instanceof ValueItem) {
                fvi = itemObject;
            } else if (itemObject instanceof FilterValueInterface) {
                fvi = itemObject;
            }
        }
        return fvi;
    }

    public String[] getSelectedFilterValues() {
        return null;
    }

    public void setFilterValue(String value) {
        this.log.debug("_DEBUG_:setFilterValue: ENTERing method");
        AdvancedFilterModelInterface myModel = this.getValidatedModel(false);
        if (myModel == null || this.isOlap()) {
            ArrayList<String> list = new ArrayList<String>(1);
            list.add(value);
            this.actionInfo.put("filterValueSingle", list);
        } else {
            ArrayList<FilterValueInterface> list = new ArrayList<FilterValueInterface>();
            Object valToAdd = this.getFilterValue(value, myModel);
            if (valToAdd == null) {
                valToAdd = value;
            }
            list.add((FilterValueInterface)valToAdd);
            this.actionInfo.put("filterValueSingle", list);
        }
        this.log.debug("_DEBUG_:setFilterValue: EXITing method");
    }

    public String getFilterValue() {
        return null;
    }

    public void setFilterValueText(String value) {
        this.log.debug("_DEBUG_:setFilterValueText: ENTERing method");
        ArrayList<String> data = null;
        if (value != null && value.length() > 0) {
            ArrayList<String> list = new ArrayList<String>(1);
            list.add(value);
            data = list;
        }
        this.actionInfo.put("filterValueTextTyped", data);
        this.log.debug("_DEBUG_:setFilterValueText: EXITing method");
    }

    public String getFilterValueText() {
        return null;
    }

    public void setFilterValueMax(String value) {
        this.log.debug("_DEBUG_:setFilterValueMax: ENTERing method");
        ArrayList<String> dataValues = (ArrayList<String>)this.actionInfo.get("filterValuesBetween");
        AdvancedFilterModelInterface afsModel = this.getValidatedModel(false);
        if (dataValues == null) {
            dataValues = new ArrayList<String>(2);
        }
        while (dataValues.size() < 2) {
            dataValues.add(null);
        }
        String valToAdd = null;
        if (afsModel != null && !this.isOlap()) {
            valToAdd = this.getFilterValue(value, afsModel);
        }
        if (valToAdd == null) {
            valToAdd = value;
        }
        dataValues.set(1, valToAdd);
        this.actionInfo.put("filterValuesBetween", dataValues);
        this.log.debug("_DEBUG_:setFilterValueMax: EXITing method");
    }

    public String getFilterValueMax() {
        return null;
    }

    public void setFilterValueMin(String value) {
        this.log.debug("_DEBUG_:setFilterValueMin: ENTERing method");
        ArrayList<String> dataValues = (ArrayList<String>)this.actionInfo.get("filterValuesBetween");
        if (dataValues == null) {
            dataValues = new ArrayList<String>(2);
        }
        AdvancedFilterModelInterface myModel = this.getValidatedModel(false);
        while (dataValues.size() < 1) {
            dataValues.add(null);
        }
        if (this.isOlap() || myModel == null) {
            dataValues.set(0, value);
        } else {
            Object valToAdd = this.getFilterValue(value, myModel);
            if (valToAdd == null) {
                valToAdd = value;
            }
            dataValues.set(0, (String)valToAdd);
        }
        this.actionInfo.put("filterValuesBetween", dataValues);
        this.log.debug("_DEBUG_:setFilterValueMin: EXITing method");
    }

    private void processValueList(String listKey) {
        if (listKey != null) {
            List list = (List)this.actionInfo.get(listKey);
            this.processValueList(list);
            if (list != null) {
                this.actionInfo.put(listKey, list);
            }
        }
    }

    private void processValueList(List list) {
        if (list != null) {
            AdvancedFilterModelInterface myModel = this.getValidatedModel(false);
            int size = list.size();
            for (int i = 0; i < size; ++i) {
                Object entry = list.get(i);
                if (entry instanceof String) {
                    Object value = this.getFilterValueObject((String)entry, myModel);
                    if (value == null) continue;
                    list.set(i, value);
                    continue;
                }
                if (!(entry instanceof ValueItem)) continue;
                list.set(i, entry);
            }
        }
    }

    public String getFilterValueMin() {
        return null;
    }

    public void setFilterValueMaxText(String value) {
        this.log.debug("_DEBUG_:setFilterValueMaxText: ENTERing method");
        ArrayList<String> dataValues = (ArrayList<String>)this.actionInfo.get("filterValuesBetweenTextTyped");
        if (dataValues == null) {
            dataValues = new ArrayList<String>(2);
        }
        while (dataValues.size() < 2) {
            dataValues.add(null);
        }
        dataValues.set(1, value);
        this.actionInfo.put("filterValuesBetweenTextTyped", dataValues);
        this.log.debug("_DEBUG_:setFilterValueMaxText: EXITing method");
    }

    public String getFilterValueMaxText() {
        return null;
    }

    public void setFilterValueMinText(String value) {
        this.log.debug("_DEBUG_:setFilterValueMinText: ENTERing method");
        ArrayList<String> dataValues = (ArrayList<String>)this.actionInfo.get("filterValuesBetweenTextTyped");
        if (dataValues == null) {
            dataValues = new ArrayList<String>(2);
        }
        while (dataValues.size() < 1) {
            dataValues.add(null);
        }
        dataValues.set(0, value);
        this.actionInfo.put("filterValuesBetweenTextTyped", dataValues);
        this.log.debug("_DEBUG_:setFilterValueMinText: EXITing method");
    }

    public String getFilterValueMinText() {
        return null;
    }

    public void setTypedFilterValues(String value) {
        this.log.debug("_DEBUG_:setTypedFilterValues: ENTERing method");
        ArrayList<String> dataValues = new ArrayList<String>();
        StreamTokenizer st = new StreamTokenizer(new StringReader(value));
        st.wordChars(48, 57);
        st.slashStarComments(false);
        st.slashSlashComments(false);
        try {
            while (st.nextToken() != -1) {
                switch (st.ttype) {
                    case -3: 
                    case 34: 
                    case 39: {
                        dataValues.add(st.sval);
                    }
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.actionInfo.put("filterValuesInListTyped", dataValues);
        this.log.debug("_DEBUG_:setTypedFilterValues: EXITing method");
    }

    public String getTypedFilterValues() {
        return null;
    }

    public void setFilterValueTyped(String value) {
        this.log.debug("_DEBUG_:setFilterValueTyped: ENTERing method");
        Object data = value;
        if (value != null && value.length() > 0) {
            ArrayList<String> list = new ArrayList<String>(1);
            list.add(value);
            data = list;
        }
        this.actionInfo.put("filterValueTyped", data);
        this.log.debug("_DEBUG_:setFilterValueTyped: EXITing method");
    }

    public String getFilterValueTyped() {
        return null;
    }

    public void setTypedFilterValueMax(String value) {
        this.log.debug("_DEBUG_:setTypedFilterValueMax: ENTERing method");
        ArrayList<String> dataValues = (ArrayList<String>)this.actionInfo.get("filterValuesBetweenTyped");
        if (dataValues == null) {
            dataValues = new ArrayList<String>(2);
        }
        while (dataValues.size() < 2) {
            dataValues.add(null);
        }
        dataValues.set(1, value);
        this.actionInfo.put("filterValugesBetweenTyped", dataValues);
        this.log.debug("_DEBUG_:setTypedFilterValueMax: EXITing method");
    }

    public String getTypedFilterValueMax() {
        return null;
    }

    public void setTypedFilterValueMin(String value) {
        this.log.debug("_DEBUG_:setTypedFilterValueMin: ENTERing method");
        ArrayList<String> dataValues = (ArrayList<String>)this.actionInfo.get("filterValuesBetweenTyped");
        if (dataValues == null) {
            dataValues = new ArrayList<String>(2);
        }
        while (dataValues.size() < 1) {
            dataValues.add(null);
        }
        dataValues.set(0, value);
        this.actionInfo.put("filterValuesBetweenTyped", dataValues);
        this.log.debug("_DEBUG_:setTypedFilterValueMin: EXITing method");
    }

    public String getTypedFilterValueMin() {
        return null;
    }

    public void setValueListItem(String itemID) {
        this.log.debug("_DEBUG_:setValueListItem: ENTERing method");
        this.actionInfo.put("action", new String[]{"getValues", itemID});
        this.log.debug("_DEBUG_:setValueListItem: EXITing method");
    }

    public String getValueListItem() {
        return null;
    }

    public void setFilterItem(String itemID) {
        this.log.debug("_DEBUG_:setFilterItem: ENTERing method");
        this.actionInfo.put(SELECTED_ITEM, itemID);
        this.log.debug("_DEBUG_:setFilterItem: EXITing method");
    }

    public String getFilterItem() {
        return null;
    }

    public void setFilterQualifier(String itemID) {
        this.log.debug("_DEBUG_:setFilterQualifier: ENTERing method");
        this.actionInfo.put("selectedQualifier", itemID);
        this.log.debug("_DEBUG_:setFilterQualifier: EXITing method");
    }

    public String getFilterQualifier() {
        return (String)this.actionInfo.get("selectedQualifier");
    }

    public void setFilterOperator(String itemID) {
        this.log.debug("_DEBUG_:setFilterOperator: ENTERing method");
        this.actionInfo.put("selectedOperator", itemID);
        this.log.debug("_DEBUG_:setFilterOperator: EXITing method");
    }

    public String getFilterOperator() {
        return (String)this.actionInfo.get("selectedOperator");
    }

    public void setAddFilter(String value) {
        this.log.debug("_DEBUG_:setAddFilter: ENTERing method");
        this.setPendingAction(ADD_ACTION);
        this.actionInfo.put("addFilterAction", value);
        this.log.debug("_DEBUG_:setAddFilter: EXITing method");
    }

    public String getAddFilter() {
        return null;
    }

    public void setUpdateFilter(String itemID) {
        this.log.debug("_DEBUG_:setUpdateFilter: ENTERing method");
        this.setPendingAction(UPDATE_ACTION);
        this.actionInfo.put("updateFilterAction", itemID);
        this.log.debug("_DEBUG_:setUpdateFilter: EXITing method");
    }

    public String getUpdateFilter() {
        return null;
    }

    public void setEditFilter(String itemID) {
        this.log.debug("_DEBUG_:setEditFilter: ENTERing method");
        this.setPendingAction(EDIT_ACTION);
        this.actionInfo.put("editFilterAction", itemID);
        this.log.debug("_DEBUG_:setEditFilter: EXITing method");
    }

    public String getEditFilter() {
        return null;
    }

    public void setDeleteFilter(String itemID) {
        this.log.debug("_DEBUG_:setDeleteFilter: ENTERing method");
        this.setPendingAction(DELETE_ACTION);
        this.actionInfo.put("deleteFilterAction", itemID);
        this.log.debug("_DEBUG_:setDeleteFilter: EXITing method");
    }

    public String getDeleteFilter() {
        return null;
    }

    public void setDeleteAllFilters(String dummy) {
        this.log.debug("_DEBUG_:setDeleteAllFilters: ENTERing method");
        this.setPendingAction(DELETEALL_ACTION);
        this.log.debug("_DEBUG_:setDeleteAllFilters: EXITing method");
    }

    public String getDeleteAllFilters() {
        return null;
    }

    public void setAndFilter(String itemID) {
        this.setPendingAction(AND_ACTION);
        this.actionInfo.put("andFilterAction", itemID);
    }

    public String getAndFilter() {
        return null;
    }

    public void setOrFilter(String itemID) {
        this.setPendingAction(OR_ACTION);
        this.actionInfo.put("orFilterAction", itemID);
    }

    public String getOrFilter() {
        return null;
    }

    public void setNotFilter(String itemID) {
        this.setPendingAction(NOT_ACTION);
        this.actionInfo.put("notFilterAction", itemID);
    }

    public String getNotFilter() {
        return null;
    }

    public void setGroupFilter(String items) {
        this.setPendingAction(GROUP_ACTION);
        int index = items.indexOf(",");
        String min = items.substring(0, index);
        String max = items.substring(index + 1, items.length());
        if (min != null && max != null) {
            this.actionInfo.put("groupFilterMin", min);
            this.actionInfo.put("groupFilterMax", max);
        } else {
            this.actionInfo.put("groupFilterMin", "-1");
            this.actionInfo.put("groupFilterMax", "-1");
        }
    }

    public String getGroupFilter() {
        return null;
    }

    public void setSplitFilter(String itemID) {
        this.setPendingAction(SPLIT_ACTION);
        this.actionInfo.put("splitFilterAction", itemID);
    }

    public String getSplitFilter() {
        return null;
    }

    public void setUpFilter(String itemID) {
        this.setPendingAction(UP_ACTION);
        this.actionInfo.put("upFilterAction", itemID);
    }

    public String getUpFilter() {
        return null;
    }

    public void setDownFilter(String itemID) {
        this.setPendingAction(DOWN_ACTION);
        this.actionInfo.put("downFilterAction", itemID);
    }

    public String getDownFilter() {
        return null;
    }

    public void setQualifierMode(String itemID) {
        this.setPendingAction(QUALIFIER_ACTION);
        this.actionInfo.put(QUALIFIER_ACTION, itemID);
    }

    public String getQualifierMode() {
        return null;
    }

    public void setOlapOkAction(String value) {
        this.setPendingAction(OLAPOK_ACTION);
    }

    public void setValuePickerUpdateAction(String value) {
        this.setPendingAction(VALUEPICKER_UPDATE_ACTION);
    }

    public String getOlapOkAction() {
        return null;
    }

    public String getValuePickerUpdateAction() {
        return null;
    }

    public void setAction(String value) {
        this.action = value;
    }

    public String getAction() {
        return this.action;
    }

    public void setClearFilter(String itemID) {
        this.setPendingAction(CLEAR_ACTION);
        this.actionInfo.put(CLEAR_ACTION, itemID);
    }

    public String getClearFilter() {
        return null;
    }

    public void setClearAllFilter(String all) {
        this.setPendingAction(CLEARALL_ACTION);
        this.actionInfo.put(CLEARALL_ACTION, "true");
    }

    public String getClearAllFilter() {
        return null;
    }

    public void setImportFilter(String itemID) {
        this.setPendingAction(IMPORT_ACTION);
        this.actionInfo.put(IMPORT_ACTION, itemID);
    }

    public String getImportFilter() {
        return null;
    }

    public String getStartCalendar() {
        return null;
    }

    public void setStartCalendar(String calendar) {
        this.actionInfo.put("startCalendar", calendar);
    }

    public String getEndCalendar() {
        return null;
    }

    public void setEndCalendar(String calendar) {
        this.actionInfo.put("endCalendar", calendar);
    }

    public String getValueEntryType() {
        return this.valueEntryType;
    }

    public void setValueEntryType(String type) {
        this.valueEntryType = type;
    }

    private int getConditionArgumentCount(FilterLogicTestNodeInterface selectionModel) {
        if (selectionModel != null) {
            return this.getConditionArgumentCount(selectionModel.getCondition());
        }
        return 0;
    }

    private int getConditionArgumentCount(FilterConditionInterface condition) {
        if (condition != null) {
            int count = condition.getConditionArgumentCount();
            if (count == 1 && !condition.isValueListAllowed()) {
                return 3;
            }
            return condition.getConditionArgumentCount();
        }
        return 0;
    }

    protected FilterLogicEditableTestNodeInterface getChangableSelectionModel() {
        return this.getChangableSelectionModel(this.getSelectionModel());
    }

    protected FilterLogicEditableTestNodeInterface getChangableSelectionModel(FilterLogicTestNodeInterface node) {
        Object changableSelection = null;
        changableSelection = node == null ? new DefaultFilterLogicTestNode() : (node instanceof FilterLogicEditableTestNodeInterface ? (FilterLogicEditableTestNodeInterface)node : new DefaultFilterLogicTestNode(node));
        return changableSelection;
    }

    protected static String getID(Object object) {
        String id = null;
        if (object != null) {
            id = Integer.toHexString(System.identityHashCode(object));
        }
        return id;
    }

    protected boolean isOlap() {
        Object sModel;
        DataSelectorInterface mySelector = this.getSelector();
        if (mySelector != null && (sModel = mySelector.getSelectorModel()) instanceof AdvancedFilterModelInterface) {
            return ((AdvancedFilterModelInterface)sModel).isOLAP();
        }
        return false;
    }

    public Map getFilterItemMap() {
        return this._filterItemMap;
    }

    public void setFilterItemMap(List list) {
        if (this._filterItemMap == null) {
            this._filterItemMap = new HashMap();
        } else {
            this._filterItemMap.clear();
        }
        if (list != null) {
            for (FilterableItemInterface item : list) {
                item.getFilterModel().setSelectionCursor(-1);
                FilterItemInterface filterItem = (FilterItemInterface)item.getFilterModel().getDataSource().getFilterItemList().get(0);
                this._filterItemMap.put(AdvancedFilterSelectorCommand.getID(filterItem), filterItem);
            }
        }
    }

    public AdvancedFilterModelInterface getValidatedModel(boolean updateSelector) {
        if (this.validatedModel == null || this.action != null && this.action.equalsIgnoreCase(FILTERITEM_CHANGED)) {
            String selectedItem;
            Object myModel = this.getSelectorModel();
            if (myModel == null && this.getSelector() != null) {
                myModel = this.getSelector().getSelectorModel();
            }
            if (myModel != null && myModel instanceof AdvancedFilterModelInterface) {
                this.validatedModel = (AdvancedFilterModelInterface)myModel;
            } else if (myModel != null && myModel instanceof FilterableListModelInterface && (selectedItem = (String)this.actionInfo.get(SELECTED_ITEM)) != null) {
                List list = ((FilterableListModelInterface)myModel).getFilterableItems();
                for (int i = 0; i < list.size(); ++i) {
                    FilterableItemInterface item = (FilterableItemInterface)list.get(i);
                    FilterItemInterface filterItem = (FilterItemInterface)item.getFilterModel().getDataSource().getFilterItemList().get(0);
                    if (!AdvancedFilterSelectorCommand.getID(filterItem).equals(selectedItem)) continue;
                    this.validatedModel = item.getFilterModel();
                    if (updateSelector || this.validatedModel.isOLAP()) {
                        this.getSelector().setSelectorModel((Object)this.validatedModel);
                        break;
                    }
                    Object appData = this.validatedModel.getApplicationData();
                    if (appData instanceof FilterLogicTestNodeObjectMap) break;
                    FilterLogicTestNodeObjectMap objectMap = new FilterLogicTestNodeObjectMap();
                    objectMap.mapFilterItems(this.validatedModel.getDataSource());
                    if (!(this.validatedModel instanceof PersistentFilterProviderModelInterface)) break;
                    objectMap.mapPersistentFilters(((PersistentFilterProviderModelInterface)this.validatedModel).getPersistentFilterList());
                    break;
                }
            }
        }
        return this.validatedModel;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int getCommandStatus(ActionSupportFilter filter) {
        Object myModel = filter.getAttribute("model");
        List items = null;
        if (!(myModel instanceof BusinessQueryProviderInterface)) return 4;
        BusinessQuery businessQuery = ((BusinessQueryProviderInterface)myModel).getBusinessQuery();
        if (businessQuery != null) {
            if (businessQuery.getInputStructure().isOLAP()) {
                try {
                    items = businessQuery.getResultItems(Role.COLUMN);
                    items.addAll(businessQuery.getResultItems(Role.ROW));
                    items.addAll(businessQuery.getResultItems(Role.BACKGROUND));
                }
                catch (MetadataException e) {
                    return 0;
                }
            } else {
                boolean isFilterSupported = businessQuery.isActionSupported(BusinessQueryActionType.FILTER_ITEM);
                if (!isFilterSupported) return 2;
                return 0;
            }
        }
        if (items == null) return 0;
        return this._getCommandStatus(items);
    }

    private int _getCommandStatus(List items) {
        int size = items.size();
        for (int i = 0; i < size; ++i) {
            DataItem di = (DataItem)items.get(i);
            if (!di.isActionSupported(DataItemActionType.STEP_MEMBER_FILTER) && !di.isActionSupported(DataItemActionType.STEP_DATABASED_FILTER)) continue;
            return 0;
        }
        return 4;
    }

    public boolean isSupported(ActionSupportFilter actionFilter) {
        Object myModel = actionFilter.getAttribute("model");
        return myModel != null && (myModel instanceof AdvancedFilterModelInterface || myModel instanceof DataSelection || myModel instanceof BusinessQueryProviderInterface || myModel instanceof BusinessModel || myModel instanceof BusinessQuery);
    }

    public String getPendingAction() {
        DataSelectorInterface mySelector = this.getSelector();
        if (mySelector instanceof PendingActionSelector) {
            return ((PendingActionSelector)mySelector).getPendingAction();
        }
        return null;
    }

    public void setPendingAction(String value) {
        DataSelectorInterface mySelector = this.getSelector();
        if (mySelector instanceof PendingActionSelector) {
            ((PendingActionSelector)mySelector).setPendingAction(value);
        }
    }

    public AdvancedFilterModelInterface getCurrentValidatedModel() {
        return this.validatedModel;
    }

    public void setWhereCheckbox(String state) {
        this.actionInfo.put(QUALIFIER_CHECKED, state);
    }

    public String getWhereCheckbox() {
        return null;
    }
}

