/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.backup.spi;

import com.sas.svcs.backup.analyze.BackupTask;
import com.sas.svcs.backup.analyze.model.RuntimeSASEnvironment;
import com.sas.svcs.backup.client.BackupServiceSession;
import com.sas.svcs.backup.client.BackupSourceConfig;
import com.sas.svcs.backup.client.BackupSourceDetails;
import com.sas.svcs.backup.client.OperationDetails;
import com.sas.svcs.backup.client.RecoveryOptions;
import com.sas.svcs.backup.common.definitions.BackupErrorConstants;
import com.sas.svcs.backup.common.definitions.BackupException;
import com.sas.svcs.backup.dao.BackupServiceUtils;
import com.sas.svcs.backup.dao.ConfigBeanConverter;
import com.sas.svcs.backup.spi.BackupSupportService;
import com.sas.svcs.backup.spi.RB;
import com.sas.svcs.metadata.mgmt.client.Backup;
import com.sas.svcs.metadata.mgmt.client.BackupOptions;
import com.sas.svcs.metadata.mgmt.client.MetadataBackupService;
import com.sas.svcs.metadata.mgmt.client.Operation;
import com.sas.svcs.metadata.mgmt.client.Recovery;
import com.sas.text.Message;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service(value="METADATASERVER")
public class MetadataBackupSupportService
implements BackupSupportService {
    private static Logger logger = LogManager.getLogger(MetadataBackupSupportService.class);
    MetadataBackupService metadataBackupService;
    @Autowired
    ConfigBeanConverter configBeanConverter;

    @Autowired
    public void setMetadataBackupService(@Qualifier(value="MetadataBackupService") MetadataBackupService metadataBackupService) {
        this.metadataBackupService = metadataBackupService;
    }

    @Override
    public BackupSourceDetails doSourceBackup(RuntimeSASEnvironment runtimeSASEnvironment, BackupTask backupTask, com.sas.svcs.backup.client.BackupOptions backupOptions, BackupServiceSession<?> session) throws BackupException {
        logger.info(RB.getStringResource("MetadataBackupSupportService.starting.metadata.backup.txt"));
        BackupSourceDetails srcBackupDetails = null;
        Backup metadataBackup = null;
        try {
            BackupSourceConfig srcConfig = this.configBeanConverter.backupTaskToSourceConfig(backupTask, runtimeSASEnvironment.getPrimaryMetdataTier());
            srcBackupDetails = new BackupSourceDetails(srcConfig);
            BackupOptions options = BackupOptions.newOptions((String)backupOptions.getComment());
            options.setReorganizeRepositories(backupOptions.isReorganizeRepositories());
            this.updateMetadataOptions(options, backupTask);
            metadataBackup = this.metadataBackupService.backup(options);
            if (metadataBackup != null && metadataBackup.getStatus() == Operation.Status.SUCCESS) {
                logger.info(Message.format((String)RB.getStringResource("MetadataBackupSupportService.metadata.backup.completed.fmt"), (Object)metadataBackup.getName()));
            } else {
                srcBackupDetails.setServerSideErrorCode(-1);
                logger.error(RB.getStringResource("MetadataBackupSupportService.metadata.backup.failed.txt"));
            }
            this.updateBackupSourceDetails(srcBackupDetails, metadataBackup);
        }
        catch (Throwable t) {
            try {
                srcBackupDetails.setStatus(OperationDetails.OperationStatus.FAIL);
                srcBackupDetails.setServerSideErrorCode(BackupErrorConstants.ErrorCodes.ERROR_CODE_METADATA_SERVER_BACKUP_FAILED.getErrorCode());
                throw new BackupException(RB.getStringResource("MetadataBackupSupportService.metadata.backup.failed.txt"), t, BackupErrorConstants.ErrorCodes.ERROR_CODE_METADATA_SERVER_BACKUP_FAILED.getErrorCode());
            }
            catch (Throwable throwable) {
                this.updateBackupSourceDetails(srcBackupDetails, metadataBackup);
                throw throwable;
            }
        }
        logger.info(RB.getStringResource("MetadataBackupSupportService.metadata.backup.completed.fmt"));
        return srcBackupDetails;
    }

    private void updateMetadataOptions(BackupOptions options, BackupTask backupTask) {
        String reorganizeRepositories;
        Properties properties = backupTask.getProperties();
        if (properties != null && (reorganizeRepositories = properties.getProperty("USEROPTION:reorganizeMetadataRepositories")) != null) {
            logger.debug("Setting user provided option: reorganizeMetadataRepositories:" + reorganizeRepositories);
            options.setReorganizeRepositories(Boolean.parseBoolean(reorganizeRepositories));
        }
    }

    @Override
    public Map<String, List<String>> getContentDetails(BackupSourceConfig sourceConfig, String operationName, BackupServiceSession session) {
        return null;
    }

    private void updateBackupSourceDetails(BackupSourceDetails srcBackupDetails, Backup metadataBackup) {
        if (srcBackupDetails != null && metadataBackup != null) {
            if (metadataBackup.isWarningDetected()) {
                srcBackupDetails.setServerSideErrorCode(2);
                logger.warn(RB.getStringResource("MetadataBackupSupportService.metadata.backup.encountered.warning.txt"));
            }
            String status = metadataBackup.getStatus().toString();
            srcBackupDetails.setStatus(BackupServiceUtils.parseStatus(status));
            srcBackupDetails.setSourceBackupName(metadataBackup.getName());
            srcBackupDetails.setBackupLocation(this.metadataBackupService.getAbsoluteBackupDirectory(metadataBackup));
            srcBackupDetails.setLogFilePath(metadataBackup.getLog());
            srcBackupDetails.setSize(new Double(metadataBackup.getSize()).longValue());
            srcBackupDetails.setPercentComplete(metadataBackup.getPercentComplete());
        }
    }

    @Override
    public BackupSourceDetails doSourceRecovery(String backupId, RecoveryOptions recoveryOptions, BackupSourceDetails sourceBackup, BackupServiceSession session) throws BackupException {
        logger.info(RB.getStringResource("MetadataBackupSupportService.starting.metadata.recovery.txt"));
        BackupSourceDetails sourceRecovery = new BackupSourceDetails(sourceBackup);
        Recovery metaRecovery = null;
        try {
            String name = sourceBackup.getSourceBackupName();
            Backup newBackup = this.metadataBackupService.getBackupByName(name);
            if (newBackup != null) {
                com.sas.svcs.metadata.mgmt.client.RecoveryOptions metadataRecoveryOptions = new com.sas.svcs.metadata.mgmt.client.RecoveryOptions();
                metadataRecoveryOptions.setComment(recoveryOptions.getComment());
                metadataRecoveryOptions.setPauseComment(recoveryOptions.getPauseComment());
                metadataRecoveryOptions.setIncludeConfig(recoveryOptions.isIncludeConfig());
                metadataRecoveryOptions.setReorganizeRepositories(recoveryOptions.isReorganizeRepositories());
                metadataRecoveryOptions.setVerify(recoveryOptions.isVerify());
                if (!BackupServiceUtils.isEmpty(recoveryOptions.getRollForward())) {
                    metadataRecoveryOptions.setRollForward(recoveryOptions.getRollForward());
                }
                if ((metaRecovery = this.metadataBackupService.recover(newBackup, metadataRecoveryOptions)) == null) {
                    logger.error(Message.format((String)RB.getStringResource("MetadataBackupSupportService.recovery.failed.fmt"), (Object)name));
                    sourceRecovery.setServerSideErrorCode(-1);
                    sourceRecovery.setStatus(OperationDetails.OperationStatus.FAIL);
                }
            } else {
                sourceRecovery.setStatus(OperationDetails.OperationStatus.FAIL);
                logger.error(Message.format((String)RB.getStringResource("MetadataBackupSupportService.metadata.backup.instance.not.available.fmt"), (Object)name));
            }
        }
        catch (Throwable e) {
            sourceRecovery.setServerSideErrorCode(BackupErrorConstants.ErrorCodes.ERROR_CODE_METADATA_SERVER_RECOVERY_FAILED.getErrorCode());
            sourceRecovery.setStatus(OperationDetails.OperationStatus.FAIL);
            logger.error(RB.getStringResource("MetadataBackupSupportService.metadataserver.recovery.failed.txt"));
            throw new BackupException(RB.getStringResource("MetadataBackupSupportService.metadataserver.recovery.failed.txt"), e, BackupErrorConstants.ErrorCodes.ERROR_CODE_METADATA_SERVER_RECOVERY_FAILED.getErrorCode());
        }
        finally {
            this.updateRecoveryDetails(sourceRecovery, metaRecovery);
        }
        logger.info(RB.getStringResource("MetadataBackupSupportService.metadata.server.recovery.txt"));
        return sourceRecovery;
    }

    private void updateRecoveryDetails(BackupSourceDetails sourceRecovery, Recovery metaRecovery) {
        if (sourceRecovery != null && metaRecovery != null) {
            if (metaRecovery.isWarningDetected()) {
                sourceRecovery.setServerSideErrorCode(2);
                logger.warn(RB.getStringResource("MetadataBackupSupportService.metadata.recovery.encountered.warning.txt"));
            }
            String status = metaRecovery.getStatus().toString();
            sourceRecovery.setStatus(BackupServiceUtils.parseStatus(status));
            sourceRecovery.setLogFilePath(metaRecovery.getLog());
            sourceRecovery.setSize(new Double(metaRecovery.getSize()).longValue());
            sourceRecovery.setPercentComplete(metaRecovery.getPercentComplete());
        }
    }
}

