/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.backup.spi;

import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.SoftwareComponent;
import com.sas.metadata.util.ConfigurablePropertiesUtil;
import com.sas.services.ServiceException;
import com.sas.services.information.Filter;
import com.sas.services.information.FilterComponent;
import com.sas.services.information.FilterInterface;
import com.sas.services.information.MetadataServerInterface;
import com.sas.services.information.metadata.ServerComponentInterface;
import com.sas.services.information.metadata.SoftwareComponentInterface;
import com.sas.services.information.metadata.servers.DataServerInterface;
import com.sas.services.information.metadata.servers.SASInfrastructureDataServerUtil;
import com.sas.services.user.UserIdentityInterface;
import com.sas.solstice.platform.core.access.IResults;
import com.sas.svcs.authentication.helper.FoundationServicesUserSessionFactory;
import com.sas.svcs.backup.analyze.BackupTask;
import com.sas.svcs.backup.analyze.model.RuntimeSASEnvironment;
import com.sas.svcs.backup.client.BackupOptions;
import com.sas.svcs.backup.client.BackupServiceSession;
import com.sas.svcs.backup.client.BackupSourceConfig;
import com.sas.svcs.backup.client.BackupSourceDetails;
import com.sas.svcs.backup.client.BackupSourceNode;
import com.sas.svcs.backup.client.RecoveryOptions;
import com.sas.svcs.backup.common.definitions.BackupErrorConstants;
import com.sas.svcs.backup.common.definitions.BackupException;
import com.sas.svcs.backup.dao.BackupServerContext;
import com.sas.svcs.backup.dao.BackupServerHelperDAO;
import com.sas.svcs.backup.dao.BackupServiceUtils;
import com.sas.svcs.backup.dao.ConfigBeanConverter;
import com.sas.svcs.backup.dao.DeploymentAgentClient;
import com.sas.svcs.backup.dao.OMRDeploymentBackupConfiguration;
import com.sas.svcs.backup.spi.AbstractBackupSupportService;
import com.sas.svcs.backup.spi.RB;
import com.sas.svcs.deployment.data.SASTier;
import com.sas.text.Message;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service(value="CONTENTSERVER")
public class ContentServerBackupSupportService
extends AbstractBackupSupportService {
    private static final Logger logger = LogManager.getLogger(ContentServerBackupSupportService.class);
    private static final String SASINFRA_SERVERCOMPONENT_CLASSIDENTIFIER = "SASInfrastructureData";
    private static final String CLASSIDENTIFIER = "ClassIdentifier";
    private static final String SERVER_COMPONENT = "ServerComponent";
    public static final String WEBAPPSERV_SOFTWARECOMPONENTCLASSIDENTIFIER = "webappsrv";
    public static final String SCS_DATABASE_NAME = "webappsrv.dbms.name";
    public static final String SCS_DATABASE_TYPE = "data.dbms.type";
    public static final String SCS_WEBINFPLTM_INSTALL_CONFIG_DIR = "webinfpltfm.install.config.dir";
    public static final String SCS_WEBAPPSERV_USERID = "webappsrv.dbms.userid";
    public static final String SCS_WEBAPPSERV_DB_HOST = "webappsrv.dbms.host";
    public static final String SCS_WEBAPPSERV_DB_PORT = "webappsrv.dbms.port";
    public static final String WEBAPPSERV_HTTP_PROTOCOL = "webappsrv.server.protocol";
    public static final String WEBAPPSERV1_HTTP_PROTOCOL = "webappsrv.server1.protocol";
    private static final String WEBINFRA_COMPONENT_CLASSIDENTIFIER = "webinfpltfm";
    private static final String WEBINFREPO = "iomsrv.httpserver.repository.dir";
    @Autowired
    @Qualifier(value="BackupServerHelperDAO")
    BackupServerHelperDAO helperDAO;
    @Autowired
    private FoundationServicesUserSessionFactory userSessionFactory;
    @Autowired
    private OMRDeploymentBackupConfiguration omrDeploymentConf;
    @Autowired
    private ConfigBeanConverter convertor;

    @Override
    public BackupSourceDetails doSourceBackup(RuntimeSASEnvironment runtimeSASEnvironment, BackupTask backupTask, BackupOptions options, BackupServiceSession<?> session) throws BackupException {
        BackupSourceDetails srcBackupDetails = null;
        try {
            logger.info(RB.getStringResource("ContentServerBackupSupportService.starting.contentserver.backup.txt"));
            LinkedHashMap<String, String> optionalProps = new LinkedHashMap<String, String>();
            Properties properties = backupTask.getProperties();
            optionalProps.put("-host", properties.getProperty("host"));
            optionalProps.put("-port", properties.getProperty("port"));
            optionalProps.put("-user", properties.getProperty("user"));
            optionalProps.put("-pw", properties.getProperty("pw"));
            optionalProps.put("-httpprotocol", properties.getProperty("httpprotocol"));
            srcBackupDetails = this.helperDAO.backup(runtimeSASEnvironment, backupTask, session, optionalProps, BackupErrorConstants.ErrorCodes.ERROR_CODE_CONTENT_SERVER_BACKUP_FAILED);
            this.pullSCSContentFromDropZone(srcBackupDetails, backupTask, session, runtimeSASEnvironment);
            logger.info(RB.getStringResource("ContentServerBackupSupportService.content.server.backup.done.txt"));
        }
        catch (BackupException e) {
            throw e;
        }
        catch (Exception e) {
            throw new BackupException((Throwable)e, BackupErrorConstants.ErrorCodes.ERROR_CODE_CONTENT_SERVER_BACKUP_FAILED.getErrorCode());
        }
        return srcBackupDetails;
    }

    private void pullSCSContentFromDropZone(BackupSourceDetails srcBackupDetails, BackupTask backupTask, BackupServiceSession<?> session, RuntimeSASEnvironment runtimeSASEnvironment) throws BackupException {
        String scsbackupPath = null;
        String scsBackupHost = null;
        String tempPath = null;
        String scsHost = null;
        BackupErrorConstants.ErrorCodes errorTobeUsed = null;
        File scsBackup = null;
        if (errorTobeUsed == null) {
            errorTobeUsed = BackupErrorConstants.ErrorCodes.ERROR_CODE_GET_BACKUPSERVER_FILE_FAILED;
        }
        try {
            tempPath = BackupServiceUtils.getTempDir().getPath();
            scsBackupHost = srcBackupDetails.getSCSBackupHost();
            scsbackupPath = srcBackupDetails.getSCSBackupPath();
            if (scsbackupPath != null) {
                scsHost = backupTask.getPerformOn().getHostName();
                BackupServerContext context = BackupServerContext.getInstance(this.omrDeploymentConf, srcBackupDetails.getSourceConfig().getBackupSourceNode(), srcBackupDetails.getSourceConfig().getSourceType());
                String targetDropZonePath = context.getBackupDropZone() + "/" + session.getSessionId() + "/" + "content";
                scsBackup = new File(tempPath + "/" + "SCSBackupTemp" + Math.random());
                String SCSTempPath = null;
                boolean SCSBackupExists = false;
                if (scsBackup.exists()) {
                    logger.debug("Deleting SCSBackupTemp");
                    ContentServerBackupSupportService.deleteDir(scsBackup);
                }
                logger.debug("Create SCSBackupTemp");
                SCSBackupExists = scsBackup.mkdir();
                if (!SCSBackupExists) {
                    throw new BackupException("Unable to create temp dir" + scsBackup.getAbsolutePath(), errorTobeUsed.getErrorCode());
                }
                SCSTempPath = scsBackup.getAbsolutePath();
                logger.debug("SCSTempPath" + SCSTempPath + "   scsBackupHost" + scsBackupHost + "    scsbackupPath" + scsbackupPath);
                logger.debug("scsHost    " + scsHost + "   targetDropZonePath" + targetDropZonePath);
                if (!BackupServiceUtils.isHostsEqual(scsHost, scsBackupHost) || !this.helperDAO.isOnCurrentTier(srcBackupDetails.getSourceConfig().getBackupSourceNode(), scsbackupPath, srcBackupDetails.getSourceConfig().getBackupSourceNode().getConfigDirPath(), session, BackupErrorConstants.ErrorCodes.ERROR_CODE_CONTENT_SERVER_BACKUP_FAILED)) {
                    BackupSourceNode csBackupNode;
                    String[] paramsGetResult = new String[]{"pullFolder", scsBackupHost, scsbackupPath, SCSTempPath};
                    logger.debug("Pulling folder files from  host " + scsBackupHost + "freom path [scs backup path ] " + scsbackupPath + "  to temp folder " + SCSTempPath);
                    IResults copyResult = DeploymentAgentClient.handleArgLine(paramsGetResult, paramsGetResult);
                    if (copyResult.getStatus() != 0 || copyResult.getSubstatus() != 0) {
                        logger.error(Message.format((String)RB.getStringResource("ContentServerBackupSupportService.Error.copying.resultfile.fromhost.fmt"), (Object)scsbackupPath, (Object)scsBackupHost));
                    }
                    String[] paramsGetResult1 = new String[]{"copyFolder", scsHost, SCSTempPath, targetDropZonePath};
                    logger.debug("Copying folder  from host " + scsHost + " from temp folder " + SCSTempPath + " to the target DropZonePath " + targetDropZonePath);
                    IResults copyResult1 = DeploymentAgentClient.handleArgLine(paramsGetResult1, paramsGetResult1);
                    if (copyResult1.getStatus() != 0 || copyResult1.getSubstatus() != 0) {
                        logger.error(Message.format((String)RB.getStringResource("ContentServerBackupSupportService.Error.copying.resultfile.fromhost.fmt"), (Object)targetDropZonePath, (Object)scsHost));
                    }
                    if ((csBackupNode = this.getContentServerBackupTier(runtimeSASEnvironment, scsHost, scsbackupPath)) != null) {
                        this.helperDAO.cleanDropZone(csBackupNode, scsbackupPath);
                    } else {
                        logger.warn("Unable to get SASTier for : " + scsHost + ", Please manually delete the SCS backup from : " + scsbackupPath);
                    }
                    srcBackupDetails.setSize(BackupServiceUtils.getDirectorySize(scsBackup));
                }
            }
        }
        catch (IOException e) {
            logger.error(Message.format((String)RB.getStringResource("ContentServerBackupSupportService.ErrorPulliing.Results.fmt"), scsbackupPath, (Object)scsBackupHost));
            throw new BackupException(Message.format((String)RB.getStringResource("ContentServerBackupSupportService.ErrorPulliing.Results.fmt"), (Object)scsbackupPath, (Object)scsBackupHost), (Throwable)e, errorTobeUsed.getErrorCode());
        }
    }

    private BackupSourceNode getContentServerBackupTier(RuntimeSASEnvironment sasEnv, String scsHost, String scsBackupPath) {
        List sasTiers = sasEnv.getAvailableTiers();
        String forComp1 = scsBackupPath != null ? scsBackupPath.toLowerCase() : "";
        String forCompHost1 = scsHost != null ? scsHost.toLowerCase() : "";
        String forComp2 = null;
        String forCompHost2 = null;
        if (sasTiers != null) {
            for (SASTier sasTier : sasTiers) {
                forComp2 = sasTier.getSasConfig() != null ? sasTier.getSasConfig().toLowerCase() : "";
                String string = forCompHost2 = sasTier.getHostName() != null ? sasTier.getHostName().toLowerCase() : "";
                if (!forComp1.startsWith(forComp2) || !forCompHost1.equals(forCompHost2)) continue;
                return this.convertor.sasTierToBackupSourceNode(sasTier, null);
            }
        }
        logger.warn("Unable to find SASTier for content server backup in available tiers on : " + scsHost);
        return null;
    }

    private void getSCSContentsDetails(Map<String, List<String>> contentDetails, String sourceDetailsLoc) throws BackupException {
        File SCSLogFile = new File(sourceDetailsLoc);
        BufferedReader SCSLogBR = null;
        try {
            if (SCSLogFile.exists()) {
                SCSLogBR = new BufferedReader(new FileReader(SCSLogFile));
                int lineNo = 0;
                String line = null;
                while ((line = SCSLogBR.readLine()) != null) {
                    String fileCompletePath;
                    String[] tempArray;
                    if (line.contains("FilePath@") && (tempArray = line.split("FilePath@")).length == 2 && (tempArray = (fileCompletePath = tempArray[1]).split("content")).length == 2) {
                        String filePath = tempArray[1];
                        File backdupFile = new File(filePath);
                        String dirName = backdupFile.getParent();
                        String fileName = BackupServiceUtils.getName(filePath);
                        List<String> filesList = contentDetails.get(dirName);
                        if (filesList == null) {
                            filesList = new ArrayList<String>();
                        }
                        filesList.add(fileName);
                        contentDetails.put(dirName, filesList);
                    }
                    ++lineNo;
                }
            }
        }
        catch (FileNotFoundException e) {
            logger.error(e.getMessage());
            throw new BackupException("Error encountered while trying to fetch content server backup contents.", (Throwable)e, BackupErrorConstants.ErrorCodes.ERROR_CODE_GET_CONTENT_DETAILS_FAILED.getErrorCode());
        }
        catch (IOException e) {
            logger.error(e.getMessage());
            throw new BackupException("Error encountered while trying to fetch content server backup contents.", (Throwable)e, BackupErrorConstants.ErrorCodes.ERROR_CODE_GET_CONTENT_DETAILS_FAILED.getErrorCode());
        }
        finally {
            if (SCSLogBR != null) {
                try {
                    SCSLogBR.close();
                }
                catch (Throwable throwable) {}
            }
        }
    }

    @Override
    public BackupSourceDetails doSourceRecovery(String backupId, RecoveryOptions recoveryOptions, BackupSourceDetails sourceBackup, BackupServiceSession session) throws BackupException {
        BackupSourceDetails sourceRecovery = null;
        try {
            logger.info(RB.getStringResource("ContentServerBackupSupportService.starting.content.server.recovery.txt"));
            LinkedHashMap<String, String> optionalProps = new LinkedHashMap();
            optionalProps = this.getOptionalProps(backupId);
            sourceRecovery = this.helperDAO.recover(sourceBackup, session, optionalProps, BackupErrorConstants.ErrorCodes.ERROR_CODE_CONTENT_SERVER_RECOVERY_FAILED);
            logger.info(RB.getStringResource("ContentServerBackupSupportService.content.server.recovered.txt"));
        }
        catch (BackupException e) {
            throw e;
        }
        catch (Exception e) {
            throw new BackupException((Throwable)e, BackupErrorConstants.ErrorCodes.ERROR_CODE_CONTENT_SERVER_RECOVERY_FAILED.getErrorCode());
        }
        return sourceRecovery;
    }

    public Map<String, String> getOptionalProps(String backupId) throws BackupException, RemoteException, MdException {
        LinkedHashMap<String, String> optionalProperties;
        block17: {
            optionalProperties = new LinkedHashMap<String, String>();
            try {
                SASInfrastructureDataServerUtil util = new SASInfrastructureDataServerUtil(this.userSessionFactory.getLocalSession());
                DataServerInterface datserverInterface = null;
                Map connectionInfo = null;
                try {
                    List sasInfraDataServerComponents = this.omrDeploymentConf.getServerComponents(SASINFRA_SERVERCOMPONENT_CLASSIDENTIFIER);
                    if (sasInfraDataServerComponents == null) {
                        logger.error(RB.getStringResource("OMRPostgresSupportService.error.sasinfra.component.notfound.txt"));
                        throw new BackupException(RB.getStringResource("OMRPostgresSupportService.error.sasinfra.component.notfound.txt"), BackupErrorConstants.ErrorCodes.ERROR_CODE_CONTENT_SERVER_DISCOVERY_FAILED.getErrorCode());
                    }
                    block6: for (ServerComponentInterface postgresInstance : sasInfraDataServerComponents) {
                        List dependentComponents = postgresInstance.getDependentComponents();
                        for (SoftwareComponentInterface componentdependent : dependentComponents) {
                            if (!componentdependent.getClassIdentifier().equals(WEBAPPSERV_SOFTWARECOMPONENTCLASSIDENTIFIER)) continue;
                            datserverInterface = util.getServerByName(postgresInstance.getName());
                            if (datserverInterface == null) continue block6;
                            connectionInfo = datserverInterface.getServerProperties();
                            continue block6;
                        }
                    }
                }
                catch (RemoteException e) {
                    logger.error(e.getMessage());
                    throw new BackupException("Error encountered while trying to get connection information from server component SASInfrastructureData", (Throwable)e, BackupErrorConstants.ErrorCodes.ERROR_CODE_CONTENT_SERVER_RECOVERY_FAILED.getErrorCode());
                }
                if (connectionInfo == null) break block17;
                try {
                    String AuthDomain = (String)connectionInfo.get("AUTHDOMAIN");
                    MetadataServerInterface metadataServer = (MetadataServerInterface)this.omrDeploymentConf.getServer();
                    List loginAuthDoamin = metadataServer.getLoginsForAuthDomain(AuthDomain);
                    if (loginAuthDoamin.size() > 0) {
                        UserIdentityInterface uid = (UserIdentityInterface)loginAuthDoamin.get(0);
                        String userName = uid.getPrincipal().toString();
                        String password = uid.getCredential().toString();
                        optionalProperties.put("-pguser", userName);
                        optionalProperties.put("-pgpw", password);
                    }
                }
                catch (RemoteException e) {
                    logger.error(RB.getStringResource("OMRPostgresSupportService.error.credentials.notfound.txt"), (Throwable)e);
                    throw new BackupException(RB.getStringResource("OMRPostgresSupportService.error.credentials.notfound.txt"), (Throwable)e, BackupErrorConstants.ErrorCodes.ERROR_CODE_CONTENT_SERVER_RECOVERY_FAILED.getErrorCode());
                }
            }
            catch (ServiceException e) {
                throw new BackupException("Error encountered while trying to get connection information and login details from server component SASInfrastructureData", (Throwable)e, BackupErrorConstants.ErrorCodes.ERROR_CODE_CONTENT_SERVER_RECOVERY_FAILED.getErrorCode());
            }
        }
        List WebappComponents = this.omrDeploymentConf.getSoftwareComponents(WEBAPPSERV_SOFTWARECOMPONENTCLASSIDENTIFIER);
        SoftwareComponentInterface webappServComponent = null;
        if (WebappComponents.size() > 0) {
            webappServComponent = (SoftwareComponentInterface)WebappComponents.get(0);
        }
        if (webappServComponent == null) {
            logger.error("Software component for SAS Web Application Server not found");
            throw new BackupException("Software component for SAS Web Application Server not found", BackupErrorConstants.ErrorCodes.ERROR_CODE_CONTENT_SERVER_RECOVERY_FAILED.getErrorCode());
        }
        String dbServerHost = this.omrDeploymentConf.getSoftwareComponentProperty(webappServComponent, SCS_WEBAPPSERV_DB_HOST, BackupErrorConstants.ErrorCodes.ERROR_CODE_CONTENT_SERVER_RECOVERY_FAILED);
        optionalProperties.put("-pghost", dbServerHost);
        logger.debug("DBMS Server host: " + dbServerHost);
        String dbServerPort = this.omrDeploymentConf.getSoftwareComponentProperty(webappServComponent, SCS_WEBAPPSERV_DB_PORT, BackupErrorConstants.ErrorCodes.ERROR_CODE_CONTENT_SERVER_RECOVERY_FAILED);
        optionalProperties.put("-pgport", dbServerPort);
        logger.debug("DBMS Server port: " + dbServerPort);
        String webappUserid = this.omrDeploymentConf.getSoftwareComponentProperty(webappServComponent, SCS_WEBAPPSERV_USERID, BackupErrorConstants.ErrorCodes.ERROR_CODE_CONTENT_SERVER_RECOVERY_FAILED);
        if (webappUserid != null) {
            optionalProperties.put("-webappuserid", webappUserid);
        }
        optionalProperties.put("-backupid", backupId);
        String dbName = this.omrDeploymentConf.getSoftwareComponentProperty(webappServComponent, SCS_DATABASE_NAME, BackupErrorConstants.ErrorCodes.ERROR_CODE_CONTENT_SERVER_RECOVERY_FAILED);
        optionalProperties.put("-dbname", dbName);
        String jdbcURL = this.omrDeploymentConf.getSoftwareComponentProperty(webappServComponent, "webappsrv.jdbc.url", BackupErrorConstants.ErrorCodes.ERROR_CODE_CONTENT_SERVER_RECOVERY_FAILED);
        optionalProperties.put("-jdbcurl", jdbcURL);
        List softwareComponents = this.omrDeploymentConf.getSoftwareComponents(WEBINFRA_COMPONENT_CLASSIDENTIFIER);
        if (softwareComponents != null && softwareComponents.size() > 0) {
            String repositoryPath;
            SoftwareComponentInterface webinfpltfmcomp = (SoftwareComponentInterface)softwareComponents.get(0);
            HashMap publicProperties = new HashMap();
            HashMap privateProperties = new HashMap();
            ConfigurablePropertiesUtil.getObjectProperties((SoftwareComponent)((SoftwareComponent)webinfpltfmcomp.getRepositoryEntity()), publicProperties, privateProperties);
            String dbType = (String)publicProperties.get(SCS_DATABASE_TYPE);
            if (dbType != null) {
                optionalProperties.put("-dbtype", dbType);
            }
            if ((repositoryPath = (String)publicProperties.get(WEBINFREPO)) != null) {
                String repoName = BackupServiceUtils.getName(repositoryPath);
                optionalProperties.put("-defaultrepos", repoName);
                File repositoryFile = new File(repositoryPath);
                File parentFile = repositoryFile.getParentFile();
                String scsRoot = null;
                scsRoot = parentFile != null ? parentFile.getPath() : BackupServiceUtils.getParentPath(repositoryPath);
                optionalProperties.put("-scsroot", scsRoot);
            }
        } else {
            logger.error("Software component for Web Infrastructure Platform 9.4 not found");
            throw new BackupException("Software component for Web Infrastructure Platform 9.4 not found", BackupErrorConstants.ErrorCodes.ERROR_CODE_CONTENT_SERVER_RECOVERY_FAILED.getErrorCode());
        }
        return optionalProperties;
    }

    @Override
    public Map<String, List<String>> getContentDetails(BackupSourceConfig sourceConfig, String operationName, BackupServiceSession session) throws BackupException {
        Map<String, List<String>> contentDetails = null;
        try {
            contentDetails = super.getContentDetails(sourceConfig, operationName, session);
            this.getSCSContentsDetails(contentDetails, this.sourceDetailsLoc);
        }
        catch (BackupException e) {
            throw e;
        }
        catch (Exception e) {
            throw new BackupException("Error encountered while trying to fetch content server backup content details. ", (Throwable)e, BackupErrorConstants.ErrorCodes.ERROR_CODE_GET_CONTENT_DETAILS_FAILED.getErrorCode());
        }
        return contentDetails;
    }

    private List getServerComponents(String classIdentifier) throws BackupException {
        List serverComponents = null;
        int searchFlags = 18561;
        try {
            Filter filter = new Filter();
            FilterComponent fc = new FilterComponent();
            fc.setAggregation(1);
            fc.addComponent(new FilterComponent(CLASSIDENTIFIER, 0, classIdentifier));
            filter.setType(SERVER_COMPONENT);
            filter.setOMRFlags(searchFlags);
            filter.setFilterComponent(fc);
            serverComponents = this.omrDeploymentConf.getServer().search((FilterInterface)filter);
        }
        catch (ServiceException e) {
            logger.error(e.getMessage());
            throw new BackupException((Throwable)e, BackupErrorConstants.ErrorCodes.ERROR_CODE_CONTENT_SERVER_BACKUP_FAILED.getErrorCode());
        }
        catch (RemoteException e) {
            logger.error(e.getMessage());
            throw new BackupException("Could not get server components with class identifier " + classIdentifier, (Throwable)e, BackupErrorConstants.ErrorCodes.ERROR_CODE_CONTENT_SERVER_BACKUP_FAILED.getErrorCode());
        }
        return serverComponents;
    }

    private static boolean deleteDir(File dir) {
        if (dir.isDirectory()) {
            String[] children = dir.list();
            for (int i = 0; i < children.length; ++i) {
                boolean success = ContentServerBackupSupportService.deleteDir(new File(dir, children[i]));
                if (success) continue;
                return false;
            }
        }
        return dir.delete();
    }

    @Override
    public String getContentFilePath() {
        String pathToContentDetails = "archive/ArchiveBackup/ContentDetails.log";
        return pathToContentDetails;
    }
}

