/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.backup.spi;

import com.sas.svcs.authentication.helper.FoundationServicesUserSessionFactory;
import com.sas.svcs.backup.analyze.BackupRequestContext;
import com.sas.svcs.backup.analyze.model.RuntimeSASEnvironment;
import com.sas.svcs.backup.client.BackupConfiguration;
import com.sas.svcs.backup.client.BackupDetails;
import com.sas.svcs.backup.client.BackupOptions;
import com.sas.svcs.backup.client.BackupServiceResult;
import com.sas.svcs.backup.client.BackupServiceSession;
import com.sas.svcs.backup.client.BackupSourceConfig;
import com.sas.svcs.backup.client.BackupSourceDetails;
import com.sas.svcs.backup.client.BackupSourceInstanceDetails;
import com.sas.svcs.backup.client.BackupSourceNode;
import com.sas.svcs.backup.client.OperationDetails;
import com.sas.svcs.backup.client.RecoveryDetails;
import com.sas.svcs.backup.client.RecoveryOptions;
import com.sas.svcs.backup.client.UserConfigurationServiceInterface;
import com.sas.svcs.backup.common.definitions.BackupErrorConstants;
import com.sas.svcs.backup.common.definitions.BackupException;
import com.sas.svcs.backup.dao.BackupNodeHelper;
import com.sas.svcs.backup.dao.BackupServiceUtils;
import com.sas.svcs.backup.dao.ConfigBeanConverter;
import com.sas.svcs.backup.dao.DeploymentAgentClient;
import com.sas.svcs.backup.dao.OMRDeploymentBackupConfiguration;
import com.sas.svcs.backup.dao.XMLOperationDAO;
import com.sas.svcs.backup.spi.BackupConfigurationService;
import com.sas.svcs.backup.spi.BackupServiceImpl;
import com.sas.svcs.backup.spi.RB;
import com.sas.svcs.backup.spi.SessionManager;
import com.sas.svcs.deployment.DeploymentDiscoveryService;
import com.sas.svcs.deployment.dao.DeploymentDiscoveryDAO;
import com.sas.svcs.deployment.data.ConfigurableServer;
import com.sas.svcs.deployment.data.SASTier;
import com.sas.text.Message;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Component;

@Component
public class BackupServiceHelper {
    @Autowired
    private ApplicationContext applicationContext;
    private static final long BACKUP_ACTIVE_TIMEOUT = 86400000L;
    private static final long POLL_DELAY = 500L;
    private final Logger logger = LogManager.getLogger(BackupServiceImpl.class);
    private XMLOperationDAO xmlOperationDAO;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private OMRDeploymentBackupConfiguration omrDeploymentConf;
    @Autowired
    private BackupConfigurationService configurationService;
    @Autowired
    private FoundationServicesUserSessionFactory userSessionFactory;
    @Autowired
    private DeploymentDiscoveryService deploymentDiscovery;
    @Autowired
    private BackupNodeHelper nodeHelper;
    @Autowired
    ConfigBeanConverter configBeanConverter;
    @Autowired
    @Qualifier(value="UserConfigurationService")
    private UserConfigurationServiceInterface userConfService;

    @Autowired
    public void setDao(@Qualifier(value="XMLOperationDAO") XMLOperationDAO xmlDAO) {
        this.xmlOperationDAO = xmlDAO;
    }

    BackupServiceSession<BackupDetails> processBackupException(BackupException e, BackupServiceSession<BackupDetails> session, OperationDetails backupDetails, BackupConfiguration config) {
        if (session == null) {
            session = this.sessionManager.getMockSession("Backup");
        }
        this.addOperationtypeAndLog(e, (BackupServiceSession<?>)session, "backup");
        if (backupDetails.getStatus() != OperationDetails.OperationStatus.NOT_STARTED) {
            backupDetails.setStatus(OperationDetails.OperationStatus.FAIL);
            this.xmlOperationDAO.addOperationToHistory(backupDetails);
        } else {
            backupDetails.setErrorMessage(e.getMessage());
        }
        return session;
    }

    public void addOperationtypeAndLog(BackupException e, BackupServiceSession<?> session, String operationType) {
        this.logger.error(e.getMessage(), (Throwable)e);
        this.addOperationType(e, operationType);
        this.addToSession(session, e);
    }

    public void addToSession(BackupServiceSession session, BackupException e) {
        if (session != null) {
            session.getResult().addException(e);
        }
    }

    public void addOperationType(BackupException e, String operationType) {
        if (e.getErrorInfo("operationType") == null) {
            e.setErrorInfo("operationType", operationType);
        }
    }

    void ensureAllTiersAreReachable(RuntimeSASEnvironment runtimeSASEnvironment) {
        List unreachableTiers = runtimeSASEnvironment.getUnreachableTiers();
        this.logger.debug("In (Backup) ensureAllTiersAreReachable() list of unreachable hosts=" + unreachableTiers);
        if (!BackupServiceUtils.isEmpty(unreachableTiers)) {
            ArrayList<String> tierHosts = new ArrayList<String>();
            for (SASTier unreachableTier : unreachableTiers) {
                tierHosts.add(unreachableTier.getHostName());
            }
            String message = Message.format((String)RB.getStringResource("BackupServiceImpl.unreachable.hosts.fmt"), tierHosts);
            this.logger.error(message);
            throw new BackupException(message, BackupErrorConstants.ErrorCodes.ERROR_CODE_DEPLOYMENT_AGENT_COMMUNICATION_FAILURE.getErrorCode());
        }
    }

    void ensureRequiredTiersAreReachable(Set<BackupSourceNode> sourceNodes) {
        this.logger.debug("In ensureRequiredTiersAreReachable() ");
        List<String> unreachableHosts = null;
        ArrayList<String> allHosts = new ArrayList<String>();
        if (!BackupServiceUtils.isEmpty(sourceNodes)) {
            for (BackupSourceNode sourceNode : sourceNodes) {
                allHosts.add(sourceNode.getHostName());
            }
            unreachableHosts = DeploymentAgentClient.getUnreachableHosts(allHosts);
            List metaServers = this.deploymentDiscovery.getConfigurableServers(DeploymentDiscoveryDAO.ComponentType.METADATA_SERVER);
            ArrayList<String> metadataTierList = new ArrayList<String>();
            for (ConfigurableServer metadataServer : metaServers) {
                metadataTierList.add(metadataServer.getSasTier().getHostName());
            }
            this.logger.debug("metadataTierList: during recovery or copying configuration:" + metadataTierList);
            if (!BackupServiceUtils.isEmpty(metadataTierList) && !BackupServiceUtils.isEmpty(unreachableHosts)) {
                HashSet<BackupSourceNode> sourceNodeUpdatedSet = new HashSet<BackupSourceNode>();
                for (BackupSourceNode sourceNode : sourceNodes) {
                    if (!metadataTierList.contains(sourceNode.getHostName()) || !unreachableHosts.contains(sourceNode.getHostName())) continue;
                    this.logger.debug("If metadatahost is not reachable remove it from unreachable host");
                    unreachableHosts.remove(sourceNode.getHostName());
                    this.logger.debug("If metadatahost is not reachable then remove it from sourceNode");
                    sourceNodeUpdatedSet.add(sourceNode);
                }
                sourceNodes.removeAll(sourceNodeUpdatedSet);
            }
            this.logger.debug("In ensureRequiredTiersAreReachable() list of unreachable hosts=" + unreachableHosts);
            if (!BackupServiceUtils.isEmpty(unreachableHosts)) {
                String message = Message.format((String)RB.getStringResource("BackupServiceImpl.unreachable.hosts.fmt"), unreachableHosts);
                this.logger.error(message);
                throw new BackupException(message, BackupErrorConstants.ErrorCodes.ERROR_CODE_DEPLOYMENT_AGENT_COMMUNICATION_FAILURE.getErrorCode());
            }
        }
    }

    public void ensurePrimaryTierIsReachable(RuntimeSASEnvironment runtimeSASEnvironment) {
        if (!runtimeSASEnvironment.isPrimaryMetdataTierPresent()) {
            List unreachableTiers = runtimeSASEnvironment.getUnreachableTiers();
            ArrayList<String> tierHosts = new ArrayList<String>();
            for (SASTier unreachableTier : unreachableTiers) {
                tierHosts.add(unreachableTier.getHostName());
            }
            String message = "";
            message = runtimeSASEnvironment.getPrimaryMetdataTier() != null ? Message.format((String)RB.getStringResource("BackupServiceImpl.unreachable.primary.host.fmt"), (Object)runtimeSASEnvironment.getPrimaryMetdataTier().getHostName()) : RB.getStringResource("BackupServiceImpl.primary.host.not.set.fmt");
            this.logger.error(message);
            throw new BackupException(message, BackupErrorConstants.ErrorCodes.ERROR_CODE_DEPLOYMENT_AGENT_COMMUNICATION_FAILURE.getErrorCode());
        }
    }

    <T> void setSessionResult(BackupServiceSession<T> session, T result) {
        if (session != null) {
            session.getResult().setActualResult(result);
        }
    }

    public RuntimeSASEnvironment getRuntimeSASEnvironment() {
        BackupRequestContext backupRequestContext = (BackupRequestContext)this.applicationContext.getBean("backupRequestContext");
        return backupRequestContext.initialize();
    }

    void filterBackupSources(BackupOptions backupOptions, BackupConfiguration config) {
        List excludeFilter = backupOptions.getExcludeFilter();
        List sourceConfigs = config.getSources();
        if (!BackupServiceUtils.isEmpty(excludeFilter) && !BackupServiceUtils.isEmpty(sourceConfigs)) {
            for (BackupSourceConfig.BackupSource excludedType : excludeFilter) {
                Iterator itr = sourceConfigs.iterator();
                while (itr.hasNext()) {
                    BackupSourceConfig sourceConfig = (BackupSourceConfig)itr.next();
                    BackupSourceConfig.BackupSource sourceType = sourceConfig.getSourceType();
                    if (!excludedType.toString().equalsIgnoreCase(sourceType.toString())) continue;
                    this.logger.info(Message.format((String)RB.getStringResource("BackupServiceImpl.excluding.sourcetype.fmt"), (Object)sourceType));
                    itr.remove();
                }
            }
        }
    }

    public void removeExcludedTiersFromSASTierList(List<SASTier> sasTierList) {
        List excludedTiers = this.userConfService.getExcludedSASTiersActual();
        this.logger.debug("removeExcludedTiersFromSASTierList() input sasTierList.size() = " + sasTierList.size());
        if (excludedTiers != null && excludedTiers.size() > 0) {
            for (SASTier excludedSasTier : excludedTiers) {
                this.logger.debug("removeExcludedTiersFromSASTierList()  excludedSasTier = " + excludedSasTier.getHostName());
                Iterator<SASTier> availableSASTiersItr = sasTierList.iterator();
                while (availableSASTiersItr.hasNext()) {
                    SASTier tier = availableSASTiersItr.next();
                    if (!tier.getHostName().equals(excludedSasTier.getHostName())) continue;
                    availableSASTiersItr.remove();
                }
            }
        }
        this.logger.debug("removeExcludedTiersFromSASTierList() after processing sasTierList.size() = " + sasTierList.size());
    }

    public boolean isTierHostExcluded(String sasTierHost) {
        this.logger.trace("isTierExcluded() sasTier.getTierHost().getHostName() = " + sasTierHost);
        List excludedTiers = this.userConfService.getExcludedSASTiersActual();
        if (excludedTiers != null && excludedTiers.size() > 0 && sasTierHost != null) {
            for (SASTier excludedSasTier : excludedTiers) {
                this.logger.trace("isTierExcluded()  excludedSasTier = " + excludedSasTier.getHostName());
                if (!sasTierHost.equals(excludedSasTier.getHostName())) continue;
                return true;
            }
        }
        this.logger.trace("isTierExcluded() sasTier = " + sasTierHost + " is not excluded");
        return false;
    }

    BackupServiceSession<BackupDetails> configureBackupServerAndStartSession(BackupServiceSession<BackupDetails> session, RuntimeSASEnvironment runtimeSASEnvironment) {
        List tiersTobeConfigured = runtimeSASEnvironment.getRequiredTiersTobeConfigured();
        if (tiersTobeConfigured == null || tiersTobeConfigured.isEmpty()) {
            tiersTobeConfigured = runtimeSASEnvironment.getAvailableTiers();
        }
        List<BackupSourceNode> lstBackupSourceNodes = this.configBeanConverter.sasTierToBackupSourceNodeList(tiersTobeConfigured, runtimeSASEnvironment.getPrimaryMetdataTier());
        Set<BackupSourceNode> uniqueSourceNode = this.nodeHelper.getUniqueElements(lstBackupSourceNodes);
        this.logger.trace("configureBackupServerAndStartSession() Unique source node during backup = " + uniqueSourceNode);
        boolean isBackupServerConfigured = true;
        boolean isFreshConfig = false;
        if (!BackupServiceUtils.isEmpty(lstBackupSourceNodes)) {
            for (BackupSourceNode sourceNode : lstBackupSourceNodes) {
                if (!this.omrDeploymentConf.isBackupServerAlreadyConfigured(sourceNode)) {
                    this.logger.info("Configuring backup server on " + sourceNode);
                    if (session == null) {
                        session = this.sessionManager.startSession(uniqueSourceNode, "Backup", false);
                    }
                    if (session == null) {
                        throw new BackupException("Could not start session for backup", BackupErrorConstants.ErrorCodes.ERROR_CODE_SESSION_START_FAILED.getErrorCode());
                    }
                    isBackupServerConfigured = this.configurationService.configureBackupServer(sourceNode, (BackupServiceSession)session);
                    isFreshConfig = true;
                } else {
                    this.logger.debug("Backup Server already configured on " + sourceNode);
                }
                if (isBackupServerConfigured) continue;
                this.logger.error("Failed to configure backup server on host: " + sourceNode);
                BackupException e = new BackupException("Failed to configure backup server on host: " + sourceNode, BackupErrorConstants.ErrorCodes.ERROR_CODE_BACKUP_SERVER_CONFIGURATION_FAILURE.getErrorCode());
                throw e;
            }
        }
        if (!isFreshConfig) {
            this.logger.debug("If fresh configuration is done");
            lstBackupSourceNodes = this.configBeanConverter.sasTierToBackupSourceNodeList(runtimeSASEnvironment.getRequiredTiers(), runtimeSASEnvironment.getPrimaryMetdataTier());
            uniqueSourceNode = this.nodeHelper.getUniqueElements(lstBackupSourceNodes);
            this.logger.debug("Unique source node during backup = " + uniqueSourceNode);
            session = this.sessionManager.startSession(uniqueSourceNode, "Backup");
        }
        if (session == null) {
            this.throwSessionNotStartedException();
        }
        return session;
    }

    public <T> BackupServiceSession<T> ensureSessionStartedOn(BackupSourceNode node, String operation, boolean pullConfigFiles) {
        BackupServiceSession session = this.sessionManager.startSessionOn(node, operation, pullConfigFiles);
        if (session == null) {
            throw new BackupException("Could not start session for " + operation, BackupErrorConstants.ErrorCodes.ERROR_CODE_SESSION_START_FAILED.getErrorCode());
        }
        return session;
    }

    private void throwSessionNotStartedException() {
        BackupServiceSession<?> session1 = this.sessionManager.getSession();
        if (session1 != null && "Backup".equalsIgnoreCase(session1.getOperationName())) {
            this.logger.info(Message.format((String)RB.getStringResource("BackupServiceImpl.backup.already.running.fmt"), (Object)session1.getSessionId()));
            BackupException e = new BackupException(Message.format((String)RB.getStringResource("BackupServiceImpl.backup.already.running.fmt"), (Object)session1.getSessionId()), BackupErrorConstants.ErrorCodes.ERROR_CODE_BACKUP_ALREADY_RUNNING.getErrorCode());
            e.setLogInNewSession(true);
            throw e;
        }
        throw new BackupException("Could not start session for backup", BackupErrorConstants.ErrorCodes.ERROR_CODE_SESSION_START_FAILED.getErrorCode());
    }

    void initBackupDetails(BackupServiceSession session, BackupDetails backupDetails, BackupOptions backupOptions) throws BackupException {
        backupDetails.setName(session.getSessionId());
        if (backupOptions != null) {
            backupDetails.setComment(backupOptions.getComment());
            if (!backupOptions.getBackupSlugName().equals("")) {
                backupDetails.setSlug(backupOptions.getBackupSlugName());
            }
        }
        String userName = null;
        if (this.userSessionFactory != null) {
            try {
                userName = this.userSessionFactory.getLocalUser().getName();
            }
            catch (RemoteException e) {
                this.logger.warn("Unable to find user name.");
            }
        }
        backupDetails.setRunBy(userName != null ? userName : "UNKNOWN");
        backupDetails.setRecovered(false);
        backupDetails.setStatus(OperationDetails.OperationStatus.INPROGRESS);
    }

    void syncXMLFiles(BackupDetails backupDetails, BackupServiceSession<BackupDetails> session) {
        this.xmlOperationDAO.addOperationToHistory((OperationDetails)backupDetails);
        this.xmlOperationDAO.setConfig(backupDetails.getConfig());
        this.sessionManager.endSession(session, "Backup", true);
    }

    BackupServiceResult<BackupDetails> getExceptionResultInNewSession(BackupException e, BackupDetails backupDetails) {
        this.logger.info("Logging error in new session.");
        BackupServiceSession newsession = this.sessionManager.getMockSession("NewBackup");
        this.addOperationtypeAndLog(e, newsession, "backup");
        newsession.getResult().setActualResult((Object)backupDetails);
        return newsession.getResult();
    }

    void ensureOverlappingBackupsNotProcessed(BackupServiceSession<BackupDetails> session) {
        BackupDetails previousBackup = this.getMostRecentBackup(session);
        if (previousBackup != null) {
            previousBackup = this.waitForNewBackup(previousBackup, session);
        }
    }

    BackupDetails waitForNewBackup(BackupDetails previousBackup, BackupServiceSession<?> session) throws BackupException {
        String previousBackupName = "None";
        if (previousBackup != null) {
            previousBackupName = previousBackup.getName();
        }
        boolean alreadyRunning = false;
        BackupDetails backup = this.getMostRecentBackup(session);
        boolean bl = alreadyRunning = backup != null && backup.getStatus() == OperationDetails.OperationStatus.INPROGRESS;
        if (alreadyRunning) {
            this.logger.info(Message.format((String)RB.getStringResource("BackupServiceImpl.backup.already.running.fmt"), (Object)previousBackupName));
            BackupException e = new BackupException(Message.format((String)RB.getStringResource("BackupServiceImpl.backup.already.running.fmt"), (Object)previousBackupName), BackupErrorConstants.ErrorCodes.ERROR_CODE_BACKUP_ALREADY_RUNNING.getErrorCode());
            e.setLogInNewSession(true);
            throw e;
        }
        return backup;
    }

    void postBackup(BackupOptions backupOptions, BackupDetails backupDetails, BackupServiceSession<BackupDetails> session, boolean anotherSessionRunning) {
        try {
            if (backupOptions.isScheduled() && backupDetails != null) {
                backupDetails.setScheduled(true);
            }
            if (session != null && !anotherSessionRunning) {
                boolean onlyServersync = backupOptions.isAsynchronous();
                this.sessionManager.endSession(session, "Backup", onlyServersync);
                if (!BackupServiceUtils.deleteTempDir()) {
                    this.logger.trace(RB.getStringResource("BackupServiceImpl.unable.to.delete.temp.directory.txt"));
                }
            }
        }
        catch (BackupException e) {
            if (session != null) {
                session.getResult().addException(e);
            }
            this.logger.debug("postBackup() BackupException encountered", (Throwable)e);
        }
        catch (Throwable t) {
            if (session != null) {
                session.getResult().addException(new BackupException(t, BackupErrorConstants.ErrorCodes.ERROR_CODE_UNKNOWN.getErrorCode()));
            }
            this.logger.debug("postBackup() Throwable encountered", t);
        }
    }

    void deleteTempDirectory() {
        try {
            BackupServiceUtils.deleteTempDir();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    void logBackupStatusMessage(BackupDetails backupDetails) {
        if (backupDetails != null && backupDetails.getStatus() == OperationDetails.OperationStatus.INPROGRESS) {
            this.logger.info(RB.getStringResource("BackupServiceImpl.backup.started.txt"));
        } else if (backupDetails != null && backupDetails.getStatus() != null && backupDetails.getStatus().canBeRecovered()) {
            this.logger.info(RB.getStringResource("BackupServiceImpl.backup.complete.txt"));
        } else {
            this.logger.error(RB.getStringResource("BackupServiceImpl.backup.failed.txt"));
        }
    }

    BackupServiceResult<BackupDetails> getScheduledBackupNotAllowedResult(BackupDetails backupDetails) {
        this.logger.error(RB.getStringResource("BackupServiceImpl.schedules.backup.not.allowed.txt"));
        backupDetails.setStatus(OperationDetails.OperationStatus.FAIL);
        BackupServiceResult backupserviceResult = new BackupServiceResult();
        backupserviceResult.setActualResult((Object)backupDetails);
        return backupserviceResult;
    }

    BackupDetails waitForBackupCompletion(Future<BackupDetails> future) throws BackupException {
        long totalWait = 0L;
        BackupDetails backupDetails = null;
        try {
            while (!future.isDone()) {
                this.logger.trace(RB.getStringResource("BackupServiceImpl.backup.in.propgress.txt"));
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if ((totalWait += 500L) <= 86400000L) continue;
                throw new BackupException(RB.getStringResource("BackupService.BackupFinishTimeout.log"), BackupErrorConstants.ErrorCodes.ERROR_CODE_OPERATION_TIMEOUT.getErrorCode());
            }
            backupDetails = future.get();
        }
        catch (InterruptedException e) {
            if (e.getCause() instanceof BackupException) {
                throw (BackupException)e.getCause();
            }
            throw new BackupException("Unable to get details of backup running thread.", (Throwable)e, BackupErrorConstants.ErrorCodes.ERROR_CODE_UNKNOWN.getErrorCode());
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof BackupException) {
                throw (BackupException)e.getCause();
            }
            throw new BackupException("Unable to get details of backup running thread.", (Throwable)e, BackupErrorConstants.ErrorCodes.ERROR_CODE_UNKNOWN.getErrorCode());
        }
        catch (Throwable t) {
            if (t instanceof BackupException) {
                throw (BackupException)t;
            }
            throw new BackupException("Unable to get details of backup running thread.", t, BackupErrorConstants.ErrorCodes.ERROR_CODE_UNKNOWN.getErrorCode());
        }
        return backupDetails;
    }

    RecoveryDetails waitForRecoveryCompletion(Future<RecoveryDetails> future) throws BackupException {
        long totalWait = 0L;
        RecoveryDetails recovery = null;
        try {
            while (!future.isDone()) {
                this.logger.trace(RB.getStringResource("BackupServiceImpl.recovery.in.propgress.txt"));
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if ((totalWait += 500L) <= 86400000L) continue;
                throw new BackupException(RB.getStringResource("BackupService.BackupFinishTimeout.log"), BackupErrorConstants.ErrorCodes.ERROR_CODE_OPERATION_TIMEOUT.getErrorCode());
            }
            recovery = future.get();
        }
        catch (InterruptedException e) {
            if (e.getCause() instanceof BackupException) {
                throw (BackupException)e.getCause();
            }
            throw new BackupException("Unable to get details of recovery running thread.", (Throwable)e, BackupErrorConstants.ErrorCodes.ERROR_CODE_UNKNOWN.getErrorCode());
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof BackupException) {
                throw (BackupException)e.getCause();
            }
            throw new BackupException("Unable to get details of recovery running thread.", (Throwable)e, BackupErrorConstants.ErrorCodes.ERROR_CODE_UNKNOWN.getErrorCode());
        }
        catch (Throwable t) {
            if (t instanceof BackupException) {
                throw (BackupException)t;
            }
            throw new BackupException("Unable to get details of recovery running thread.", t, BackupErrorConstants.ErrorCodes.ERROR_CODE_UNKNOWN.getErrorCode());
        }
        return recovery;
    }

    List<OperationDetails> getAllHistory(BackupServiceSession<?> session) throws BackupException {
        ArrayList<OperationDetails> history = new ArrayList();
        try {
            this.logger.info(RB.getStringResource("BackupServiceImpl.reading.history.txt"));
            history = this.xmlOperationDAO.getHistory();
        }
        catch (BackupException e) {
            this.addOperationType(e, "gethistory");
            throw e;
        }
        return history;
    }

    void filterRecoverySources(RecoveryOptions recoverOptions, BackupDetails backup) {
        List sourceDetails = backup.getSourceDetails();
        List excludeFilter = recoverOptions.getExcludeFilter();
        if (!BackupServiceUtils.isEmpty(excludeFilter)) {
            for (BackupSourceConfig.BackupSource excludedType : excludeFilter) {
                Iterator itr = sourceDetails.iterator();
                while (itr.hasNext()) {
                    BackupSourceDetails spurceDetail = (BackupSourceDetails)itr.next();
                    BackupSourceConfig sourceConfig = spurceDetail.getSourceConfig();
                    BackupSourceConfig.BackupSource sourceType = sourceConfig.getSourceType();
                    if (!excludedType.toString().equalsIgnoreCase(sourceType.toString())) continue;
                    this.logger.info(Message.format((String)RB.getStringResource("BackupServiceImpl.excluded.recovery.fmt"), (Object)sourceType));
                    itr.remove();
                }
            }
        }
        if (!BackupServiceUtils.isEmpty(sourceDetails)) {
            for (BackupSourceDetails spurceDetail : sourceDetails) {
                Map backupInstanceDetails = spurceDetail.getSourceInstances();
                if (backupInstanceDetails == null) continue;
                HashMap filteredBackupInstanceDetails = new HashMap();
                filteredBackupInstanceDetails.putAll(backupInstanceDetails);
                Set keys = backupInstanceDetails.keySet();
                for (String instanceKey : keys) {
                    BackupSourceInstanceDetails instanceDetail = (BackupSourceInstanceDetails)backupInstanceDetails.get(instanceKey);
                    String instanceToInclude = recoverOptions.getInstanceName();
                    if (instanceToInclude == null) continue;
                    String[] instances = instanceToInclude.split(",,");
                    boolean found = false;
                    for (String instance : instances) {
                        if (!instanceDetail.getInstanceName().equals(instance)) continue;
                        found = true;
                        break;
                    }
                    if (found) continue;
                    filteredBackupInstanceDetails.remove(instanceKey);
                }
                if (filteredBackupInstanceDetails.isEmpty()) {
                    spurceDetail.setSourceInstances(backupInstanceDetails);
                    continue;
                }
                spurceDetail.setSourceInstances(filteredBackupInstanceDetails);
            }
        }
    }

    void initRecoveryDetails(RecoveryDetails recoveryDetails) throws BackupException {
        String userName = null;
        if (this.userSessionFactory != null) {
            try {
                userName = this.userSessionFactory.getLocalUser().getName();
                recoveryDetails.setRunBy(userName);
            }
            catch (Throwable e) {
                this.logger.warn(e.getMessage(), e);
            }
        }
        recoveryDetails.setRunBy(userName != null ? userName : "UNKNOWN");
        recoveryDetails.setStatus(OperationDetails.OperationStatus.INPROGRESS);
        this.xmlOperationDAO.addOperationToHistory((OperationDetails)recoveryDetails);
    }

    RecoveryDetails waitForNewRecovery(RecoveryDetails previousRecovery, BackupServiceSession<?> session) throws BackupException {
        String previousRecoveryName = "None";
        if (previousRecovery != null) {
            previousRecoveryName = previousRecovery.getName();
        }
        boolean alreadyRunning = false;
        RecoveryDetails recovery = this.getMostRecentRecovery(session);
        boolean bl = alreadyRunning = recovery != null && recovery.getStatus() == OperationDetails.OperationStatus.INPROGRESS;
        if (alreadyRunning) {
            this.logger.info(Message.format((String)RB.getStringResource("BackupServiceImpl.recovery.already.running.fmt"), (Object)previousRecoveryName));
            BackupException e = new BackupException(Message.format((String)RB.getStringResource("BackupServiceImpl.recovery.already.running.fmt"), (Object)previousRecoveryName), BackupErrorConstants.ErrorCodes.ERROR_CODE_RECOVERY_ALREADY_RUNNING.getErrorCode());
            e.setLogInNewSession(true);
            throw e;
        }
        return recovery;
    }

    BackupDetails getMostRecentBackup(BackupServiceSession<?> session) throws BackupException {
        BackupDetails details = null;
        try {
            details = this.xmlOperationDAO.getMostRecentBackup();
        }
        catch (BackupException e) {
            this.addOperationType(e, "gethistory");
            throw e;
        }
        return details;
    }

    RecoveryDetails getMostRecentRecovery(BackupServiceSession<?> session) throws BackupException {
        RecoveryDetails details = null;
        try {
            details = this.xmlOperationDAO.getMostRecentRecovery();
        }
        catch (BackupException e) {
            this.addOperationType(e, "gethistory");
            throw e;
        }
        return details;
    }

    OperationDetails getDetails(String name, String type, String identifier, BackupServiceSession<?> session) throws BackupException {
        OperationDetails details = this.xmlOperationDAO.getDetails(name, type, identifier);
        return details;
    }

    void postRecovery(BackupServiceSession<RecoveryDetails> session, boolean anotherSessionRunning) {
        try {
            if (session != null && !anotherSessionRunning) {
                this.logger.info("Ending the session ....");
                this.sessionManager.endSession(session, "Recover", false);
                this.deleteTempDirectory();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    BackupServiceSession<RecoveryDetails> processRecoveryException(BackupException e, BackupServiceSession<RecoveryDetails> session, RecoveryDetails recovery) {
        if (session == null) {
            session = this.sessionManager.getMockSession("Recover");
        }
        if (e.getErrorInfo("operationType") == null) {
            e.setErrorInfo("operationType", "recover");
        }
        session.getResult().addException(e);
        if (recovery != null && recovery.getStatus() != OperationDetails.OperationStatus.NOT_STARTED) {
            recovery.setStatus(OperationDetails.OperationStatus.FAIL);
            this.xmlOperationDAO.addOperationToHistory((OperationDetails)recovery);
        }
        return session;
    }

    BackupServiceResult<RecoveryDetails> getRecoveryExceptionInNewSession(BackupException e, RecoveryDetails recovery) {
        this.logger.info("Logging error in new session.");
        BackupServiceSession newsession = this.sessionManager.getMockSession("NewRecover");
        if (e.getErrorInfo("operationType") == null) {
            e.setErrorInfo("operationType", "recover");
        }
        newsession.getResult().addException(e);
        newsession.getResult().setActualResult((Object)recovery);
        return newsession.getResult();
    }

    BackupServiceResult<RecoveryDetails> returnNoSourceSelectedResult(RecoveryDetails recovery, BackupServiceSession<RecoveryDetails> session) {
        recovery.setStatus(OperationDetails.OperationStatus.FAIL);
        recovery.setComment("Need to select atleast one source.");
        this.xmlOperationDAO.addOperationToHistory((OperationDetails)recovery);
        session.getResult().setActualResult((Object)recovery);
        return session.getResult();
    }

    void logRecoveryStatusMessage(RecoveryDetails recovery) {
        if (recovery.getStatus() == OperationDetails.OperationStatus.INPROGRESS) {
            this.logger.info(RB.getStringResource("BackupServiceImpl.recovery.started.txt"));
        } else if (recovery.getStatus() == OperationDetails.OperationStatus.SUCCESS) {
            this.logger.info(RB.getStringResource("BackupServiceImpl.recovery.complete.txt"));
        } else {
            this.logger.error(RB.getStringResource("BackupServiceImpl.recovery.failed.txt"));
        }
    }

    void fillRecoveryDetails(RecoveryOptions recoveryOptions, RecoveryDetails recovery) {
        if (recoveryOptions != null) {
            recovery.setComment(recoveryOptions.getComment());
            recovery.setPauseComments(recoveryOptions.getPauseComment());
            if (recoveryOptions.getRecvoerySlugName() != null && !recoveryOptions.getRecvoerySlugName().equals("")) {
                recovery.setSlug(recoveryOptions.getRecvoerySlugName());
            }
        }
    }

    void validateBackupWasSuccessful(BackupDetails backup) {
        if (backup.getStatus() == null || !backup.getStatus().canBeRecovered()) {
            throw new BackupException("Recovery of failed backup is not allowed to maintain system integrity.", BackupErrorConstants.ErrorCodes.ERROR_CODE_GENERAL_RECOVERY_FAILURE.getErrorCode());
        }
    }

    void validateSession(BackupServiceSession<RecoveryDetails> session) {
        if (session == null) {
            BackupServiceSession<?> session1 = this.sessionManager.getSession();
            if (session1 != null && "Recover".equalsIgnoreCase(session1.getOperationName())) {
                this.logger.info(Message.format((String)RB.getStringResource("BackupServiceImpl.recovery.already.running.fmt"), (Object)session1.getSessionId()));
                BackupException e = new BackupException(Message.format((String)RB.getStringResource("BackupServiceImpl.recovery.already.running.fmt"), (Object)session1.getSessionId()), BackupErrorConstants.ErrorCodes.ERROR_CODE_RECOVERY_ALREADY_RUNNING.getErrorCode());
                e.setLogInNewSession(true);
                throw e;
            }
            throw new BackupException("Could not start session for recovery.", BackupErrorConstants.ErrorCodes.ERROR_CODE_SESSION_START_FAILED.getErrorCode());
        }
    }

    void validateBackup(BackupDetails backup) {
        if (backup == null) {
            this.logger.error(RB.getStringResource("BackupServiceImpl.no.backup.specified.txt"));
            throw new BackupException(RB.getStringResource("BackupServiceImpl.no.backup.specified.txt"), BackupErrorConstants.ErrorCodes.ERROR_CODE_GENERAL_RECOVERY_FAILURE.getErrorCode());
        }
        if (backup.getName() == null) {
            this.logger.error(RB.getStringResource("BackupServiceImpl.invalid.backupid.for.recovery.txt"));
            throw new BackupException(RB.getStringResource("BackupServiceImpl.invalid.backupid.for.recovery.txt"), BackupErrorConstants.ErrorCodes.ERROR_CODE_GENERAL_RECOVERY_FAILURE.getErrorCode());
        }
    }

    void reloadConfiguration(RecoveryOptions recoverOptions, RecoveryDetails recovery) throws BackupException {
        BackupConfiguration config = recovery.getConfig();
        List sourceConfigs = config.getSources();
        List excludeFilter = recoverOptions.getExcludeFilter();
        if (!BackupServiceUtils.isEmpty(excludeFilter) && !BackupServiceUtils.isEmpty(sourceConfigs)) {
            for (BackupSourceConfig.BackupSource excludedType : excludeFilter) {
                Iterator itr = sourceConfigs.iterator();
                while (itr.hasNext()) {
                    BackupSourceConfig sourceConfig = (BackupSourceConfig)itr.next();
                    BackupSourceConfig.BackupSource sourceType = sourceConfig.getSourceType();
                    if (!excludedType.toString().equalsIgnoreCase(sourceType.toString())) continue;
                    this.logger.info(Message.format((String)RB.getStringResource("BackupServiceImpl.excluded.recovery.fmt"), (Object)sourceType));
                    itr.remove();
                }
            }
        }
        this.configurationService.reloadConfiguration(config);
    }
}

