/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.backup.spi;

import com.sas.services.information.ServerInterface;
import com.sas.services.session.SessionContextInterface;
import com.sas.services.session.SessionServiceInterface;
import com.sas.services.user.UserContextInterface;
import com.sas.services.user.UserServiceInterface;
import com.sas.svcs.backup.analyze.model.RuntimeSASEnvironment;
import com.sas.svcs.backup.client.BackupService;
import com.sas.svcs.backup.client.BackupServiceResult;
import com.sas.svcs.backup.client.BackupServiceSession;
import com.sas.svcs.backup.client.BackupSourceNode;
import com.sas.svcs.backup.common.definitions.BackupException;
import com.sas.svcs.backup.dao.BackupServiceUtils;
import com.sas.svcs.backup.dao.ConfigBeanConverter;
import com.sas.svcs.backup.dao.OMRDeploymentBackupConfiguration;
import com.sas.svcs.backup.dao.XMLOperationDAO;
import com.sas.svcs.backup.spi.BackupSchedulingServiceImpl;
import com.sas.svcs.backup.spi.BackupServiceHelper;
import com.sas.svcs.backup.spi.RB;
import com.sas.svcs.backup.spi.SessionManager;
import java.util.Arrays;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.userdetails.User;

public class BackupServiceContextListener
implements ApplicationListener<ContextRefreshedEvent> {
    private static final Logger logger = LogManager.getLogger(BackupServiceContextListener.class);
    UserServiceInterface userService;
    SessionServiceInterface sessionService;
    String username;
    String password;
    static boolean isHistoryCleaned;
    @Autowired
    private ApplicationContext applicationContext;
    @Autowired
    @Qualifier(value="BackupService")
    BackupService backupService;
    @Autowired
    @Qualifier(value="BackupSchedulingService")
    BackupSchedulingServiceImpl backupSchedulingService;
    @Autowired
    @Qualifier(value="XMLOperationDAO")
    private XMLOperationDAO xmlOperationDAO;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private OMRDeploymentBackupConfiguration omrDeploymentConf;
    @Autowired
    ConfigBeanConverter configBeanConverter;
    @Autowired
    BackupServiceHelper helper;
    ServerInterface server;

    public BackupServiceContextListener() {
        logger.trace(RB.getStringResource("BackupServiceContextListener.app.context.listener.created.txt"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onApplicationEvent(ContextRefreshedEvent event) {
        logger.debug("Received ContextRefreshedEvent.");
        if (!BackupSchedulingServiceImpl.isSchedulerRunning()) {
            try {
                SecurityContextHolder.getContext().setAuthentication((Authentication)new UsernamePasswordAuthenticationToken((Object)new User(this.username, this.password, true, true, true, true, Arrays.asList(new GrantedAuthority[0])), (Object)"aBigSecret"));
                logger.info("the user sasadm has been added to security context");
                UserContextInterface userContext = this.getUserService().getUser(this.username);
                SessionContextInterface sessionContext = this.getSessionService().newSessionContext(userContext);
                logger.info("user and session context interfaces obtained");
                this.server = sessionContext.getUserContext().getAuthServer();
                logger.info("The auth server = " + this.server);
                logger.debug("Scheduler is not running. Trying to start it with schedule(s) from the metadata server.");
                BackupServiceResult result = this.backupService.getBackupSchedule();
                List schedules = (List)result.getActualResult();
                if (schedules != null) {
                    this.backupService.setBackupSchedule(schedules);
                    logger.info("Scheduler started successfully");
                    BackupSchedulingServiceImpl.setSchedulerRunning(true);
                }
                logger.warn(RB.getStringResource("BackupServiceContextListener.warning.while.configure.scheduler.txt"));
            }
            catch (Throwable t) {
                logger.warn(RB.getStringResource("BackupServiceContextListener.warning.while.configure.scheduler.txt"));
                return;
            }
        } else {
            logger.trace("Skipped scheduler configuration as scheduler is already running.");
        }
        BackupServiceSession session = null;
        if (!isHistoryCleaned) {
            try {
                String lstConfiguredHosts = this.omrDeploymentConf.getConfigurationProperties().get("svrbakupevm.configured.hosts");
                if (lstConfiguredHosts != null && lstConfiguredHosts.length() != 0) {
                    RuntimeSASEnvironment runtimeSASEnvironment = this.helper.getRuntimeSASEnvironment();
                    this.helper.ensurePrimaryTierIsReachable(runtimeSASEnvironment);
                    BackupSourceNode primaryNode = this.configBeanConverter.sasTierToBackupSourceNode(runtimeSASEnvironment.getPrimaryMetdataTier());
                    session = this.helper.ensureSessionStartedOn(primaryNode, "clearProgressNode", true);
                    logger.debug("Clearing the INPROGRESS Nodes");
                    this.xmlOperationDAO.clearInprogressNodes();
                    isHistoryCleaned = true;
                }
            }
            catch (Throwable throwable) {
            }
            finally {
                try {
                    this.sessionManager.endSession(session, "clearProgressNode", false);
                    BackupServiceUtils.deleteTempDir();
                }
                catch (BackupException backupException) {}
            }
        }
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public UserServiceInterface getUserService() {
        return this.userService;
    }

    public void setUserService(UserServiceInterface userService) {
        this.userService = userService;
    }

    public SessionServiceInterface getSessionService() {
        return this.sessionService;
    }

    public void setSessionService(SessionServiceInterface sessionService) {
        this.sessionService = sessionService;
    }
}

