/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.backup.spi;

import com.sas.solstice.platform.core.access.IResults;
import com.sas.svcs.backup.client.BackupServiceSession;
import com.sas.svcs.backup.client.BackupSourceConfig;
import com.sas.svcs.backup.client.BackupSourceNode;
import com.sas.svcs.backup.common.definitions.BackupErrorConstants;
import com.sas.svcs.backup.common.definitions.BackupException;
import com.sas.svcs.backup.dao.BackupServerContext;
import com.sas.svcs.backup.dao.BackupServiceUtils;
import com.sas.svcs.backup.dao.ConstantsMapper;
import com.sas.svcs.backup.dao.DeploymentAgentClient;
import com.sas.svcs.backup.dao.OMRDeploymentBackupConfiguration;
import com.sas.svcs.backup.spi.BackupSupportService;
import com.sas.text.Message;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

public abstract class AbstractBackupSupportService
implements BackupSupportService {
    private static final Logger logger = LogManager.getLogger(AbstractBackupSupportService.class);
    @Autowired
    @Qualifier(value="DeploymentBackupConfiguration")
    private OMRDeploymentBackupConfiguration backupConfiguration;
    protected String sourceDetailsLoc;

    @Override
    public Map<String, List<String>> getContentDetails(BackupSourceConfig sourceConfig, String operationName, BackupServiceSession session) throws BackupException {
        HashMap<String, List<String>> contentDetails = null;
        BackupSourceConfig.BackupSource sourceType = sourceConfig.getSourceType();
        BackupSourceNode sourceNode = sourceConfig.getBackupSourceNode();
        String hostName = sourceNode.getHostName();
        BackupServerContext context = BackupServerContext.getInstance(this.backupConfiguration, sourceNode, sourceType);
        String backupServerPath = context.getBackupServerPath();
        try {
            this.sourceDetailsLoc = this.getContentFilestempLocation(backupServerPath, hostName, operationName, sourceType);
            contentDetails = new HashMap<String, List<String>>();
        }
        catch (IOException ex) {
            logger.error(ex.getMessage());
            throw new BackupException((Throwable)ex, BackupErrorConstants.ErrorCodes.ERROR_CODE_GET_CONTENT_DETAILS_FAILED.getErrorCode());
        }
        return contentDetails;
    }

    public abstract String getContentFilePath();

    private String getContentFilestempLocation(String backupServerPath, String hostName, String sessionId, BackupSourceConfig.BackupSource sourceType) throws IOException {
        File tempDir = BackupServiceUtils.getTempDir();
        String contentDetailsPath = backupServerPath + "/" + "Logs" + "/" + sessionId + "/" + this.getContentFilePath();
        String tempcontentDetailsPath = tempDir.getCanonicalPath() + File.separator + sessionId + File.separator + ConstantsMapper.getReadablecmdParams(sourceType.name()) + File.separator + ConstantsMapper.getReadablecmdParams(sourceType.name()) + Math.random() + ".log";
        String[] paramsGetResult = new String[]{"pullFile", hostName, contentDetailsPath, tempcontentDetailsPath};
        try {
            logger.debug("Trying to copy " + contentDetailsPath);
            IResults copyResult = DeploymentAgentClient.handleArgLine(paramsGetResult, paramsGetResult);
            if (copyResult.getStatus() != 0) {
                logger.error(Message.format((String)"Error copying packaged contents folder from", (Object)contentDetailsPath));
            }
        }
        catch (Throwable t) {
            logger.error(Message.format((String)"Error copying packaged folder {0} from {1}", (Object)contentDetailsPath, (Object)hostName));
        }
        return tempcontentDetailsPath;
    }
}

