/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.backup.dao;

import com.sas.svcs.backup.analyze.BackupTask;
import com.sas.svcs.backup.analyze.model.AnalysisResult;
import com.sas.svcs.backup.analyze.model.RuntimeSASEnvironment;
import com.sas.svcs.backup.client.BackupSourceConfig;
import com.sas.svcs.backup.client.ConfigurableServerProxy;
import com.sas.svcs.backup.client.UserConfigurationServiceInterface;
import com.sas.svcs.backup.client.UserOptionsProxy;
import com.sas.svcs.backup.common.definitions.BackupErrorConstants;
import com.sas.svcs.backup.common.definitions.BackupException;
import com.sas.svcs.backup.dao.BackupServiceUtils;
import com.sas.svcs.backup.dao.OMRBackupSourceSupportService;
import com.sas.svcs.backup.dao.OMRDeploymentBackupConfiguration;
import com.sas.svcs.backup.dao.RB;
import com.sas.svcs.deployment.DeploymentDiscoveryService;
import com.sas.svcs.deployment.data.ConfigurableServer;
import com.sas.svcs.deployment.data.SASTier;
import com.sas.text.Message;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service(value="OMRMETADATASERVER")
public class OMRMetadataSupportService
extends OMRBackupSourceSupportService {
    private static Logger logger = LogManager.getLogger(OMRMetadataSupportService.class);
    @Autowired
    @Qualifier(value="DeploymentBackupConfiguration")
    private OMRDeploymentBackupConfiguration backupConfigComponent;
    @Autowired
    private DeploymentDiscoveryService discoverer;
    @Autowired
    @Qualifier(value="UserConfigurationService")
    UserConfigurationServiceInterface userConfigurationService;

    @Override
    public List<AnalysisResult.AnalysisProblem> analyze(RuntimeSASEnvironment sasEnvironment) throws BackupException {
        ArrayList<AnalysisResult.AnalysisProblem> analysisProblems = new ArrayList<AnalysisResult.AnalysisProblem>();
        try {
            ConfigurableServer metadataServer;
            boolean found = false;
            List metadataServers = this.userConfigurationService.getConfigurableServers(BackupSourceConfig.BackupSource.METADATASERVER);
            if (metadataServers != null && !metadataServers.isEmpty() && (metadataServer = (ConfigurableServer)BackupServiceUtils.extractAsObject(metadataServers)) != null) {
                SASTier configuredOn;
                if (!this.userConfigurationService.isCanonicalExclude(metadataServer, BackupSourceConfig.BackupSource.METADATASERVER) && (configuredOn = sasEnvironment.getPrimaryMetdataTier()) == null) {
                    analysisProblems.add(AnalysisResult.createError((int)BackupErrorConstants.ErrorCodes.ERROR_CODE_METADATA_SERVER_DISCOVERY_FAILED.getErrorCode(), (String)Message.format((String)RB.getStringResource("OMRBackupSourceSupportService.analyze.error.sastier.notfound.fmt"), (Object)metadataServer.getObjectName())));
                }
                found = true;
            }
            if (!found) {
                analysisProblems.add(AnalysisResult.createError((int)BackupErrorConstants.ErrorCodes.ERROR_CODE_METADATA_SERVER_DISCOVERY_FAILED.getErrorCode(), (String)RB.getStringResource("OMRMetadataSupportService.analyze.error.metadata.server.notfound.txt")));
            }
        }
        catch (Exception e) {
            String message = Message.format((String)RB.getStringResource("OMRBackupSourceSupportService.analyze.failed.with.unknown.error.fmt"), (Object)BackupSourceConfig.BackupSource.METADATASERVER);
            logger.error(message, (Throwable)e);
            analysisProblems.add(AnalysisResult.createProblem((int)BackupErrorConstants.ErrorCodes.ERROR_CODE_METADATA_SERVER_DISCOVERY_FAILED.getErrorCode(), (String)message));
        }
        return analysisProblems;
    }

    @Override
    public List<BackupTask> getBackupTasks(RuntimeSASEnvironment runtimeSASEnvironment) throws BackupException {
        BackupTask metadataServerBackupTask = null;
        for (SASTier sasTier : runtimeSASEnvironment.getAvailableTiers()) {
            ConfigurableServer metadataServer;
            List metadataServers = this.userConfigurationService.getConfigurableServers(BackupSourceConfig.BackupSource.METADATASERVER, sasTier);
            if (metadataServers == null || metadataServers.isEmpty() || (metadataServer = (ConfigurableServer)BackupServiceUtils.extractAsObject(metadataServers)) == null) continue;
            if (this.userConfigurationService.isExcluded(metadataServer, BackupSourceConfig.BackupSource.METADATASERVER) || runtimeSASEnvironment.hasErrors(BackupSourceConfig.BackupSource.METADATASERVER, metadataServer)) break;
            logger.info("Starting discovery of metadata server.");
            try {
                SASTier configuredOn = runtimeSASEnvironment.getPrimaryMetdataTier();
                if (configuredOn != null) {
                    BackupTask.BackupTaskBuilder taskBuilder = BackupTask.getBackupNodeTaskBuilder(BackupSourceConfig.BackupSource.METADATASERVER, configuredOn);
                    this.addUserOptions(metadataServer, taskBuilder);
                    metadataServerBackupTask = taskBuilder.addParam("METADATAHOST", configuredOn.getHostName()).build();
                    logger.info("Finished discovery of metadata server.");
                }
            }
            catch (Exception e) {
                BackupException be = new BackupException("Discovery of metadata server failed.", (Throwable)e, BackupErrorConstants.ErrorCodes.ERROR_CODE_METADATA_SERVER_DISCOVERY_FAILED.getErrorCode());
                throw be;
            }
            if (metadataServerBackupTask != null) break;
            throw new BackupException("Discovery of metadata server failed.", BackupErrorConstants.ErrorCodes.ERROR_CODE_METADATA_SERVER_DISCOVERY_FAILED.getErrorCode());
        }
        return BackupServiceUtils.decorateAsList(metadataServerBackupTask);
    }

    private void addUserOptions(ConfigurableServer metadataServer, BackupTask.BackupTaskBuilder taskBuilder) {
        HashMap options;
        UserOptionsProxy optionsProxy;
        ConfigurableServerProxy serverProxy = this.userConfigurationService.getUserConfiguration(metadataServer, BackupSourceConfig.BackupSource.METADATASERVER);
        if (serverProxy != null && (optionsProxy = serverProxy.getUseroptions()) != null && (options = optionsProxy.getOptions()) != null && !options.isEmpty()) {
            for (Map.Entry entry : options.entrySet()) {
                taskBuilder.addParam("USEROPTION:" + (String)entry.getKey(), (String)entry.getValue());
            }
        }
    }

    @Override
    public List<BackupTask> getRestoreTasks(RuntimeSASEnvironment runtimeSASEnvironment) throws BackupException {
        BackupTask metadataServerBackupTask = null;
        logger.info("Starting discovery of metadata server.");
        try {
            SASTier configuredOn = runtimeSASEnvironment.getPrimaryMetdataTier();
            BackupTask.BackupTaskBuilder taskBuilder = BackupTask.getBackupNodeTaskBuilder(BackupSourceConfig.BackupSource.METADATASERVER, configuredOn);
            metadataServerBackupTask = taskBuilder.addParam("METADATAHOST", configuredOn.getHostName()).build();
            logger.info("Finished discovery of metadata server.");
        }
        catch (Exception e) {
            BackupException be = new BackupException("Discovery of metadata server failed.", (Throwable)e, BackupErrorConstants.ErrorCodes.ERROR_CODE_METADATA_SERVER_DISCOVERY_FAILED.getErrorCode());
            throw be;
        }
        if (metadataServerBackupTask == null) {
            throw new BackupException("Discovery of metadata server failed.", BackupErrorConstants.ErrorCodes.ERROR_CODE_METADATA_SERVER_DISCOVERY_FAILED.getErrorCode());
        }
        return BackupServiceUtils.decorateAsList(metadataServerBackupTask);
    }
}

