/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.backup.dao;

import com.sas.svcs.backup.analyze.BackupTask;
import com.sas.svcs.backup.analyze.model.AnalysisResult;
import com.sas.svcs.backup.analyze.model.RuntimeSASEnvironment;
import com.sas.svcs.backup.client.BackupSourceConfig;
import com.sas.svcs.backup.client.ConfigurableServerProxy;
import com.sas.svcs.backup.client.ConfigurationFilter;
import com.sas.svcs.backup.client.UserConfigurationServiceInterface;
import com.sas.svcs.backup.client.UserSourceConfiguration;
import com.sas.svcs.backup.common.definitions.BackupErrorConstants;
import com.sas.svcs.backup.common.definitions.BackupException;
import com.sas.svcs.backup.dao.BackupServerHelperDAO;
import com.sas.svcs.backup.dao.BackupServiceUtils;
import com.sas.svcs.backup.dao.ConfigBeanConverter;
import com.sas.svcs.backup.dao.OMRBackupSourceSupportService;
import com.sas.svcs.backup.dao.OMRDeploymentBackupConfiguration;
import com.sas.svcs.backup.dao.RB;
import com.sas.svcs.deployment.DeploymentDiscoveryService;
import com.sas.svcs.deployment.data.ConfigurableServer;
import com.sas.svcs.deployment.data.SASTier;
import com.sas.text.Message;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Repository;

@Repository(value="OMRCONFIGDIR")
public class OMRLevconfigSupportService
extends OMRBackupSourceSupportService {
    @Autowired
    private OMRDeploymentBackupConfiguration omrDeploymentConf;
    @Autowired
    @Qualifier(value="BackupServerHelperDAO")
    BackupServerHelperDAO backupServer;
    private static Logger logger = LogManager.getLogger(OMRLevconfigSupportService.class);
    @Autowired
    private DeploymentDiscoveryService discoverer;
    @Autowired
    @Qualifier(value="UserConfigurationService")
    UserConfigurationServiceInterface userConfigurationService;
    @Autowired
    ConfigBeanConverter configBeanConverter;
    public static final String PROP_CONFIG_LEV_CONTEXT_DIR = "config.lev.appservercontext.dir";
    public static final String SASMETA = "SASMeta";

    @Override
    public List<AnalysisResult.AnalysisProblem> analyze(RuntimeSASEnvironment sasEnvironment) throws BackupException {
        ArrayList<AnalysisResult.AnalysisProblem> analysisProblems = new ArrayList<AnalysisResult.AnalysisProblem>();
        try {
            List sasAppServers = this.userConfigurationService.getConfigurableServers(BackupSourceConfig.BackupSource.CONFIGDIR);
            if (!BackupServiceUtils.isEmpty(sasAppServers)) {
                for (ConfigurableServer configurableServer : sasAppServers) {
                    if (this.userConfigurationService.isCanonicalExclude(configurableServer, BackupSourceConfig.BackupSource.CONFIGDIR)) continue;
                    this.analyzeSASAppServer(configurableServer, analysisProblems);
                }
            }
        }
        catch (Exception e) {
            String message = Message.format((String)RB.getStringResource("OMRBackupSourceSupportService.analyze.failed.with.unknown.error.fmt"), (Object)BackupSourceConfig.BackupSource.CONFIGDIR);
            logger.error(message, (Throwable)e);
            analysisProblems.add(AnalysisResult.createProblem((int)BackupErrorConstants.ErrorCodes.ERROR_CODE_CONFIGDIR_DISCOVERY_FAILED.getErrorCode(), (String)message));
        }
        return analysisProblems;
    }

    private void analyzeSASAppServer(ConfigurableServer configurableServer, List<AnalysisResult.AnalysisProblem> analysisProblems) throws RemoteException {
        if (configurableServer.getSasTier() == null) {
            // empty if block
        }
    }

    @Override
    public List<BackupTask> getBackupTasks(RuntimeSASEnvironment runtimeSASEnvironment) throws BackupException {
        ArrayList<BackupTask> sasAppServerBackupTasks = new ArrayList<BackupTask>();
        logger.info("Starting discovery of levconfig.");
        try {
            for (SASTier sasTier : runtimeSASEnvironment.getAvailableTiers()) {
                List<ConfigurableServer> sasAppServers = this.getConfigDirForTier(sasTier);
                if (BackupServiceUtils.isEmpty(sasAppServers)) continue;
                BackupTask.BackupTaskBuilder taskBuilder = BackupTask.getBackupNodeTaskBuilder(BackupSourceConfig.BackupSource.CONFIGDIR, sasTier);
                BackupTask backupTask = null;
                ConfigurableServer configurableServer = BackupServiceUtils.extractAsObject(sasAppServers);
                if (!runtimeSASEnvironment.hasErrors(BackupSourceConfig.BackupSource.CONFIGDIR, configurableServer)) {
                    this.includeBackupTaskFor(configurableServer, taskBuilder);
                }
                if (!taskBuilder.hasParams()) continue;
                backupTask = taskBuilder.build();
                sasAppServerBackupTasks.add(backupTask);
            }
            logger.info("Finished discovery of levconfig.");
        }
        catch (BackupException e) {
            throw e;
        }
        catch (Exception e) {
            BackupException be = new BackupException("Discovery of levconfig failed.", (Throwable)e, BackupErrorConstants.ErrorCodes.ERROR_CODE_CONFIGDIR_DISCOVERY_FAILED.getErrorCode());
            throw be;
        }
        return sasAppServerBackupTasks;
    }

    private List<ConfigurableServer> getConfigDirForTier(SASTier sasTier) {
        List mergedTiers;
        ArrayList<ConfigurableServer> sasAppServers = new ArrayList<ConfigurableServer>();
        UserSourceConfiguration userSourceConfig = this.userConfigurationService.getMergedConfiguration(BackupSourceConfig.BackupSource.CONFIGDIR);
        if (userSourceConfig != null && (mergedTiers = userSourceConfig.getConfigurableServers()) != null) {
            for (ConfigurableServerProxy proxy : mergedTiers) {
                if (proxy.getSasTierId() == null || !proxy.getSasTierId().equalsIgnoreCase(sasTier.getTierName())) continue;
                ConfigurableServer server = this.configBeanConverter.proxyToServer(proxy);
                sasAppServers.add(server);
            }
        }
        return sasAppServers;
    }

    private void includeBackupTaskFor(ConfigurableServer configurableServer, BackupTask.BackupTaskBuilder taskBuilder) throws RemoteException {
        String dirName = configurableServer.getConfigurablePath();
        if (!this.userConfigurationService.isExcluded(configurableServer, BackupSourceConfig.BackupSource.CONFIGDIR)) {
            ConfigurationFilter configurationFilter = this.userConfigurationService.getConfigurationFilter(configurableServer, BackupSourceConfig.BackupSource.CONFIGDIR);
            if (configurationFilter != null) {
                String excludesFilter;
                String includesFilter;
                if (!BackupServiceUtils.isEmpty(configurationFilter.getIncludes()) && (includesFilter = BackupServiceUtils.listtoString(configurationFilter.getIncludes(), ":")) != null && !includesFilter.trim().isEmpty()) {
                    taskBuilder.appendParam("includefilter", dirName + "?" + includesFilter, ",");
                }
                if (!BackupServiceUtils.isEmpty(configurationFilter.getExcludes()) && (excludesFilter = BackupServiceUtils.listtoString(configurationFilter.getExcludes(), ":")) != null && !excludesFilter.trim().isEmpty()) {
                    taskBuilder.appendParam("excludefilter", dirName + "?" + excludesFilter, ",");
                }
                taskBuilder.addParam("SERVERCONTEXT:" + dirName, dirName);
                logger.info("Discovered levconfig data on  " + configurableServer);
            }
        } else {
            logger.info(dirName + " excluded from levconfig backup process.");
        }
    }

    @Override
    public List<BackupTask> getRestoreTasks(RuntimeSASEnvironment runtimeSASEnvironment) throws BackupException {
        return null;
    }
}

