/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.backup.dao;

import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.AuthenticationDomain;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.LogicalServer;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdFactory;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.MdStore;
import com.sas.metadata.remote.Property;
import com.sas.metadata.remote.PropertySet;
import com.sas.metadata.remote.ServerComponent;
import com.sas.metadata.remote.ServerContext;
import com.sas.metadata.remote.SoftwareComponent;
import com.sas.metadata.remote.TCPIPConnection;
import com.sas.metadata.util.ConfigurablePropertiesUtil;
import com.sas.services.ServiceException;
import com.sas.services.information.Filter;
import com.sas.services.information.FilterComponent;
import com.sas.services.information.FilterInterface;
import com.sas.services.information.MetadataServerInterface;
import com.sas.services.information.OMIServer;
import com.sas.services.information.ServerInterface;
import com.sas.services.information.metadata.LoginInterface;
import com.sas.services.information.metadata.OMRProperty;
import com.sas.services.information.metadata.OMRServerComponent;
import com.sas.services.information.metadata.PropertyInterface;
import com.sas.services.information.metadata.PropertySetInterface;
import com.sas.services.information.metadata.ServerComponentInterface;
import com.sas.services.information.metadata.SoftwareComponentInterface;
import com.sas.services.user.UserIdentityInterface;
import com.sas.svcs.authentication.helper.FoundationServicesUserSessionFactory;
import com.sas.svcs.backup.client.BackupSchedule;
import com.sas.svcs.backup.client.BackupSourceNode;
import com.sas.svcs.backup.client.DirectoryDetails;
import com.sas.svcs.backup.common.definitions.BackupErrorConstants;
import com.sas.svcs.backup.common.definitions.BackupException;
import com.sas.svcs.backup.dao.BackupServerHelperDAO;
import com.sas.svcs.backup.dao.BackupServiceUtils;
import com.sas.svcs.backup.dao.DeploymentBackupConfiguration;
import com.sas.svcs.deployment.data.SASTier;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Repository;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

@Repository(value="DeploymentBackupConfiguration")
public class OMRDeploymentBackupConfiguration
implements DeploymentBackupConfiguration {
    @Autowired
    ApplicationContext applicationContext;
    @Autowired
    private FoundationServicesUserSessionFactory userSessionFactory;
    @Autowired
    private BackupServerHelperDAO backupServer;
    private static final String BACKSLASHSTYLE_PATTERN = "^([^\\\\]+)\\\\(.*)$";
    private static final String ATSIGNSTYLE_PATTERN = "^(.*)@([^@]+)$";
    private static final Logger logger = LogManager.getLogger(OMRDeploymentBackupConfiguration.class);
    public static final String SOFTWARE_COMPONENT = "SoftwareComponent";
    public static final String LOGICAL_SERVER = "LogicalServer";
    public static final String LOGIN = "Login";
    public static final String SERVER_COMPONENT = "ServerComponent";
    public static final String CLASSIDENTIFIER = "ClassIdentifier";
    public static final String NAME = "Name";
    public static final String SASINFRA_SERVERCOMPONENT_CLASSIDENTIFIER = "SASInfrastructureData";
    public static final String LOGICAL_METADATA_CLASSIDENTIFIER = "0217E202-B560-11DB-AD91-001083FF6836";
    public static final String METADATA_CLASSIDENTIFIER = "0217E202-B560-11DB-AD91-001083FF6836";
    public static final String templateSoftwareComponent = "<Templates><SoftwareComponent><Notes/></SoftwareComponent></Templates>";
    public static final String templateServerComponent = "<Templates><ServerComponent><Notes/><SourceConnections/><UsedByComponents/></ServerComponent><LogicalServer><DependsOnComponents/></LogicalServer><ServerContext/></Templates>";
    public static final String BACKUP_AUTH = "SASDeploymentBackupAuth";
    public static final String BACKUP_USER = "SASDeploymentBackupUser";
    public static final String LEVDIRROOT_CLASSIDENTIFIER = "levdirroot";
    public static final String LEVDIRROOT_OS_HOST = "os.localhost.fqdn.host.name";
    public static final String LEVDIRROOT_CONFIG_LEV_DIR = "config.lev.dir";
    public static final String LEVDIRROOT_CONFIG_PROP_FILE = "config.properties.file";
    public static final String LEVDIRROOT_LEV_APP_DATA = "config.lev.appdata.dir";
    public static final String LEVDIRROOT_SAS_HOME_DIR = "sas.home.dir";
    public static final String LEVDIRROOT_SAS_ROOT_DIR = "levdirroot.sasinstall.install.dir";
    public static final String CONFIGPROP_SAS_ROOT_DIR = "sasinstall.install.dir";
    public static final String CONFIGPROP_OS_MACHINE_TYPE = "os.localhost.machine.type";
    public static final String CONFIGPROP_PLAN_MACHINE_CONFIG_LIST = "plan.machine.config.list";
    public static final String CONFIGPROP_METADATA_SERVER_12_BYTE = "METADATASRV";
    public static final String LEVDIRROOT_PLATFORMTYPES_INSTALL_DIR = "levdirroot.platfmltypes.install.dir";
    public static final String CONFIGPROP_PLATFORMTYPES_INSTALL_DIR = "platfmltypes.install.dir";
    public static final String CONFIGPROP_LEV_UTILITIES_DIR = "config.lev.utilities.dir";
    public static final String CONFIGPROP_CONFIG_UTILITIES_DIR_NAME = "config.utilities.dir.name";
    public static final String BACKUP_COMPONENT_CLASSIDENTIFIER = "svrbakupevm";
    public static final String BACKUP_COMPONENT_WORKSPACE_DIR = "svrbakupevm.backup.workspace.legal.dir.name";
    public static final String BACKUP_COMPONENT_VALUT_DIR_NAME = "svrbakupevm.backup.vault.legal.dir.name";
    public static final String BACKUP_COMPONENT_LOG_DIR_NAME = "svrbakupevm.backup.log.legal.dir.name";
    public static final String BACKUP_COMPONENT_RESULT_DIR_NAME = "svrbakupevm.backup.results.legal.dir.name";
    public static final String BACKUP_COMPONENT_RETENTION_PERIOD = "svrbakupevm.retention.period.days";
    public static final String BACKUP_COMPONENT_RUN_SCHEDULED_BACKUPS = "svrbakupevm.scheduledbackups.isallow";
    public static final String BACKUP_COMPONENT_SHARED_VAULT_LOCATION = "svrbakupevm.shared.vault.dir";
    public static final String BACKUP_COMPOENT_CONFIGURED_HOSTS = "svrbakupevm.configured.hosts";
    public static final String BACKUP_COMPONENT_SCHEDULES = "svrbakupevm.schedule.val";
    public static final String BACKUP_COMPONENT_CUSTOMDIRS = "svrbakupevm.customdirs.val";
    public static final String BACKUP_COMPONENT_APP_HOME = "svrbakupevm.app.home";
    public static final String BACKUP_COMPONENT_PROPERTYSET = "Application Configuration";
    public static final String BACKUP_COMPONENT_ADMIN_USER_EMAIL = "svrbakupevm.admin.email.to.address";
    public static final String BACKUP_COMPONENT_PRIMARY_TIER = "svrbakupevm.admin.primary.tier.val";
    public static final String BACKUP_SCHEDULE_LOCK = "Schdule LOCK";
    public static final String AGENT_PORT = "solstice.agent.jmx.port";
    public static final String NOTIFICATION_LEVEL = "svrbakupevm.email.notification.level";
    public static ServerInterface authServer = null;

    public static ServerInterface getAuthServer() {
        return authServer;
    }

    public ServerInterface getServer() throws BackupException {
        ServerInterface server = null;
        try {
            server = this.userSessionFactory.getLocalSession().getUserContext().getAuthServer();
        }
        catch (RemoteException e) {
            logger.error((Object)e.getCause());
            throw new BackupException("Unable to access metadata server", (Throwable)e, BackupErrorConstants.ErrorCodes.ERROR_CODE_METADATA_RETRIVAL_FAILED.getErrorCode());
        }
        catch (ServiceException e) {
            logger.error((Object)e.getCause());
            throw new BackupException("Unable to access metadata server", (Throwable)e, BackupErrorConstants.ErrorCodes.ERROR_CODE_METADATA_RETRIVAL_FAILED.getErrorCode());
        }
        authServer = server;
        return server;
    }

    public List<BackupSchedule> getSchedules() throws BackupException {
        try {
            String xmlString = this.getBackupSchedules();
            xmlString = this.replaceSpCharsWithEscChars(xmlString, false);
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.parse(new InputSource(new StringReader(xmlString)));
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            DOMSource source = new DOMSource(document);
            StreamResult result = new StreamResult(new StringWriter());
            transformer.transform(source, result);
            String str1 = result.getWriter().toString();
            Document doc = builder.parse(new InputSource(new StringReader(str1)));
            NodeList sheduleNodes = doc.getElementsByTagName("Schedule");
            Element scheduleElement = (Element)sheduleNodes.item(0);
            int weekday = 1;
            ArrayList<BackupSchedule> schedulesList = new ArrayList<BackupSchedule>();
            for (BackupSchedule.DayOfWeek dayOfWeek : BackupSchedule.DayOfWeek.values()) {
                String attr = scheduleElement.getAttribute("Weekday" + Integer.toString(weekday));
                if (attr.length() > 0) {
                    for (String eventString : attr.split(";")) {
                        BackupSchedule event = new BackupSchedule();
                        event.setDayOfWeek(dayOfWeek);
                        event.setHour(Integer.parseInt(eventString.substring(0, 2)));
                        event.setMinute(Integer.parseInt(eventString.substring(2, 4)));
                        schedulesList.add(event);
                    }
                }
                ++weekday;
            }
            return schedulesList;
        }
        catch (IOException e) {
            throw new BackupException((Throwable)e, BackupErrorConstants.ErrorCodes.ERROR_CODE_GET_CONFIG_ERROR.getErrorCode());
        }
        catch (SAXException e) {
            throw new BackupException((Throwable)e, BackupErrorConstants.ErrorCodes.ERROR_CODE_GET_CONFIG_ERROR.getErrorCode());
        }
        catch (TransformerException e) {
            throw new BackupException((Throwable)e, BackupErrorConstants.ErrorCodes.ERROR_CODE_GET_CONFIG_ERROR.getErrorCode());
        }
        catch (ParserConfigurationException e) {
            throw new BackupException((Throwable)e, BackupErrorConstants.ErrorCodes.ERROR_CODE_GET_CONFIG_ERROR.getErrorCode());
        }
    }

    public boolean addCustomDirs(Map<String, List<DirectoryDetails>> customDirsWithHostNames) throws BackupException {
        Map<String, List<DirectoryDetails>> regdCustomDirsWithHostNames = this.getCustomDirs();
        regdCustomDirsWithHostNames = this.mergeCustomDirsMap(regdCustomDirsWithHostNames, customDirsWithHostNames);
        String originalListCustomDirs = this.getConfigurationProperties().get(BACKUP_COMPONENT_CUSTOMDIRS);
        return this.updateCustomDirs(new String(), regdCustomDirsWithHostNames);
    }

    private Map<String, List<DirectoryDetails>> mergeCustomDirsMap(Map<String, List<DirectoryDetails>> regdCustomDirsWithHostNames, Map<String, List<DirectoryDetails>> customDirsWithHostNames) throws BackupException {
        Set<String> newHosts = customDirsWithHostNames.keySet();
        HashMap<String, List<DirectoryDetails>> mergeCustomDirsMap = new HashMap<String, List<DirectoryDetails>>();
        for (String newHost : newHosts) {
            boolean isSASFoundationInstalled = this.checkIfFoundationInstalled(newHost);
            if (isSASFoundationInstalled) {
                Set<String> regdHosts = regdCustomDirsWithHostNames.keySet();
                List<DirectoryDetails> newDirs = customDirsWithHostNames.get(newHost);
                boolean ifAlredyRegdandUpdated = false;
                for (String regdHost : regdHosts) {
                    List<DirectoryDetails> regdDirs = regdCustomDirsWithHostNames.get(regdHost);
                    mergeCustomDirsMap.put(regdHost, regdDirs);
                    if (!BackupServiceUtils.isHostsEqual(newHost, regdHost)) continue;
                    for (DirectoryDetails newDir : newDirs) {
                        if (regdDirs.contains(newDir)) continue;
                        regdDirs.add(newDir);
                    }
                    mergeCustomDirsMap.put(regdHost, regdDirs);
                    ifAlredyRegdandUpdated = true;
                }
                if (ifAlredyRegdandUpdated) continue;
                mergeCustomDirsMap.put(newHost, newDirs);
                continue;
            }
            throw new BackupException("Couldn't add customer directory because SASFoundation is not installed on the host " + newHost, BackupErrorConstants.ErrorCodes.ERROR_CODE_SET_CONFIG_ERROR.getErrorCode());
        }
        return mergeCustomDirsMap;
    }

    private boolean checkIfFoundationInstalled(String newHost) throws BackupException {
        boolean foundationInstalled;
        block5: {
            foundationInstalled = false;
            try {
                List lstLevDirRoot = this.getSoftwareComponents(LEVDIRROOT_CLASSIDENTIFIER);
                if (lstLevDirRoot == null) break block5;
                for (int i = 0; i < lstLevDirRoot.size(); ++i) {
                    String hostName = null;
                    SoftwareComponentInterface levrootInstance = (SoftwareComponentInterface)lstLevDirRoot.get(i);
                    HashMap publicProperties = new HashMap();
                    HashMap privateProperties = new HashMap();
                    logger.debug("Fetching properties for :" + levrootInstance.getName());
                    ConfigurablePropertiesUtil.getObjectProperties((SoftwareComponent)((SoftwareComponent)levrootInstance.getRepositoryEntity()), publicProperties, privateProperties);
                    hostName = (String)publicProperties.get(LEVDIRROOT_OS_HOST);
                    if (BackupServiceUtils.isEmpty(hostName) || !BackupServiceUtils.isHostsEqual(hostName, newHost)) continue;
                    logger.debug("Host matched.");
                    if (privateProperties.get(LEVDIRROOT_SAS_ROOT_DIR) == null) continue;
                    logger.debug("SASFoundation is installed on " + newHost);
                    foundationInstalled = true;
                    break;
                }
            }
            catch (MdException e) {
                throw new BackupException("Couldn't add customer directory on the host " + newHost, (Throwable)e, BackupErrorConstants.ErrorCodes.ERROR_CODE_SET_CONFIG_ERROR.getErrorCode());
            }
            catch (RemoteException e) {
                throw new BackupException("Couldn't add customer directory on the host " + newHost, (Throwable)e, BackupErrorConstants.ErrorCodes.ERROR_CODE_SET_CONFIG_ERROR.getErrorCode());
            }
        }
        if (!foundationInstalled) {
            logger.debug("SASFoundation is installed on " + newHost);
        }
        return foundationInstalled;
    }

    public boolean setCustomDirs(Map<String, List<DirectoryDetails>> customDirsWithHostNames) throws BackupException {
        String originalListCustomDirs = new String();
        return this.updateCustomDirs(originalListCustomDirs, customDirsWithHostNames);
    }

    private boolean updateCustomDirs(String originalListCustomDirs, Map<String, List<DirectoryDetails>> customDirsWithHostNames) throws BackupException {
        Set<String> hostNames = customDirsWithHostNames.keySet();
        for (String hostName : hostNames) {
            List<DirectoryDetails> dirs = customDirsWithHostNames.get(hostName);
            boolean directoryAdded = false;
            for (int i = 0; i < dirs.size(); ++i) {
                DirectoryDetails dir = dirs.get(i);
                if (originalListCustomDirs == null) {
                    originalListCustomDirs = "";
                }
                if (i == 0) {
                    originalListCustomDirs = originalListCustomDirs + hostName + "#";
                } else if (originalListCustomDirs.charAt(originalListCustomDirs.length() - 1) != '#') {
                    originalListCustomDirs = originalListCustomDirs + ",,";
                }
                originalListCustomDirs = originalListCustomDirs + dir.getId() + "@" + dir.getDirectoryPath();
                directoryAdded = true;
            }
            if (!directoryAdded) continue;
            originalListCustomDirs = originalListCustomDirs + ";";
        }
        return this.updateConfigurationProperties(BACKUP_COMPONENT_CUSTOMDIRS, originalListCustomDirs);
    }

    private boolean isAlreadyRegistered(String originalListCustomDirs, String host, String dir) {
        String[] registeredDirs;
        for (String regDir : registeredDirs = originalListCustomDirs.split(";")) {
            String[] dirs;
            String[] hostAndDirs = regDir.split("#");
            if (hostAndDirs == null || hostAndDirs.length != 2) continue;
            for (String directory : dirs = hostAndDirs[1].split(",,")) {
                if (!BackupServiceUtils.isHostsEqual(hostAndDirs[0], host) || !directory.equals(dir)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void setSharedVaultLocation(String sharedVaultLocation) throws BackupException {
        if (sharedVaultLocation != null) {
            this.updateConfigurationProperties(BACKUP_COMPONENT_SHARED_VAULT_LOCATION, sharedVaultLocation);
        }
    }

    @Override
    public void setScheduledBackupsAllowed(boolean scheduledBackupAllowed) throws BackupException {
        this.updateConfigurationProperties(BACKUP_COMPONENT_RUN_SCHEDULED_BACKUPS, String.valueOf(scheduledBackupAllowed).toUpperCase());
    }

    @Override
    public void setRetentionPeriod(int daysToretainBackup) throws BackupException {
        this.updateConfigurationProperties(BACKUP_COMPONENT_RETENTION_PERIOD, Integer.toString(daysToretainBackup));
    }

    public void setSchedules(List<BackupSchedule> schedules) throws BackupException {
        String[] schedule = new String[7];
        String scheduleString = "<Schedule Event=\"Backup\"";
        if (schedules != null) {
            for (BackupSchedule event : schedules) {
                int day = event.getDayOfweek().ordinal();
                StringBuffer value = new StringBuffer();
                if (schedule[day] != null) {
                    value.append(schedule[day]);
                    value.append(";");
                }
                if (event.getHour() < 10) {
                    value.append("0");
                }
                value.append(Integer.toString(event.getHour()));
                if (event.getMinute() < 10) {
                    value.append("0");
                }
                value.append(Integer.toString(event.getMinute()));
                schedule[day] = value.toString();
            }
        }
        for (int day = 0; day < 7; ++day) {
            scheduleString = scheduleString + " Weekday" + Integer.toString(day + 1);
            scheduleString = schedule[day] != null ? scheduleString + "=\"" + schedule[day] + "\"" : scheduleString + "=\"\"";
        }
        scheduleString = scheduleString + "/>";
        scheduleString = this.replaceSpCharsWithEscChars(scheduleString, true);
        this.updateConfigurationProperties(BACKUP_COMPONENT_SCHEDULES, scheduleString);
    }

    private String replaceSpCharsWithEscChars(String scheduleString, boolean xmlToescaped) {
        String temp = scheduleString;
        if (xmlToescaped) {
            temp = temp.replaceAll("<", "&lt;");
            temp = temp.replaceAll("\"", "&quot;");
            temp = temp.replaceAll(">", "&gt;");
        } else {
            temp = temp.replaceAll("&lt;", "<");
            temp = temp.replaceAll("&quot;", "\"");
            temp = temp.replaceAll("&gt;", ">");
        }
        return temp;
    }

    @Override
    public List getSoftwareComponents(String classIdentifier) throws BackupException {
        List softwareComponents = null;
        int searchFlags = 18561;
        try {
            Filter filter = new Filter();
            FilterComponent fc = new FilterComponent();
            fc.setAggregation(1);
            fc.addComponent(new FilterComponent(CLASSIDENTIFIER, 0, classIdentifier));
            filter.setType(SOFTWARE_COMPONENT);
            filter.setOMRFlags(searchFlags);
            filter.setFilterComponent(fc);
            softwareComponents = this.getServer().search((FilterInterface)filter);
        }
        catch (ServiceException e) {
            throw new BackupException("Error encountered while trying to get software components for class identifier " + classIdentifier, (Throwable)e, BackupErrorConstants.ErrorCodes.ERROR_CODE_METADATA_RETRIVAL_FAILED.getErrorCode());
        }
        catch (RemoteException e) {
            throw new BackupException("Error encountered while trying to get software components for class identifier " + classIdentifier, (Throwable)e, BackupErrorConstants.ErrorCodes.ERROR_CODE_METADATA_RETRIVAL_FAILED.getErrorCode());
        }
        return softwareComponents;
    }

    @Override
    public List getLogicalServers(String classIdentifier) throws BackupException {
        List softwareComponents = null;
        int searchFlags = 18561;
        try {
            Filter filter = new Filter();
            FilterComponent fc = new FilterComponent();
            fc.setAggregation(1);
            fc.addComponent(new FilterComponent(CLASSIDENTIFIER, 0, classIdentifier));
            filter.setType(LOGICAL_SERVER);
            filter.setOMRFlags(searchFlags);
            filter.setFilterComponent(fc);
            softwareComponents = this.getServer().search((FilterInterface)filter);
        }
        catch (ServiceException e) {
            throw new BackupException("Error encountered while trying to get software components for class identifier " + classIdentifier, (Throwable)e, BackupErrorConstants.ErrorCodes.ERROR_CODE_METADATA_RETRIVAL_FAILED.getErrorCode());
        }
        catch (RemoteException e) {
            throw new BackupException("Error encountered while trying to get software components for class identifier " + classIdentifier, (Throwable)e, BackupErrorConstants.ErrorCodes.ERROR_CODE_METADATA_RETRIVAL_FAILED.getErrorCode());
        }
        return softwareComponents;
    }

    public List getServerComponents(String classIdentifier) throws BackupException {
        List serverComponents = null;
        int searchFlags = 18561;
        try {
            Filter filter = new Filter();
            FilterComponent fc = new FilterComponent();
            fc.setAggregation(1);
            fc.addComponent(new FilterComponent(CLASSIDENTIFIER, 0, classIdentifier));
            filter.setType(SERVER_COMPONENT);
            filter.setOMRFlags(searchFlags);
            filter.setFilterComponent(fc);
            serverComponents = this.getServer().search((FilterInterface)filter);
        }
        catch (ServiceException e) {
            logger.error((Object)e.getCause());
            throw new BackupException("Error encountered while trying to get server components for class identifier " + classIdentifier, (Throwable)e, BackupErrorConstants.ErrorCodes.ERROR_CODE_METADATA_RETRIVAL_FAILED.getErrorCode());
        }
        catch (RemoteException e) {
            logger.error((Object)e.getCause());
            throw new BackupException("Error encountered while trying to get server components for class identifier " + classIdentifier, (Throwable)e, BackupErrorConstants.ErrorCodes.ERROR_CODE_METADATA_RETRIVAL_FAILED.getErrorCode());
        }
        return serverComponents;
    }

    public SoftwareComponent getSoftwareComponent(SoftwareComponentInterface smartObject) throws BackupException {
        int searchFlags = 18441;
        SoftwareComponent jomaObject = null;
        try {
            CMetadata metadataObject = (CMetadata)smartObject.getRepositoryEntity();
            MdFactory objectFactory = metadataObject.getObjectStore().getFactory();
            jomaObject = (SoftwareComponent)objectFactory.getOMIUtil().getMetadataAllDepths(metadataObject, new ArrayList(), null, templateSoftwareComponent, searchFlags);
        }
        catch (MdException e) {
            throw new BackupException("Error encountered while trying to get JOMA object software components from smart object.", (Throwable)e, BackupErrorConstants.ErrorCodes.ERROR_CODE_METADATA_RETRIVAL_FAILED.getErrorCode());
        }
        catch (RemoteException e) {
            throw new BackupException("Error encountered while trying to get JOMA object software components from smart object.", (Throwable)e, BackupErrorConstants.ErrorCodes.ERROR_CODE_METADATA_RETRIVAL_FAILED.getErrorCode());
        }
        return jomaObject;
    }

    public ServerComponent getServerComponent(ServerComponentInterface smartObject) throws BackupException {
        int searchFlags = 26633;
        ServerComponent jomaObject = null;
        try {
            CMetadata metadataObject = (CMetadata)smartObject.getRepositoryEntity();
            MdFactory objectFactory = metadataObject.getObjectStore().getFactory();
            jomaObject = (ServerComponent)objectFactory.getOMIUtil().getMetadataAllDepths(metadataObject, new ArrayList(), null, templateServerComponent, searchFlags);
        }
        catch (MdException e) {
            throw new BackupException("Error encountered while trying to get JOMA object software components from smart object.", (Throwable)e, BackupErrorConstants.ErrorCodes.ERROR_CODE_METADATA_RETRIVAL_FAILED.getErrorCode());
        }
        catch (RemoteException e) {
            throw new BackupException("Error encountered while trying to get JOMA object software components from smart object.", (Throwable)e, BackupErrorConstants.ErrorCodes.ERROR_CODE_METADATA_RETRIVAL_FAILED.getErrorCode());
        }
        return jomaObject;
    }

    public String getSoftwareComponentProperty(SoftwareComponentInterface smartObject, String propertyName, BackupErrorConstants.ErrorCodes errorTobeUsed) throws BackupException {
        String propertyValue;
        block7: {
            if (errorTobeUsed == null) {
                errorTobeUsed = BackupErrorConstants.ErrorCodes.ERROR_CODE_METADATA_RETRIVAL_FAILED;
            }
            propertyValue = null;
            if (propertyName != null) {
                try {
                    HashMap publicProperties = new HashMap();
                    HashMap privateProperties = new HashMap();
                    ConfigurablePropertiesUtil.getObjectProperties((SoftwareComponent)((SoftwareComponent)smartObject.getRepositoryEntity()), publicProperties, privateProperties);
                    for (String key : publicProperties.keySet()) {
                        if (!propertyName.equalsIgnoreCase(key)) continue;
                        propertyValue = (String)publicProperties.get(key);
                        break;
                    }
                    if (propertyValue != null) break block7;
                    for (String key : privateProperties.keySet()) {
                        if (!propertyName.equalsIgnoreCase(key)) continue;
                        propertyValue = (String)publicProperties.get(key);
                        break;
                    }
                }
                catch (MdException e) {
                    throw new BackupException("Error encountered while trying to get software component property " + propertyName, (Throwable)e, errorTobeUsed.getErrorCode());
                }
                catch (RemoteException e) {
                    throw new BackupException("Error encountered while trying to get software component property " + propertyName, (Throwable)e, errorTobeUsed.getErrorCode());
                }
            }
        }
        return propertyValue;
    }

    @Override
    public void reloadSourceNodes(List<BackupSourceNode> sourceNodes) throws BackupException {
        logger.debug("Reloading source tier information from metadata...");
        FileInputStream fis = null;
        try {
            logger.debug("Searching for 'levdirroot' software component(s)...");
            List lstLevDirRoot = this.getSoftwareComponents(LEVDIRROOT_CLASSIDENTIFIER);
            boolean isTierCheckRequired = this.isTierCheckRequired(lstLevDirRoot);
            if (lstLevDirRoot != null) {
                boolean isPrimaryNodealredySet = false;
                for (int i = 0; i < lstLevDirRoot.size(); ++i) {
                    SoftwareComponentInterface levrootInstance = (SoftwareComponentInterface)lstLevDirRoot.get(i);
                    HashMap publicProperties = new HashMap();
                    HashMap privateProperties = new HashMap();
                    logger.debug("Fetching properties for :" + levrootInstance.getName());
                    ConfigurablePropertiesUtil.getObjectProperties((SoftwareComponent)((SoftwareComponent)levrootInstance.getRepositoryEntity()), publicProperties, privateProperties);
                    String agentPort = (String)publicProperties.get(AGENT_PORT);
                    boolean isAgentDeployed = agentPort != null;
                    String hostName = (String)publicProperties.get(LEVDIRROOT_OS_HOST);
                    String configDir = (String)publicProperties.get(LEVDIRROOT_CONFIG_LEV_DIR);
                    if (BackupServiceUtils.isEmpty(hostName) || BackupServiceUtils.isEmpty(configDir)) {
                        throw new BackupException("Either host or configuration directory information is not found in levdirroot metadata.", BackupErrorConstants.ErrorCodes.ERROR_CODE_GENERAL_AUTO_DISCOVERY_FAILURE.getErrorCode());
                    }
                    BackupSourceNode lSourceNode = new BackupSourceNode(hostName, configDir);
                    for (BackupSourceNode sourceNode : sourceNodes) {
                        boolean isMetadataTier;
                        String sourceNodeHost = sourceNode.getHostName();
                        if (!lSourceNode.equals((Object)sourceNode) || !isAgentDeployed || !(isMetadataTier = this.checkIfMetadataTier(sourceNode, isTierCheckRequired))) continue;
                        sourceNode.setMetadataTier(true);
                        if (isPrimaryNodealredySet) continue;
                        isPrimaryNodealredySet = true;
                        sourceNode.setIsPrimary(true);
                    }
                }
            }
        }
        catch (BackupException e) {
            throw e;
        }
        catch (Exception e) {
            logger.error((Object)e.getCause());
            throw new BackupException("Failed to load tier information using levdirroot metadata.", (Throwable)e, BackupErrorConstants.ErrorCodes.ERROR_CODE_GENERAL_AUTO_DISCOVERY_FAILURE.getErrorCode());
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public boolean checkIfMetadataTier(BackupSourceNode sourceNode, boolean isTierCheckRequired) throws BackupException {
        boolean result = false;
        try {
            logger.info("Checking if it is primary metadata tier.");
            List metadataServers = this.getServerComponents("0217E202-B560-11DB-AD91-001083FF6836");
            OMRServerComponent omrMetadataServer = null;
            ServerComponent metadataServer = null;
            if (metadataServers.size() > 0 && metadataServers.get(0) instanceof OMRServerComponent) {
                omrMetadataServer = (OMRServerComponent)metadataServers.get(0);
                metadataServer = this.getServerComponent((ServerComponentInterface)omrMetadataServer);
            }
            if (metadataServer == null) {
                throw new BackupException("NOTFOUND: Metadata server not found", BackupErrorConstants.ErrorCodes.ERROR_CODE_GENERAL_AUTO_DISCOVERY_FAILURE.getErrorCode());
            }
            logger.debug("Found metadata server component " + metadataServer.getName());
            AssociationList sourceConnections = metadataServer.getSourceConnections(true);
            if (sourceConnections.size() > 0) {
                for (int i = 0; i < sourceConnections.size(); ++i) {
                    TCPIPConnection tcpipConnection;
                    String metadataHostName;
                    if (sourceConnections.get(i) == null || !(sourceConnections.get(i) instanceof TCPIPConnection) || (metadataHostName = (tcpipConnection = (TCPIPConnection)sourceConnections.get(i)).getHostName()) == null || !BackupServiceUtils.isHostsEqual(metadataHostName, sourceNode.getHostName())) continue;
                    LogicalServer logicalServer = null;
                    if (!isTierCheckRequired) {
                        logger.info("Tier check not required. Primary Metadata tier is " + sourceNode);
                        result = true;
                        break;
                    }
                    logger.debug("Checking tier match for metadata server.");
                    AssociationList logicalServers = metadataServer.getUsedByComponents(true);
                    if (BackupServiceUtils.isEmpty(logicalServers)) continue;
                    for (int index = 0; index < logicalServers.size(); ++index) {
                        if (!(logicalServers.get(index) instanceof LogicalServer)) continue;
                        logicalServer = (LogicalServer)logicalServers.get(index);
                        logger.debug("Got logical server for metadata server" + logicalServer.getName());
                        AssociationList dependsOnComponents = logicalServer.getDependsOnComponents(true);
                        if (BackupServiceUtils.isEmpty(dependsOnComponents)) continue;
                        for (int cnt = 0; cnt < dependsOnComponents.size(); ++cnt) {
                            ServerContext serverContext;
                            if (!(dependsOnComponents.get(cnt) instanceof ServerContext) || !"SASMeta".equals((serverContext = (ServerContext)dependsOnComponents.get(cnt)).getName())) continue;
                            logger.debug("Found SASMeta context under logical server: " + logicalServer.getName());
                            HashMap publicProperties = new HashMap();
                            HashMap privateProperties = new HashMap();
                            ConfigurablePropertiesUtil.getObjectProperties((SoftwareComponent)serverContext, publicProperties, privateProperties);
                            String contextPath = (String)publicProperties.get("config.lev.appservercontext.dir");
                            if (contextPath == null || sourceNode.getConfigDirPath() == null || !sourceNode.getConfigDirPath().equalsIgnoreCase(BackupServiceUtils.getParentPath(contextPath))) continue;
                            logger.info("Primary Metadata tier is " + sourceNode);
                            result = true;
                            break;
                        }
                        if (result) break;
                    }
                    if (result) break;
                }
            }
            if (!result) {
                this.checkifMetadataClusterNode(sourceNode, metadataServer, isTierCheckRequired);
            }
        }
        catch (RemoteException e) {
            throw new BackupException("Error encountered while trying to check metadata server tier.", BackupErrorConstants.ErrorCodes.ERROR_CODE_GENERAL_AUTO_DISCOVERY_FAILURE.getErrorCode());
        }
        catch (MdException e) {
            throw new BackupException("Error encountered while trying to check metadata server tier.", BackupErrorConstants.ErrorCodes.ERROR_CODE_GENERAL_AUTO_DISCOVERY_FAILURE.getErrorCode());
        }
        return result;
    }

    private void checkifMetadataClusterNode(BackupSourceNode sourceNode, ServerComponent metadataServer, boolean isTiercheckRequired) throws BackupException {
        block7: {
            LogicalServer logicalServer = null;
            boolean isClusterNode = false;
            try {
                logger.debug("Checking if " + sourceNode + " is metadata cluster node");
                AssociationList logicalServers = metadataServer.getUsedByComponents(true);
                if (BackupServiceUtils.isEmpty(logicalServers)) break block7;
                for (int index = 0; index < logicalServers.size(); ++index) {
                    if (!(logicalServers.get(index) instanceof LogicalServer)) continue;
                    logicalServer = (LogicalServer)logicalServers.get(index);
                    logger.debug("Logical  metadata Server: " + logicalServer.getName());
                    AssociationList usingComponents = logicalServer.getUsingComponents(true);
                    for (int cnt = 0; cnt < usingComponents.size(); ++cnt) {
                        AssociationList sourceConnections;
                        if (!(usingComponents.get(cnt) instanceof ServerComponent)) continue;
                        ServerComponent metadataComponent = (ServerComponent)usingComponents.get(cnt);
                        logger.debug("metadataComponent " + metadataComponent.getName());
                        if (!"0217E202-B560-11DB-AD91-001083FF6836".equals(metadataComponent.getClassIdentifier()) || (sourceConnections = metadataComponent.getSourceConnections(true)).size() <= 0) continue;
                        for (int i = 0; i < sourceConnections.size(); ++i) {
                            if (sourceConnections.get(i) == null || !(sourceConnections.get(i) instanceof TCPIPConnection)) continue;
                            TCPIPConnection tcpipConnection = (TCPIPConnection)sourceConnections.get(i);
                            String metadataHostName = tcpipConnection.getHostName();
                            logger.debug("tcpipConnection host " + metadataHostName);
                            if (metadataHostName == null || !BackupServiceUtils.isHostsEqual(metadataHostName, sourceNode.getHostName())) continue;
                            logger.info("Metadata cluster node is " + sourceNode);
                            sourceNode.setMetadataCluster(true);
                            isClusterNode = true;
                            break;
                        }
                        if (isClusterNode) break;
                    }
                    if (!isClusterNode) {
                        continue;
                    }
                    break;
                }
            }
            catch (RemoteException e) {
                throw new BackupException("Error encountered while trying to check metadata server tier.", BackupErrorConstants.ErrorCodes.ERROR_CODE_GENERAL_AUTO_DISCOVERY_FAILURE.getErrorCode());
            }
            catch (MdException e) {
                throw new BackupException("Error encountered while trying to check metadata server tier.", BackupErrorConstants.ErrorCodes.ERROR_CODE_GENERAL_AUTO_DISCOVERY_FAILURE.getErrorCode());
            }
        }
    }

    @Override
    public String getSharedVaultLocation() throws BackupException {
        return this.getConfigurationProperties().get(BACKUP_COMPONENT_SHARED_VAULT_LOCATION);
    }

    @Override
    public String getBackupSchedules() throws BackupException {
        return this.getConfigurationProperties().get(BACKUP_COMPONENT_SCHEDULES);
    }

    @Override
    public Map<String, List<DirectoryDetails>> getCustomDirs() throws BackupException {
        String customDirs = this.getConfigurationProperties().get(BACKUP_COMPONENT_CUSTOMDIRS);
        HashMap<String, List<DirectoryDetails>> customDirsMap = new HashMap<String, List<DirectoryDetails>>();
        if (customDirs != null && !customDirs.equals("")) {
            String[] hostSpeicificCustomDirs;
            for (String hostSpcfcDirs : hostSpeicificCustomDirs = customDirs.split(";")) {
                String[] dirsArray;
                String[] hostNameAndDirs = hostSpcfcDirs.split("#");
                String hostName = hostNameAndDirs[0].trim();
                ArrayList<DirectoryDetails> dirsList = (ArrayList<DirectoryDetails>)customDirsMap.get(hostName);
                if (dirsList == null) {
                    dirsList = new ArrayList<DirectoryDetails>();
                }
                for (String dirDetails : dirsArray = hostNameAndDirs[1].split(",,")) {
                    String[] idAndPath = dirDetails.split("@");
                    if (idAndPath.length != 2) continue;
                    dirsList.add(new DirectoryDetails(idAndPath[0], idAndPath[1]));
                }
                customDirsMap.put(hostName, dirsList);
            }
        }
        return customDirsMap;
    }

    @Override
    public boolean isBackupServerAlreadyConfigured(BackupSourceNode sourceNode) throws BackupException {
        String lstConfiguredHosts = this.getConfigurationProperties().get(BACKUP_COMPOENT_CONFIGURED_HOSTS);
        if (lstConfiguredHosts == null || lstConfiguredHosts.length() == 0) {
            logger.debug("No configured hosts found.");
            return false;
        }
        String[] lstOfConfiguredHosts = lstConfiguredHosts.split(",");
        if (!BackupServiceUtils.isEmpty(lstOfConfiguredHosts)) {
            for (String configuredHostNConfigDir : lstOfConfiguredHosts) {
                BackupSourceNode lSourceNode = new BackupSourceNode(configuredHostNConfigDir);
                if (!sourceNode.equals((Object)lSourceNode)) continue;
                logger.debug("Backup server is already configured");
                return true;
            }
        }
        logger.debug("Backup server not yet configured");
        return false;
    }

    @Override
    public int getRetentionPeriod() throws BackupException {
        String str = this.getConfigurationProperties().get(BACKUP_COMPONENT_RETENTION_PERIOD);
        logger.debug("Retention period is: " + str);
        return Integer.parseInt(str);
    }

    @Override
    public boolean isScheduledBackupsAllowed() throws BackupException {
        String str = this.getConfigurationProperties().get(BACKUP_COMPONENT_RUN_SCHEDULED_BACKUPS);
        boolean result = true;
        if (!BackupServiceUtils.isEmpty(str)) {
            result = str.startsWith("t") || str.startsWith("T");
        }
        return result;
    }

    @Override
    public String getBackupWorkspaceDirName() throws BackupException {
        String str = this.getConfigurationProperties().get(BACKUP_COMPONENT_WORKSPACE_DIR);
        return str;
    }

    @Override
    public String getEmailNotificationLevel() throws BackupException {
        String str = this.getConfigurationProperties().get(NOTIFICATION_LEVEL);
        return str;
    }

    @Override
    public String getAppHomePath() throws BackupException {
        String str = null;
        String baseTempPath = System.getProperty("java.io.tmpdir");
        File tempDir = new File(baseTempPath + File.separator + "SASDeploymentBackup_APPHOME");
        str = tempDir.getAbsolutePath();
        if (!tempDir.exists()) {
            if (!tempDir.mkdir()) {
                throw new BackupException("Can't create application home at " + str, BackupErrorConstants.ErrorCodes.ERROR_CODE_GENERAL_IO_FAILURE.getErrorCode());
            }
            tempDir.setExecutable(true, false);
            tempDir.setReadable(true, false);
            tempDir.setWritable(true, false);
        }
        logger.trace("App Home: " + str);
        return str;
    }

    @Override
    public Map<String, String> getConfigurationProperties() throws BackupException {
        PropertySet pset1 = this.getPropertySet();
        HashMap<String, String> backupComponentProperties = new HashMap<String, String>();
        try {
            AssociationList props = pset1.getSetProperties(true);
            if (props.size() > 0) {
                for (int i = 0; i < props.size(); ++i) {
                    Property property = (Property)props.get(i);
                    backupComponentProperties.put(property.getName(), property.getDefaultValue());
                }
            }
        }
        catch (MdException e) {
            logger.error("NOTFOUND: Backup Component's configuration properties");
            throw new BackupException("Error encountered while trying to get properties of metadata object with class identifier svrbakupevm", (Throwable)e, BackupErrorConstants.ErrorCodes.ERROR_CODE_METADATA_RETRIVAL_FAILED.getErrorCode());
        }
        catch (RemoteException e) {
            throw new BackupException("Error encountered while trying to get properties of metadata object with class identifier svrbakupevm", (Throwable)e, BackupErrorConstants.ErrorCodes.ERROR_CODE_METADATA_RETRIVAL_FAILED.getErrorCode());
        }
        return backupComponentProperties;
    }

    private PropertySet getPropertySet() throws BackupException {
        Object pset1 = null;
        PropertySet propertySet = null;
        List softwareComponents = this.getSoftwareComponents(BACKUP_COMPONENT_CLASSIDENTIFIER);
        SoftwareComponentInterface backupComponent = null;
        if (softwareComponents.size() > 0) {
            backupComponent = (SoftwareComponentInterface)softwareComponents.get(0);
        }
        if (backupComponent == null) {
            throw new BackupException("NOTFOUND: Backup Component not found", BackupErrorConstants.ErrorCodes.ERROR_CODE_METADATA_RETRIVAL_FAILED.getErrorCode());
        }
        SoftwareComponent jomaObj = this.getSoftwareComponent(backupComponent);
        try {
            AssociationList props = jomaObj.getPropertySets(true);
            if (props == null || props.size() == 0) {
                throw new BackupException("NOTFOUND: Backup Component's configuration properties", BackupErrorConstants.ErrorCodes.ERROR_CODE_METADATA_RETRIVAL_FAILED.getErrorCode());
            }
            for (int i = 0; i < props.size(); ++i) {
                if (!BACKUP_COMPONENT_PROPERTYSET.equals(((PropertySet)props.get(i)).getName())) continue;
                propertySet = (PropertySet)props.get(i);
                break;
            }
        }
        catch (RemoteException e) {
            throw new BackupException("Error encountered while trying to get PropertySet of metadata object with class identifier svrbakupevm", (Throwable)e, BackupErrorConstants.ErrorCodes.ERROR_CODE_METADATA_RETRIVAL_FAILED.getErrorCode());
        }
        catch (MdException e) {
            throw new BackupException("Error encountered while trying to get PropertySet of metadata object with class identifier svrbakupevm", (Throwable)e, BackupErrorConstants.ErrorCodes.ERROR_CODE_METADATA_RETRIVAL_FAILED.getErrorCode());
        }
        return propertySet;
    }

    @Override
    public boolean updateConfigurationProperties(String key, String value) throws BackupException {
        List softwareComponents = this.getSoftwareComponents(BACKUP_COMPONENT_CLASSIDENTIFIER);
        SoftwareComponentInterface backupComponent = null;
        if (softwareComponents.size() > 0) {
            backupComponent = (SoftwareComponentInterface)softwareComponents.get(0);
        }
        if (backupComponent == null) {
            throw new BackupException("NOTFOUND: Backup Component not found", BackupErrorConstants.ErrorCodes.ERROR_CODE_SET_CONFIG_ERROR.getErrorCode());
        }
        List props1 = null;
        try {
            props1 = backupComponent.getPropertySets();
            if (props1 == null || props1.size() == 0) {
                throw new BackupException("NOTFOUND: Backup Component's configuration properties", BackupErrorConstants.ErrorCodes.ERROR_CODE_SET_CONFIG_ERROR.getErrorCode());
            }
            PropertySetInterface pset1 = (PropertySetInterface)props1.get(0);
            List props = pset1.getSetProperties();
            if (props.size() > 0) {
                for (int i = 0; i < props.size(); ++i) {
                    PropertyInterface property = (PropertyInterface)props.get(i);
                    if (key == null || !key.equals(property.getName())) continue;
                    property.setValue(value);
                }
            }
            backupComponent.update();
        }
        catch (ServiceException e) {
            throw new BackupException("Failed to update properties of metadata object with class identifier svrbakupevm", (Throwable)e, BackupErrorConstants.ErrorCodes.ERROR_CODE_SET_CONFIG_ERROR.getErrorCode());
        }
        catch (RemoteException e) {
            throw new BackupException("Failed to update properties of metadata object with class identifier svrbakupevm", (Throwable)e, BackupErrorConstants.ErrorCodes.ERROR_CODE_SET_CONFIG_ERROR.getErrorCode());
        }
        return true;
    }

    @Override
    public boolean addConfigurationProperties(String key, String value) throws BackupException {
        List softwareComponents = this.getSoftwareComponents(BACKUP_COMPONENT_CLASSIDENTIFIER);
        SoftwareComponentInterface backupComponent = null;
        if (softwareComponents.size() > 0) {
            backupComponent = (SoftwareComponentInterface)softwareComponents.get(0);
        }
        if (backupComponent == null) {
            throw new BackupException("NOTFOUND: Backup Component not found", BackupErrorConstants.ErrorCodes.ERROR_CODE_SET_CONFIG_ERROR.getErrorCode());
        }
        List props1 = null;
        try {
            props1 = backupComponent.getPropertySets();
            if (props1 == null || props1.size() == 0) {
                throw new BackupException("NOTFOUND: Backup Component's configuration properties", BackupErrorConstants.ErrorCodes.ERROR_CODE_SET_CONFIG_ERROR.getErrorCode());
            }
            PropertySetInterface pset = (PropertySetInterface)props1.get(0);
            OMRProperty prop = new OMRProperty();
            prop.setName(key);
            prop.setValue(value);
            pset.addSetProperty((PropertyInterface)prop);
            backupComponent.update();
        }
        catch (ServiceException e) {
            throw new BackupException("Failed to update properties of metadata object with class identifier svrbakupevm", (Throwable)e, BackupErrorConstants.ErrorCodes.ERROR_CODE_SET_CONFIG_ERROR.getErrorCode());
        }
        catch (RemoteException e) {
            throw new BackupException("Failed to update properties of metadata object with class identifier svrbakupevm", (Throwable)e, BackupErrorConstants.ErrorCodes.ERROR_CODE_SET_CONFIG_ERROR.getErrorCode());
        }
        return true;
    }

    @Override
    public Map<String, String> getBackupUserLoginInfo() throws BackupException {
        return this.getLoginInfo(BACKUP_AUTH);
    }

    public Map<String, String> getLoginInfo(String authDomain) throws BackupException {
        HashMap<String, String> loginInfo = new HashMap<String, String>();
        if (BackupServiceUtils.isEmpty(authDomain)) {
            logger.warn("Invalid domain name.");
            return loginInfo;
        }
        AuthenticationDomain authDomainObj = this.getAuthDomainObject(BACKUP_AUTH);
        if (BackupServiceUtils.isEmpty(authDomainObj)) {
            logger.info("NOTFOUND: SASDeploymentBackupAuth domain information from metadata.");
            return loginInfo;
        }
        MetadataServerInterface metadataServer = (MetadataServerInterface)this.getServer();
        try {
            UserIdentityInterface uid;
            List loginAuthDoamin = metadataServer.getLoginsForAuthDomain(authDomain);
            if (loginAuthDoamin.size() > 0 && !BackupServiceUtils.isEmpty(uid = (UserIdentityInterface)loginAuthDoamin.get(0)) && !BackupServiceUtils.isEmpty(uid.getPrincipal())) {
                String userName = uid.getPrincipal().toString();
                Map<String, String> userdetail = this.getUserAndDomain(userName);
                String password = uid.getCredential().toString();
                loginInfo.put("loginUsername", userdetail.get("loginUsername"));
                loginInfo.put("loginPassword", password);
                loginInfo.put("loginDomain", userdetail.get("loginDomain"));
                logger.debug("user name: " + userName);
            }
        }
        catch (ServiceException e) {
            throw new BackupException("Failed to get Backup User metadata ", (Throwable)e, BackupErrorConstants.ErrorCodes.ERROR_CODE_METADATA_RETRIVAL_FAILED.getErrorCode());
        }
        catch (RemoteException e) {
            throw new BackupException("Failed to get Backup User metadata ", (Throwable)e, BackupErrorConstants.ErrorCodes.ERROR_CODE_METADATA_RETRIVAL_FAILED.getErrorCode());
        }
        return loginInfo;
    }

    private Map<String, String> getUserAndDomain(String userid) {
        HashMap<String, String> userDetails = new HashMap<String, String>();
        if (userid == null) {
            throw new IllegalStateException("Invalid user");
        }
        String userName = null;
        String domain = "";
        Pattern domainStyle1 = Pattern.compile(BACKSLASHSTYLE_PATTERN);
        Pattern domainStyle2 = Pattern.compile(ATSIGNSTYLE_PATTERN);
        Matcher matcher1 = domainStyle1.matcher(userid);
        Matcher matcher2 = domainStyle2.matcher(userid);
        if (matcher1.matches()) {
            domain = matcher1.group(1);
            userName = matcher1.group(2);
        } else if (matcher2.matches()) {
            domain = matcher2.group(2);
            userName = matcher2.group(1);
        } else {
            userName = userid;
            domain = "";
        }
        userDetails.put("loginUsername", userName);
        userDetails.put("loginDomain", domain);
        return userDetails;
    }

    public LoginInterface getLoginObject(String loginName) throws BackupException {
        LoginInterface login = null;
        List logins = null;
        int searchFlags = 18561;
        try {
            Filter filter = new Filter();
            FilterComponent fc = new FilterComponent();
            fc.setAggregation(1);
            fc.addComponent(new FilterComponent(NAME, 0, loginName));
            filter.setType(LOGIN);
            filter.setOMRFlags(searchFlags);
            filter.setFilterComponent(fc);
            logins = this.getServer().search((FilterInterface)filter);
            if (!BackupServiceUtils.isEmpty(logins)) {
                login = (LoginInterface)logins.get(0);
            }
        }
        catch (ServiceException e) {
            throw new BackupException("Failed to get Login object metadata for " + loginName, (Throwable)e, BackupErrorConstants.ErrorCodes.ERROR_CODE_METADATA_RETRIVAL_FAILED.getErrorCode());
        }
        catch (RemoteException e) {
            throw new BackupException("Failed to get Login object metadata for " + loginName, (Throwable)e, BackupErrorConstants.ErrorCodes.ERROR_CODE_METADATA_RETRIVAL_FAILED.getErrorCode());
        }
        return login;
    }

    public AuthenticationDomain getAuthDomainObject(String domainName) throws BackupException {
        AuthenticationDomain domain = null;
        List authDomains = null;
        int searchFlags = 18561;
        String options = "<XMLSelect search=\"@Name='SASDeploymentBackupAuth'\"/>";
        try {
            MdFactory mdFact = ((OMIServer)this.getServer()).getMdFactory();
            MdObjectStore store = mdFact.createObjectStore();
            authDomains = mdFact.getOMIUtil().getMetadataObjectsSubset((MdStore)store, mdFact.getOMIUtil().getFoundationReposID(), "AuthenticationDomain", searchFlags, options);
            if (!BackupServiceUtils.isEmpty(authDomains)) {
                domain = (AuthenticationDomain)authDomains.get(0);
            }
            store.dispose();
        }
        catch (MdException e) {
            throw new BackupException("Failed to get Authentication Domain metadata for " + domainName, (Throwable)e, BackupErrorConstants.ErrorCodes.ERROR_CODE_METADATA_RETRIVAL_FAILED.getErrorCode());
        }
        catch (RemoteException e) {
            throw new BackupException("Failed to get Authentication Domain metadata for " + domainName, (Throwable)e, BackupErrorConstants.ErrorCodes.ERROR_CODE_METADATA_RETRIVAL_FAILED.getErrorCode());
        }
        if (BackupServiceUtils.isEmpty(domain)) {
            logger.debug("Authentication domain not found: " + domain);
        }
        return domain;
    }

    @Override
    public boolean isBackupUserEnabled() throws BackupException {
        boolean isBackupUserPresent = false;
        AuthenticationDomain authDomain = this.getAuthDomainObject(BACKUP_AUTH);
        try {
            String userName;
            UserIdentityInterface uid;
            MetadataServerInterface metadataServer;
            List loginAuthDoamin;
            if (!(BackupServiceUtils.isEmpty(authDomain) || BackupServiceUtils.isEmpty(loginAuthDoamin = (metadataServer = (MetadataServerInterface)this.getServer()).getLoginsForAuthDomain(BACKUP_AUTH)) || BackupServiceUtils.isEmpty(uid = (UserIdentityInterface)loginAuthDoamin.get(0)) || BackupServiceUtils.isEmpty(uid.getPrincipal()) || BackupServiceUtils.isEmpty(userName = uid.getPrincipal().toString()))) {
                isBackupUserPresent = true;
                logger.debug("user name: " + userName);
            }
            if (!isBackupUserPresent) {
                logger.debug("Backup User is not enabled");
            }
        }
        catch (ServiceException e) {
            throw new BackupException("Failed to determine whether Backup user is enabled.", (Throwable)e, BackupErrorConstants.ErrorCodes.ERROR_CODE_METADATA_RETRIVAL_FAILED.getErrorCode());
        }
        catch (RemoteException e) {
            throw new BackupException("Failed to determine whether Backup user is enabled.", (Throwable)e, BackupErrorConstants.ErrorCodes.ERROR_CODE_METADATA_RETRIVAL_FAILED.getErrorCode());
        }
        return isBackupUserPresent;
    }

    @Override
    public boolean isTierCheckRequired() throws BackupException {
        boolean result = false;
        try {
            List lstLevDirRoot = this.getSoftwareComponents(LEVDIRROOT_CLASSIDENTIFIER);
            if (!BackupServiceUtils.isEmpty(lstLevDirRoot) && lstLevDirRoot.size() == 1) {
                logger.debug("This is single tier setup.");
                return false;
            }
            if (!BackupServiceUtils.isEmpty(lstLevDirRoot) && lstLevDirRoot.size() > 1) {
                HashSet<String> hostNames = new HashSet<String>();
                ArrayList<String> lstHosts = new ArrayList<String>();
                for (int i = 0; i < lstLevDirRoot.size(); ++i) {
                    SoftwareComponentInterface levrootInstance = (SoftwareComponentInterface)lstLevDirRoot.get(i);
                    HashMap publicProperties = new HashMap();
                    HashMap privateProperties = new HashMap();
                    ConfigurablePropertiesUtil.getObjectProperties((SoftwareComponent)((SoftwareComponent)levrootInstance.getRepositoryEntity()), publicProperties, privateProperties);
                    String hostName = (String)publicProperties.get(LEVDIRROOT_OS_HOST);
                    String agentPort = (String)publicProperties.get(AGENT_PORT);
                    boolean isAgentDeployed = agentPort != null;
                    boolean hasDependentComponents = !BackupServiceUtils.isEmpty(levrootInstance.getDependentComponents());
                    boolean isCurrentMetadataTier = BackupServiceUtils.isHostsEqual(this.getServer().getHost(), hostName);
                    if (!isAgentDeployed || !hasDependentComponents && !isCurrentMetadataTier) continue;
                    if (hostNames.contains(hostName) || this.isHostFound(lstHosts, hostName)) {
                        logger.debug("More than one tiers are present on the host machine: " + hostName);
                        return true;
                    }
                    hostNames.add(hostName);
                    lstHosts.add(hostName);
                }
                logger.debug("Each tier in the deployment is on distinct host machine.");
            }
        }
        catch (BackupException e) {
            throw e;
        }
        catch (Exception e) {
            throw new BackupException("Failed to determine whether multiple tiers are on same machine.", (Throwable)e, BackupErrorConstants.ErrorCodes.ERROR_CODE_METADATA_RETRIVAL_FAILED.getErrorCode());
        }
        return result;
    }

    private boolean isHostFound(List<String> lstHosts, String hostName) {
        boolean hostFound = false;
        if (lstHosts != null) {
            Iterator<String> iterHost = lstHosts.iterator();
            while (iterHost.hasNext()) {
                String dbHost = iterHost.next().toString();
                if (!BackupServiceUtils.isHostsEqual(dbHost, hostName)) continue;
                logger.debug("Host found: " + hostName);
                return true;
            }
        }
        return hostFound;
    }

    private boolean isTierCheckRequired(List lstLevDirRoot) throws BackupException {
        boolean result = false;
        try {
            if (!BackupServiceUtils.isEmpty(lstLevDirRoot) && lstLevDirRoot.size() == 1) {
                logger.debug("This is single tier setup.");
                return false;
            }
            if (!BackupServiceUtils.isEmpty(lstLevDirRoot) && lstLevDirRoot.size() > 1) {
                HashSet<String> hostNames = new HashSet<String>();
                ArrayList<String> lstHosts = new ArrayList<String>();
                for (int i = 0; i < lstLevDirRoot.size(); ++i) {
                    SoftwareComponentInterface levrootInstance = (SoftwareComponentInterface)lstLevDirRoot.get(i);
                    HashMap publicProperties = new HashMap();
                    HashMap privateProperties = new HashMap();
                    ConfigurablePropertiesUtil.getObjectProperties((SoftwareComponent)((SoftwareComponent)levrootInstance.getRepositoryEntity()), publicProperties, privateProperties);
                    String hostName = (String)publicProperties.get(LEVDIRROOT_OS_HOST);
                    String agentPort = (String)publicProperties.get(AGENT_PORT);
                    boolean isAgentDeployed = agentPort != null;
                    boolean hasDependentComponents = !BackupServiceUtils.isEmpty(levrootInstance.getDependentComponents());
                    boolean isCurrentMetadataTier = BackupServiceUtils.isHostsEqual(this.getServer().getHost(), hostName);
                    if (!isAgentDeployed || !hasDependentComponents && !isCurrentMetadataTier) continue;
                    if (hostNames.contains(hostName) || this.isHostFound(lstHosts, hostName)) {
                        logger.debug("More than one tiers are present on the host machine: " + hostName);
                        return true;
                    }
                    hostNames.add(hostName);
                    lstHosts.add(hostName);
                }
                logger.debug("Each tier in the deployment is on distinct host machine.");
            }
        }
        catch (BackupException e) {
            throw e;
        }
        catch (Exception e) {
            throw new BackupException("Failed to determine whether multiple tiers are on same machine.", (Throwable)e, BackupErrorConstants.ErrorCodes.ERROR_CODE_METADATA_RETRIVAL_FAILED.getErrorCode());
        }
        return result;
    }

    @Override
    public List<String> getHostsInDeployment() throws BackupException {
        HashSet<String> hosts = null;
        logger.debug("Retrieving host information from metadata...");
        Object fis = null;
        try {
            logger.debug("Searching for 'levdirroot' software component(s)...");
            List lstLevDirRoot = this.getSoftwareComponents(LEVDIRROOT_CLASSIDENTIFIER);
            if (lstLevDirRoot != null) {
                hosts = new HashSet<String>();
                boolean isPrimaryNodealredySet = false;
                int i = 0;
                while (i < lstLevDirRoot.size()) {
                    String hostName = null;
                    SoftwareComponentInterface levrootInstance = (SoftwareComponentInterface)lstLevDirRoot.get(i);
                    String tierNickName = "tier" + ++i;
                    HashMap publicProperties = new HashMap();
                    HashMap privateProperties = new HashMap();
                    logger.debug("Fetching properties for :" + levrootInstance.getName());
                    ConfigurablePropertiesUtil.getObjectProperties((SoftwareComponent)((SoftwareComponent)levrootInstance.getRepositoryEntity()), publicProperties, privateProperties);
                    hostName = (String)publicProperties.get(LEVDIRROOT_OS_HOST);
                    String agentPort = (String)publicProperties.get(AGENT_PORT);
                    boolean isAgentDeployed = agentPort != null;
                    boolean hasDependentComponents = !BackupServiceUtils.isEmpty(levrootInstance.getDependentComponents());
                    boolean isCurrentMetadataTier = BackupServiceUtils.isHostsEqual(this.getServer().getHost(), hostName);
                    if (!isAgentDeployed || !hasDependentComponents && !isCurrentMetadataTier) continue;
                    String configDir = (String)publicProperties.get(LEVDIRROOT_CONFIG_LEV_DIR);
                    if (BackupServiceUtils.isEmpty(hostName) || BackupServiceUtils.isEmpty(configDir)) {
                        throw new BackupException("Either host or configuration directory information is not found in levdirroot metadata.", BackupErrorConstants.ErrorCodes.ERROR_CODE_METADATA_RETRIVAL_FAILED.getErrorCode());
                    }
                    hosts.add(hostName);
                }
            }
        }
        catch (BackupException e) {
            throw e;
        }
        catch (RemoteException e) {
            throw new BackupException("Failed to retrieve host information in the SAS deployment.", (Throwable)e, BackupErrorConstants.ErrorCodes.ERROR_CODE_METADATA_RETRIVAL_FAILED.getErrorCode());
        }
        catch (MdException e) {
            throw new BackupException("Failed to retrieve host information in the SAS deployment.", (Throwable)e, BackupErrorConstants.ErrorCodes.ERROR_CODE_METADATA_RETRIVAL_FAILED.getErrorCode());
        }
        catch (ServiceException e) {
            throw new BackupException("Failed to retrieve host information in the SAS deployment.", (Throwable)e, BackupErrorConstants.ErrorCodes.ERROR_CODE_METADATA_RETRIVAL_FAILED.getErrorCode());
        }
        return new ArrayList<String>(hosts);
    }

    @Override
    public String[] getEmailToList() throws BackupException {
        String userEmails = this.getConfigurationProperties().get(BACKUP_COMPONENT_ADMIN_USER_EMAIL);
        String[] userEmailId = null;
        if (!userEmails.isEmpty()) {
            userEmailId = userEmails.split("\\,");
        }
        return userEmailId;
    }

    @Override
    public void setEmailToList(String[] emailToList) throws BackupException {
        StringBuilder builder = new StringBuilder();
        String seperator = "";
        for (String email : emailToList) {
            if (email != null) {
                builder.append(seperator);
            }
            seperator = ",";
            builder.append(email);
        }
        String emailList = builder.toString();
        if (emailList != null) {
            this.updateConfigurationProperties(BACKUP_COMPONENT_ADMIN_USER_EMAIL, emailList);
        } else {
            logger.error("Receiver email address is invalid");
        }
    }

    public boolean isNotificationsEnabled() throws BackupException {
        boolean result = false;
        String[] emailToList = this.getEmailToList();
        if (emailToList != null) {
            result = true;
        }
        return result;
    }

    @Override
    public SASTier getUserSpecifiedPrimaryMetadataTier() throws BackupException {
        SASTier userSpecifiedPrimaryTier = null;
        String strUserSpecifiedPrimaryTier = this.getConfigurationProperties().get(BACKUP_COMPONENT_PRIMARY_TIER);
        if (strUserSpecifiedPrimaryTier != null && !strUserSpecifiedPrimaryTier.isEmpty()) {
            userSpecifiedPrimaryTier = BackupServiceUtils.createSASTierInstance(strUserSpecifiedPrimaryTier);
        }
        return userSpecifiedPrimaryTier;
    }
}

