/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.backup.dao;

import com.sas.svcs.backup.analyze.BackupTask;
import com.sas.svcs.backup.analyze.model.AnalysisResult;
import com.sas.svcs.backup.analyze.model.RuntimeSASEnvironment;
import com.sas.svcs.backup.client.BackupSourceConfig;
import com.sas.svcs.backup.client.ConfigurableServerProxy;
import com.sas.svcs.backup.client.ConfigurationFilter;
import com.sas.svcs.backup.client.SASTierProxy;
import com.sas.svcs.backup.client.SASTiers;
import com.sas.svcs.backup.client.UserConfigurationServiceInterface;
import com.sas.svcs.backup.client.UserSourceConfiguration;
import com.sas.svcs.backup.common.definitions.BackupErrorConstants;
import com.sas.svcs.backup.common.definitions.BackupException;
import com.sas.svcs.backup.dao.BackupServerHelperDAO;
import com.sas.svcs.backup.dao.BackupServiceUtils;
import com.sas.svcs.backup.dao.ConfigBeanConverter;
import com.sas.svcs.backup.dao.OMRBackupSourceSupportService;
import com.sas.svcs.backup.dao.OMRDeploymentBackupConfiguration;
import com.sas.svcs.backup.dao.RB;
import com.sas.svcs.deployment.data.ConfigurableServer;
import com.sas.svcs.deployment.data.SASTier;
import com.sas.text.Message;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service(value="OMRCUSTOMDIR")
public class OMRCustomDirSupportService
extends OMRBackupSourceSupportService {
    private Logger logger = LogManager.getLogger(OMRCustomDirSupportService.class);
    @Autowired
    private OMRDeploymentBackupConfiguration omrDeploymentConf;
    @Autowired
    @Qualifier(value="UserConfigurationService")
    private UserConfigurationServiceInterface userConfigurationService;
    @Autowired
    ConfigBeanConverter configBeanConverter;
    @Autowired
    @Qualifier(value="BackupServerHelperDAO")
    BackupServerHelperDAO backupServer;

    @Override
    public List<AnalysisResult.AnalysisProblem> analyze(RuntimeSASEnvironment sasEnvironment) throws BackupException {
        ArrayList<AnalysisResult.AnalysisProblem> analysisProblems = new ArrayList<AnalysisResult.AnalysisProblem>();
        this.logger.debug("Calling UserConfigurationService.getSourceConfig(BackupSource.CUSTOMDIR)");
        try {
            List configServers;
            UserSourceConfiguration userSourceConfiguration = this.userConfigurationService.getSourceConfig(BackupSourceConfig.BackupSource.CUSTOMDIR);
            if (!BackupServiceUtils.isEmpty(userSourceConfiguration) && !BackupServiceUtils.isEmpty(configServers = userSourceConfiguration.getConfigurableServers())) {
                for (ConfigurableServerProxy configServer : configServers) {
                    ConfigurableServer configurableServer;
                    if (BackupServiceUtils.isEmpty(configServer) || this.userConfigurationService.isCanonicalExclude(configurableServer = this.configBeanConverter.proxyToServer(configServer), BackupSourceConfig.BackupSource.CUSTOMDIR)) continue;
                    this.analyzeCustomeDirectory(configServer, analysisProblems);
                }
            }
        }
        catch (Exception e) {
            String message = Message.format((String)RB.getStringResource("OMRBackupSourceSupportService.analyze.failed.with.unknown.error.fmt"), (Object)BackupSourceConfig.BackupSource.CUSTOMDIR);
            this.logger.error(message, (Throwable)e);
            analysisProblems.add(AnalysisResult.createProblem((int)BackupErrorConstants.ErrorCodes.ERROR_CODE_CUSTOMDIR_DISCOVERY_FAILED.getErrorCode(), (String)message));
        }
        return analysisProblems;
    }

    private List<AnalysisResult.AnalysisProblem> analyzeCustomeDirectory(ConfigurableServerProxy configServer, List<AnalysisResult.AnalysisProblem> analysisProblems) {
        String tierId = configServer.getSasTierId();
        ConfigurableServer configurableServer = this.configBeanConverter.proxyToServer(configServer);
        if (!BackupServiceUtils.isEmpty(tierId)) {
            List proxies;
            SASTierProxy proxy = null;
            SASTiers sasTiers = this.userConfigurationService.getSASTiers();
            if (sasTiers != null && (proxies = sasTiers.getSasTiers()) != null && proxies.size() > 0) {
                for (SASTierProxy testProxy : proxies) {
                    if (!tierId.equals(testProxy.getTierName())) continue;
                    proxy = testProxy;
                    break;
                }
            }
            if (proxy != null) {
                String path = configServer.getConfigurablePath();
                if (BackupServiceUtils.isEmpty(path)) {
                    analysisProblems.add(AnalysisResult.createErrorForSource((ConfigurableServer)configurableServer, (int)BackupErrorConstants.ErrorCodes.ERROR_CODE_CUSTOMDIR_DISCOVERY_FAILED.getErrorCode(), (String)"Can't find path for custom directory.", (String)"Check user configuration."));
                }
            } else {
                analysisProblems.add(AnalysisResult.createErrorForSource((ConfigurableServer)configurableServer, (int)BackupErrorConstants.ErrorCodes.ERROR_CODE_CUSTOMDIR_DISCOVERY_FAILED.getErrorCode(), (String)Message.format((String)RB.getStringResource("OMRBackupSourceSupportService.analyze.error.sastier.notfound.fmt"), (Object)configServer.getName())));
            }
        } else {
            analysisProblems.add(AnalysisResult.createErrorForSource((ConfigurableServer)configurableServer, (int)BackupErrorConstants.ErrorCodes.ERROR_CODE_CUSTOMDIR_DISCOVERY_FAILED.getErrorCode(), (String)Message.format((String)RB.getStringResource("OMRBackupSourceSupportService.analyze.error.sastier.notfound.fmt"), (Object)configServer.getName())));
        }
        return analysisProblems;
    }

    @Override
    public List<BackupTask> getBackupTasks(RuntimeSASEnvironment runtimeSASEnvironment) throws BackupException {
        ArrayList<BackupTask> customDirBackupTasks = new ArrayList<BackupTask>();
        try {
            this.logger.info("Starting discovery of custom directory.");
            for (SASTier sasTier : runtimeSASEnvironment.getAvailableTiers()) {
                if (sasTier != null && !runtimeSASEnvironment.getUnreachableTiers().contains(sasTier)) {
                    List configServers = this.userConfigurationService.getConfigurableServerForTier(BackupSourceConfig.BackupSource.CUSTOMDIR, sasTier);
                    if (BackupServiceUtils.isEmpty(configServers)) continue;
                    BackupTask.BackupTaskBuilder taskBuilder = BackupTask.getBackupNodeTaskBuilder(BackupSourceConfig.BackupSource.CUSTOMDIR, sasTier);
                    BackupTask backupTask = null;
                    for (ConfigurableServerProxy configServer : configServers) {
                        this.includeBackupTaskFor(configServer, taskBuilder, runtimeSASEnvironment);
                    }
                    if (!taskBuilder.hasParams()) continue;
                    backupTask = taskBuilder.build();
                    customDirBackupTasks.add(backupTask);
                    this.logger.info("Discovered custom directory on  " + sasTier);
                    continue;
                }
                this.logger.info("SASTier excluded during CUSTOMDIR getBackupTasks since it is not reachable.");
            }
            this.logger.info("Finished discovery of custom directory.");
        }
        catch (BackupException e) {
            throw e;
        }
        catch (Exception e) {
            BackupException be = new BackupException("Discovery of custom directory failed.", (Throwable)e, BackupErrorConstants.ErrorCodes.ERROR_CODE_CUSTOMDIR_DISCOVERY_FAILED.getErrorCode());
            throw be;
        }
        return customDirBackupTasks;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void includeBackupTaskFor(ConfigurableServerProxy configServer, BackupTask.BackupTaskBuilder taskBuilder, RuntimeSASEnvironment runtimeSASEnvironment) {
        List proxies;
        String tierId = configServer.getSasTierId();
        ConfigurableServer configurableServer = this.configBeanConverter.proxyToServer(configServer);
        if (this.userConfigurationService.isExcluded(configurableServer, BackupSourceConfig.BackupSource.CUSTOMDIR) || runtimeSASEnvironment.hasErrors(BackupSourceConfig.BackupSource.CUSTOMDIR, configurableServer)) return;
        if (BackupServiceUtils.isEmpty(tierId)) throw BackupException.getBuilder((int)BackupErrorConstants.ErrorCodes.ERROR_CODE_CUSTOMDIR_DISCOVERY_FAILED.getErrorCode()).build();
        String path = configServer.getConfigurablePath();
        if (BackupServiceUtils.isEmpty(path)) throw BackupException.getBuilder((int)BackupErrorConstants.ErrorCodes.ERROR_CODE_CUSTOMDIR_DISCOVERY_FAILED.getErrorCode()).build();
        SASTierProxy proxy = null;
        SASTiers sasTiers = this.userConfigurationService.getSASTiers();
        if (sasTiers != null && (proxies = sasTiers.getSasTiers()) != null && proxies.size() > 0) {
            for (SASTierProxy testProxy : proxies) {
                if (!tierId.equals(testProxy.getTierName())) continue;
                proxy = testProxy;
                break;
            }
        }
        if (proxy == null) return;
        ConfigurationFilter configurationFilter = configServer.getFilter();
        if (configurationFilter != null) {
            String excludesFilter;
            String includesFilter;
            if (!BackupServiceUtils.isEmpty(configurationFilter.getIncludes()) && (includesFilter = BackupServiceUtils.listtoString(configurationFilter.getIncludes(), ":")) != null && !includesFilter.trim().isEmpty()) {
                taskBuilder.appendParam("includefilter", path + "?" + includesFilter, ",");
            }
            if (!BackupServiceUtils.isEmpty(configurationFilter.getExcludes()) && (excludesFilter = BackupServiceUtils.listtoString(configurationFilter.getExcludes(), ":")) != null && !excludesFilter.trim().isEmpty()) {
                taskBuilder.appendParam("excludefilter", path + "?" + excludesFilter, ",");
            }
        }
        taskBuilder.addParam(path, path);
    }

    @Override
    public List<BackupTask> getRestoreTasks(RuntimeSASEnvironment runtimeSASEnvironment) throws BackupException {
        return null;
    }
}

