/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.backup.dao;

import com.sas.svcs.backup.analyze.BackupJob;
import com.sas.svcs.backup.analyze.BackupTask;
import com.sas.svcs.backup.analyze.model.RuntimeSASEnvironment;
import com.sas.svcs.backup.client.BackupConfiguration;
import com.sas.svcs.backup.client.BackupSourceConfig;
import com.sas.svcs.backup.client.BackupSourceNode;
import com.sas.svcs.backup.client.ConfigurableServerProxy;
import com.sas.svcs.backup.client.ConfigurationFilter;
import com.sas.svcs.backup.client.SASTierProxy;
import com.sas.svcs.backup.client.SASTiers;
import com.sas.svcs.backup.client.UserBackupConfiguration;
import com.sas.svcs.backup.client.UserConfigurationServiceInterface;
import com.sas.svcs.backup.client.UserSourceConfiguration;
import com.sas.svcs.backup.dao.BackupServiceUtils;
import com.sas.svcs.backup.spi.BackupConfigurationService;
import com.sas.svcs.deployment.data.ConfigurableServer;
import com.sas.svcs.deployment.data.SASHost;
import com.sas.svcs.deployment.data.SASTier;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component
public class ConfigBeanConverter {
    @Autowired
    BackupConfigurationService backupConfigurationService;
    @Autowired
    @Qualifier(value="UserConfigurationService")
    UserConfigurationServiceInterface userConfigurationService;

    public List<ConfigurableServer> proxiesListToServersList(List<ConfigurableServerProxy> proxies) {
        if (proxies != null) {
            ArrayList<ConfigurableServer> configServers = new ArrayList<ConfigurableServer>();
            for (ConfigurableServerProxy proxy : proxies) {
                configServers.add(this.proxyToServer(proxy));
            }
            return configServers;
        }
        return null;
    }

    public List<ConfigurableServerProxy> serversListToProxiesList(List<ConfigurableServer> configServers) {
        if (configServers != null) {
            ArrayList<ConfigurableServerProxy> proxies = new ArrayList<ConfigurableServerProxy>();
            for (ConfigurableServer server : configServers) {
                proxies.add(this.serverToProxy(server));
            }
            return proxies;
        }
        return null;
    }

    public List<SASTierProxy> sasTierListToProxyList(List<SASTier> tiers) {
        if (tiers != null) {
            ArrayList<SASTierProxy> proxies = new ArrayList<SASTierProxy>();
            for (SASTier tier : tiers) {
                proxies.add(this.sasTierToProxy(tier));
            }
            return proxies;
        }
        return null;
    }

    public List<SASTier> proxiesListToSASTiersList(List<SASTierProxy> proxies) {
        if (proxies != null) {
            ArrayList<SASTier> tiers = new ArrayList<SASTier>();
            for (SASTierProxy proxy : proxies) {
                tiers.add(this.proxyToSASTier(proxy));
            }
            return tiers;
        }
        return null;
    }

    public SASTierProxy sasTierToProxy(SASTier tier) {
        if (tier != null) {
            SASTierProxy proxy = new SASTierProxy();
            proxy.setSasConfig(tier.getSasConfig());
            proxy.setSasHome(tier.getSasHome());
            proxy.setTierHost(tier.getTierHost());
            proxy.setTierName(tier.getTierName());
            proxy.setId(tier.getTierName());
            if (tier.getProperties() != null) {
                proxy.setProperties(tier.getProperties());
            }
            return proxy;
        }
        return null;
    }

    public ConfigurableServerProxy sasTierProxyToUserConfigDir(SASTierProxy tier) {
        if (tier != null) {
            ConfigurableServerProxy proxy = new ConfigurableServerProxy();
            proxy.setSasTierId(tier.getTierName());
            proxy.setName(tier.getTierName());
            proxy.setConfigurablePath(tier.getSasConfig());
            proxy.setId(tier.getTierName());
            return proxy;
        }
        return null;
    }

    public SASTier proxyToSASTier(SASTierProxy proxy) {
        if (proxy != null) {
            SASTier tier = new SASTier();
            if (proxy.getTierName() != null) {
                tier.setTierName(proxy.getTierName());
            }
            tier.setTierHost(proxy.getTierHost());
            tier.setSasHome(proxy.getSasHome());
            tier.setSasConfig(proxy.getSasConfig());
            if (proxy.getProperties() != null) {
                tier.setProperties(proxy.getProperties());
            }
            return tier;
        }
        return null;
    }

    public ConfigurableServer proxyToServer(ConfigurableServerProxy proxy) {
        if (proxy != null) {
            ConfigurableServer server = new ConfigurableServer();
            server.setConfigurablePath(proxy.getConfigurablePath());
            server.setObjectName(proxy.getName());
            server.setSasTierId(proxy.getSasTierId());
            if (proxy.getProperties() != null) {
                server.setProperties(proxy.getProperties());
            }
            return server;
        }
        return null;
    }

    public ConfigurableServerProxy serverToProxy(ConfigurableServer server) {
        if (server != null) {
            ConfigurableServerProxy proxy = new ConfigurableServerProxy();
            proxy.setConfigurablePath(server.getConfigurablePath());
            proxy.setName(server.getObjectName());
            String tierId = this.getSASTierId(server.getSasTier());
            proxy.setSasTierId(tierId);
            proxy.setIncluded(Boolean.valueOf(true));
            if (server.getProperties() != null) {
                proxy.setProperties(server.getProperties());
            }
            return proxy;
        }
        return null;
    }

    private String getSASTierId(SASTier sasTier) {
        List sastierProxies;
        SASTiers sastiers;
        if (sasTier != null && (sastiers = this.userConfigurationService.getSASTiers()) != null && (sastierProxies = sastiers.getSasTiers()) != null) {
            for (SASTierProxy proxy : sastierProxies) {
                if (!proxy.getTierHost().getHostName().equals(sasTier.getHostName()) || !proxy.getSasConfig().equals(sasTier.getSasConfig())) continue;
                return proxy.getTierName();
            }
        }
        return null;
    }

    public UserBackupConfiguration configtoUserconfig(BackupConfiguration config) {
        if (config != null) {
            UserBackupConfiguration userconfg = new UserBackupConfiguration();
            userconfg.setDaysToRetainBackups(config.getDaysToRetainBackups());
            userconfg.setEmailToList(config.getEmailToList());
            userconfg.setId(config.getId());
            userconfg.setScheduledBackupsAllowed(config.isScheduledBackupsAllowed());
            userconfg.setVaultLocation(config.getVaultLocation());
            userconfg.setFilter(config.getFilter());
            List sources = config.getSources();
            ArrayList<UserSourceConfiguration> usersources = new ArrayList<UserSourceConfiguration>();
            if (sources != null) {
                for (BackupSourceConfig source : sources) {
                    usersources.add(this.sourceConfigToUsersourceConfig(source));
                }
            }
            userconfg.setSources(usersources);
            return userconfg;
        }
        return null;
    }

    public BackupConfiguration userConfigToBackupConfig(UserBackupConfiguration userconfig) {
        if (userconfig != null) {
            BackupConfiguration config = new BackupConfiguration();
            config.setDaysToRetainBackups(userconfig.getDaysToRetainBackups());
            config.setEmailToList(userconfig.getEmailToList());
            config.setFilter(userconfig.getFilter());
            config.setId(userconfig.getId());
            config.setScheduledBackupsAllowed(userconfig.isScheduledBackupsAllowed());
            config.setVaultLocation(userconfig.getVaultLocation());
            List userSources = userconfig.getSources();
            ArrayList<BackupSourceConfig> sources = new ArrayList<BackupSourceConfig>();
            if (userSources != null) {
                for (UserSourceConfiguration usersource : userSources) {
                    sources.add(this.userSourceToBackupSource(usersource));
                }
            }
            config.setSources(sources);
            return config;
        }
        return null;
    }

    public UserBackupConfiguration BackupConfigTouserConfig(BackupConfiguration baseconfiguration) {
        if (baseconfiguration != null) {
            UserBackupConfiguration configuration = new UserBackupConfiguration();
            configuration.setDaysToRetainBackups(baseconfiguration.getDaysToRetainBackups());
            configuration.setEmailToList(baseconfiguration.getEmailToList());
            configuration.setId(baseconfiguration.getId());
            configuration.setScheduledBackupsAllowed(baseconfiguration.isScheduledBackupsAllowed());
            configuration.setFilter(baseconfiguration.getFilter());
            configuration.setVaultLocation(baseconfiguration.getVaultLocation());
            List sources = baseconfiguration.getSources();
            ArrayList<UserSourceConfiguration> userSources = new ArrayList<UserSourceConfiguration>();
            if (sources != null) {
                for (BackupSourceConfig backupsource : sources) {
                    userSources.add(this.BackupSourceTouserSource(backupsource));
                }
            }
            configuration.setSources(userSources);
            return configuration;
        }
        return null;
    }

    public List<BackupSourceConfig> userSourcesListToSources(List<UserSourceConfiguration> userSources) {
        if (userSources != null) {
            ArrayList<BackupSourceConfig> sources = new ArrayList<BackupSourceConfig>();
            for (UserSourceConfiguration usersource : userSources) {
                sources.add(this.userSourceToBackupSource(usersource));
            }
            return sources;
        }
        return null;
    }

    public List<UserSourceConfiguration> SourcesListtoUserSources(List<BackupSourceConfig> sources) {
        if (sources != null) {
            ArrayList<UserSourceConfiguration> usersources = new ArrayList<UserSourceConfiguration>();
            for (BackupSourceConfig source : sources) {
                usersources.add(this.sourceConfigToUsersourceConfig(source));
            }
            return usersources;
        }
        return null;
    }

    public BackupSourceConfig userSourceToBackupSource(UserSourceConfiguration userSourceConfig) {
        if (userSourceConfig != null) {
            BackupSourceConfig source = new BackupSourceConfig();
            source.setSourceType(BackupServiceUtils.getBackupSource(userSourceConfig.getSourceType()));
            return source;
        }
        return null;
    }

    public UserSourceConfiguration BackupSourceTouserSource(BackupSourceConfig backupSourceConfig) {
        if (backupSourceConfig != null) {
            UserSourceConfiguration source = new UserSourceConfiguration();
            return source;
        }
        return null;
    }

    public UserSourceConfiguration sourceConfigToUsersourceConfig(BackupSourceConfig sourceConfig) {
        if (sourceConfig != null) {
            UserSourceConfiguration userSourceConfig = new UserSourceConfiguration();
            return userSourceConfig;
        }
        return null;
    }

    public List<BackupSourceNode> sasTierToBackupSourceNodeList(List<SASTier> sastiers, SASTier primaryTier) {
        ArrayList<BackupSourceNode> backupSourceNodes = new ArrayList<BackupSourceNode>();
        if (sastiers != null) {
            for (SASTier sasTier : sastiers) {
                BackupSourceNode lSourceNode;
                BackupSourceNode node = this.sasTierToBackupSourceNode(sasTier);
                if (primaryTier != null && node.equals((Object)(lSourceNode = new BackupSourceNode(primaryTier.getHostName(), primaryTier.getSasConfig())))) {
                    node.setIsPrimary(true);
                    node.setMetadataTier(true);
                }
                backupSourceNodes.add(node);
            }
        }
        return backupSourceNodes;
    }

    public BackupSourceNode sasTierToBackupSourceNode(SASTier sasTier) {
        BackupSourceNode node = new BackupSourceNode();
        if (sasTier != null) {
            Properties configurableProperties = sasTier.getProperties();
            node.setNickName(sasTier.getTierName());
            SASHost sasHost = sasTier.getTierHost();
            if (sasHost != null) {
                node.setHostName(sasHost.getHostName());
            }
            String configDir = configurableProperties.getProperty("config.lev.dir");
            node.setConfigDirPath(configDir);
            node.setSasHome(configurableProperties.getProperty("sas.home.dir"));
            node.setOsType(configurableProperties.getProperty("os.localhost.machine.type"));
            node.setAppDataFolder(configurableProperties.getProperty("config.lev.appdata.dir"));
            node.setLevUtilitiesDir(configDir + "/" + "Utilities");
            node.setMetadataTier(sasTier.isPrimaryMetadataServer());
            node.setIsPrimary(sasTier.isPrimaryMetadataServer());
            node.setPlatformTypesInstallDir(configurableProperties.getProperty("levdirroot.platfmltypes.install.dir"));
            node.setSasRoot(configurableProperties.getProperty("levdirroot.sasinstall.install.dir"));
        }
        return node;
    }

    public BackupSourceNode sasTierToBackupSourceNode(SASTier sasTier, SASTier primaryTier) {
        BackupSourceNode lSourceNode;
        BackupSourceNode node = this.sasTierToBackupSourceNode(sasTier);
        if (primaryTier != null && node.equals((Object)(lSourceNode = new BackupSourceNode(primaryTier.getHostName(), primaryTier.getSasConfig())))) {
            node.setIsPrimary(true);
            node.setMetadataTier(true);
        }
        return node;
    }

    public SASTier sourceNodeToSASTier(BackupSourceNode sourceNode) {
        SASTier sasTier = new SASTier();
        if (sourceNode != null) {
            sasTier.setTierName(sourceNode.getNickName());
            SASHost sasHost = new SASHost(sourceNode.getHostName(), sourceNode.getOsType());
            sasTier.setTierHost(sasHost);
            sasTier.setSasConfig(sourceNode.getConfigDirPath());
            sasTier.setSasHome(sourceNode.getSasHome());
            sasTier.setPrimaryMetadataServer(sourceNode.isMetadataTier());
        }
        return sasTier;
    }

    public BackupConfiguration backupJobToConfig(BackupJob backupJob) {
        BackupConfiguration backupConfiguration = this.getBaseConfig(backupJob);
        ArrayList<BackupSourceConfig> backupSourceConfigs = new ArrayList<BackupSourceConfig>();
        this.fillBackupSourceConfigs(backupJob, backupSourceConfigs);
        backupConfiguration.setSources(backupSourceConfigs);
        return backupConfiguration;
    }

    private BackupConfiguration getBaseConfig(BackupJob backupJob) {
        BackupConfiguration backupConfiguration = backupJob.getBaseConfiguration();
        return backupConfiguration;
    }

    private List<BackupSourceConfig> fillBackupSourceConfigs(BackupJob backupJob, List<BackupSourceConfig> backupSourceConfigs) {
        RuntimeSASEnvironment runtimeSASEnvironment = backupJob.getBackupJobEnvironment();
        for (BackupSourceConfig.BackupSource backupSource : BackupSourceConfig.BackupSource.values()) {
            List<BackupTask> sourceBackupTasks = backupJob.getTasks(backupSource);
            if (sourceBackupTasks == null) continue;
            for (BackupTask sourceBackupTask : sourceBackupTasks) {
                backupSourceConfigs.add(this.backupTaskToSourceConfig(sourceBackupTask, runtimeSASEnvironment.getPrimaryMetdataTier()));
            }
        }
        return backupSourceConfigs;
    }

    public BackupSourceConfig backupTaskToSourceConfig(BackupTask backupTask, SASTier primaryTier) {
        BackupSourceConfig backupSourceConfig = new BackupSourceConfig();
        backupSourceConfig.setSourceType(backupTask.getSource());
        backupSourceConfig.setBackupSourceNode(this.sasTierToBackupSourceNode(backupTask.getPerformOn(), primaryTier));
        backupSourceConfig.setProperties(backupTask.getProperties());
        return backupSourceConfig;
    }

    public void main(String[] args) {
        ConfigurableServer server = new ConfigurableServer();
        SASHost host = new SASHost("rdcesx15048.race.sas.com", "WX6");
        SASTier tier = new SASTier();
        tier.setTierHost(host);
        server.setConfigurablePath("C:\\SAS\\Config\\Lev1");
        server.setSasTier(tier);
        server.setObjectName("severName");
        server.setSasTierId("tier1");
        ConfigurableServerProxy proxy = this.serverToProxy(server);
        server = this.proxyToServer(proxy);
        server.setSasTier(tier);
        List<ConfigurableServer> servers = new ArrayList<ConfigurableServer>();
        servers.add(server);
        List<ConfigurableServerProxy> proxies = this.serversListToProxiesList(servers);
        servers = this.proxiesListToServersList(proxies);
        BackupConfiguration config = new BackupConfiguration();
        config.setDaysToRetainBackups(28);
        config.setId("default");
        String[] emails = new String[]{"nilesh.mahadik@sas.com"};
        config.setEmailToList(emails);
        config.setVaultLocation("C:\\centralvault");
        ConfigurationFilter filter = new ConfigurationFilter();
        ArrayList<String> includes = new ArrayList<String>();
        includes.add("DATABASE");
        includes.add("CONTENTSERVER");
        includes.add("configdirectories");
        ArrayList excludes = new ArrayList();
        filter.setExcludes(excludes);
        filter.setIncludes(includes);
        config.setFilter(filter);
        ArrayList<BackupSourceConfig> sources = new ArrayList<BackupSourceConfig>();
        BackupSourceConfig source = new BackupSourceConfig();
        source.setSourceType(BackupSourceConfig.BackupSource.CONFIGDIR);
        sources.add(source);
        source = new BackupSourceConfig();
        source.setSourceType(BackupSourceConfig.BackupSource.DATABASE);
        source = new BackupSourceConfig();
        source.setSourceType(BackupSourceConfig.BackupSource.CONTENTSERVER);
        config.setSources(sources);
        UserBackupConfiguration userConfig = this.configtoUserconfig(config);
        List<UserSourceConfiguration> usersources = this.SourcesListtoUserSources(sources);
        userConfig.setSources(usersources);
        System.out.println("testing done!");
    }
}

