/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.backup.dao;

import com.sas.services.ServiceException;
import com.sas.services.information.MetadataServerInterface;
import com.sas.services.user.UserIdentityInterface;
import com.sas.svcs.backup.client.BackupServiceConstants;
import com.sas.svcs.backup.client.BackupSourceConfig;
import com.sas.svcs.backup.client.BackupSourceNode;
import com.sas.svcs.backup.client.OperationDetails;
import com.sas.svcs.backup.common.definitions.BackupException;
import com.sas.svcs.backup.dao.OSUtils;
import com.sas.svcs.backup.dao.RB;
import com.sas.svcs.deployment.data.SASHost;
import com.sas.svcs.deployment.data.SASTier;
import com.sas.text.Message;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.rmi.RemoteException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.appender.FileAppender;
import org.apache.logging.log4j.core.config.Configuration;

public class BackupServiceUtils {
    private static final Logger logger = LogManager.getLogger(BackupServiceUtils.class);
    private static File tempDir = null;
    private static final String DEFAULT_LOGFILE_NAME = "SASDeploymentBackup9.4.log";

    public static File getTempDir() throws IOException {
        if (tempDir == null || !tempDir.exists()) {
            tempDir = BackupServiceUtils.createTempDir();
        }
        return tempDir;
    }

    private static File createTempDir() throws IOException {
        String baseTempPath = System.getProperty("java.io.tmpdir");
        Random random = new Random();
        int randomInt = 1 + random.nextInt();
        File tempDir = new File(baseTempPath + File.separator + "BackupTemp" + randomInt);
        if (tempDir.exists() && !tempDir.delete()) {
            return BackupServiceUtils.createTempDir();
        }
        tempDir.mkdir();
        return tempDir;
    }

    public static boolean deleteTempDir() {
        boolean deleted = true;
        if (tempDir != null) {
            File folderTobedeleted = tempDir;
            logger.info(Message.format((String)RB.getStringResource("BackupServiceUtils.deleting.tempdir.fmt"), (Object)folderTobedeleted.getAbsolutePath()));
            tempDir = null;
            deleted = BackupServiceUtils.deleteFile(folderTobedeleted);
            if (deleted) {
                logger.debug("Deleted " + folderTobedeleted);
            }
        }
        return deleted;
    }

    private static boolean deleteFile(File fileTobedeleted) {
        boolean deleted = false;
        try {
            if (!fileTobedeleted.exists()) {
                return true;
            }
            if (!deleted) {
                deleted = FileUtils.deleteQuietly((File)fileTobedeleted);
            }
            if (!deleted) {
                fileTobedeleted.deleteOnExit();
                logger.debug("File could not be deleted. Setting deleteOnExit flag.");
            }
        }
        catch (Throwable t) {
            logger.warn("Unable to delete " + fileTobedeleted);
        }
        if (deleted) {
            logger.trace("Deleted " + fileTobedeleted);
        } else {
            logger.warn("Couldn't delete " + fileTobedeleted);
        }
        return deleted;
    }

    public static OperationDetails.OperationStatus parseStatus(String status) {
        if (status.equalsIgnoreCase("NotStarted") || status.equalsIgnoreCase("Not_Started")) {
            return OperationDetails.OperationStatus.NOT_STARTED;
        }
        if (status.equalsIgnoreCase("Started") || status.equalsIgnoreCase("INPROGRESS")) {
            return OperationDetails.OperationStatus.INPROGRESS;
        }
        if (status.equalsIgnoreCase("Successful") || status.equalsIgnoreCase("SUCCESS")) {
            return OperationDetails.OperationStatus.SUCCESS;
        }
        if (status.equalsIgnoreCase("Failed") || status.equalsIgnoreCase("FAIL") || status.equalsIgnoreCase("fatal")) {
            return OperationDetails.OperationStatus.FAIL;
        }
        if (status.equalsIgnoreCase("Cancelled") || status.equalsIgnoreCase("Cancel")) {
            return OperationDetails.OperationStatus.CANCELLED;
        }
        return OperationDetails.OperationStatus.UNKNOWN;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Date parseISO8601DateTime(String iso8601) throws ParseException {
        if (iso8601 != null) {
            int len = iso8601.length();
            if (len <= 0) {
                return null;
            }
            if (len > 22 && iso8601.charAt(len - 3) == ':') {
                iso8601 = iso8601.substring(0, len - 3) + iso8601.substring(len - 2);
            }
            SimpleDateFormat simpleDateFormat = BackupServiceConstants.iso8601format;
            synchronized (simpleDateFormat) {
                return BackupServiceConstants.iso8601format.parse(iso8601);
            }
        }
        return null;
    }

    public static <T> List<T> asList(Map<T, T> map) {
        LinkedList<T> list = null;
        if (map != null) {
            list = new LinkedList<T>();
            for (Map.Entry<T, T> entry : map.entrySet()) {
                list.add(entry.getKey());
                list.add(entry.getValue());
            }
        }
        return list;
    }

    public static boolean isHostsEqual(String host1, String host2) {
        InetAddress hostAddress1 = BackupServiceUtils.convertToInetAddress(host1);
        InetAddress hostAddress2 = BackupServiceUtils.convertToInetAddress(host2);
        return hostAddress1 != null && hostAddress1.getHostAddress() != null && hostAddress2 != null && hostAddress2.getHostAddress() != null && hostAddress1.getHostAddress().equals(hostAddress2.getHostAddress());
    }

    public static InetAddress convertToInetAddress(String host) {
        InetAddress address = null;
        try {
            if (!BackupServiceUtils.isEmpty(host)) {
                address = InetAddress.getByName(host);
                logger.debug("Inet address for " + host + " is " + address);
            }
        }
        catch (UnknownHostException unknownHost) {
            logger.error("Unknown host : " + host);
        }
        return address;
    }

    public static boolean isEmpty(Object object) {
        boolean isEmpty = false;
        if (object == null) {
            isEmpty = true;
        } else if (object instanceof String && ((String)object).length() <= 0) {
            isEmpty = true;
        } else if (object instanceof Collection && ((Collection)object).size() <= 0) {
            isEmpty = true;
        } else if (object instanceof Map && ((Map)object).size() <= 0) {
            isEmpty = true;
        } else if (object.getClass().isArray() && ((Object[])object).length <= 0) {
            isEmpty = true;
        }
        return isEmpty;
    }

    public static String getQuotedString(String str) {
        if (str.contains(" ")) {
            str = "\"" + str + "\"";
        }
        return str;
    }

    public static boolean isChild(String parent, String child) {
        boolean isChild = false;
        if (parent != null && child != null) {
            File parentFile = new File(parent);
            File childFile = new File(child);
            parentFile = parentFile.getAbsoluteFile();
            childFile = childFile.getAbsoluteFile();
            for (File childParent = childFile.getParentFile(); childParent != null; childParent = childParent.getParentFile()) {
                if (!parentFile.equals(childParent)) continue;
                isChild = true;
                break;
            }
        }
        return isChild;
    }

    public static String getName(String path) {
        if (path == null) {
            throw new NullPointerException();
        }
        String name = null;
        name = new File(path).getName();
        if (name.indexOf("\\") != -1 || name.indexOf("/") != -1) {
            int unixSepIdx;
            int winSepIdx = path.lastIndexOf("\\");
            int startIdx = winSepIdx > (unixSepIdx = path.lastIndexOf("/")) ? winSepIdx : unixSepIdx;
            name = path.substring(startIdx + 1);
        }
        return name == null ? "" : name;
    }

    public static String getParentPath(String childAbsolutePath) {
        String parent = null;
        if (childAbsolutePath == null) {
            throw new NullPointerException();
        }
        if (childAbsolutePath.indexOf("\\") != -1 || childAbsolutePath.indexOf("/") != -1) {
            int unixSepIdx;
            int winSepIdx = childAbsolutePath.lastIndexOf("\\");
            int endIdx = winSepIdx > (unixSepIdx = childAbsolutePath.lastIndexOf("/")) ? winSepIdx : unixSepIdx;
            parent = childAbsolutePath.substring(0, endIdx);
        }
        return parent == null ? "" : parent;
    }

    public static List<String> decorateParams(List<String> params, String osType) {
        String osFamily = OSUtils.getOSFamily(osType);
        LinkedList<String> newList = new LinkedList<String>(params);
        for (int i = 0; i < params.size(); ++i) {
            String param = params.get(i);
            if (param == null || !param.contains(" ") || param.contains("\"") || !osFamily.equalsIgnoreCase("Windows")) continue;
            logger.debug("Adding double quotes to " + param);
            param = "\"" + param + "\"";
            newList.add(i, param);
            newList.remove(i + 1);
        }
        return newList;
    }

    public static void addDetailsToException(BackupException backupException, BackupSourceNode sourceNode) {
        String errorOriginatingTier = sourceNode.toString();
        if (!BackupServiceUtils.isEmpty(errorOriginatingTier) && backupException.getErrorInfo("errorOriginatingTier") == null) {
            backupException.setErrorInfo("errorOriginatingTier", errorOriginatingTier);
        }
        if (backupException.getErrorInfo("logName") == null) {
            backupException.setErrorInfo("logFileLocation", sourceNode.getConfigDirPath() + "/Backup");
            backupException.setErrorInfo("logName", "backupserver.log");
        }
    }

    public static void addLogDetailsToException(BackupException backupException) {
        String errorOriginatingTier;
        String logName = backupException.getErrorInfo("logName");
        if (logName == null) {
            File logFile = null;
            FileAppender appender = null;
            LoggerContext lc = (LoggerContext)LogManager.getContext((boolean)false);
            Configuration config = lc.getConfiguration();
            if (config.getAppender("SAS_FILE") instanceof FileAppender) {
                appender = (FileAppender)config.getAppender("SAS_FILE");
            }
            if (appender != null) {
                logFile = new File(appender.getFileName());
            }
            if (logFile != null) {
                backupException.setErrorInfo("logName", logFile.getName());
                backupException.setErrorInfo("logFileLocation", logFile.getParent());
            } else {
                backupException.setErrorInfo("logName", DEFAULT_LOGFILE_NAME);
            }
        }
        if ((errorOriginatingTier = backupException.getErrorInfo("errorOriginatingTier")) == null) {
            InetAddress address = null;
            try {
                address = InetAddress.getLocalHost();
                if (address != null) {
                    errorOriginatingTier = address.getCanonicalHostName();
                }
                if (errorOriginatingTier != null) {
                    backupException.setErrorInfo("errorOriginatingTier", errorOriginatingTier);
                }
            }
            catch (Exception e) {
                logger.warn(e.getMessage(), (Throwable)e);
            }
        }
    }

    public static long getDirectorySize(File dir) {
        long dirSize = 0L;
        if (dir.exists()) {
            if (dir.isDirectory()) {
                File[] fileList = dir.listFiles();
                for (int i = 0; i < fileList.length; ++i) {
                    if (fileList[i].isDirectory()) {
                        dirSize += BackupServiceUtils.getDirectorySize(fileList[i]);
                        continue;
                    }
                    dirSize += fileList[i].length();
                }
            } else {
                dirSize = dir.length();
            }
        }
        return dirSize;
    }

    public static <T> List<T> decorateAsList(T t) {
        ArrayList<T> ts = null;
        if (t != null) {
            ts = new ArrayList<T>(1);
            ts.add(t);
        }
        return ts;
    }

    public static <T> T extractAsObject(List<T> ts) {
        if (ts != null && ts.size() > 0) {
            return ts.get(0);
        }
        return null;
    }

    public static <T> T retrieveObject(List<T> ts, T keyObject) {
        T t = null;
        if (ts != null && ts.size() > 0 && keyObject != null) {
            for (T entry : ts) {
                if (entry == null || !entry.equals(keyObject)) continue;
                t = entry;
                break;
            }
        }
        return t;
    }

    public static <T> Set<T> getSetFormCollection(Collection<T> collection) {
        HashSet<T> uniqueElements = new HashSet<T>();
        if (collection != null) {
            uniqueElements.addAll(collection);
        }
        return uniqueElements;
    }

    public static Tuple<String, String> getUserPrincipal(MetadataServerInterface server, String authDomain) throws BackupException {
        try {
            List userids = server.getLoginsForAuthDomain(authDomain);
            UserIdentityInterface user = (UserIdentityInterface)BackupServiceUtils.extractAsObject(userids);
            if (user != null) {
                return new Tuple<String, String>(user.getPrincipal().toString(), user.getCredential().toString());
            }
        }
        catch (RemoteException remoteException) {
        }
        catch (ServiceException serviceException) {
            // empty catch block
        }
        return null;
    }

    public static SASTier createSASTierInstance(String hostAndConfigDir) {
        SASTier sastier = new SASTier();
        String[] strArray = hostAndConfigDir.split(Pattern.quote("|"), 2);
        if (strArray != null && strArray.length > 0) {
            SASHost tierHost = new SASHost();
            tierHost.setHostName(strArray[0]);
            sastier.setTierHost(tierHost);
            if (strArray.length > 1) {
                sastier.setSasConfig(strArray[1]);
            }
        }
        return sastier;
    }

    public static String listtoString(List<String> values, String delim) {
        if (values != null && !values.isEmpty()) {
            String ddelim = delim != null ? delim : ",";
            StringBuilder builder = new StringBuilder();
            for (String value : values) {
                if (value == null || value.trim().isEmpty()) continue;
                if (!builder.toString().trim().isEmpty()) {
                    builder.append(ddelim);
                }
                builder.append(value);
            }
            return builder.toString();
        }
        return null;
    }

    public static String listtoString(List<String> values, String delim, String prefix) {
        if (values != null && !values.isEmpty()) {
            String ddelim = delim != null ? delim : ",";
            StringBuilder builder = new StringBuilder();
            for (String value : values) {
                if (value == null || value.trim().isEmpty()) continue;
                if (!builder.toString().trim().isEmpty()) {
                    builder.append(ddelim);
                }
                builder.append(prefix + value);
            }
            return builder.toString();
        }
        return null;
    }

    public static BackupSourceConfig.BackupSource getBackupSource(String sourceTypeDisplayName) {
        BackupSourceConfig.BackupSource sourceType = null;
        if (sourceTypeDisplayName != null && !sourceTypeDisplayName.isEmpty()) {
            for (BackupSourceConfig.BackupSource source : BackupSourceConfig.BackupSource.values()) {
                if (!source.getDisplayName().equalsIgnoreCase(sourceTypeDisplayName.toUpperCase())) continue;
                sourceType = source;
                break;
            }
        }
        return sourceType;
    }

    public static class Tuple<T, V> {
        private T key;
        private V value;

        public Tuple(T key, V value) {
            this.key = key;
            this.value = value;
        }

        public T getKey() {
            return this.key;
        }

        public V getValue() {
            return this.value;
        }
    }
}

