/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.backup.dao;

import com.sas.services.information.metadata.SoftwareComponentInterface;
import com.sas.solstice.platform.core.access.IResults;
import com.sas.svcs.authentication.helper.FoundationServicesUserSessionFactory;
import com.sas.svcs.backup.analyze.BackupTask;
import com.sas.svcs.backup.analyze.model.RuntimeSASEnvironment;
import com.sas.svcs.backup.client.BackupServiceSession;
import com.sas.svcs.backup.client.BackupSourceConfig;
import com.sas.svcs.backup.client.BackupSourceDetails;
import com.sas.svcs.backup.client.BackupSourceEntryDetails;
import com.sas.svcs.backup.client.BackupSourceInstanceDetails;
import com.sas.svcs.backup.client.BackupSourceNode;
import com.sas.svcs.backup.client.OperationDetails;
import com.sas.svcs.backup.client.ServerSideBackupArchiveResult;
import com.sas.svcs.backup.client.ServerSideResult;
import com.sas.svcs.backup.common.definitions.BackupErrorConstants;
import com.sas.svcs.backup.common.definitions.BackupException;
import com.sas.svcs.backup.dao.BackupServerContext;
import com.sas.svcs.backup.dao.BackupServiceUtils;
import com.sas.svcs.backup.dao.ConfigBeanConverter;
import com.sas.svcs.backup.dao.DeploymentAgentClient;
import com.sas.svcs.backup.dao.OMRDeploymentBackupConfiguration;
import com.sas.svcs.backup.dao.OSUtils;
import com.sas.svcs.backup.dao.RB;
import com.sas.text.Message;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Repository;

@Repository(value="BackupServerHelperDAO")
public class BackupServerHelperDAO {
    private static final Logger logger = LogManager.getLogger(BackupServerHelperDAO.class);
    @Autowired
    @Qualifier(value="DeploymentBackupConfiguration")
    private OMRDeploymentBackupConfiguration backupConfiguration;
    @Autowired
    private FoundationServicesUserSessionFactory userSessionFactory;
    @Autowired
    ConfigBeanConverter configBeanConverter;
    public static final String CONFIGPROP_SCS_JNDI_NAME = "webappsrv.jdbc.jndi.name";
    public static final String CONFIGPROP_SCS_JDBC_DRIVER = "webappsrv.jdbc.driver";
    public static final String CONFIGPROP_SCS_JDBC_URL = "webappsrv.jdbc.url";
    private static final String SASINFRA_SERVERCOMPONENT_CLASSIDENTIFIER = "SASInfrastructureData";
    private static final String SASWEBAPP_SERVERCOMPONENT_CLASSIDENTIFIER = "webappsrv";
    public static final String ISCHILD = "ischild";
    public static final String BACKUP_SERVER_EMPTY_STRING_PARAM = "emptystring";

    public void initSessionStart(BackupSourceNode sourceNode, String operation, BackupServiceSession session) throws BackupException {
        this.initSessionStart(sourceNode, operation, session, false);
    }

    public void initSessionStart(BackupSourceNode sourceNode, String operation, BackupServiceSession session, boolean syncDown) throws BackupException {
        String tempResultPath = null;
        String sessionId = session.getSessionId();
        IResults agentresult = null;
        try {
            BackupServerContext context = BackupServerContext.getInstance(this.backupConfiguration, sourceNode);
            String hostName = sourceNode.getHostName();
            String backupServerPath = context.getBackupServerPath();
            String isPrimaryNode = String.valueOf(sourceNode.isPrimary());
            List<String> commands = this.getBasicExecCommand(sourceNode);
            commands.add(backupServerPath + "/" + context.getBackupServerExecutableName());
            commands.add("session");
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("-client", "BackupService");
            params.put("-configbase", backupServerPath);
            params.put("-sessionid", sessionId);
            params.put("-operation", operation);
            params.put("-isprimary", isPrimaryNode);
            String sharedVault = this.backupConfiguration.getSharedVaultLocation();
            this.addSharedVaultParamIfSpecified(sharedVault, params);
            if (syncDown) {
                params.put("-syncdown", "");
            } else {
                params.put("-start", "");
            }
            commands.addAll(BackupServiceUtils.asList(params));
            commands = BackupServiceUtils.decorateParams(commands, sourceNode.getOsType());
            this.printCommandInLog(commands);
            String[] paramArrayOfString = commands.toArray(new String[commands.size()]);
            logger.info("initSessionStart");
            agentresult = DeploymentAgentClient.handleArgLine(paramArrayOfString, paramArrayOfString);
            tempResultPath = this.getResult(backupServerPath, sessionId, hostName, "session", null);
        }
        catch (BackupException e) {
            try {
                if (e.getErrorInfo("operationType") == null) {
                    e.setErrorInfo("operationType", "session");
                }
                if (e.getErrorInfo("errorOriginatingTier") == null) {
                    BackupServiceUtils.addDetailsToException(e, sourceNode);
                }
                throw e;
            }
            catch (Throwable throwable) {
                this.parseResult(sourceNode, tempResultPath, agentresult, session, BackupErrorConstants.ErrorCodes.ERROR_CODE_SESSION_START_FAILED);
                throw throwable;
            }
        }
        this.parseResult(sourceNode, tempResultPath, agentresult, session, BackupErrorConstants.ErrorCodes.ERROR_CODE_SESSION_START_FAILED);
    }

    public void initSessionEnd(BackupSourceNode sourceNode, String operation, BackupServiceSession session, boolean onlySync) throws BackupException {
        String tempResultPath = null;
        IResults agentresult = null;
        try {
            BackupServerContext context = BackupServerContext.getInstance(this.backupConfiguration, sourceNode);
            String hostName = sourceNode.getHostName();
            String backupServerPath = context.getBackupServerPath();
            String isPrimaryNode = String.valueOf(sourceNode.isPrimary());
            List<String> commands = this.getBasicExecCommand(sourceNode);
            commands.add(backupServerPath + "/" + context.getBackupServerExecutableName());
            commands.add("session");
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("-client", "BackupService");
            params.put("-configbase", backupServerPath);
            params.put("-sessionid", session.getSessionId());
            params.put("-operation", operation);
            params.put("-isprimary", isPrimaryNode);
            String sharedVault = this.backupConfiguration.getSharedVaultLocation();
            this.addSharedVaultParamIfSpecified(sharedVault, params);
            if (onlySync) {
                params.put("-synchup", "");
            } else {
                params.put("-end", "");
            }
            commands.addAll(BackupServiceUtils.asList(params));
            commands = BackupServiceUtils.decorateParams(commands, sourceNode.getOsType());
            this.printCommandInLog(commands);
            String[] paramArrayOfString = commands.toArray(new String[commands.size()]);
            logger.info("initSessionEnd");
            agentresult = DeploymentAgentClient.handleArgLine(paramArrayOfString, paramArrayOfString);
            tempResultPath = this.getResult(backupServerPath, session.getSessionId(), hostName, "session", null);
        }
        catch (BackupException e) {
            try {
                if (e.getErrorInfo("operationType") == null) {
                    e.setErrorInfo("operationType", "session");
                }
                if (e.getErrorInfo("errorOriginatingTier") == null) {
                    BackupServiceUtils.addDetailsToException(e, sourceNode);
                }
                throw e;
            }
            catch (Throwable throwable) {
                this.parseResult(sourceNode, tempResultPath, agentresult, session, BackupErrorConstants.ErrorCodes.ERROR_CODE_SESSION_END_FAILED);
                throw throwable;
            }
        }
        this.parseResult(sourceNode, tempResultPath, agentresult, session, BackupErrorConstants.ErrorCodes.ERROR_CODE_SESSION_END_FAILED);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public BackupSourceDetails backup(RuntimeSASEnvironment runtimeSASEnvironment, BackupTask backupTask, BackupServiceSession<?> session, Map<String, String> optionalProps, BackupErrorConstants.ErrorCodes errorTobeUsed) throws BackupException {
        String sessionId = session.getSessionId();
        BackupSourceConfig sourceConfig = this.configBeanConverter.backupTaskToSourceConfig(backupTask, runtimeSASEnvironment.getPrimaryMetdataTier());
        BackupSourceDetails sourceBackup = new BackupSourceDetails(sourceConfig);
        String tempResultPath = null;
        IResults result = null;
        BackupSourceNode sourceNode = sourceConfig.getBackupSourceNode();
        try {
            BackupSourceConfig.BackupSource sourceType = sourceConfig.getSourceType();
            String hostName = sourceNode.getHostName();
            BackupServerContext context = BackupServerContext.getInstance(this.backupConfiguration, sourceNode, sourceType);
            String backupServerPath = context.getBackupServerPath();
            List<String> commands = this.createCommand("backup", sourceBackup, session);
            if (optionalProps != null && optionalProps.size() != 0) {
                commands.addAll(BackupServiceUtils.asList(optionalProps));
            }
            commands = BackupServiceUtils.decorateParams(commands, sourceNode.getOsType());
            this.printCommandInLog(commands);
            String[] paramArrayOfString = commands.toArray(new String[commands.size()]);
            logger.info("backup");
            result = DeploymentAgentClient.handleArgLine(paramArrayOfString, paramArrayOfString);
            logger.debug("Backup Server executed with status:" + result.getStatus() + " Sub status: " + result.getSubstatus());
            tempResultPath = this.getResult(backupServerPath, sessionId, hostName, "backup", BackupServerCommandConstants.SOURCE_TYPE_PARAMS.get(sourceType.toString()));
            this.populateResult(sourceBackup, tempResultPath, result, session, errorTobeUsed);
        }
        catch (BackupException e) {
            this.addDetailsForBackupOperationAndThrow(e, sourceNode);
        }
        catch (Throwable t) {
            BackupException e2 = new BackupException(errorTobeUsed.getErrorCode());
            this.addDetailsForBackupOperationAndThrow(e2, sourceNode);
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
            this.populateResult(sourceBackup, tempResultPath, result, session, errorTobeUsed);
        }
        finally {
            this.populateResult(sourceBackup, tempResultPath, result, session, errorTobeUsed);
        }
        return sourceBackup;
    }

    private void addDetailsForBackupOperationAndThrow(BackupException e, BackupSourceNode sourceNode) throws BackupException {
        if (e.getErrorInfo("operationType") == null) {
            e.setErrorInfo("operationType", "backup");
        }
        if (e.getErrorInfo("errorOriginatingTier") == null) {
            BackupServiceUtils.addDetailsToException(e, sourceNode);
        }
        throw e;
    }

    private int parseResult(IResults result) {
        int intResult = 0;
        logger.info("status: " + result.getStatus() + " SubStatus:" + result.getSubstatus() + " Message:" + result.getMessage());
        if (result.getStatus() != 0) {
            intResult = BackupErrorConstants.ErrorCodes.ERROR_CODE_UNKNOWN.getErrorCode();
        }
        if (result.getSubstatus() != 0) {
            intResult = result.getSubstatus();
        }
        if (result.getException() != null) {
            logger.error((Object)result.getException());
            result.getException().printStackTrace();
            intResult = BackupErrorConstants.ErrorCodes.ERROR_CODE_UNKNOWN.getErrorCode();
        }
        return intResult;
    }

    private int parseResultMessage(IResults result) throws Throwable {
        int intResult;
        block3: {
            intResult = 0;
            try {
                if (result == null || result.getMessage() == null) break block3;
                String message = result.getMessage();
                logger.debug("SDA's message is : " + message);
                Pattern p = Pattern.compile("(Return\\s?code:\\s*\")(\\d+)");
                Matcher m = p.matcher(message);
                if (!m.find()) break block3;
                if (m.groupCount() == 2) {
                    String actualReturnCodeString = m.group(2);
                    logger.warn("SAS Deployment Agent has a error messsage :" + result.getMessage());
                    logger.warn("SAS Deployment Agent Message has error code : " + actualReturnCodeString);
                    intResult = Integer.parseInt(actualReturnCodeString);
                    logger.warn("SAS Deployment Agent Message has error code : " + intResult);
                    break block3;
                }
                return -1;
            }
            catch (Throwable t) {
                logger.warn("Parsing of deployment agent result failed !!" + t.getMessage());
                throw t;
            }
        }
        return intResult;
    }

    public BackupSourceDetails recover(BackupSourceDetails sourceBackup, BackupServiceSession session, Map<String, String> optionalProps, BackupErrorConstants.ErrorCodes errorTobeUsed) throws BackupException {
        BackupSourceDetails sourceRecovery = new BackupSourceDetails(sourceBackup);
        BackupSourceConfig sourceConfig = sourceBackup.getSourceConfig();
        String tempResultPath = null;
        IResults result = null;
        BackupSourceNode sourceNode = sourceConfig.getBackupSourceNode();
        try {
            BackupSourceConfig.BackupSource sourceType = sourceConfig.getSourceType();
            String hostName = sourceNode.getHostName();
            BackupServerContext context = BackupServerContext.getInstance(this.backupConfiguration, sourceNode, sourceType);
            String backupServerPath = context.getBackupServerPath();
            List<String> commands = this.createCommand("recover", sourceRecovery, session);
            if (optionalProps != null && optionalProps.size() != 0) {
                commands.addAll(BackupServiceUtils.asList(optionalProps));
            }
            commands = BackupServiceUtils.decorateParams(commands, sourceNode.getOsType());
            this.printCommandInLog(commands);
            String[] paramArrayOfString = commands.toArray(new String[commands.size()]);
            logger.info("recover");
            result = DeploymentAgentClient.handleArgLine(paramArrayOfString, paramArrayOfString);
            logger.info("Backup Server executed");
            logger.info(Message.format((String)RB.getStringResource("BackupServerHelperDAO.backupserver.status.fmt"), (Object)result.getStatus()));
            tempResultPath = this.getResult(backupServerPath, session.getSessionId(), hostName, "recover", BackupServerCommandConstants.SOURCE_TYPE_PARAMS.get(sourceType.toString()));
        }
        catch (BackupException e) {
            try {
                if (e.getErrorInfo("operationType") == null) {
                    e.setErrorInfo("operationType", "recover");
                }
                if (e.getErrorInfo("errorOriginatingTier") == null) {
                    BackupServiceUtils.addDetailsToException(e, sourceNode);
                }
                throw e;
            }
            catch (Throwable throwable) {
                this.populateResult(sourceRecovery, tempResultPath, result, session, errorTobeUsed);
                sourceRecovery.setBackupLocation(sourceBackup.getBackupLocation());
                sourceRecovery.setSize(sourceBackup.getSize());
                throw throwable;
            }
        }
        this.populateResult(sourceRecovery, tempResultPath, result, session, errorTobeUsed);
        sourceRecovery.setBackupLocation(sourceBackup.getBackupLocation());
        sourceRecovery.setSize(sourceBackup.getSize());
        return sourceRecovery;
    }

    public boolean purge(Set<BackupSourceNode> sourceNodes, String backupSessionId, BackupServiceSession session) throws BackupException {
        return this.purge(sourceNodes, backupSessionId, session, null);
    }

    private boolean purge(Set<BackupSourceNode> sourceNodes, String backupSessionId, BackupServiceSession session, String purgeBeforeDate) throws BackupException {
        boolean result = true;
        String currentSessionId = session.getSessionId();
        for (BackupSourceNode sourceNode : sourceNodes) {
            if (!this.backupConfiguration.isBackupServerAlreadyConfigured(sourceNode)) continue;
            try {
                HashMap<String, String> params = new HashMap<String, String>();
                String hostName = sourceNode.getHostName();
                if (StringUtils.isNotBlank((CharSequence)purgeBeforeDate)) {
                    logger.debug("Sending purge command with  purgeBeforeDate: " + purgeBeforeDate + " to Backup Server on" + hostName);
                    params.put("-beforedate", purgeBeforeDate);
                } else {
                    logger.debug("Sending purge command with backup id " + backupSessionId + " to Backup Server on" + hostName);
                    params.put("-backupid", backupSessionId);
                }
                BackupServerContext context = BackupServerContext.getInstance(this.backupConfiguration, sourceNode);
                String backupServerPath = context.getBackupServerPath();
                List<String> commands = this.getBasicExecCommand(sourceNode);
                commands.add(backupServerPath + "/" + context.getBackupServerExecutableName());
                commands.add("purge");
                params.put("-client", "BackupService");
                params.put("-configbase", backupServerPath);
                params.put("-sessionid", currentSessionId);
                String sharedVault = this.backupConfiguration.getSharedVaultLocation();
                this.addSharedVaultParamIfSpecified(sharedVault, params);
                commands.addAll(BackupServiceUtils.asList(params));
                commands = BackupServiceUtils.decorateParams(commands, sourceNode.getOsType());
                this.printCommandInLog(commands);
                String[] paramArrayOfString = commands.toArray(new String[commands.size()]);
                logger.info("purge");
                IResults agentresult = DeploymentAgentClient.handleArgLine(paramArrayOfString, paramArrayOfString);
                String tempResultPath = this.getResult(backupServerPath, session.getSessionId(), hostName, "purge", null);
                logger.info(Message.format((String)RB.getStringResource("BackupServerHelperDAO.backupserver.status.fmt"), (Object)this.parseResult(sourceNode, tempResultPath, agentresult, session, BackupErrorConstants.ErrorCodes.ERROR_CODE_PURGE_FAILED)));
                int intResult = this.parseResult(agentresult);
                if (intResult == 0 && commands.contains("doExecAsUserTimed")) {
                    try {
                        intResult = this.parseResultMessage(agentresult);
                        if (intResult == -1) {
                            logger.warn("SAS Deployment Agent's returned result object returned by server for purge command has error: " + agentresult.getMessage());
                            logger.warn("SAS Deployment Agent's returned result object returned by server for purge command can not be read. ");
                        }
                    }
                    catch (Throwable t) {
                        logger.warn("SAS Deployment Agent's returned result object returned by server for purge command can not be read. ");
                    }
                }
                if (intResult == 0) continue;
                logger.error(Message.format((String)RB.getStringResource("BackupServerHelperDAO.backupserver.status.fmt"), (Object)this.parseResult(agentresult)));
                logger.error(Message.format((String)RB.getStringResource("BackupServerHelperDAO.BackupOperation.Failed.on.host.fmt"), (Object)hostName));
                result = false;
            }
            catch (BackupException e) {
                logger.error(Message.format((String)RB.getStringResource("BackupServerHelperDAO.backupserver.status.fmt"), (Object)e.getErrorCode()));
                logger.error(Message.format((String)RB.getStringResource("BackupServerHelperDAO.BackupOperation.Failed.on.host.fmt"), (Object)sourceNode));
                result = false;
                BackupServiceUtils.addDetailsToException(e, sourceNode);
                if (e.getErrorInfo("operationType") == null) {
                    e.setErrorInfo("operationType", "purge");
                }
                session.getResult().addException(e);
            }
        }
        return result;
    }

    public boolean purgeRemainingFiles(Set<BackupSourceNode> sourceNodes, BackupServiceSession session, String purgeBeforeDate) throws BackupException {
        return this.purge(sourceNodes, null, session, purgeBeforeDate);
    }

    public ServerSideBackupArchiveResult archiveAndSessionEnd(BackupSourceNode sourceNode, BackupServiceSession session, String centralVaultPath, String backupid, String way, String metadataBackupPath, boolean isSessionend, boolean forced) throws BackupException {
        boolean result = true;
        ServerSideBackupArchiveResult serverBackupResult = (ServerSideBackupArchiveResult)ServerSideResult.getEmptyInstance(ServerSideBackupArchiveResult.class);
        String sessionId = session.getSessionId();
        String hostName = sourceNode.getHostName();
        try {
            logger.debug("Sending archive, sessionend command with session id " + sessionId + " to Backup Server on" + sourceNode);
            BackupServerContext context = BackupServerContext.getInstance(this.backupConfiguration, sourceNode);
            String backupServerPath = context.getBackupServerPath();
            String metadataServerVaultBase = null;
            if (sourceNode.isMetadataTier()) {
                metadataServerVaultBase = sourceNode.getConfigDirPath() + "/" + "SASMeta/MetadataServer";
            }
            List<String> commands = this.getBasicExecCommand(sourceNode);
            commands.add(backupServerPath + "/" + context.getBackupServerExecutableName());
            commands.add("archive");
            if (isSessionend) {
                commands.add("-sessionend");
            }
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("-client", "BackupService");
            params.put("-configbase", backupServerPath);
            params.put("-sessionid", sessionId);
            this.addSharedVaultParamIfSpecified(centralVaultPath, params);
            params.put("-backupid", backupid);
            if (forced) {
                params.put("-force", "");
            }
            if (sourceNode.isMetadataTier() && metadataBackupPath != null && metadataServerVaultBase != "") {
                params.put("-metadatastaging", metadataBackupPath);
            }
            params.put("-way", way);
            commands.addAll(BackupServiceUtils.asList(params));
            commands = BackupServiceUtils.decorateParams(commands, sourceNode.getOsType());
            this.printCommandInLog(commands);
            String[] paramArrayOfString = commands.toArray(new String[commands.size()]);
            logger.info("archiveAndSessionEnd");
            IResults agentresult = DeploymentAgentClient.handleArgLine(paramArrayOfString, paramArrayOfString);
            logger.info("Backup Server executed");
            String tempResultPath = this.getResult(backupServerPath, sessionId, hostName, "archive", null);
            ServerSideResult serverResult = this.parseResult(sourceNode, tempResultPath, agentresult, session, BackupErrorConstants.ErrorCodes.ERROR_CODE_ARCHIVE_FAILED);
            int serverSideStatus = serverResult.getServerSideResult();
            if (serverSideStatus == 0 && commands.contains("doExecAsUserTimed")) {
                try {
                    serverSideStatus = this.parseResultMessage(agentresult);
                    if (serverSideStatus == -1) {
                        logger.warn("SAS Deployment Agent's returned result object returned by server can not be read. ");
                    }
                }
                catch (Throwable t) {
                    logger.warn("SAS Deployment Agent's returned result object returned by server can not be read. ");
                }
            }
            if (serverSideStatus != 0) {
                serverResult.updateStatusCode(serverSideStatus);
                BackupException backupException = new BackupException(agentresult.getMessage(), serverSideStatus);
                BackupServiceUtils.addDetailsToException(backupException, sourceNode);
                session.getResult().addException(backupException);
                logger.error(Message.format((String)RB.getStringResource("BackupServerHelperDAO.backupserver.status.fmt"), (Object)serverSideStatus));
                logger.error(Message.format((String)RB.getStringResource("BackupServerHelperDAO.BackupOperation.Failed.on.host.fmt"), (Object)hostName));
                result = false;
            }
            if (!serverResult.isEmpty()) {
                serverBackupResult = ServerSideResult.getArchiveResult((Properties)serverResult.getAllProperties(), (int)serverResult.getServerSideResult());
            }
            logger.info(Message.format((String)RB.getStringResource("BackupServerHelperDAO.backupserver.status.fmt"), (Object)serverSideStatus));
        }
        catch (BackupException e) {
            logger.error(Message.format((String)RB.getStringResource("BackupServerHelperDAO.backupserver.status.fmt"), (Object)e.getErrorCode()));
            logger.error(Message.format((String)RB.getStringResource("BackupServerHelperDAO.BackupOperation.Failed.on.host.fmt"), (Object)hostName));
            if (e.getErrorInfo("operationType") == null) {
                e.setErrorInfo("operationType", "archive");
            }
            if (e.getErrorInfo("errorOriginatingTier") == null) {
                BackupServiceUtils.addDetailsToException(e, sourceNode);
            }
            throw e;
        }
        return serverBackupResult;
    }

    public boolean postRecover(BackupSourceNode sourceNode, Map<String, String> optionalProps, BackupServiceSession session, boolean isSCSPresent, boolean isSuccessful) throws BackupException {
        boolean result = true;
        IResults agentresult = null;
        String sessionId = session.getSessionId();
        logger.debug("Sending postrecover command with session id " + sessionId + " to Backup Server on" + sourceNode);
        String hostName = sourceNode.getHostName();
        try {
            String sasHome;
            BackupServerContext context = BackupServerContext.getInstance(this.backupConfiguration, sourceNode);
            String backupServerPath = context.getBackupServerPath();
            String sharedVault = this.backupConfiguration.getSharedVaultLocation();
            List<String> commands = this.getBasicExecCommand(sourceNode);
            commands.add(backupServerPath + "/" + context.getBackupServerExecutableName());
            commands.add("postrecover");
            HashMap<String, String> params = new HashMap<String, String>();
            String sasroot = sourceNode.getSasHome() + "/" + "SASFoundation" + "/" + "9.4";
            if (sasroot.contains(" ")) {
                sasroot = "\"" + sasroot + "\"";
            }
            if ((sasHome = sourceNode.getSasHome()).contains(" ")) {
                sasHome = "\"" + sasHome + "\"";
            }
            params.put("-client", "BackupService");
            params.put("-configbase", backupServerPath);
            params.put("-sashome", sasHome);
            params.put("-sasroot", sasroot);
            params.put("-sessionid", sessionId);
            if (sharedVault != null && !sharedVault.equals("")) {
                params.put("-sharedvaultpresent", sharedVault);
            }
            if (params != null && params.size() != 0) {
                commands.addAll(BackupServiceUtils.asList(params));
            }
            if (optionalProps != null && optionalProps.size() != 0) {
                commands.addAll(BackupServiceUtils.asList(optionalProps));
            }
            if (isSCSPresent) {
                commands.add("-scspresent");
            }
            if (isSuccessful) {
                commands.add("-recoverysuccessful");
            }
            commands = BackupServiceUtils.decorateParams(commands, sourceNode.getOsType());
            this.printCommandInLog(commands);
            String[] paramArrayOfString = commands.toArray(new String[commands.size()]);
            logger.info("postRecover");
            agentresult = DeploymentAgentClient.handleArgLine(paramArrayOfString, paramArrayOfString);
            logger.info("Backup Server executed for post recovery");
            String tempResultPath = this.getResult(backupServerPath, sessionId, hostName, "postrecover", null);
            ServerSideResult serverResult = this.parseResult(sourceNode, tempResultPath, agentresult, session, BackupErrorConstants.ErrorCodes.ERROR_CODE_UNKNOWN);
            int serverSideStatus = serverResult.getServerSideResult();
            logger.info(Message.format((String)RB.getStringResource("BackupServerHelperDAO.backupserver.status.fmt"), (Object)serverSideStatus));
            if (serverSideStatus == 0 && commands.contains("doExecAsUserTimed")) {
                try {
                    serverSideStatus = this.parseResultMessage(agentresult);
                    if (serverSideStatus == -1) {
                        logger.warn("SAS Deployment Agent's returned result object returned by server for configure postrecover can not be read. ");
                    }
                }
                catch (Throwable t) {
                    logger.warn("SAS Deployment Agent's returned result object returned by server for postrecover command can not be read. ");
                }
            }
            if (serverSideStatus != 0) {
                session.getResult().addException(new BackupException(agentresult.getMessage(), serverSideStatus));
                logger.error(Message.format((String)RB.getStringResource("BackupServerHelperDAO.backupserver.status.fmt"), (Object)serverSideStatus));
                logger.error(Message.format((String)RB.getStringResource("BackupServerHelperDAO.BackupOperation.Failed.on.host.fmt"), (Object)hostName));
                result = false;
            }
        }
        catch (BackupException e) {
            logger.error(Message.format((String)RB.getStringResource("BackupServerHelperDAO.backupserver.status.fmt"), (Object)e.getErrorCode()));
            logger.error(Message.format((String)RB.getStringResource("BackupServerHelperDAO.BackupOperation.Failed.on.host.fmt"), (Object)hostName));
            if (e.getErrorInfo("operationType") == null) {
                e.setErrorInfo("operationType", "postrecover");
            }
            if (e.getErrorInfo("errorOriginatingTier") == null) {
                BackupServiceUtils.addDetailsToException(e, sourceNode);
            }
            throw e;
        }
        return result;
    }

    private void addSharedVaultParamIfSpecified(String centralVaultPath, Map<String, String> params) {
        if (centralVaultPath != null) {
            if (centralVaultPath.isEmpty()) {
                centralVaultPath = BACKUP_SERVER_EMPTY_STRING_PARAM;
            }
            params.put("-sharedvaultbase", centralVaultPath);
        }
    }

    private List<String> getBasicExecCommand(BackupSourceNode node) {
        String hostName = node.getHostName();
        LinkedList<String> basicCommand = new LinkedList<String>();
        boolean isBackupUserConfigured = false;
        Map<Object, Object> logininfo = new HashMap();
        try {
            isBackupUserConfigured = this.backupConfiguration.isBackupUserEnabled();
            if (isBackupUserConfigured) {
                logininfo = this.backupConfiguration.getBackupUserLoginInfo();
            }
        }
        catch (Throwable t) {
            isBackupUserConfigured = false;
            logger.warn("Unable to retrieve backup user login information.");
        }
        String osType = node.getOsType();
        String osFamily = OSUtils.getOSFamily(osType);
        if (isBackupUserConfigured && !BackupServiceUtils.isEmpty(logininfo) && "Windows".equalsIgnoreCase(osFamily)) {
            String userid = (String)logininfo.get("loginUsername");
            String password = (String)logininfo.get("loginPassword");
            String domain = (String)logininfo.get("loginDomain");
            basicCommand.add("doExecAsUserTimed");
            basicCommand.add(hostName);
            basicCommand.add("86400");
            basicCommand.add(userid);
            basicCommand.add(password);
            basicCommand.add(domain);
        } else {
            basicCommand.add("doExecTimed");
            basicCommand.add(hostName);
            basicCommand.add("86400");
        }
        return basicCommand;
    }

    private List<String> createCommand(String operation, BackupSourceDetails sourceDetails, BackupServiceSession session) throws BackupException {
        String sasHome;
        if (operation == null) {
            throw new IllegalArgumentException();
        }
        String sessionId = session.getSessionId();
        BackupSourceConfig sourceConfig = sourceDetails.getSourceConfig();
        BackupSourceConfig.BackupSource sourceType = sourceConfig.getSourceType();
        String sourceTypeParam = null;
        BackupSourceNode sourceNode = sourceConfig.getBackupSourceNode();
        String hostName = sourceNode.getHostName();
        BackupServerContext context = BackupServerContext.getInstance(this.backupConfiguration, sourceNode, sourceType);
        String backupServerPath = context.getBackupServerPath();
        List<String> commands = this.getBasicExecCommand(sourceNode);
        commands.add(backupServerPath + "/" + context.getBackupServerExecutableName());
        commands.add(operation);
        String sasroot = sourceNode.getSasHome() + "/" + "SASFoundation" + "/" + "9.4";
        if (sasroot.contains(" ")) {
            sasroot = "\"" + sasroot + "\"";
        }
        if ((sasHome = sourceNode.getSasHome()).contains(" ")) {
            sasHome = "\"" + sasHome + "\"";
        }
        String sharedVault = this.backupConfiguration.getSharedVaultLocation();
        if (sourceType != null) {
            sourceTypeParam = BackupServerCommandConstants.SOURCE_TYPE_PARAMS.get(sourceType.toString());
        }
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("-client", "BackupService");
        params.put("-configbase", backupServerPath);
        params.put("-sashome", sasHome);
        params.put("-sasroot", sasroot);
        params.put("-sessionid", sessionId);
        if ("backup".equalsIgnoreCase(operation)) {
            params.put("-source", sourceTypeParam);
        } else if ("recover".equalsIgnoreCase(operation)) {
            params.put("-source", sourceTypeParam);
        } else if (!"purge".equalsIgnoreCase(operation)) {
            logger.error(RB.getStringResource("BackupServerHelperDAO.Inavlid.Operation.For.BackupServer.txt"));
        }
        this.addSharedVaultParamIfSpecified(sharedVault, params);
        commands.addAll(BackupServiceUtils.asList(params));
        return commands;
    }

    private String getResult(String backupServerPath, String sessionId, String hostName, String commandName, String handlerDecider) {
        String tempResultPath = null;
        String resultPath = null;
        try {
            File tempDir = BackupServiceUtils.getTempDir();
            if (handlerDecider != null) {
                resultPath = backupServerPath + "/" + "Results" + "/" + sessionId + "/" + commandName + "/" + handlerDecider + "/" + "result.properties";
                tempResultPath = tempDir.getCanonicalPath() + "/" + sessionId + "/" + handlerDecider + "/" + Math.random() + "_result.properties";
            } else {
                resultPath = backupServerPath + "/" + "Results" + "/" + sessionId + "/" + commandName + "/" + "result.properties";
                tempResultPath = tempDir.getCanonicalPath() + "/" + sessionId + "/" + Math.random() + "_result.properties";
            }
            String[] paramsGetResult = new String[]{"pullFile", hostName, resultPath, tempResultPath};
            logger.debug("Trying to copy " + resultPath);
            logger.info("getResult");
            IResults copyResult = DeploymentAgentClient.handleArgLine(paramsGetResult, paramsGetResult);
            if (copyResult.getStatus() != 0) {
                logger.error(Message.format((String)RB.getStringResource("BackupServerHelperDAO.Error.copying.resultfile.fmt"), (Object)resultPath));
            }
            logger.debug(resultPath + " copied at " + tempResultPath);
        }
        catch (Throwable t) {
            logger.error(Message.format((String)RB.getStringResource("BackupServerHelperDAO.ErrorPulliing.Results.fmt"), resultPath, (Object)hostName));
        }
        return tempResultPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ServerSideResult parseResult(BackupSourceNode sourceNode, String propertiePath, IResults result, BackupServiceSession session, BackupErrorConstants.ErrorCodes errorTobeUsed) throws BackupException {
        block30: {
            block29: {
                if (errorTobeUsed == null) {
                    errorTobeUsed = BackupErrorConstants.ErrorCodes.ERROR_CODE_GET_BACKUPSERVER_FILE_FAILED;
                }
                backupException = null;
                tempRetCode = BackupErrorConstants.ErrorCodes.ERROR_CODE_UNKNOWN.getErrorCode();
                resultProp = new Properties();
                if (propertiePath == null) break block30;
                propsFile = new File(propertiePath);
                fis = null;
                try {
                    block33: {
                        block31: {
                            block32: {
                                if (!propsFile.exists()) break block31;
                                fis = new FileInputStream(propsFile);
                                resultProp.load(fis);
                                tempRetCode = Integer.parseInt(resultProp.getProperty("status"));
                                backupExceptionPath = resultProp.getProperty("backup.exception.object.path");
                                if (BackupServiceUtils.isEmpty(backupExceptionPath)) break block32;
                                backupExceptionFile = this.getFile(sourceNode.getHostName(), backupExceptionPath, BackupErrorConstants.ErrorCodes.ERROR_CODE_GET_BACKUPSERVER_FILE_FAILED);
                                if (backupExceptionFile != null) {
                                    ois = null;
                                    fis1 = null;
                                    try {
                                        fis1 = new FileInputStream(backupExceptionFile);
                                        ois = new ObjectInputStream(fis1);
                                        obj = ois.readObject();
                                        if (!(obj instanceof BackupException)) ** GOTO lbl50
                                        backupException = (BackupException)obj;
                                        tempRetCode = backupException.getErrorCode();
                                    }
                                    catch (Exception e) {
                                        BackupServerHelperDAO.logger.error("Unable to deserialize BackupException", (Throwable)e);
                                    }
                                    finally {
                                        try {
                                            if (ois != null) {
                                                ois.close();
                                            }
                                            if (fis1 != null) {
                                                fis1.close();
                                            }
                                        }
                                        catch (Exception var15_21) {}
                                    }
                                }
                                break block33;
                            }
                            if (tempRetCode != BackupErrorConstants.ErrorCodes.OK.getErrorCode()) {
                                backupException = new BackupException("Status returned by backup server is other than SUCCESS.", tempRetCode);
                            }
                            break block33;
                        }
                        BackupServerHelperDAO.logger.info("parsing result");
                        tempRetCode = this.parseResult(result);
                        if (tempRetCode != BackupErrorConstants.ErrorCodes.OK.getErrorCode()) {
                            backupException = new BackupException("Status returned by backup server is other than SUCCESS.", tempRetCode);
                        }
                    }
                    if (fis == null) break block29;
                }
                catch (IOException e) {
                    try {
                        throw new BackupException(RB.getStringResource("BackupServerHelperDAO.Error.parsing.backup.txt"), (Throwable)e, errorTobeUsed.getErrorCode());
                        catch (NumberFormatException e) {
                            throw new BackupException(RB.getStringResource("BackupServerHelperDAO.Error.parsing.backup.txt"), (Throwable)e, errorTobeUsed.getErrorCode());
                        }
                    }
                    catch (Throwable var18_24) {
                        if (fis != null) {
                            try {
                                fis.close();
                            }
                            catch (Exception var19_25) {
                                // empty catch block
                            }
                        }
                        if (backupException != null) {
                            BackupServiceUtils.addDetailsToException(backupException, sourceNode);
                            session.getResult().addException(backupException);
                            BackupServerHelperDAO.logger.error(backupException);
                            throw backupException;
                        }
                        throw var18_24;
                    }
                }
                try {
                    fis.close();
                }
                catch (Exception backupExceptionPath) {
                    // empty catch block
                }
            }
            if (backupException != null) {
                BackupServiceUtils.addDetailsToException(backupException, sourceNode);
                session.getResult().addException(backupException);
                BackupServerHelperDAO.logger.error((Object)backupException);
                throw backupException;
            }
        }
        return ServerSideResult.getInstance((Properties)resultProp, (int)tempRetCode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void populateResult(BackupSourceDetails srcBackupDetails, String propertiePath, IResults result, BackupServiceSession session, BackupErrorConstants.ErrorCodes errorTobeUsed) throws BackupException {
        if (errorTobeUsed == null) {
            errorTobeUsed = BackupErrorConstants.ErrorCodes.ERROR_CODE_GET_BACKUPSERVER_FILE_FAILED;
        }
        backupException = null;
        if (propertiePath != null) {
            resultProp = new Properties();
            propsFile = new File(propertiePath);
            fis = null;
            try {
                if (propsFile.exists()) {
                    fis = new FileInputStream(propsFile);
                    resultProp.load(fis);
                    status = null;
                    tempRetCode = Integer.parseInt(resultProp.getProperty("status"));
                    if (tempRetCode == 0 || tempRetCode == 3 || tempRetCode == 4) {
                        status = OperationDetails.OperationStatus.SUCCESS;
                    } else {
                        status = OperationDetails.OperationStatus.FAIL;
                        srcBackupDetails.setServerSideErrorCode(tempRetCode);
                    }
                    BackupServerHelperDAO.logger.info("Received Status code: " + status);
                    srcBackupDetails.setStatus(status);
                    srcBackupDetails.setLogFilePath(resultProp.getProperty("log.file.path"));
                    BackupServerHelperDAO.logger.debug("Log file path: " + resultProp.get("log.file.path"));
                    if (resultProp.getProperty("vault.location") != null) {
                        srcBackupDetails.setBackupLocation(resultProp.getProperty("vault.location"));
                    }
                    if (resultProp.getProperty("size") != null) {
                        srcBackupDetails.setSize(Long.parseLong(resultProp.getProperty("size")));
                    }
                    if ((scsBackupPath = resultProp.getProperty("scs.Backup.Path")) != null) {
                        srcBackupDetails.setSCSBackupPath(scsBackupPath);
                    }
                    if ((scsBackupHost = resultProp.getProperty("scs.Backup.Host")) != null) {
                        srcBackupDetails.setSCSBackupHost(scsBackupHost);
                    }
                    if (!BackupServiceUtils.isEmpty(backupExceptionPath = resultProp.getProperty("backup.exception.object.path"))) {
                        backupExceptionFile = this.getFile(srcBackupDetails.getSourceConfig().getBackupSourceNode().getHostName(), backupExceptionPath, BackupErrorConstants.ErrorCodes.ERROR_CODE_GET_BACKUPSERVER_FILE_FAILED);
                        if (backupExceptionFile != null) {
                            ois = null;
                            fis1 = null;
                            try {
                                fis1 = new FileInputStream(backupExceptionFile);
                                ois = new ObjectInputStream(fis1);
                                obj = ois.readObject();
                                if (!(obj instanceof BackupException)) ** GOTO lbl58
                                backupException = (BackupException)obj;
                            }
                            catch (ClassNotFoundException e) {
                                e.printStackTrace();
                            }
                            finally {
                                try {
                                    if (ois != null) {
                                        ois.close();
                                    }
                                    if (fis1 != null) {
                                        fis1.close();
                                    }
                                }
                                catch (Exception e) {}
                            }
                        }
                    } else if (status != OperationDetails.OperationStatus.SUCCESS) {
                        backupException = new BackupException(tempRetCode);
                    }
lbl58:
                    // 7 sources

                    sourceType = srcBackupDetails.getSourceConfig().getSourceType();
                    source_Entry_Type = BackupServerCommandConstants.SOURCE_TYPE_PARAMS.get(sourceType.toString());
                    i = 1;
                    sourceEntries = null;
                    instanceDetails = new HashMap<String, BackupSourceInstanceDetails>();
                    while (resultProp.getProperty(source_Entry_Type.concat(".name.".concat(String.valueOf(i)))) != null) {
                        sourceStatus = null;
                        tempRetCode = BackupErrorConstants.ErrorCodes.ERROR_CODE_UNKNOWN.getErrorCode();
                        if (resultProp.getProperty(source_Entry_Type.concat(".substatus.".concat(String.valueOf(i)))) != null) {
                            tempRetCode = Integer.parseInt(resultProp.getProperty(source_Entry_Type.concat(".substatus.".concat(String.valueOf(i)))));
                        }
                        if (tempRetCode == 0 || tempRetCode == 3 || tempRetCode == 4) {
                            sourceStatus = OperationDetails.OperationStatus.SUCCESS;
                        } else {
                            sourceStatus = OperationDetails.OperationStatus.FAIL;
                            srcBackupDetails.setStatus(OperationDetails.OperationStatus.FAIL);
                            srcBackupDetails.setServerSideErrorCode(tempRetCode);
                            backupException = new BackupException(tempRetCode);
                        }
                        size = 0L;
                        instanceDetailsUID = null;
                        sourceInstance = null;
                        if (resultProp.getProperty(source_Entry_Type.concat(".size.".concat(String.valueOf(i)))) != null) {
                            size = Long.parseLong(resultProp.getProperty(source_Entry_Type.concat(".size.".concat(String.valueOf(i)))));
                        }
                        if (resultProp.getProperty(source_Entry_Type.concat(".instancedetails.".concat(String.valueOf(i)))) != null && (instanceDetailsUID = resultProp.getProperty(source_Entry_Type.concat(".instancedetails.".concat(String.valueOf(i))))) != null && (sourceInstance = (BackupSourceInstanceDetails)instanceDetails.get(instanceDetailsUID)) == null && (instanceDets = instanceDetailsUID.split("#")).length == 4) {
                            name = instanceDets[0];
                            host = instanceDets[1];
                            port = instanceDets[2];
                            bkupHoldingNode = instanceDets[3];
                            sourceInstance = new BackupSourceInstanceDetails(name, host, port);
                            sourceInstance.setBackupHoldingNode(bkupHoldingNode);
                            sourceInstance.setSourceEntries(new ArrayList<E>());
                        }
                        sourceEntryDetails = new BackupSourceEntryDetails(sourceStatus, resultProp.getProperty(source_Entry_Type.concat(".name.".concat(String.valueOf(i)))), size);
                        tempSourceEntries = sourceInstance.getSourceEntries();
                        tempSourceEntries.add(sourceEntryDetails);
                        sourceInstance.setSourceEntries(tempSourceEntries);
                        if (instanceDetails.get(instanceDetailsUID) != null) {
                            instanceDetails.remove(instanceDetailsUID);
                        }
                        instanceDetails.put(instanceDetailsUID, sourceInstance);
                        ++i;
                    }
                    if (instanceDetails.size() <= 0) ** GOTO lbl125
                    srcBackupDetails.setSourceInstances(instanceDetails);
                }
                backupServerResult = this.parseResult(result);
                srcBackupDetails.setServerSideErrorCode(backupServerResult);
                srcBackupDetails.setStatus(OperationDetails.OperationStatus.FAIL);
            }
            catch (IOException e) {
                throw new BackupException(RB.getStringResource("BackupServerHelperDAO.Error.parsing.backup.txt"), (Throwable)e, errorTobeUsed.getErrorCode());
            }
            catch (NumberFormatException e) {
                throw new BackupException(RB.getStringResource("BackupServerHelperDAO.Error.parsing.backup.txt"), (Throwable)e, errorTobeUsed.getErrorCode());
            }
            finally {
                if (fis != null) {
                    try {
                        fis.close();
                    }
                    catch (Exception var31_40) {}
                }
                if (backupException != null) {
                    BackupServiceUtils.addDetailsToException(backupException, srcBackupDetails.getSourceConfig().getBackupSourceNode());
                    session.getResult().addException(backupException);
                    BackupServerHelperDAO.logger.error(backupException);
                }
            }
        } else {
            srcBackupDetails.setStatus(OperationDetails.OperationStatus.FAIL);
            srcBackupDetails.setServerSideErrorCode(errorTobeUsed.getErrorCode());
        }
lbl125:
        // 4 sources

    }

    public boolean reConfigure(BackupSourceNode sourceNode, Map<String, String> backupServerProperties, BackupServiceSession session) throws BackupException {
        if (backupServerProperties != null) {
            backupServerProperties.put("-reconfigure", "");
            return this.configure(sourceNode, backupServerProperties, session);
        }
        return false;
    }

    public boolean configure(BackupSourceNode sourceNode, Map<String, String> backupServerProperties, BackupServiceSession session) throws BackupException {
        boolean result = true;
        try {
            String hostName = sourceNode.getHostName();
            String configdir = sourceNode.getConfigDirPath();
            String vault = backupServerProperties.get("svrbakupevm.backup.vault.legal.dir.name");
            String sharedVault = backupServerProperties.get("svrbakupevm.shared.vault.dir");
            String resultDir = backupServerProperties.get("svrbakupevm.backup.results.legal.dir.name");
            String log = backupServerProperties.get("svrbakupevm.backup.log.legal.dir.name");
            String backupWorkspace = backupServerProperties.get("svrbakupevm.backup.workspace.legal.dir.name");
            String levUtilitiesdir = sourceNode.getLevUtilitiesDir();
            String platformtypeinstalldir = sourceNode.getPlatformTypesInstallDir();
            String backupServerPath = platformtypeinstalldir + "/" + "SASDeploymentBackup";
            String tierName = sourceNode.getNickName();
            String osType = sourceNode.getOsType();
            List WebappComponents = this.backupConfiguration.getSoftwareComponents(SASWEBAPP_SERVERCOMPONENT_CLASSIDENTIFIER);
            SoftwareComponentInterface webappServComponent = null;
            if (WebappComponents.size() > 0) {
                webappServComponent = (SoftwareComponentInterface)WebappComponents.get(0);
            }
            if (webappServComponent == null) {
                logger.error(RB.getStringResource("OMRPostgresSupportService.error.webappcomponent.notfound.txt"));
                throw new IllegalStateException(RB.getStringResource("OMRPostgresSupportService.error.webappcomponent.notfound.txt"));
            }
            String dbName = this.backupConfiguration.getSoftwareComponentProperty(webappServComponent, "webappsrv.dbms.name", BackupErrorConstants.ErrorCodes.ERROR_CODE_BACKUP_SERVER_CONFIGURATION_FAILURE);
            String scsJdbcUrl = this.backupConfiguration.getSoftwareComponentProperty(webappServComponent, CONFIGPROP_SCS_JDBC_URL, BackupErrorConstants.ErrorCodes.ERROR_CODE_BACKUP_SERVER_CONFIGURATION_FAILURE);
            logger.debug("JDBC URL during backup: " + scsJdbcUrl);
            String scsJdcDriver = this.backupConfiguration.getSoftwareComponentProperty(webappServComponent, CONFIGPROP_SCS_JDBC_DRIVER, BackupErrorConstants.ErrorCodes.ERROR_CODE_BACKUP_SERVER_CONFIGURATION_FAILURE);
            String scsJndiName = "sas/jdbc/SharedServices";
            BackupServerContext context = BackupServerContext.getInstance(this.backupConfiguration, sourceNode);
            List<String> commands = this.getBasicExecCommand(sourceNode);
            commands.add(BackupServerHelperDAO.getQuotedString(backupServerPath + "/" + context.getSashomeBackupExe()));
            commands.add("configure");
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("-client", "BackupService");
            params.put("-sessionid", session.getSessionId());
            if (backupWorkspace != null) {
                params.put("-backupWorkspace", backupWorkspace);
            }
            if (configdir != null) {
                params.put("-configdir", configdir);
            }
            this.addSharedVaultParamIfSpecified(sharedVault, params);
            if (!backupServerProperties.containsKey("-reconfigure")) {
                if (log != null) {
                    params.put("-log", log);
                }
                if (platformtypeinstalldir != null) {
                    params.put("-platformtypeinstalldir", BackupServerHelperDAO.getQuotedString(platformtypeinstalldir));
                }
                if (resultDir != null) {
                    params.put("-result", resultDir);
                }
                if (levUtilitiesdir != null) {
                    params.put("-utilitiesdir", levUtilitiesdir);
                }
                if (vault != null) {
                    params.put("-vault", vault);
                }
                if (!BackupServiceUtils.isEmpty(scsJndiName)) {
                    params.put("-scsjndiname", scsJndiName);
                }
                if (!BackupServiceUtils.isEmpty(scsJdcDriver)) {
                    params.put("-scsjdbcdriver", scsJdcDriver);
                }
                if (!BackupServiceUtils.isEmpty(scsJdbcUrl)) {
                    params.put("-scsjdbcurl", scsJdbcUrl);
                }
                if (!BackupServiceUtils.isEmpty(tierName)) {
                    params.put("-tier", tierName);
                }
                if (!BackupServiceUtils.isEmpty(osType)) {
                    params.put("-ostype", osType);
                }
                if (!BackupServiceUtils.isEmpty(hostName)) {
                    params.put("-hostalias", hostName);
                }
                params.put("-pgdatabaselist", "");
            } else {
                params.put("-reconfigure", backupServerProperties.get("-reconfigure"));
            }
            commands.addAll(BackupServiceUtils.asList(params));
            commands = BackupServiceUtils.decorateParams(commands, sourceNode.getOsType());
            this.printCommandInLog(commands);
            String[] paramArrayOfString = commands.toArray(new String[commands.size()]);
            logger.info("configure");
            IResults agentresult = DeploymentAgentClient.handleArgLine(paramArrayOfString, paramArrayOfString);
            logger.info("Backup Server executed");
            int intResult = this.parseResult(agentresult);
            if (intResult == 0 && commands.contains("doExecAsUserTimed")) {
                try {
                    intResult = this.parseResultMessage(agentresult);
                    if (intResult == -1) {
                        logger.warn("SAS Deployment Agent's returned result object returned by server for configure command" + agentresult.getMessage());
                        logger.warn("SAS Deployment Agent's returned result object returned by server for configure command can not be read. ");
                    }
                }
                catch (Throwable t) {
                    logger.warn("SAS Deployment Agent's returned result object returned by server for configure command can not be read. ");
                }
            }
            if (intResult != 0) {
                logger.error(Message.format((String)RB.getStringResource("BackupServerHelperDAO.backupserver.status.fmt"), (Object)intResult));
                logger.error(Message.format((String)RB.getStringResource("BackupServerHelperDAO.BackupOperation.Failed.on.host.fmt"), (Object)hostName));
                result = false;
            }
        }
        catch (BackupException e) {
            if (e.getErrorInfo("operationType") == null) {
                e.setErrorInfo("operationType", "configure");
            }
            if (e.getErrorInfo("errorOriginatingTier") == null) {
                BackupServiceUtils.addDetailsToException(e, sourceNode);
            }
            throw e;
        }
        return result;
    }

    public File getFile(String hostName, String remoteFileLoc, BackupErrorConstants.ErrorCodes errorTobeUsed) throws BackupException {
        File file = null;
        if (errorTobeUsed == null) {
            errorTobeUsed = BackupErrorConstants.ErrorCodes.ERROR_CODE_GET_BACKUPSERVER_FILE_FAILED;
        }
        try {
            String fileName = BackupServiceUtils.getName(remoteFileLoc);
            String localFileLoc = BackupServiceUtils.getTempDir().getCanonicalPath() + File.separator + hostName.substring(0, hostName.indexOf(46) == -1 ? hostName.length() : hostName.indexOf(46)) + Math.random() + "_" + fileName;
            file = new File(localFileLoc);
            String[] paramsGetResult = new String[]{"pullFile", hostName, remoteFileLoc, localFileLoc};
            logger.debug("Trying to copy " + remoteFileLoc + " on host " + hostName);
            IResults copyResult = DeploymentAgentClient.handleArgLine(paramsGetResult, paramsGetResult);
            if (copyResult.getStatus() != 0 || copyResult.getSubstatus() != 0) {
                logger.error(Message.format((String)RB.getStringResource("BackupServerHelperDAO.Error.copying.resultfile.fromhost.fmt"), (Object)remoteFileLoc, (Object)hostName));
            }
            if (copyResult.getStatus() != 0) {
                return null;
            }
        }
        catch (IOException t) {
            logger.error(Message.format((String)RB.getStringResource("BackupServerHelperDAO.ErrorPulliing.Results.fmt"), (Object)remoteFileLoc, (Object)hostName));
            throw new BackupException(Message.format((String)RB.getStringResource("BackupServerHelperDAO.ErrorPulliing.Results.fmt"), (Object)remoteFileLoc, (Object)hostName), (Throwable)t, errorTobeUsed.getErrorCode());
        }
        return file;
    }

    public static String getQuotedString(String str) {
        if (str.contains(" ")) {
            str = "\"" + str + "\"";
        }
        return str;
    }

    public boolean cleanDropZone(BackupSourceNode sourceNode, String dropZonePath) {
        try {
            String hostName = sourceNode.getHostName();
            logger.debug("Sending ischild command to Backup Server on" + hostName);
            BackupServerContext context = BackupServerContext.getInstance(this.backupConfiguration, sourceNode);
            String backupServerPath = context.getBackupServerPath();
            List<String> commands = this.getBasicExecCommand(sourceNode);
            commands.add(backupServerPath + "/" + context.getBackupServerExecutableName());
            commands.add("util");
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("-task", "clean");
            params.put("-client", "BackupService");
            params.put("-configbase", backupServerPath);
            params.put("dir", dropZonePath);
            params.put("-sessionid", String.valueOf(System.currentTimeMillis()));
            commands.addAll(BackupServiceUtils.asList(params));
            commands = BackupServiceUtils.decorateParams(commands, sourceNode.getOsType());
            this.printCommandInLog(commands);
            String[] paramArrayOfString = commands.toArray(new String[commands.size()]);
            logger.info("cleanDropZone");
            IResults agentresult = DeploymentAgentClient.handleArgLine(paramArrayOfString, paramArrayOfString);
            return this.parseResult(agentresult) == 0;
        }
        catch (Throwable exception) {
            logger.warn("Unable to clean content server backup from cluster node drop zone");
            exception.printStackTrace();
            return false;
        }
    }

    public boolean isOnCurrentTier(BackupSourceNode sourceNode, String path, String configDirPath, BackupServiceSession session, BackupErrorConstants.ErrorCodes errorTobeUsed) throws BackupException {
        boolean isOnCurrentTier;
        block18: {
            isOnCurrentTier = true;
            logger.debug("Checking for tier equality");
            String tempResultPath = null;
            if (this.backupConfiguration.isTierCheckRequired() && configDirPath != null && path != null) {
                try {
                    logger.debug("Checking parent child relationship of " + path + " and " + configDirPath);
                    String hostName = sourceNode.getHostName();
                    logger.debug("Sending ischild command to Backup Server on" + hostName);
                    BackupServerContext context = BackupServerContext.getInstance(this.backupConfiguration, sourceNode);
                    String backupServerPath = context.getBackupServerPath();
                    List<String> commands = this.getBasicExecCommand(sourceNode);
                    commands.add(backupServerPath + "/" + context.getBackupServerExecutableName());
                    commands.add("util");
                    HashMap<String, String> params = new HashMap<String, String>();
                    params.put("-task", ISCHILD);
                    params.put("-parent", configDirPath);
                    params.put("-child", path);
                    params.put("-client", "BackupService");
                    params.put("-configbase", backupServerPath);
                    params.put("-sessionid", session.getSessionId());
                    String sharedVault = this.backupConfiguration.getSharedVaultLocation();
                    this.addSharedVaultParamIfSpecified(sharedVault, params);
                    commands.addAll(BackupServiceUtils.asList(params));
                    commands = BackupServiceUtils.decorateParams(commands, sourceNode.getOsType());
                    this.printCommandInLog(commands);
                    String[] paramArrayOfString = commands.toArray(new String[commands.size()]);
                    logger.info("isOnCurrentTier");
                    IResults agentresult = DeploymentAgentClient.handleArgLine(paramArrayOfString, paramArrayOfString);
                    logger.info(Message.format((String)RB.getStringResource("BackupServerHelperDAO.backupserver.status.fmt"), (Object)this.parseResult(agentresult)));
                    tempResultPath = this.getResult(backupServerPath, session.getSessionId(), hostName, "util", ISCHILD);
                    if (tempResultPath != null) {
                        Properties resultProp = new Properties();
                        File propsFile = new File(tempResultPath);
                        FileInputStream fis = null;
                        try {
                            if (propsFile.exists()) {
                                fis = new FileInputStream(propsFile);
                                resultProp.load(fis);
                                String strIschild = resultProp.getProperty(ISCHILD);
                                if (!BackupServiceUtils.isEmpty(strIschild)) {
                                    isOnCurrentTier = Boolean.parseBoolean(strIschild);
                                }
                            }
                            break block18;
                        }
                        catch (IOException e) {
                            throw new BackupException("Error encountered while trying to check for tier equality.", (Throwable)e, errorTobeUsed.getErrorCode());
                        }
                        finally {
                            if (fis != null) {
                                try {
                                    fis.close();
                                }
                                catch (Exception exception) {}
                            }
                        }
                    }
                    BackupException e = new BackupException("Error encountered while trying to fetch result for tier equality", BackupErrorConstants.ErrorCodes.ERROR_CODE_GET_BACKUPSERVER_FILE_FAILED.getErrorCode());
                    BackupServiceUtils.addDetailsToException(e, sourceNode);
                    throw e;
                }
                catch (BackupException e) {
                    if (e.getErrorInfo("operationType") == null) {
                        e.setErrorInfo("operationType", ISCHILD);
                    }
                    if (e.getErrorInfo("errorOriginatingTier") == null) {
                        BackupServiceUtils.addDetailsToException(e, sourceNode);
                    }
                    throw e;
                }
            }
        }
        logger.debug(path + " is child of " + configDirPath + "? " + isOnCurrentTier);
        return isOnCurrentTier;
    }

    private void printCommandInLog(List<String> commands) {
        try {
            String strCommands = "[";
            for (int i = 0; i < commands.size(); ++i) {
                if ("-pw".equalsIgnoreCase(commands.get(i))) {
                    strCommands = strCommands + commands.get(i);
                    strCommands = strCommands + ", xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx";
                    ++i;
                } else if ("-dbconnecturl".equalsIgnoreCase(commands.get(i))) {
                    strCommands = strCommands + commands.get(i);
                    strCommands = strCommands + ", ";
                    if (++i < commands.size()) {
                        String dbconnecturl = commands.get(i);
                        while (dbconnecturl.contains("::")) {
                            strCommands = strCommands + dbconnecturl.substring(0, dbconnecturl.indexOf("::") + 2);
                            strCommands = strCommands + "xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx";
                            if ((dbconnecturl = dbconnecturl.substring(dbconnecturl.indexOf("::") + 2)).contains(",")) {
                                dbconnecturl = dbconnecturl.substring(dbconnecturl.indexOf(",") + 1);
                                strCommands = strCommands + ",";
                                continue;
                            }
                            dbconnecturl = "";
                        }
                    }
                } else {
                    strCommands = commands.get(i).contains("{SAS00") || commands.get(i).contains("{sas00") ? strCommands + "xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx" : strCommands + commands.get(i);
                }
                strCommands = i + 1 < commands.size() ? strCommands + ", " : strCommands + "]";
            }
            logger.info(strCommands);
        }
        catch (Exception e) {
            logger.error("Error occurred while masking password in the log message");
        }
    }

    public static final class BackupServerCommandConstants {
        public static final String GLOBAL_OPTION_CONFIGBASE = "-configbase";
        public static final String GLOBAL_OPTION_BACKUPCONFIG = "-backupconfig";
        public static final String GLOBAL_OPTION_CLIENT = "-client";
        public static final String GLOBAL_OPTION_ASYNC = "-async";
        public static final String GLOBAL_OPTION_SEESIONID = "-sessionid";
        public static final String GLOBAL_OPTION_SASHOME = "-sashome";
        public static final String GLOBAL_OPTION_SASROOT = "-sasroot";
        public static final String GLOBAL_OPTION_SESSIONEND = "-sessionend";
        public static final String GLOBAL_OPTION_SOURCE = "-source";
        public static final String GLOBAL_OPTION_SHARED_STAGING = "-sharedvaultbase";
        public static final String LEVCONFIG_OPTION_CONFIGDIR = "-configdir";
        public static final String LEVCONFIG_OPTION_SOURCEDIRS = "-sourcedirs";
        public static final String OPTION_INCLUDEFILTER = "-includefilter";
        public static final String OPTION_EXCLUDEFILTER = "-excludefilter";
        public static final String LEVCONFIG_OPTION_BACKUPID = "-backupid";
        public static final String DB_OPTION_DBNAME = "-dbname";
        public static final String DB_OPTION_BINPATH = "-binpath";
        public static final String DB_OPTION_USER = "-user";
        public static final String DB_OPTION_PASSWORD = "-pw";
        public static final String DB_OPTION_HOST = "-host";
        public static final String DB_OPTION_PORT = "-port";
        public static final String DB_LIB_PATH = "-libpath";
        public static final String DB_NAMES_LIST = "-pgdatabaselist";
        public static final String DB_OPTION_CONNECT_URL = "-dbconnecturl";
        public static final String SCS_OPTION_HOST = "-host";
        public static final String SCS_OPTION_PORT = "-port";
        public static final String SCS_OPTION_USER = "-user";
        public static final String SCS_OPTION_PASSWORD = "-pw";
        public static final String SCS_OPTION_SCSROOT = "-scsroot";
        public static final String SCS_OPTION_DEFAULTREPOS = "-defaultrepos";
        public static final String SCS_OPTION_PG_USER = "-pguser";
        public static final String SCS_OPTION_PG_PW = "-pgpw";
        public static final String SCS_OPTION_PG_PORT = "-pgport";
        public static final String SCS_OPTION_HTTP_PROTOCOL = "-httpprotocol";
        public static final String SCS_OPTION_PG_HOST = "-pghost";
        public static final String SCS_OPTION_ISCLUSTERED = "-isclustered";
        public static final String SCS_OPTION_DATABASE_NAME = "-dbname";
        public static final String SCS_OPTION_DATABASE_TYPE = "-dbtype";
        public static final String SCS_OPTION_WEBAPPSERV_USERID = "-webappuserid";
        public static final String SCS_OPTION_JDBCURL = "-jdbcurl";
        public static final String PURGE_OPTION_BACKUPID = "-backupid";
        public static final String PURGE_OPTION_BEFOREDATE = "-beforedate";
        public static final String UTIL_OPTION_TASK = "-task";
        public static final String ISCHILD_OPTION_PARENT = "-parent";
        public static final String ISCHILD_OPTION_CHILD = "-child";
        public static final String ARCHIVE_OPTION_ID = "-backupid";
        public static final String ARCHIVE_OPTION_METADATA_STAGING = "-metadatastaging";
        public static final String ARCHIVE_OPTION_WAY = "-way";
        public static final String ARCHIVE_OPTION_FORCED = "-force";
        public static final String CONFIGURE_OPTION_VAULT = "-vault";
        public static final String CONFIGURE_OPTION_REUSLT = "-result";
        public static final String CONFIGURE_OPTION_LOG = "-log";
        public static final String CONFIGURE_OPTION_BACKUP_WORKSPACE = "-backupWorkspace";
        public static final String CONFIGURE_OPTION_RECONFIGURE = "-reconfigure";
        public static final String CONFIGURE_OPTION_UTILITIES_DIR = "-utilitiesdir";
        public static final String CONFIGURE_OPTION_CONFIGDIR = "-configdir";
        public static final String CONFIGURE_OPTION_PLATFORMTYPES_INSTALL_DIR = "-platformtypeinstalldir";
        public static final String CONFIGURE_OPTION_SCS_JNDINAME = "-scsjndiname";
        public static final String CONFIGURE_OPTIONS_SCS_JDBC_URL = "-scsjdbcurl";
        public static final String CONFIGURE_OPTIONS_SCS_JDBC_DRIVER = "-scsjdbcdriver";
        public static final String CONFIGURE_OPTIONS_TIER = "-tier";
        public static final String CONFIGURE_OPTIONS_OSTYPE = "-ostype";
        public static final String CONFIGURE_OPTIONS_HOSTALIAS = "-hostalias";
        public static final String CONFIGURE_OPTIONS_PG_DB_LIST = "-pgdatabaselist";
        public static final String SCS_PRESENT = "-scspresent";
        public static final String SHARED_VAULT_PRESENT = "-sharedvaultpresent";
        public static final String RECOVARY_SUCCESSFUL = "-recoverysuccessful";
        public static final Map<String, String> SOURCE_TYPE_PARAMS = new HashMap<String, String>();

        static {
            SOURCE_TYPE_PARAMS.put(BackupSourceConfig.BackupSource.CONFIGDIR.toString(), "levconfig");
            SOURCE_TYPE_PARAMS.put(BackupSourceConfig.BackupSource.CUSTOMDIR.toString(), "customdata");
            SOURCE_TYPE_PARAMS.put(BackupSourceConfig.BackupSource.DATABASE.toString(), "db");
            SOURCE_TYPE_PARAMS.put(BackupSourceConfig.BackupSource.CONTENTSERVER.toString(), "content");
        }
    }
}

