/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.backup.dao;

import com.sas.svcs.backup.client.BackupSourceConfig;
import com.sas.svcs.backup.client.BackupSourceNode;
import com.sas.svcs.backup.common.definitions.BackupException;
import com.sas.svcs.backup.dao.OMRDeploymentBackupConfiguration;
import com.sas.svcs.backup.dao.OSUtils;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BackupServerContext {
    private static final Logger logger = LogManager.getLogger(BackupServerContext.class);
    private static Map<String, BackupServerContext> instances = new HashMap<String, BackupServerContext>();
    private String backupServerWorkspaceDirName = "Backup";
    private String backupServerPath;
    private BackupSourceNode sourceNode;
    private Set<BackupSourceConfig.BackupSource> supportedSourceTypes = new HashSet<BackupSourceConfig.BackupSource>();
    private String configFileLocation;
    private String historyFileLocation;
    private String levBackupExe;
    private String sashomeBackupExe;
    private String fileSeparator;
    private String serverDropZone;

    private BackupServerContext() {
    }

    private BackupServerContext(BackupSourceNode backupSourceNode, OMRDeploymentBackupConfiguration backupConfiguration) {
        this.sourceNode = backupSourceNode;
        String osType = backupSourceNode.getOsType();
        String configDirPath = backupSourceNode.getConfigDirPath();
        try {
            this.backupServerWorkspaceDirName = backupConfiguration.getBackupWorkspaceDirName();
        }
        catch (Exception e) {
            this.backupServerWorkspaceDirName = "Backup";
        }
        this.backupServerPath = configDirPath + "/" + this.backupServerWorkspaceDirName;
        this.serverDropZone = this.backupServerPath + "/" + "dropzone";
        String osFamily = OSUtils.getOSFamily(osType);
        if (osFamily.equalsIgnoreCase("Windows")) {
            this.levBackupExe = "BackupServer.bat";
            this.sashomeBackupExe = "BackupServer.exe";
            this.fileSeparator = "\\\\";
        } else if (osFamily.equalsIgnoreCase("Unix")) {
            this.levBackupExe = "BackupServer.sh";
            this.sashomeBackupExe = "BackupServer";
            this.fileSeparator = "/";
        } else if (osFamily.equalsIgnoreCase("MVS") || osFamily.equalsIgnoreCase("ZOS")) {
            this.levBackupExe = "BackupServer.sh";
            this.sashomeBackupExe = "BackupServer.rexx";
            this.fileSeparator = "/";
        } else {
            this.levBackupExe = "BackupServer.sh";
            this.sashomeBackupExe = "BackupServer";
            this.fileSeparator = "/";
        }
        logger.debug("Backup Server exe name: " + this.sashomeBackupExe + ". Backup Server script name: " + this.levBackupExe);
    }

    public static BackupServerContext getInstance(OMRDeploymentBackupConfiguration backupConfiguration, BackupSourceNode backupSourceNode, BackupSourceConfig.BackupSource sourceType) throws BackupException {
        String hostName = backupSourceNode.getHostName();
        String hostAndConfigDir = hostName + "|" + backupSourceNode.getConfigDirPath();
        if (!instances.containsKey(hostAndConfigDir)) {
            BackupServerContext newInstance = new BackupServerContext(backupSourceNode, backupConfiguration);
            instances.put(hostAndConfigDir, newInstance);
        }
        BackupServerContext instance = instances.get(hostAndConfigDir);
        instance.supportedSourceTypes.add(sourceType);
        return instance;
    }

    public static BackupServerContext getInstance(OMRDeploymentBackupConfiguration backupConfiguration, BackupSourceNode backupSourceNode) throws BackupException {
        String hostName = backupSourceNode.getHostName();
        String hostAndConfigDir = hostName + "|" + backupSourceNode.getConfigDirPath();
        if (!instances.containsKey(hostAndConfigDir)) {
            BackupServerContext newInstance = new BackupServerContext(backupSourceNode, backupConfiguration);
            instances.put(hostAndConfigDir, newInstance);
        }
        BackupServerContext instance = instances.get(hostAndConfigDir);
        return instance;
    }

    public String getBackupServerPath() {
        return this.backupServerPath;
    }

    public Set<BackupSourceConfig.BackupSource> getSupportedSourceTypes() {
        return this.supportedSourceTypes;
    }

    public String getConfigFileLocation() {
        return this.configFileLocation;
    }

    public String getHistoryFileLocation() {
        return this.historyFileLocation;
    }

    public boolean isMidTier() {
        return this.sourceNode.isMidTier();
    }

    public String getBackupServerExecutableName() {
        return this.levBackupExe;
    }

    public String getFileSeparator() {
        return this.fileSeparator;
    }

    public String getSashomeBackupExe() {
        return this.sashomeBackupExe;
    }

    public void setSashomeBackupExe(String sashomeBackupExe) {
        this.sashomeBackupExe = sashomeBackupExe;
    }

    public String getBackupDropZone() {
        return this.serverDropZone;
    }
}

