/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.backup.aop;

import com.sas.svcs.backup.client.BackupServiceResult;
import com.sas.svcs.backup.client.Notifiable;
import com.sas.svcs.backup.client.OperationDetails;
import com.sas.svcs.backup.common.definitions.BackupErrorConstants;
import com.sas.svcs.backup.common.definitions.BackupErrorDetails;
import com.sas.svcs.backup.common.definitions.BackupErrorEntry;
import com.sas.svcs.backup.common.definitions.BackupErrorLogger;
import com.sas.svcs.backup.common.definitions.BackupException;
import com.sas.svcs.backup.dao.BackupServiceUtils;
import com.sas.svcs.backup.dao.OMRDeploymentBackupConfiguration;
import com.sas.svcs.backup.spi.BackupMailServiceImpl;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.AfterThrowing;
import org.aspectj.lang.annotation.Aspect;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

@Aspect
@Component
@Order(value=2)
public class NotificationAspect {
    Logger logger = LogManager.getLogger(NotificationAspect.class);
    @Autowired
    private OMRDeploymentBackupConfiguration omrDeploymentConf;
    @Autowired
    @Qualifier(value="BackupMailService")
    BackupMailServiceImpl backupMailServiceImpl;
    @Autowired
    @Qualifier(value="BackupErrorXmlLogger")
    BackupErrorLogger backupErrorXmlLogger;

    @Order(value=3)
    @AfterThrowing(pointcut="execution(* com.sas.svcs.backup.client.BackupService.*(..)) && @annotation(notify)", throwing="error")
    public void afterThrowingAdvice(JoinPoint joinPoint, Notifiable notify, Throwable error) {
        this.logger.debug("NotificationAspect.afterThrowingAdvice():" + joinPoint.getSignature().toLongString());
        BackupServiceResult<?> operationDetails = null;
        String errorMessage = null;
        BackupException backupException = null;
        try {
            backupException = error instanceof BackupException ? (BackupException)error : new BackupException("Backup service API " + joinPoint.getSignature().toLongString() + " failed due to unknown reasons.", error, BackupErrorConstants.ErrorCodes.ERROR_CODE_UNKNOWN.getErrorCode());
            BackupServiceUtils.addLogDetailsToException(backupException);
            BackupErrorDetails backupError = new BackupErrorDetails();
            BackupErrorEntry errorEntry = this.backupErrorXmlLogger.getErrorEntry(backupException);
            backupError.addBackupErrorEntry(errorEntry);
            errorMessage = this.backupErrorXmlLogger.generateCompleteErrorMessage(backupError);
            if (errorMessage == null) {
                errorMessage = "Backup service API " + joinPoint.getSignature().toLongString() + " failed due to unknown reasons.";
            }
            this.backupMailServiceImpl.sendEmailNotification(operationDetails, backupError);
        }
        catch (BackupException e) {
            this.logger.error("Error encountered while trying to send notification.", (Throwable)e);
        }
        catch (Throwable t) {
            this.logger.error("Error encountered while trying to send notification.", t);
        }
    }

    @Order(value=2)
    @AfterReturning(pointcut="execution(* com.sas.svcs.backup.client.BackupService.*(..)) && @annotation(notify)", returning="backupServiceResult")
    public void afterReturningAdvice(JoinPoint joinPoint, Notifiable notify, BackupServiceResult<?> backupServiceResult) {
        this.logger.info("NotificationAspect.afterReturningAdvice()" + joinPoint.getSignature().toLongString());
        OperationDetails operationDetails = null;
        Object error = null;
        try {
            if (backupServiceResult != null && this.omrDeploymentConf.isNotificationsEnabled()) {
                boolean errorsEncountered = !BackupServiceUtils.isEmpty(backupServiceResult.getExceptions());
                Object actualResult = backupServiceResult.getActualResult();
                if (actualResult != null && actualResult instanceof OperationDetails && this.shouldSendEmail(operationDetails = (OperationDetails)actualResult, errorsEncountered)) {
                    if (errorsEncountered) {
                        for (BackupException backupException : backupServiceResult.getExceptions()) {
                            BackupServiceUtils.addLogDetailsToException(backupException);
                        }
                    }
                    this.backupMailServiceImpl.sendEmailNotification(backupServiceResult);
                }
            }
        }
        catch (BackupException e) {
            this.logger.error("Error encountered while trying to send notification.", (Throwable)e);
            if (backupServiceResult == null) {
                backupServiceResult = new BackupServiceResult();
            }
            backupServiceResult.addException(e);
            try {
                backupServiceResult.generateErrorDetails(this.backupErrorXmlLogger);
            }
            catch (BackupException e1) {
                backupServiceResult.addException(e1);
            }
        }
        catch (Throwable t) {
            this.logger.error("Error encountered while trying to send notification.", t);
            if (backupServiceResult == null) {
                backupServiceResult = new BackupServiceResult();
            }
            BackupException be = new BackupException("Error encountered while trying to send notification.", t, BackupErrorConstants.ErrorCodes.ERROR_CODE_EMAIL_NOTIFICATION_FAILED.getErrorCode());
            backupServiceResult.addException(be);
            try {
                backupServiceResult.generateErrorDetails(this.backupErrorXmlLogger);
            }
            catch (BackupException e1) {
                backupServiceResult.addException(e1);
            }
        }
    }

    private boolean shouldSendEmail(OperationDetails operationDetails, boolean errorsEncountered) {
        boolean notificationReqd;
        boolean bl = notificationReqd = errorsEncountered || operationDetails.getStatus() != null && operationDetails.getStatus().isNotificationRequired();
        if (!notificationReqd) {
            return false;
        }
        boolean shouldSendEmail = true;
        String emailNotificationLevel = this.omrDeploymentConf.getEmailNotificationLevel();
        OperationDetails.OperationStatus customStatusLevel = null;
        if (emailNotificationLevel != null && (customStatusLevel = OperationDetails.OperationStatus.valueOf((String)emailNotificationLevel)) == null) {
            this.logger.warn("Invalid value specified for svrbakupevm.email.notification.level property.");
        }
        if (customStatusLevel == null) {
            return true;
        }
        if (operationDetails.getStatus() != null && customStatusLevel.getIntCode() > operationDetails.getStatus().getIntCode()) {
            return false;
        }
        return shouldSendEmail;
    }
}

