/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.backup.analyze;

import com.sas.svcs.backup.client.BackupSourceConfig;
import com.sas.svcs.backup.client.ConfigurableServerProxy;
import com.sas.svcs.backup.client.ConfigurationFilter;
import com.sas.svcs.backup.client.SASTierProxy;
import com.sas.svcs.backup.client.SASTiers;
import com.sas.svcs.backup.client.UserConfigurationServiceInterface;
import com.sas.svcs.backup.client.UserSourceConfiguration;
import com.sas.svcs.backup.dao.ConfigBeanConverter;
import com.sas.svcs.deployment.DeploymentDiscoveryService;
import com.sas.svcs.deployment.dao.DeploymentDiscoveryDAO;
import com.sas.svcs.deployment.data.ConfigurableServer;
import com.sas.svcs.deployment.data.SASTier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.collections.ListUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component
public class ConfigurationMergeManager {
    @Autowired
    @Qualifier(value="UserConfigurationService")
    private UserConfigurationServiceInterface userConfig;
    @Autowired
    private DeploymentDiscoveryService discoveryService;
    @Autowired
    private ConfigBeanConverter userConfigMapper;
    private Logger logger = LogManager.getLogger(ConfigurationMergeManager.class);

    public void merge(List<SASTier> tiers) {
        List<SASTierProxy> userSASTiers = this.userConfigMapper.sasTierListToProxyList(tiers);
        this.logger.debug("Calling UserConfigurationService.getSASTiers()");
        SASTiers orgSASTiersProxy = this.userConfig.getSASTiers();
        List excludedTiers = this.userConfig.getExcludedSASTiersActual();
        for (SASTier tiers1 : excludedTiers) {
            SASTierProxy tierProxy;
            Iterator<SASTierProxy> itr = userSASTiers.iterator();
            Iterator orgTiersItr = orgSASTiersProxy.getSasTiers().iterator();
            this.logger.debug("Excluded Tier to be removed : tiers1.getTierHost().getHostName() = " + tiers1.getTierHost().getHostName() + "  , tiers1.getHostName() = " + tiers1.getHostName());
            while (itr.hasNext()) {
                tierProxy = itr.next();
                this.logger.debug("ConfigurationMergeManager merge() userSASTiers  tierProxy.getTierName() = " + tierProxy.getTierName() + "tierProxy.getTierHost().getHostName() = " + tierProxy.getTierHost().getHostName());
                if (!tierProxy.getTierHost().getHostName().equals(tiers1.getHostName())) continue;
                this.logger.debug("Removing Excluded Tier Host " + tierProxy.getTierHost().getHostName());
                itr.remove();
            }
            while (orgTiersItr.hasNext()) {
                tierProxy = (SASTierProxy)orgTiersItr.next();
                this.logger.debug("ConfigurationMergeManager merge() orgSASTiersProxy  tierProxy.getTierName() = " + tierProxy.getTierHost().getHostName());
                if (!tierProxy.getTierHost().getHostName().equals(tiers1.getTierHost().getHostName())) continue;
                this.logger.debug("Removing Excluded Tier " + tierProxy.getTierHost().getHostName());
                orgTiersItr.remove();
            }
        }
        if (orgSASTiersProxy == null || !ListUtils.isEqualList(userSASTiers, (Collection)orgSASTiersProxy.getSasTiers())) {
            if (orgSASTiersProxy == null) {
                this.logger.debug("No SAS Tiers found by config files, SAS Tiers from metadata need to set by User Configuration Service");
            } else {
                this.logger.debug("SAS Tiers from metadata appear to be different. Need to be merged with User Configuration Service");
            }
            SASTiers sastiers = this.mergeTiers(userSASTiers, orgSASTiersProxy);
            this.userConfig.setSASTiers(sastiers);
            UserSourceConfiguration configDirConfiguration = new UserSourceConfiguration();
            configDirConfiguration.setConfigurableServers(this.mergeConfigDirectories(sastiers.getSasTiers()));
            this.userConfig.setSourceConfiguration(configDirConfiguration, BackupSourceConfig.BackupSource.CONFIGDIR);
        } else {
            this.logger.debug("Ignoring merging request as SAS Tiers' information is already in sync");
        }
    }

    private SASTiers mergeTiers(List<SASTierProxy> userSASTiers, SASTiers orgSASTiersProxy) {
        this.logger.info("Merging the SAS tiers");
        List<SASTierProxy> mergedList = null;
        if (orgSASTiersProxy != null) {
            List orgSasTiers = orgSASTiersProxy.getSasTiers();
            mergedList = this.mergeLists(userSASTiers, orgSasTiers, SASTierProxy.class);
        } else {
            this.logger.info("No user configuration found for SAS tiers adding the default SAS tiers to user configuration");
            orgSASTiersProxy = new SASTiers();
            mergedList = userSASTiers;
        }
        if (mergedList == null) {
            this.logger.error("No tiers found : should never happen");
        }
        orgSASTiersProxy.setSasTiers(mergedList);
        return orgSASTiersProxy;
    }

    public List<ConfigurableServerProxy> mergeConfigDirectories(List<SASTierProxy> sasTiers) {
        ArrayList<ConfigurableServerProxy> appServerProxies = new ArrayList<ConfigurableServerProxy>();
        List<ConfigurableServerProxy> mergedList = null;
        if (sasTiers != null) {
            for (SASTierProxy sasTierProxy : sasTiers) {
                ConfigurableServerProxy proxy = this.userConfigMapper.sasTierProxyToUserConfigDir(sasTierProxy);
                List<String> includes = this.getIncludes(sasTierProxy);
                if (includes == null || includes.isEmpty()) continue;
                ConfigurationFilter filter = new ConfigurationFilter();
                filter.setIncludes(includes);
                proxy.setFilter(filter);
                appServerProxies.add(proxy);
            }
            this.logger.debug("Calling UserConfigurationService.getSourceConfig(" + BackupSourceConfig.BackupSource.CONFIGDIR + ")");
            UserSourceConfiguration userConfiguration = this.userConfig.getSourceConfig(BackupSourceConfig.BackupSource.CONFIGDIR);
            if (userConfiguration != null) {
                List userServers = userConfiguration.getConfigurableServers();
                mergedList = this.mergeLists(appServerProxies, userServers, ConfigurableServerProxy.class);
            }
        }
        return mergedList != null ? mergedList : appServerProxies;
    }

    private List<String> getIncludes(SASTierProxy sasTierProxy) {
        ArrayList<String> includes = new ArrayList<String>();
        SASTier sasTier = this.userConfigMapper.proxyToSASTier(sasTierProxy);
        List sasAppServers = this.discoveryService.getConfigurableServers(DeploymentDiscoveryDAO.ComponentType.SAS_APP_SERVER, sasTier);
        for (ConfigurableServer configurableServer : sasAppServers) {
            String sasAppServerPath = configurableServer.getConfigurablePath();
            if (sasAppServerPath == null) continue;
            includes.add(sasAppServerPath + "/Data");
            includes.add(sasAppServerPath + "/SASEnvironment");
        }
        return includes;
    }

    private <T> List<T> mergeLists(List<T> discovered, List<T> stored, Class<T> clazz) {
        ArrayList<T> merged = null;
        if (stored != null) {
            List recentlyRemoved;
            merged = new ArrayList<T>(stored);
            List newlyAdded = ListUtils.subtract(discovered, stored);
            if (newlyAdded != null && newlyAdded.size() > 0) {
                this.logger.info(newlyAdded.size() + " new instances of type " + newlyAdded.get(0) + " discovered");
                merged.addAll(newlyAdded);
            }
            if ((recentlyRemoved = ListUtils.subtract(stored, discovered)) != null && recentlyRemoved.size() > 0) {
                this.logger.info(recentlyRemoved.size() + " instances of type " + clazz.getName() + " are removed from deployment");
                merged.removeAll(recentlyRemoved);
            }
        }
        return merged;
    }

    public List<ConfigurableServerProxy> mergeServers(BackupSourceConfig.BackupSource backupSource) {
        DeploymentDiscoveryDAO.ComponentType[] componentTypes = backupSource.getComponentTypes();
        this.logger.debug("Calling UserConfigurationService.getSourceConfig(" + backupSource + ")");
        UserSourceConfiguration configuration = this.userConfig.getSourceConfig(backupSource);
        List<ConfigurableServer> discovered = this.getConfigurableServers(componentTypes);
        List serverProxy = null;
        if (configuration != null) {
            serverProxy = configuration.getConfigurableServers();
        }
        return this.convert(discovered, serverProxy);
    }

    private List<ConfigurableServerProxy> convert(List<ConfigurableServer> discovered, List<ConfigurableServerProxy> userConfiged) {
        List<ConfigurableServerProxy> serverProxies = this.userConfigMapper.serversListToProxiesList(discovered);
        if (userConfiged != null && serverProxies != null) {
            for (ConfigurableServerProxy proxy : serverProxies) {
                if (!userConfiged.contains(proxy)) continue;
                for (ConfigurableServerProxy userProxy : userConfiged) {
                    if (!userProxy.getName().equalsIgnoreCase(proxy.getName())) continue;
                    if (userProxy.getConfigurablePath() != null) {
                        proxy.setConfigurablePath(userProxy.getConfigurablePath());
                    }
                    if (userProxy.getFilter() != null) {
                        proxy.setFilter(userProxy.getFilter());
                    }
                    if (userProxy.getSasTierId() != null) {
                        proxy.setSasTierId(userProxy.getSasTierId());
                    }
                    if (userProxy.getUseroptions() != null) {
                        proxy.setUseroptions(userProxy.getUseroptions());
                    }
                    if (userProxy.isIncluded() != null) {
                        proxy.setIncluded(userProxy.isIncluded());
                    }
                    if (userProxy.getId() == null) continue;
                    proxy.setId(userProxy.getId());
                }
            }
        } else if (userConfiged != null) {
            return userConfiged;
        }
        return serverProxies;
    }

    private List<ConfigurableServer> getConfigurableServers(DeploymentDiscoveryDAO.ComponentType[] componentTypes) {
        ArrayList configServers = null;
        if (componentTypes != null) {
            configServers = new ArrayList();
            for (DeploymentDiscoveryDAO.ComponentType type : componentTypes) {
                List servers = this.discoveryService.getConfigurableServers(type);
                if (servers == null) continue;
                configServers.addAll(servers);
            }
        }
        return configServers;
    }
}

