/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.backup.analyze;

import com.sas.svcs.backup.client.BackupSourceConfig;
import com.sas.svcs.deployment.data.SASTier;
import java.util.Properties;

public class BackupTask {
    BackupSourceConfig.BackupSource source;
    SASTier performOn;
    Properties properties;

    private BackupTask(BackupSourceConfig.BackupSource source, SASTier tier, Properties properties) {
        this.source = source;
        this.performOn = tier;
        this.properties = properties;
    }

    public static BackupTaskBuilder getBackupNodeTaskBuilder(BackupSourceConfig.BackupSource source, SASTier sastier) {
        return new BackupTaskBuilder(source, sastier);
    }

    public static BackupTaskBuilder getBackupTaskBuilder(BackupSourceConfig.BackupSource source) {
        return new BackupTaskBuilder(source);
    }

    public BackupSourceConfig.BackupSource getSource() {
        return this.source;
    }

    public SASTier getPerformOn() {
        return this.performOn;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public static class BackupTaskBuilder {
        private BackupSourceConfig.BackupSource source;
        private SASTier performOn;
        Properties properties = new Properties();

        private BackupTaskBuilder(BackupSourceConfig.BackupSource source) {
            this.source = source;
        }

        private BackupTaskBuilder(BackupSourceConfig.BackupSource source, SASTier sasTier) {
            this.source = source;
            this.performOn = sasTier;
        }

        public BackupTaskBuilder addParam(String name, String value) {
            this.properties.setProperty(name, value);
            return this;
        }

        public BackupTaskBuilder appendParam(String name, String value, String delimitor) {
            if (this.properties.containsKey(name)) {
                String previous = this.properties.getProperty(name);
                value = previous + delimitor + value;
            }
            this.properties.setProperty(name, value);
            return this;
        }

        public boolean hasParams() {
            return this.properties != null && !this.properties.isEmpty();
        }

        public String getParam(String paramName) {
            return this.properties.getProperty(paramName);
        }

        public BackupTask build() {
            return new BackupTask(this.source, this.performOn, this.properties);
        }
    }
}

