/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.backup.analyze;

import com.sas.svcs.backup.analyze.BackupTask;
import com.sas.svcs.backup.analyze.model.RuntimeSASEnvironment;
import com.sas.svcs.backup.client.BackupConfiguration;
import com.sas.svcs.backup.client.BackupOptions;
import com.sas.svcs.backup.client.BackupSourceConfig;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BackupJob {
    private String jobId;
    private String name;
    private boolean runAsync;
    private BackupOptions options;
    private RuntimeSASEnvironment backupJobEnvironment;
    private BackupConfiguration baseConfiguration;
    private Map<BackupSourceConfig.BackupSource, List<BackupTask>> backupTasks = new HashMap<BackupSourceConfig.BackupSource, List<BackupTask>>();
    private Logger logger = LogManager.getLogger(BackupJob.class);

    public BackupJob(String jobid, BackupOptions options) {
        this.jobId = jobid;
        this.options = options;
    }

    public void setBackupJobEnvironment(RuntimeSASEnvironment backupJobEnvironment) {
        this.backupJobEnvironment = backupJobEnvironment;
    }

    public RuntimeSASEnvironment getBackupJobEnvironment() {
        return this.backupJobEnvironment;
    }

    public BackupConfiguration getBaseConfiguration() {
        return this.baseConfiguration;
    }

    public void setBaseConfiguration(BackupConfiguration baseConfiguration) {
        this.baseConfiguration = baseConfiguration;
    }

    public BackupOptions getBackupOptions() {
        return this.options;
    }

    public void setBackupOptions(BackupOptions options) {
        this.options = options;
    }

    public List<BackupTask> getTasks(BackupSourceConfig.BackupSource source) {
        if (this.backupTasks.containsKey(source)) {
            return this.backupTasks.get(source);
        }
        return null;
    }

    public List<BackupTask> getAllSourcesTasks() {
        ArrayList<BackupTask> allTasks = new ArrayList<BackupTask>();
        Collection<List<BackupTask>> allSources = this.backupTasks.values();
        if (!allSources.isEmpty()) {
            for (List<BackupTask> allTasksForSource : allSources) {
                allTasks.addAll(allTasksForSource);
            }
        }
        return allTasks;
    }

    public void addTask(BackupTask task) {
        if (task != null) {
            BackupSourceConfig.BackupSource source = task.getSource();
            if (this.backupTasks.containsKey(source)) {
                this.backupTasks.get(source).add(task);
            } else {
                ArrayList<BackupTask> tasks = new ArrayList<BackupTask>(5);
                tasks.add(task);
                this.backupTasks.put(task.getSource(), tasks);
            }
        }
    }

    public void addTasks(List<BackupTask> tasks, BackupSourceConfig.BackupSource backupSource) {
        if (tasks != null) {
            if (this.backupTasks.containsKey(backupSource)) {
                this.backupTasks.get(backupSource).addAll(tasks);
            } else {
                this.backupTasks.put(backupSource, tasks);
            }
        }
    }

    public String getJobId() {
        return this.jobId;
    }

    public void setJobId(String jobId) {
        this.jobId = jobId;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isRunAsync() {
        return this.runAsync;
    }

    public void setRunAsync(boolean runAsync) {
        this.runAsync = runAsync;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }
}

