/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.authorization.client;

import com.sas.svcs.authorization.client.AuthorizationPrincipal;
import com.sas.svcs.authorization.client.GroupGrantedAuthority;
import java.security.Principal;
import org.springframework.security.acls.domain.GrantedAuthoritySid;
import org.springframework.security.acls.domain.PrincipalSid;
import org.springframework.security.acls.model.Sid;
import org.springframework.security.core.userdetails.UserDetails;

public class PrincipalResolver {
    public static AuthorizationPrincipal authorizationPrincipalForPrincipalObject(Object principal) {
        if (principal == null) {
            throw new NullPointerException();
        }
        if (principal instanceof AuthorizationPrincipal) {
            return (AuthorizationPrincipal)principal;
        }
        if (principal instanceof String) {
            return new AuthorizationPrincipal((String)principal, AuthorizationPrincipal.PrincipalType.User);
        }
        if (principal instanceof Principal) {
            return new AuthorizationPrincipal(((Principal)principal).getName(), AuthorizationPrincipal.PrincipalType.User);
        }
        if (principal instanceof UserDetails) {
            return new AuthorizationPrincipal(((UserDetails)principal).getUsername(), AuthorizationPrincipal.PrincipalType.User);
        }
        if (principal instanceof Sid) {
            return PrincipalResolver.authorizationPrincipalForSid((Sid)principal);
        }
        throw new IllegalArgumentException("Principal type " + (principal == null ? "null" : principal.getClass().getName()) + " is not supported");
    }

    public static AuthorizationPrincipal authorizationPrincipalForSid(Sid sid) {
        if (sid == null) {
            throw new NullPointerException();
        }
        AuthorizationPrincipal principal = null;
        if (sid instanceof PrincipalSid) {
            principal = new AuthorizationPrincipal(((PrincipalSid)sid).getPrincipal(), AuthorizationPrincipal.PrincipalType.User);
        } else if (sid instanceof GrantedAuthoritySid) {
            GroupGrantedAuthority ga = new GroupGrantedAuthority((GrantedAuthoritySid)sid);
            principal = new AuthorizationPrincipal(ga.getGroupName(), AuthorizationPrincipal.PrincipalType.Group);
        } else {
            throw new IllegalArgumentException("Unsupported Sid type " + sid.getClass().getName());
        }
        return principal;
    }
}

