/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.authorization.client;

import com.sas.svcs.commons.Identifiable;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.security.acls.domain.ObjectIdentityImpl;
import org.springframework.security.acls.model.ObjectIdentity;
import org.springframework.util.ReflectionUtils;

public class ObjectIdentityUtilities {
    private static final Logger LOGGER = LogManager.getLogger(ObjectIdentityUtilities.class);

    public static Long getObjectType(Object obj) {
        if (obj instanceof Identifiable) {
            Identifiable idObj = (Identifiable)obj;
            return idObj.getObjectType();
        }
        Method getObjectTypeMethod = ReflectionUtils.findMethod(obj.getClass(), (String)"getObjectType");
        try {
            if (getObjectTypeMethod != null && (Long.class.isAssignableFrom(getObjectTypeMethod.getReturnType()) || Long.TYPE.isAssignableFrom(getObjectTypeMethod.getReturnType()))) {
                return (Long)getObjectTypeMethod.invoke(obj, new Object[0]);
            }
        }
        catch (IllegalArgumentException e) {
            LOGGER.warn("Could not invoke getObjectType method for type " + obj.getClass(), (Throwable)e);
        }
        catch (IllegalAccessException e) {
            LOGGER.warn("Could not invoke getObjectType method for type " + obj.getClass(), (Throwable)e);
        }
        catch (InvocationTargetException e) {
            LOGGER.warn("Could not invoke getObjectType method for type " + obj.getClass(), (Throwable)e);
        }
        return null;
    }

    public static String getObjectId(Object obj) {
        if (obj instanceof Identifiable) {
            Identifiable idObj = (Identifiable)obj;
            return idObj.getId();
        }
        Method getIdMethod = ReflectionUtils.findMethod(obj.getClass(), (String)"getId");
        try {
            Object id;
            if (getIdMethod != null && (id = getIdMethod.invoke(obj, new Object[0])) != null) {
                return id.toString();
            }
        }
        catch (IllegalArgumentException e) {
            LOGGER.warn("Could not invoke getId method for type " + obj.getClass(), (Throwable)e);
        }
        catch (IllegalAccessException e) {
            LOGGER.warn("Could not invoke getId method for type " + obj.getClass(), (Throwable)e);
        }
        catch (InvocationTargetException e) {
            LOGGER.warn("Could not invoke getId method for type " + obj.getClass(), (Throwable)e);
        }
        return null;
    }

    public static ObjectIdentity getSpringObjectIdentity(Object obj) {
        Long objectType = ObjectIdentityUtilities.getObjectType(obj);
        String id = ObjectIdentityUtilities.getObjectId(obj);
        if (objectType != null && id != null) {
            return new ObjectIdentityImpl(Long.toString(objectType), (Serializable)((Object)id));
        }
        throw new RuntimeException("Could not generate Spring ObjectIdentity for class " + obj.getClass());
    }

    public static com.sas.svcs.commons.ObjectIdentity getSasObjectIdentity(Object obj) {
        if (obj instanceof ObjectIdentity) {
            ObjectIdentity springOid = (ObjectIdentity)obj;
            return new com.sas.svcs.commons.ObjectIdentity(Long.parseLong(springOid.getType()), springOid.getIdentifier().toString());
        }
        Long objectType = ObjectIdentityUtilities.getObjectType(obj);
        String id = ObjectIdentityUtilities.getObjectId(obj);
        if (objectType != null && id != null) {
            return new com.sas.svcs.commons.ObjectIdentity(objectType.longValue(), id);
        }
        throw new RuntimeException("Could not generate Spring ObjectIdentity for class " + obj.getClass());
    }

    public static ObjectIdentity getSpringObjectIdentityFromSasObjectIdentity(com.sas.svcs.commons.ObjectIdentity objId) {
        return new ObjectIdentityImpl(Long.toString(objId.getObjectType()), (Serializable)((Object)objId.getId()));
    }
}

