/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.authorization.client;

import com.sas.svcs.authorization.client.AuthorityType;
import com.sas.svcs.authorization.client.AuthorizationService;
import com.sas.svcs.authorization.client.TypedGrantedAuthority;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;

public class AuthorizationHelper {
    public AuthorizationHelper(AuthorizationService authorizationService) {
    }

    public boolean hasAuthority(String name) {
        if (null == name) {
            return false;
        }
        SecurityContext securityContext = SecurityContextHolder.getContext();
        if (null == securityContext) {
            return false;
        }
        Authentication authentication = securityContext.getAuthentication();
        if (null == authentication) {
            return false;
        }
        for (GrantedAuthority ga : authentication.getAuthorities()) {
            if (!name.equalsIgnoreCase(ga.getAuthority())) continue;
            return true;
        }
        return false;
    }

    private Set<GrantedAuthority> getGrantedAuthoritiesForType(SecurityContext securityContext, AuthorityType type) {
        if (null == securityContext) {
            return Collections.emptySet();
        }
        Authentication authentication = securityContext.getAuthentication();
        if (null == authentication) {
            return Collections.emptySet();
        }
        HashSet<GrantedAuthority> roles = new HashSet<GrantedAuthority>();
        for (GrantedAuthority ga : authentication.getAuthorities()) {
            if (!(ga instanceof TypedGrantedAuthority) || !type.equals((Object)((TypedGrantedAuthority)ga).getAuthorityType())) continue;
            roles.add(ga);
        }
        return roles;
    }

    public Set<GrantedAuthority> getPrivilegesForContext(SecurityContext securityContext) {
        return this.getGrantedAuthoritiesForType(securityContext, AuthorityType.PRIVILEGE);
    }

    public Set<GrantedAuthority> getCurrentPrivileges() {
        return this.getPrivilegesForContext(SecurityContextHolder.getContext());
    }

    public Set<GrantedAuthority> getRolesForContext(SecurityContext securityContext) {
        return this.getGrantedAuthoritiesForType(securityContext, AuthorityType.ROLE);
    }

    public Set<GrantedAuthority> getCurrentRoles() {
        return this.getRolesForContext(SecurityContextHolder.getContext());
    }

    public Set<GrantedAuthority> getGroupsForContext(SecurityContext securityContext) {
        return this.getGrantedAuthoritiesForType(securityContext, AuthorityType.GROUP);
    }

    public Set<GrantedAuthority> getCurrentGroups() {
        return this.getGroupsForContext(SecurityContextHolder.getContext());
    }
}

