/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.authorization.acl.client;

import com.sas.svcs.authorization.acl.client.AccessControlEntry;
import com.sas.svcs.authorization.acl.client.AccessControlList;
import com.sas.svcs.authorization.acl.client.AclService;
import com.sas.svcs.authorization.acl.client.CreateAccessControl;
import com.sas.svcs.authorization.client.AuthorizationPrincipal;
import com.sas.svcs.authorization.client.ObjectIdentityUtilities;
import com.sas.svcs.authorization.client.PrincipalResolver;
import com.sas.svcs.commons.ObjectIdentity;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Arrays;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.ExpressionParser;
import org.springframework.security.access.expression.method.MethodSecurityExpressionHandler;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.util.Assert;

public class AceCreatingInterceptor
implements MethodInterceptor {
    private static final Logger LOGGER = LogManager.getLogger(AceCreatingInterceptor.class);
    AclService aclService;
    MethodSecurityExpressionHandler expressionHandler;

    public void setAclService(AclService aclService) {
        this.aclService = aclService;
    }

    public void setExpressionHandler(MethodSecurityExpressionHandler expressionHandler) {
        this.expressionHandler = expressionHandler;
    }

    static String resolveId(EvaluationContext context, ExpressionParser parser, String expressionStr, Object[] args) {
        String id = null;
        if (!expressionStr.equals("")) {
            Expression expression = parser.parseExpression(expressionStr);
            id = (String)expression.getValue(context, String.class);
        } else if (args != null) {
            Object arg;
            Object[] objectArray = args;
            int n = objectArray.length;
            for (int i = 0; i < n && (id = ObjectIdentityUtilities.getObjectId(arg = objectArray[i])) == null; ++i) {
            }
        }
        return id;
    }

    static Long resolveObjectType(EvaluationContext context, ExpressionParser parser, String expressionStr, Object[] args) {
        Long objectType = null;
        if (!expressionStr.equals("")) {
            Expression expression = parser.parseExpression(expressionStr);
            objectType = (Long)expression.getValue(context, Long.class);
        } else if (args != null) {
            Object arg;
            Object[] objectArray = args;
            int n = objectArray.length;
            for (int i = 0; i < n && (objectType = ObjectIdentityUtilities.getObjectType(arg = objectArray[i])) == null; ++i) {
            }
        }
        return objectType;
    }

    public Object invoke(MethodInvocation invocation) throws Throwable {
        Object result = invocation.proceed();
        CreateAccessControl anno = this.getAnnotation(invocation, CreateAccessControl.class);
        if (anno != null) {
            Long parentType;
            String parentId;
            Long selfType;
            String selfId;
            SecurityContext securityContext = SecurityContextHolder.getContext();
            Assert.notNull((Object)securityContext, (String)"Security Context was null. Is the user logged in?");
            Authentication auth = securityContext.getAuthentication();
            Assert.notNull((Object)auth, (String)"Authentication object was null. Is the user logged in?");
            AuthorizationPrincipal principal = PrincipalResolver.authorizationPrincipalForPrincipalObject(auth.getPrincipal());
            EvaluationContext context = null;
            ExpressionParser parser = null;
            ObjectIdentity objectId = null;
            ObjectIdentity parent = null;
            if (!(anno.objectId().equals("") && anno.objectType().equals("") && anno.parentId().equals("") && anno.parentType().equals(""))) {
                context = this.expressionHandler.createEvaluationContext(auth, (Object)invocation);
                this.expressionHandler.setReturnObject(result, context);
                parser = this.expressionHandler.getExpressionParser();
            }
            if ((selfId = AceCreatingInterceptor.resolveId(context, parser, anno.objectId(), invocation.getArguments())) != null && (selfType = AceCreatingInterceptor.resolveObjectType(context, parser, anno.objectType(), invocation.getArguments())) != null) {
                objectId = new ObjectIdentity(selfType.longValue(), selfId);
            }
            if ((parentId = AceCreatingInterceptor.resolveId(context, parser, anno.parentId(), null)) != null && (parentType = AceCreatingInterceptor.resolveObjectType(context, parser, anno.parentType(), null)) != null) {
                parent = new ObjectIdentity(parentType.longValue(), parentId);
            }
            if (objectId == null) {
                throw new RuntimeException("Could not create access control entry.");
            }
            AccessControlEntry ace = new AccessControlEntry(principal, anno.read(), anno.write(), anno.administer(), anno.delete(), anno.create());
            AccessControlEntry authenticatedUsersAce = new AccessControlEntry(new AuthorizationPrincipal("SAS_AUTHENTICATED_USERS", AuthorizationPrincipal.PrincipalType.Group), anno.authenticatedUsersRead(), anno.authenticatedUsersWrite(), anno.authenticatedUsersAdminister(), anno.authenticatedUsersDelete(), anno.authenticatedUsersCreate());
            AccessControlList acl = new AccessControlList(Arrays.asList(ace, authenticatedUsersAce), principal, parent, anno.inheritable());
            if (!this.aclService.aclExists(objectId)) {
                this.aclService.createAcl(objectId, acl);
            } else {
                LOGGER.warn("Access control entry already exists");
            }
        } else {
            LOGGER.warn("Could not find CreateAce annotation");
        }
        return result;
    }

    private <T extends Annotation> T getAnnotation(MethodInvocation invocation, Class<T> annotationType) throws NoSuchMethodException {
        T anno = invocation.getMethod().getAnnotation(annotationType);
        if (anno == null) {
            Object joinpoint = invocation.getThis();
            Method method = invocation.getMethod();
            Method targetMethod = joinpoint.getClass().getMethod(method.getName(), method.getParameterTypes());
            if (targetMethod != null) {
                anno = targetMethod.getAnnotation(annotationType);
            }
        }
        return anno;
    }
}

