/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.authentication.client;

import java.io.Serializable;
import java.security.Principal;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.security.auth.Subject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SubjectMatter
implements Serializable {
    private static final Logger logger = LogManager.getLogger(SubjectMatter.class);
    private static final long serialVersionUID = 1L;
    private static final int PRINCIPAL_LIST_INIT = 16;
    private static final int CREDENTIAL_LIST_INIT = 8;
    private static final int EMPTY_LIST_INIT = 1;
    private final List<Principal> _principals = new ArrayList<Principal>(16);
    private final List<Object> _privateCredentials = new ArrayList<Object>(8);
    private final List<Object> _publicCredentials = new ArrayList<Object>(1);

    public SubjectMatter(Subject subject) {
        Set<Principal> principals = subject.getPrincipals();
        Set<Object> publicCredentials = subject.getPublicCredentials();
        Set<Object> privateCredentials = subject.getPrivateCredentials();
        for (Principal principal : principals) {
            this.addPrincipal(principal);
        }
        for (Object object : publicCredentials) {
            this.addPublicCredential(object);
        }
        for (Object object : privateCredentials) {
            this.addPrivateCredential(object);
        }
    }

    public void addPrincipal(Principal principal) {
        if (principal instanceof Serializable) {
            this._principals.add(principal);
        } else {
            logger.debug("The following principal is not being passed because it is not Serializable.");
        }
    }

    public void addPrivateCredential(Object credential) {
        if (credential instanceof Serializable) {
            this._privateCredentials.add(credential);
        } else {
            logger.debug("The following credential is not being passed because it is not Serializable. ");
        }
    }

    public void addPublicCredential(Object credential) {
        if (credential instanceof Serializable) {
            this._publicCredentials.add(credential);
        } else {
            logger.debug("The following credential is not being passed because it is not Serializable, " + credential);
        }
    }

    public List<Principal> getPrincipals() {
        return this._principals;
    }

    public List<Object> getPrivateCredentials() {
        return this._privateCredentials;
    }

    public List<Object> getPublicCredentials() {
        return this._publicCredentials;
    }
}

