/*
 * Decompiled with CFR 0.152.
 */
package com.sas.framework.commons.time;

import com.sas.framework.commons.time.Frequency;
import com.sas.framework.commons.time.PeriodTypeName;
import com.sas.framework.commons.time.TimeEnum;
import java.text.DateFormatSymbols;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public abstract class PeriodType
extends TimeEnum {
    private static final long serialVersionUID = 1L;
    private static final Map<Locale, DateFormatSymbols> DFS_MAP = new HashMap<Locale, DateFormatSymbols>();

    public PeriodType(String key) {
        super(key);
    }

    public boolean isRecurring() {
        return true;
    }

    public abstract PeriodType next();

    public abstract PeriodType prev();

    public String getAbbreviation(Locale locale) {
        return this.getLabel(locale);
    }

    public String getDescription(Locale locale) {
        return this.getLabel(locale);
    }

    public final Frequency getFrequency() {
        return this.getName().getFrequency();
    }

    public abstract PeriodTypeName getName();

    protected DateFormatSymbols getDateFormatSymbols(Locale locale) {
        DateFormatSymbols dfs = DFS_MAP.get(locale);
        if (null == dfs) {
            dfs = new DateFormatSymbols(locale);
            DFS_MAP.put(locale, dfs);
        }
        return dfs;
    }
}

