/*
 * Decompiled with CFR 0.152.
 */
package com.sas.framework.commons.time;

import com.sas.framework.commons.time.DayN;
import com.sas.framework.commons.time.FiscalCalendarDefinition;
import com.sas.framework.commons.time.FiscalMonthPattern;
import com.sas.framework.commons.time.FiscalYearPattern;
import com.sas.framework.commons.time.HalfYear;
import com.sas.framework.commons.time.Month;
import com.sas.framework.commons.time.MonthN;
import com.sas.framework.commons.time.Period;
import com.sas.framework.commons.time.PeriodType;
import com.sas.framework.commons.time.QuarterYear;
import com.sas.framework.commons.time.Week;
import com.sas.framework.commons.time.Year;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import javax.swing.tree.DefaultMutableTreeNode;

public final class HierarchyGenerator {
    private static final long serialVersionUID = 1L;
    private static final int[] WEEKS_445 = new int[]{4, 4, 5, 4, 4, 5, 4, 4, 5, 4, 4, 5};
    private static final int[] WEEKS_454 = new int[]{4, 5, 4, 4, 5, 4, 4, 5, 4, 4, 5, 4};
    private static final int[] WEEKS_544 = new int[]{5, 4, 4, 5, 4, 4, 5, 4, 4, 5, 4, 4};

    public static DefaultMutableTreeNode generateCalendarYear(int year) {
        FiscalCalendarDefinition fcd = new FiscalCalendarDefinition();
        fcd.setYearPattern(FiscalYearPattern.MONTHLY);
        fcd.setMonth(Month.DECEMBER);
        return HierarchyGenerator.generateFiscalYear(year, fcd);
    }

    public static DefaultMutableTreeNode generateFiscalYear(int year, FiscalCalendarDefinition fcd) {
        DefaultMutableTreeNode yearNode = new DefaultMutableTreeNode();
        int[] dayCounter = new int[]{0};
        int month = fcd.getMonth().getCalendarValue();
        GregorianCalendar calendar = new GregorianCalendar(year, month, 1);
        FiscalYearPattern yearPattern = fcd.getYearPattern();
        if (((Object)((Object)FiscalYearPattern.MONTHLY)).equals((Object)yearPattern)) {
            ((Calendar)calendar).add(2, 1);
            HierarchyGenerator.addMonths(yearNode, calendar, dayCounter);
        } else {
            int day = fcd.getDay().getCalendarValue();
            calendar.set(7, day);
            calendar.set(8, -1);
            if (((Object)((Object)FiscalYearPattern.WEEKLY_LAST_DAY)).equals((Object)yearPattern) || HierarchyGenerator.daysLeftInMonth(calendar) <= 3) {
                ((Calendar)calendar).add(5, 1);
            } else {
                ((Calendar)calendar).add(5, 8);
            }
            HierarchyGenerator.addWeeks(yearNode, calendar, dayCounter);
            GregorianCalendar nextYearsCalendar = new GregorianCalendar(year + 1, month, 1);
            nextYearsCalendar.set(7, day);
            nextYearsCalendar.set(8, -1);
            if (((Object)((Object)FiscalYearPattern.WEEKLY_LAST_DAY)).equals((Object)yearPattern) || HierarchyGenerator.daysLeftInMonth(nextYearsCalendar) <= 3) {
                ((Calendar)nextYearsCalendar).add(5, 1);
            } else {
                ((Calendar)nextYearsCalendar).add(5, 8);
            }
            if (!((Calendar)calendar).equals(nextYearsCalendar)) {
                HierarchyGenerator.addWeek(yearNode, calendar, 53, dayCounter);
                if (!((Calendar)calendar).equals(nextYearsCalendar)) {
                    throw new IllegalStateException();
                }
            }
            HierarchyGenerator.addMonths(yearNode, fcd.getMonthPattern());
        }
        HierarchyGenerator.addQuarters(yearNode);
        HierarchyGenerator.addSemesters(yearNode);
        HierarchyGenerator.setPeriod(yearNode, Year.getYear(year + 1));
        return yearNode;
    }

    private static void addSemesters(DefaultMutableTreeNode yearNode) {
        for (int s = 0; s < 2; ++s) {
            DefaultMutableTreeNode semesterNode = new DefaultMutableTreeNode();
            for (int q = 0; q < 2; ++q) {
                semesterNode.add((DefaultMutableTreeNode)yearNode.getChildAt(0));
            }
            HierarchyGenerator.setPeriod(semesterNode, HalfYear.HALVES[s]);
            yearNode.add(semesterNode);
        }
    }

    private static void addQuarters(DefaultMutableTreeNode yearNode) {
        for (int q = 0; q < 4; ++q) {
            DefaultMutableTreeNode quarterNode = new DefaultMutableTreeNode();
            for (int m = 0; m < 3; ++m) {
                quarterNode.add((DefaultMutableTreeNode)yearNode.getChildAt(0));
            }
            HierarchyGenerator.setPeriod(quarterNode, QuarterYear.QUARTERS[q]);
            yearNode.add(quarterNode);
        }
    }

    private static void addMonths(DefaultMutableTreeNode yearNode, FiscalMonthPattern monthPattern) {
        DefaultMutableTreeNode monthNode = null;
        Object firstMonthNode = null;
        MonthN month = null;
        int[] weeks = WEEKS_445;
        if (((Object)((Object)FiscalMonthPattern.WEEKS_454)).equals((Object)monthPattern)) {
            weeks = WEEKS_454;
        } else if (((Object)((Object)FiscalMonthPattern.WEEKS_544)).equals((Object)monthPattern)) {
            weeks = WEEKS_544;
        }
        for (int m = 0; m < 12; ++m) {
            monthNode = new DefaultMutableTreeNode();
            for (int w = 0; w < weeks[m]; ++w) {
                monthNode.add((DefaultMutableTreeNode)yearNode.getChildAt(0));
            }
            if (null == firstMonthNode) {
                firstMonthNode = monthNode;
                month = MonthN.getMonth(1);
            } else {
                month = month.nextMonth();
            }
            HierarchyGenerator.setPeriod(monthNode, month);
            yearNode.add(monthNode);
        }
        if (!firstMonthNode.equals(yearNode.getChildAt(0))) {
            monthNode.add((DefaultMutableTreeNode)yearNode.getChildAt(0));
            HierarchyGenerator.setPeriod(monthNode, month);
        }
    }

    private static void addMonths(DefaultMutableTreeNode yearNode, Calendar calendar, int[] dayCounter) {
        for (int m = 1; m <= 12; ++m) {
            DefaultMutableTreeNode monthNode = new DefaultMutableTreeNode();
            int month = calendar.get(2);
            HierarchyGenerator.addDaysToMonth(monthNode, calendar, dayCounter);
            HierarchyGenerator.setPeriod(monthNode, Month.getMonth(month));
            yearNode.add(monthNode);
        }
    }

    private static void addWeeks(DefaultMutableTreeNode yearNode, Calendar calendar, int[] dayCounter) {
        for (int w = 1; w <= 52; ++w) {
            HierarchyGenerator.addWeek(yearNode, calendar, w, dayCounter);
        }
    }

    private static void addWeek(DefaultMutableTreeNode yearNode, Calendar calendar, int week, int[] dayCounter) {
        DefaultMutableTreeNode weekNode = new DefaultMutableTreeNode();
        HierarchyGenerator.addDaysToWeek(weekNode, calendar, dayCounter);
        HierarchyGenerator.setPeriod(weekNode, Week.getWeek(week));
        yearNode.add(weekNode);
    }

    private static void addDaysToMonth(DefaultMutableTreeNode monthNode, Calendar calendar, int[] dayCounter) {
        int month = calendar.get(2);
        do {
            monthNode.add(HierarchyGenerator.newDay(calendar, dayCounter));
            calendar.add(5, 1);
        } while (calendar.get(2) == month);
    }

    private static void addDaysToWeek(DefaultMutableTreeNode weekNode, Calendar calendar, int[] dayCounter) {
        for (int d = 1; d <= 7; ++d) {
            weekNode.add(HierarchyGenerator.newDay(calendar, dayCounter));
            calendar.add(5, 1);
        }
    }

    private static int daysLeftInMonth(Calendar calendar) {
        return calendar.getActualMaximum(5) - calendar.get(5);
    }

    private static DefaultMutableTreeNode newDay(Calendar calendar, int[] dayCounter) {
        dayCounter[0] = dayCounter[0] + 1;
        int day = dayCounter[0];
        Date date = calendar.getTime();
        Period period = new Period(DayN.getDay(day), date, date);
        return new DefaultMutableTreeNode(period);
    }

    private static Period getPeriod(DefaultMutableTreeNode node) {
        return (Period)node.getUserObject();
    }

    private static void setPeriod(DefaultMutableTreeNode node, PeriodType periodType) {
        Period period = new Period(periodType, HierarchyGenerator.getStartDate(node), HierarchyGenerator.getEndDate(node));
        node.setUserObject(period);
    }

    private static Date getStartDate(DefaultMutableTreeNode node) {
        return HierarchyGenerator.getPeriod((DefaultMutableTreeNode)node.getFirstChild()).getStartDate();
    }

    private static Date getEndDate(DefaultMutableTreeNode node) {
        return HierarchyGenerator.getPeriod((DefaultMutableTreeNode)node.getLastChild()).getEndDate();
    }

    private HierarchyGenerator() {
    }
}

