/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.streaming.client;

import com.sas.svcs.streaming.client.BinaryStreamServiceInterface;
import com.sas.svcs.streaming.client.GeneralServiceExceptionHolder;
import com.sas.svcs.streaming.client.types.ExceptionType;
import com.sas.svcs.streaming.client.types.ReadBytes;
import com.sas.svcs.streaming.client.types.ReadBytesResponse;
import java.io.IOException;

public class InputStream
extends java.io.InputStream {
    private static final ReadBytes readOneByte = new ReadBytes();
    private boolean isClosed;
    private final BinaryStreamServiceInterface _binaryStream;

    public InputStream(BinaryStreamServiceInterface binaryStream) {
        if (binaryStream == null) {
            throw new IllegalArgumentException("A non-null binary stream must be specified.");
        }
        this._binaryStream = binaryStream;
    }

    @Override
    public int read() throws IOException {
        if (this.isClosed) {
            throw new IOException("Stream already closed");
        }
        try {
            ReadBytesResponse response = this._binaryStream.readBytes(readOneByte);
            if (response == null) {
                throw new IOException("Server response was null");
            }
            byte[] bytes = response.getBinaryData();
            if (bytes == null) {
                throw new IOException("Server response contained no binary data");
            }
            if (bytes.length == 0) {
                return -1;
            }
            return response.getBinaryData()[0];
        }
        catch (GeneralServiceExceptionHolder e) {
            ExceptionType et;
            String message = e.getMessage();
            if (message == null && (et = e.getExceptionType()) != null) {
                message = et.getMessage();
            }
            throw new IOException(message);
        }
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (this.isClosed) {
            throw new IOException("Stream already closed");
        }
        if (b == null) {
            throw new NullPointerException("A non-null byte array must be specified.");
        }
        if (off < 0) {
            throw new IndexOutOfBoundsException("The offset index must be greater than or equal to zero.");
        }
        if (len < 0) {
            throw new IndexOutOfBoundsException("The length must be greater than zero.");
        }
        if (off + len < 0) {
            throw new IndexOutOfBoundsException("The offset " + off + " plus length " + len + " must be greater than zero.");
        }
        if (off >= b.length) {
            throw new IndexOutOfBoundsException("The offset index " + off + " should be less than the byte array length " + b.length + '.');
        }
        if (off + len > b.length) {
            throw new IndexOutOfBoundsException("The offset " + off + " plus length " + len + " can not exceed the length of the byte array " + b.length + '.');
        }
        if (len == 0) {
            return 0;
        }
        try {
            ReadBytes readBytes = new ReadBytes();
            readBytes.setRequestedLength(len);
            ReadBytesResponse response = this._binaryStream.readBytes(readBytes);
            if (response == null) {
                throw new IOException("Server response was null");
            }
            byte[] bytes = response.getBinaryData();
            if (bytes == null) {
                throw new IOException("Server response contained no binary data");
            }
            if (bytes.length == 0) {
                return -1;
            }
            int numBytes = Math.min(len, bytes.length);
            System.arraycopy(bytes, 0, b, off, numBytes);
            return numBytes;
        }
        catch (GeneralServiceExceptionHolder e) {
            ExceptionType et;
            String message = e.getMessage();
            if (message == null && (et = e.getExceptionType()) != null) {
                message = et.getMessage();
            }
            throw new IOException(message);
        }
    }

    @Override
    public void close() throws IOException {
        if (this.isClosed) {
            return;
        }
        try {
            this.isClosed = true;
            this._binaryStream.destroy();
        }
        catch (GeneralServiceExceptionHolder e) {
            ExceptionType et;
            String message = e.getMessage();
            if (message == null && (et = e.getExceptionType()) != null) {
                message = et.getMessage();
            }
            throw new IOException(message);
        }
    }

    static {
        readOneByte.setRequestedLength(1);
    }
}

