/*
 * Decompiled with CFR 0.152.
 */
package com.sas.tkts.util;

import com.sas.tkts.info.ParameterInfo;
import com.sas.tkts.logging.AbstractLogger;
import com.sas.tkts.logging.LoggerFactory;
import com.sas.tkts.sql.LocalizedErrorHandler;
import com.sas.tkts.util.TimeRepresentation;
import java.io.InputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.Vector;

public class UtilityFunctions {
    private static String thisClassName = UtilityFunctions.class.getName();
    private static AbstractLogger logger = LoggerFactory.getLogger(thisClassName);
    static final byte zeroByte = 0;
    static final Byte zeroByteObj = new Byte(0);
    static final double zeroDouble = 0.0;
    static final Double zeroDoubleObj = new Double(0.0);
    static final float zeroFloat = 0.0f;
    static final Float zeroFloatObj = new Float(0.0);
    private static final int BYTES_PER_ROW = 10;

    private UtilityFunctions() {
    }

    public static byte[] convertStringArrayIntoByteArray(String[] strings) {
        if (strings == null || strings.length == 0) {
            return new byte[0];
        }
        int totalLen = 0;
        int indx = 0;
        for (int i = 0; i < strings.length; ++i) {
            totalLen += strings[i].length();
        }
        byte[] result = new byte[totalLen];
        for (int i = 0; i < strings.length; ++i) {
            for (int j = 0; j < strings[i].length(); ++j) {
                result[indx++] = (byte)strings[i].charAt(j);
            }
        }
        return result;
    }

    public static String fillTailWith(char character, String name, int maxSize) {
        if (name.length() > maxSize) {
            name = name.substring(0, maxSize);
        } else if (name.length() < maxSize) {
            int leftSpace = maxSize - name.length();
            char[] leftSpaces = new char[leftSpace];
            Arrays.fill(leftSpaces, character);
            name = name + String.valueOf(leftSpaces);
        }
        return name;
    }

    public static String fillHeadWith(char character, String name, int maxSize) {
        if (name.length() > maxSize) {
            name = name.substring(0, maxSize);
        } else if (name.length() < maxSize) {
            int leftSpace = maxSize - name.length();
            char[] leftSpaces = new char[leftSpace];
            Arrays.fill(leftSpaces, character);
            String leftSpacesStr = String.valueOf(leftSpaces);
            name = leftSpacesStr + name;
        }
        return name;
    }

    public static int mapSQLType2CType(ParameterInfo parameterInfo, int sqlType) {
        int cType = 0;
        parameterInfo.setSQLType(sqlType);
        switch (sqlType) {
            case -4: {
                parameterInfo.setDisplaySize(-2L);
                cType = 2;
                break;
            }
            case -10: 
            case -1: {
                parameterInfo.setSQLType(-1);
                parameterInfo.setDisplaySize(-2L);
                cType = 1;
                break;
            }
            case -9: {
                parameterInfo.setSQLType(12);
                cType = 1;
                break;
            }
            case -8: {
                parameterInfo.setSQLType(1);
                cType = 1;
                break;
            }
            case 1: 
            case 12: {
                cType = 1;
                break;
            }
            case -3: 
            case -2: {
                cType = 2;
                break;
            }
            case 6: 
            case 7: {
                cType = 4;
                parameterInfo.setBufferLength(8);
                break;
            }
            case 2: 
            case 3: {
                cType = 5;
                parameterInfo.setBufferLength(19);
                break;
            }
            case 8: {
                cType = 6;
                parameterInfo.setBufferLength(8);
                break;
            }
            case 4: {
                cType = 10;
                parameterInfo.setBufferLength(4);
                parameterInfo.setDecimalDigits(0);
                break;
            }
            case -5: {
                cType = 8;
                parameterInfo.setBufferLength(8);
                break;
            }
            case -7: 
            case -6: 
            case 16: {
                cType = 14;
                parameterInfo.setBufferLength(1);
                break;
            }
            case 5: {
                cType = 12;
                parameterInfo.setBufferLength(2);
                break;
            }
            case 91: {
                cType = 17;
                parameterInfo.setBufferLength(6);
                break;
            }
            case 92: {
                cType = 18;
                parameterInfo.setBufferLength(6);
                break;
            }
            case 93: {
                cType = 19;
                parameterInfo.setBufferLength(16);
                break;
            }
            case 0: {
                cType = 0;
                break;
            }
            default: {
                cType = sqlType;
            }
        }
        parameterInfo.setCType(cType);
        return cType;
    }

    public static String getSQLTypeAsString(int sqlType) {
        String name = "UNKNOWN";
        switch (sqlType) {
            case -7: {
                name = "java.sql.Types.BIT";
                break;
            }
            case -6: {
                name = "java.sql.Types.TINYINT";
                break;
            }
            case 5: {
                name = "java.sql.Types.SMALLINT";
                break;
            }
            case 4: {
                name = "java.sql.Types.INTEGER";
                break;
            }
            case -5: {
                name = "java.sql.Types.BIGINT";
                break;
            }
            case 6: {
                name = "java.sql.Types.FLOAT";
                break;
            }
            case 7: {
                name = "java.sql.Types.REAL";
                break;
            }
            case 8: {
                name = "java.sql.Types.DOUBLE";
                break;
            }
            case 2: {
                name = "java.sql.Types.NUMERIC";
                break;
            }
            case 3: {
                name = "java.sql.Types.DECIMAL";
                break;
            }
            case 1: {
                name = "java.sql.Types.CHAR";
                break;
            }
            case 12: {
                name = "java.sql.Types.VARCHAR";
                break;
            }
            case -1: {
                name = "java.sql.Types.LONGVARCHAR";
                break;
            }
            case 91: {
                name = "java.sql.Types.DATE";
                break;
            }
            case 92: {
                name = "java.sql.Types.TIME";
                break;
            }
            case 93: {
                name = "java.sql.Types.TIMESTAMP";
                break;
            }
            case -2: {
                name = "java.sql.Types.BINARY";
                break;
            }
            case -3: {
                name = "java.sql.Types.VARBINARY";
                break;
            }
            case -4: {
                name = "java.sql.Types.LONGVARBINARY";
                break;
            }
            case 0: {
                name = "java.sql.Types.NULL";
                break;
            }
            case 1111: {
                name = "java.sql.Types.OTHER";
                break;
            }
            case 2000: {
                name = "java.sql.Types.JAVA_OBJECT";
                break;
            }
            case 2001: {
                name = "java.sql.Types.DISTINCT";
                break;
            }
            case 2002: {
                name = "java.sql.Types.STRUCT";
                break;
            }
            case 2003: {
                name = "java.sql.Types.ARRAY";
                break;
            }
            case 2004: {
                name = "java.sql.Types.BLOB";
                break;
            }
            case 2005: {
                name = "java.sql.Types.CLOB";
                break;
            }
            case 2006: {
                name = "java.sql.Types.REF";
                break;
            }
            case 70: {
                name = "java.sql.Types.DATALINK";
                break;
            }
            case 16: {
                name = "java.sql.Types.BOOLEAN";
                break;
            }
        }
        return name;
    }

    public static String getJavaTypeClassName(int sqlType) {
        String columnClassName = "";
        switch (sqlType) {
            case 91: {
                columnClassName = Date.class.getName();
                break;
            }
            case 92: {
                columnClassName = Time.class.getName();
                break;
            }
            case 93: {
                columnClassName = Timestamp.class.getName();
                break;
            }
            case -7: {
                columnClassName = Boolean.class.getName();
                break;
            }
            case 4: {
                columnClassName = Integer.class.getName();
                break;
            }
            case 5: {
                columnClassName = Short.class.getName();
                break;
            }
            case 2: 
            case 3: {
                columnClassName = BigDecimal.class.getName();
                break;
            }
            case -4: 
            case -3: 
            case -2: {
                columnClassName = Byte.TYPE.getName();
                break;
            }
            case -6: {
                columnClassName = Byte.class.getName();
                break;
            }
            case -5: {
                columnClassName = Long.class.getName();
                break;
            }
            case 7: {
                columnClassName = Float.class.getName();
                break;
            }
            case 6: 
            case 8: {
                columnClassName = Double.class.getName();
                break;
            }
            case -1: 
            case 1: 
            case 12: {
                columnClassName = String.class.getName();
                break;
            }
            default: {
                columnClassName = "";
            }
        }
        return columnClassName;
    }

    public static int getObjectSQLType(Object theObject) {
        int sqlType = 0;
        Class<?> myClass = theObject.getClass();
        boolean isArray = myClass.isArray();
        if (isArray) {
            if (theObject instanceof byte[]) {
                sqlType = -3;
            } else if (AbstractLogger.isTrace) {
                logger.trace("Array of unsupported object or primatives(not byte[])");
            }
        } else if (theObject instanceof String) {
            sqlType = 12;
        } else if (theObject instanceof Number) {
            if (theObject instanceof BigDecimal) {
                sqlType = 2;
            } else if (theObject instanceof BigInteger) {
                sqlType = 2;
            } else if (theObject instanceof Byte) {
                sqlType = -6;
            } else if (theObject instanceof Double) {
                sqlType = 8;
            } else if (theObject instanceof Float) {
                sqlType = 6;
            } else if (theObject instanceof Integer) {
                sqlType = 4;
            } else if (theObject instanceof Long) {
                sqlType = -5;
            } else if (theObject instanceof Short) {
                sqlType = 5;
            }
        } else if (theObject instanceof java.util.Date) {
            if (theObject instanceof Date) {
                sqlType = 91;
            } else if (theObject instanceof Time) {
                sqlType = 92;
            } else if (theObject instanceof Timestamp) {
                sqlType = 93;
            } else if (theObject instanceof java.util.Date) {
                sqlType = 1111;
            }
        } else if (theObject instanceof Boolean) {
            sqlType = -6;
        } else if (theObject instanceof Blob) {
            sqlType = 2004;
        } else if (theObject instanceof Clob) {
            sqlType = 2005;
        } else if (theObject instanceof Array) {
            sqlType = 2003;
        } else if (theObject instanceof Calendar) {
            sqlType = 1111;
        }
        return sqlType;
    }

    public static DriverPropertyInfo[] getDriverPropertyInfo() {
        DriverPropertyInfo[] DRIVER_PROPERTY_INFO;
        block4: {
            DRIVER_PROPERTY_INFO = null;
            Driver driver = null;
            try {
                Class.forName("com.sas.tkts.TKTSDriver");
                driver = DriverManager.getDriver("jdbc:sastkts://");
                DRIVER_PROPERTY_INFO = driver.getPropertyInfo(null, null);
            }
            catch (ClassNotFoundException cnfe) {
                if (AbstractLogger.isError) {
                    logger.error("getDriverPropertyInfo: ");
                    logger.error(cnfe);
                }
            }
            catch (SQLException se) {
                if (!AbstractLogger.isError) break block4;
                logger.error("getDriverPropertyInfo: ");
                logger.error(se);
            }
        }
        return DRIVER_PROPERTY_INFO;
    }

    public static String getDriverPropertyValue(String inKey, Properties inProps, DriverPropertyInfo[] DPI) {
        String outString = null;
        if (DPI == null) {
            return outString;
        }
        Enumeration<Object> a = inProps.keys();
        while (a.hasMoreElements()) {
            String key = (String)a.nextElement();
            if (!key.equalsIgnoreCase(inKey)) continue;
            String value = (String)inProps.get(key);
            return value;
        }
        for (DriverPropertyInfo dpi : DPI) {
            if (!inKey.equalsIgnoreCase(dpi.name) || (outString = dpi.value) == null || outString.length() != 0) continue;
            outString = null;
        }
        return outString;
    }

    public static String getSortedString(Properties inProps) {
        String outString = "";
        DriverPropertyInfo[] DRIVER_PROPERTY_INFO = UtilityFunctions.getDriverPropertyInfo();
        if (DRIVER_PROPERTY_INFO == null) {
            return outString;
        }
        String FORMAT = "%s=%s\n";
        TreeMap<Object, Object> sortedProps = new TreeMap<Object, Object>(inProps);
        Set keySet = sortedProps.keySet();
        for (String key : keySet) {
            String value = inProps.getProperty(key);
            outString = outString + String.format("%s=%s\n", key, value);
        }
        return outString;
    }

    public static void throwInvalidObjectException(Object theObject) throws SQLException {
        Class<?> myClass = theObject.getClass();
        boolean isArray = myClass.isArray();
        if (isArray) {
            if (theObject instanceof byte[]) {
                return;
            }
            Class<?> componentType = myClass.getComponentType();
            if (AbstractLogger.isTrace) {
                logger.trace("Array of unsupported Object Types:" + componentType);
            }
            String ei = "TKTSPreparedStatement.setObjectErrorArray.fmt";
            Object[] args = new String[]{componentType.toString()};
            LocalizedErrorHandler.throwLocalizedException("TKTSPreparedStatement.setObjectErrorArray.fmt", args, logger);
        } else {
            if (theObject instanceof String) {
                return;
            }
            if (theObject instanceof Number) {
                if (theObject instanceof BigDecimal) {
                    return;
                }
                if (theObject instanceof BigInteger) {
                    return;
                }
                if (theObject instanceof Byte) {
                    return;
                }
                if (theObject instanceof Double) {
                    return;
                }
                if (theObject instanceof Float) {
                    return;
                }
                if (theObject instanceof Integer) {
                    return;
                }
                if (theObject instanceof Long) {
                    return;
                }
                if (theObject instanceof Short) {
                    return;
                }
            } else if (theObject instanceof java.util.Date) {
                if (theObject instanceof Date) {
                    return;
                }
                if (theObject instanceof Time) {
                    return;
                }
                if (theObject instanceof Timestamp) {
                    return;
                }
                if (theObject instanceof java.util.Date) {
                    return;
                }
            } else {
                if (theObject instanceof Boolean) {
                    return;
                }
                if (theObject instanceof Blob) {
                    return;
                }
                if (theObject instanceof Clob) {
                    return;
                }
                if (theObject instanceof Array) {
                    return;
                }
                if (theObject instanceof TimeRepresentation) {
                    return;
                }
                if (theObject instanceof Calendar) {
                    return;
                }
                Class<?> theObjectClass = theObject.getClass();
                String ei = "TKTSPreparedStatement.setObjectError.txt";
                Object[] args = new String[]{theObjectClass.toString()};
                LocalizedErrorHandler.throwLocalizedException("TKTSPreparedStatement.setObjectError.txt", args, logger);
            }
        }
    }

    public static String compressString(String value) {
        int cur = 0;
        int nex = 0;
        char[] chars = value.toUpperCase().toCharArray();
        while (nex < chars.length) {
            if (chars[nex] == ' ') {
                ++nex;
                continue;
            }
            chars[cur++] = chars[nex++];
        }
        return new String(chars, 0, cur);
    }

    public static boolean evaluateBooleanProperty(String sValue, boolean defaultValue) {
        boolean returnedValue = false;
        if (sValue == null || sValue.equals("")) {
            returnedValue = defaultValue;
        } else if (sValue.equalsIgnoreCase("true")) {
            returnedValue = true;
        }
        return returnedValue;
    }

    public static int evaluateIntegerProperty(String sValue, int defaultValue) {
        int value = defaultValue;
        try {
            value = Integer.valueOf(sValue);
        }
        catch (Exception e) {
            if (AbstractLogger.isError) {
                logger.error("getDriverPropertyInfo: ");
                logger.error(e);
            }
            value = defaultValue;
        }
        return value;
    }

    public static String evaluateStringProperty(String sValue, String defaultValue) {
        if (sValue == null || sValue.equals("")) {
            return defaultValue;
        }
        return sValue;
    }

    public static int[] extractIntArrayFromIntegerVector(Vector<Integer> vector) {
        Integer[] values = new Integer[vector.size()];
        vector.toArray(values);
        int[] result = new int[values.length];
        for (int i = 0; i < values.length; ++i) {
            result[i] = values[i];
        }
        return result;
    }

    public static void applyCalendar(Date date, Calendar cal) {
        if (cal != null) {
            Calendar target = Calendar.getInstance(cal.getTimeZone());
            target.clear();
            target.setTime(date);
            Calendar jvmCal = Calendar.getInstance();
            jvmCal.clear();
            jvmCal.setTime(date);
            int zoneOffset = jvmCal.get(15) - target.get(15);
            int dstOffset = jvmCal.get(16) - target.get(16);
            long tzOffset = zoneOffset + dstOffset;
            date.setTime(date.getTime() - tzOffset);
        }
    }

    public static void applyCalendar(Time time, Calendar cal) {
        if (cal != null) {
            Calendar target = Calendar.getInstance(cal.getTimeZone());
            target.clear();
            target.setTime(time);
            Calendar jvmCal = Calendar.getInstance();
            jvmCal.clear();
            jvmCal.setTime(time);
            int zoneOffset = jvmCal.get(15) - target.get(15);
            int dstOffset = jvmCal.get(16) - target.get(16);
            long tzOffset = zoneOffset + dstOffset;
            time.setTime(time.getTime() - tzOffset);
        }
    }

    public static void applyCalendar(Timestamp timestamp, Calendar cal) {
        if (cal != null) {
            int nanoSec = timestamp.getNanos();
            Calendar target = Calendar.getInstance(cal.getTimeZone());
            target.clear();
            target.setTime(timestamp);
            Calendar jvmCal = Calendar.getInstance();
            jvmCal.clear();
            jvmCal.setTime(timestamp);
            int zoneOffset = jvmCal.get(15) - target.get(15);
            int dstOffset = jvmCal.get(16) - target.get(16);
            long tzOffset = zoneOffset + dstOffset;
            timestamp.setTime(timestamp.getTime() - tzOffset);
            timestamp.setNanos(nanoSec);
        }
    }

    public static String escapeStringValue(String value, char theChar) {
        char[] chars = value.toCharArray();
        int count = 0;
        for (int i = 0; i < chars.length; ++i) {
            if (chars[i] != theChar) continue;
            ++count;
        }
        if (count > 0) {
            char[] newChars = new char[chars.length + count];
            int j = 0;
            for (int i = 0; i < chars.length; ++i) {
                if (chars[i] == theChar) {
                    newChars[j++] = chars[i];
                }
                newChars[j++] = chars[i];
            }
            value = new String(newChars);
        }
        return value;
    }

    public static int countParameters(String sql) {
        int parmCount = 0;
        int inquotes = -1;
        int length = 0;
        int n = length = sql == null ? 0 : sql.length();
        for (int b = 0; b < length; ++b) {
            if (sql.charAt(b) == '\'' || sql.charAt(b) == '\"') {
                if (inquotes == -1) {
                    inquotes = sql.charAt(b);
                } else if (inquotes == sql.charAt(b)) {
                    inquotes = -1;
                }
            }
            if (sql.charAt(b) != '?' || inquotes != -1) continue;
            ++parmCount;
        }
        return parmCount;
    }

    public static Boolean convertToBoolean(Object iObj) {
        Boolean oObj = null;
        boolean oValue = false;
        if (iObj == null) {
            return oValue;
        }
        if (iObj instanceof String) {
            String value = (String)iObj;
            if (value.compareToIgnoreCase("yes") == 0) {
                oObj = Boolean.TRUE;
            } else if (value.compareToIgnoreCase("no") == 0) {
                oObj = Boolean.FALSE;
            }
        } else if (iObj instanceof Number) {
            if (iObj instanceof Byte) {
                Byte value = (Byte)iObj;
                int compare = value.compareTo(zeroByteObj);
                oObj = compare != 0 ? Boolean.TRUE : Boolean.FALSE;
            } else if (iObj instanceof Double) {
                Double value = (Double)iObj;
                int compare = value.compareTo(0.0);
                oObj = compare != 0 ? Boolean.TRUE : Boolean.FALSE;
            } else if (iObj instanceof Float) {
                Float value = (Float)iObj;
                int compare = value.compareTo(zeroFloatObj);
                oObj = compare != 0 ? Boolean.TRUE : Boolean.FALSE;
            } else if (iObj instanceof Integer) {
                Integer value = (Integer)iObj;
                oObj = value != 0 ? Boolean.TRUE : Boolean.FALSE;
            } else if (iObj instanceof Short) {
                Short value = (Short)iObj;
                oObj = value != 0 ? Boolean.TRUE : Boolean.FALSE;
            }
        }
        if (oObj != null) {
            oValue = oObj;
        }
        return oValue;
    }

    public static String convertToString(Object iObj) {
        String oValue = null;
        if (iObj == null) {
            return oValue;
        }
        oValue = iObj.toString();
        return oValue;
    }

    public static String sqlWarnings(SQLWarning sw) {
        String outStr = null;
        if (sw == null) {
            outStr = "SQLWarnings: None";
            outStr = outStr + "\n";
        } else {
            outStr = "SQLWarnings: ";
            int i = 0;
            while (sw != null) {
                outStr = outStr + "\nWarning[" + i + "]: ";
                outStr = outStr + "\n  Cause:" + sw.getCause();
                outStr = outStr + "\n  ErrorCode:" + sw.getErrorCode();
                outStr = outStr + "\n  LocalizedMessage:" + sw.getLocalizedMessage();
                outStr = outStr + "\n  Message:" + sw.getMessage();
                outStr = outStr + "\n  SQLState:" + sw.getSQLState();
                outStr = outStr + "\n";
                sw = sw.getNextWarning();
            }
        }
        return outStr;
    }

    public static int getDataTruncationLength(Object theObject) {
        int out = -1;
        if (theObject == null) {
            out = 0;
            return out;
        }
        if (theObject instanceof String) {
            out = ((String)theObject).length();
        } else if (theObject instanceof Number) {
            if (theObject instanceof BigDecimal) {
                out = 19;
            } else if (theObject instanceof BigInteger) {
                out = 19;
            } else if (theObject instanceof Byte) {
                out = 1;
            } else if (theObject instanceof Double) {
                out = 8;
            } else if (theObject instanceof Float) {
                out = 8;
            } else if (theObject instanceof Integer) {
                out = 4;
            } else if (theObject instanceof Long) {
                out = 8;
            } else if (theObject instanceof Short) {
                out = 2;
            }
        } else if (theObject instanceof java.util.Date) {
            if (theObject instanceof Date) {
                out = 6;
            } else if (theObject instanceof Time) {
                out = 6;
            } else if (theObject instanceof Timestamp) {
                out = 16;
            }
        } else if (theObject instanceof Boolean) {
            out = 1;
        } else if (theObject.getClass().isArray() && theObject.getClass().getComponentType() == Byte.TYPE) {
            out = ((byte[])theObject).length;
        } else if (theObject instanceof Blob) {
            out = -1;
        } else if (theObject instanceof Clob) {
            out = -1;
        } else if (theObject instanceof Array) {
            out = ((byte[])theObject).length;
        }
        return out;
    }

    public static String[] defaultStringArray(int entries, String value) {
        String[] out = new String[entries];
        for (int i = 0; i < entries; ++i) {
            out[i] = value;
        }
        return out;
    }

    public static boolean hasInsertInto(String inSql) {
        int i;
        String sqlUC = inSql.toUpperCase();
        String INSERT_TEXT = "INSERT ";
        String INTO_TEXT = " INTO ";
        int insert_position = sqlUC.indexOf("INSERT ");
        int into_position = sqlUC.indexOf(" INTO ");
        if (insert_position == -1 || into_position == -1) {
            return false;
        }
        for (i = 0; i < insert_position; ++i) {
            if (sqlUC.charAt(i) == ' ') continue;
            return false;
        }
        for (i = insert_position + "INSERT ".length(); i < into_position; ++i) {
            if (sqlUC.charAt(i) == ' ') continue;
            return false;
        }
        return true;
    }

    public static byte[] streamToArray(String method, InputStream theStream) throws SQLException {
        int BYTES_PER_READ = 131072;
        ArrayList<byte[]> dataList = new ArrayList<byte[]>(100);
        byte[] data = new byte[131072];
        int bytesInStream = 0;
        byte[] newValue = null;
        try {
            int bytesRead;
            while ((bytesRead = theStream.read(data, 0, data.length)) != -1) {
                bytesInStream += bytesRead;
                dataList.add(data);
                data = new byte[131072];
            }
            int eCnt = 0;
            int destPos = 0;
            newValue = new byte[bytesInStream];
            while (bytesInStream > 0) {
                int dataBytes = bytesInStream > 131072 ? 131072 : bytesInStream;
                data = (byte[])dataList.get(eCnt);
                System.arraycopy(data, 0, newValue, destPos, dataBytes);
                ++eCnt;
                destPos += dataBytes;
                bytesInStream -= dataBytes;
            }
        }
        catch (Exception ex) {
            String ei = "Generic.InputStreamError.fmt";
            Object[] args = new String[]{method, ex.getLocalizedMessage()};
            String es = LocalizedErrorHandler.getLocalizedError("Generic.InputStreamError.fmt", args);
            SQLException outSE = new SQLException(es);
            throw outSE;
        }
        return newValue;
    }

    public static int getFormatBytesRowSize() {
        return 10;
    }

    public static String formatBytes(byte[] bl, int startOffset, int bytesToFormat) {
        int BYTES_PER_ROW = 10;
        String s = "";
        boolean truncate = false;
        if (bytesToFormat > 10) {
            bytesToFormat = 10;
            truncate = true;
        }
        if (bytesToFormat > 0) {
            int i = startOffset;
            switch (bytesToFormat) {
                case 10: {
                    s = s + String.format("[%10d] %4d, %4d, %4d, %4d, %4d, %4d, %4d, %4d, %4d, %4d", i, bl[i++], bl[i++], bl[i++], bl[i++], bl[i++], bl[i++], bl[i++], bl[i++], bl[i++], bl[i++]);
                    break;
                }
                case 9: {
                    s = s + String.format("[%10d] %4d, %4d, %4d, %4d, %4d, %4d, %4d, %4d, %4d", i, bl[i++], bl[i++], bl[i++], bl[i++], bl[i++], bl[i++], bl[i++], bl[i++], bl[i++]);
                    break;
                }
                case 8: {
                    s = s + String.format("[%10d] %4d, %4d, %4d, %4d, %4d, %4d, %4d, %4d", i, bl[i++], bl[i++], bl[i++], bl[i++], bl[i++], bl[i++], bl[i++], bl[i++]);
                    break;
                }
                case 7: {
                    s = s + String.format("[%10d] %4d, %4d, %4d, %4d, %4d, %4d, %4d", i, bl[i++], bl[i++], bl[i++], bl[i++], bl[i++], bl[i++], bl[i++]);
                    break;
                }
                case 6: {
                    s = s + String.format("[%10d] %4d, %4d, %4d, %4d, %4d, %4d", i, bl[i++], bl[i++], bl[i++], bl[i++], bl[i++], bl[i++]);
                    break;
                }
                case 5: {
                    s = s + String.format("[%10d] %4d, %4d, %4d, %4d, %4d", i, bl[i++], bl[i++], bl[i++], bl[i++], bl[i++]);
                    break;
                }
                case 4: {
                    s = s + String.format("[%10d] %4d, %4d, %4d, %4d", i, bl[i++], bl[i++], bl[i++], bl[i++]);
                    break;
                }
                case 3: {
                    s = s + String.format("[%10d] %4d, %4d, %4d", i, bl[i++], bl[i++], bl[i++]);
                    break;
                }
                case 2: {
                    s = s + String.format("[%10d] %4d, %4d", i, bl[i++], bl[i++]);
                    break;
                }
                case 1: {
                    s = s + String.format("[%10d] %4d", i, bl[i++]);
                    break;
                }
                default: {
                    s = "Error:";
                }
            }
            if (truncate) {
                s = s + " Truncated!!";
            }
        } else {
            s = "NULL";
        }
        return s;
    }

    public static String formatBytesHex(byte[] bl, int startOffset, int bytesToFormat) {
        int BYTES_PER_ROW = 10;
        String s = "";
        boolean truncate = false;
        if (bytesToFormat > 10) {
            bytesToFormat = 10;
            truncate = true;
        }
        if (bytesToFormat > 0) {
            int i = startOffset;
            switch (bytesToFormat) {
                case 10: {
                    s = s + String.format("[%10d] %2x, %2x, %2x, %2x, %2x, %2x, %2x, %2x, %2x, %2x", i, bl[i++], bl[i++], bl[i++], bl[i++], bl[i++], bl[i++], bl[i++], bl[i++], bl[i++], bl[i++]);
                    break;
                }
                case 9: {
                    s = s + String.format("[%10d] %2x, %2x, %2x, %2x, %2x, %2x, %2x, %2x, %2x", i, bl[i++], bl[i++], bl[i++], bl[i++], bl[i++], bl[i++], bl[i++], bl[i++], bl[i++]);
                    break;
                }
                case 8: {
                    s = s + String.format("[%10d] %2x, %2x, %2x, %2x, %2x, %2x, %2x, %2x", i, bl[i++], bl[i++], bl[i++], bl[i++], bl[i++], bl[i++], bl[i++], bl[i++]);
                    break;
                }
                case 7: {
                    s = s + String.format("[%10d] %2x, %2x, %2x, %2x, %2x, %2x, %2x", i, bl[i++], bl[i++], bl[i++], bl[i++], bl[i++], bl[i++], bl[i++]);
                    break;
                }
                case 6: {
                    s = s + String.format("[%10d] %2x, %2x, %2x, %2x, %2x, %2x", i, bl[i++], bl[i++], bl[i++], bl[i++], bl[i++], bl[i++]);
                    break;
                }
                case 5: {
                    s = s + String.format("[%10d] %2x, %2x, %2x, %2x, %2x", i, bl[i++], bl[i++], bl[i++], bl[i++], bl[i++]);
                    break;
                }
                case 4: {
                    s = s + String.format("[%10d] %2x, %2x, %2x, %2x", i, bl[i++], bl[i++], bl[i++], bl[i++]);
                    break;
                }
                case 3: {
                    s = s + String.format("[%10d] %2x, %2x, %2x", i, bl[i++], bl[i++], bl[i++]);
                    break;
                }
                case 2: {
                    s = s + String.format("[%10d] %2x, %2x", i, bl[i++], bl[i++]);
                    break;
                }
                case 1: {
                    s = s + String.format("[%10d] %2x", i, bl[i++]);
                    break;
                }
                default: {
                    s = "Error:";
                }
            }
            if (truncate) {
                s = s + " Truncated!!";
            }
        } else {
            s = "NULL";
        }
        return s;
    }

    public static String toMD5(String inSring) {
        String outString = null;
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.update(inSring.getBytes());
            byte[] digest = md.digest();
            StringBuffer sb = new StringBuffer();
            for (byte b : digest) {
                sb.append(String.format("%02x", b & 0xFF));
            }
            outString = sb.toString();
        }
        catch (NoSuchAlgorithmException ex) {
            if (AbstractLogger.isError) {
                logger.error("toMD5: ");
                logger.error(ex);
            }
            outString = "********";
        }
        return outString;
    }

    public static String safeToLog(String inValue, String prefix) {
        if (inValue == null) {
            return prefix;
        }
        try {
            int index = inValue.indexOf("pwd");
            if (index >= 0) {
                inValue = "********";
            } else {
                index = inValue.indexOf("password");
                if (index >= 0) {
                    inValue = "********";
                } else {
                    index = inValue.indexOf("uid");
                    if (index >= 0) {
                        inValue = "********";
                    } else {
                        index = inValue.indexOf("user");
                        if (index >= 0) {
                            inValue = "********";
                        } else {
                            index = inValue.indexOf("userName");
                            if (index >= 0) {
                                inValue = "********";
                            }
                        }
                    }
                }
            }
        }
        catch (Exception ex) {
            if (AbstractLogger.isError) {
                logger.error("safeToLog: [" + inValue + "]");
                logger.error(ex);
            }
            inValue = "********";
        }
        return prefix + inValue;
    }

    public static String logProperties(Properties p) {
        String logMessage = "Properties:";
        Enumeration<Object> keys = p.keys();
        if (keys != null) {
            while (keys.hasMoreElements()) {
                String key = (String)keys.nextElement();
                Object objValue = p.get(key);
                if (!(objValue instanceof String)) continue;
                String value = (String)objValue;
                if (key.compareToIgnoreCase("pwd") == 0 || key.compareToIgnoreCase("password") == 0 || key.compareToIgnoreCase("uid") == 0 || key.compareToIgnoreCase("user") == 0 || key.compareToIgnoreCase("userName") == 0) {
                    value = "********";
                } else if (key.compareToIgnoreCase("constring") == 0) {
                    value = UtilityFunctions.safeToLog(value, "");
                }
                logMessage = logMessage + " " + key + "='" + value + "' ";
            }
        }
        return logMessage;
    }

    public static String getPortNumber(String url) throws SQLException {
        int hostNameEndsAt;
        String method = "getPortNumber(url)";
        int portNumberEndsAt = url.indexOf(63);
        String portNumber = null;
        if (portNumberEndsAt == -1) {
            portNumberEndsAt = url.length();
        }
        if ((hostNameEndsAt = url.lastIndexOf(58, portNumberEndsAt)) == -1 || hostNameEndsAt + 1 > portNumberEndsAt || url.length() < hostNameEndsAt + 2) {
            String ei = "TKTSConnection.urlError.txt";
            LocalizedErrorHandler.throwLocalizedException("TKTSConnection.urlError.txt", logger);
        }
        portNumber = url.substring(hostNameEndsAt + 1, portNumberEndsAt);
        try {
            new Integer(portNumber);
        }
        catch (NumberFormatException e) {
            if (AbstractLogger.isError) {
                logger.error("getPortNumber: ");
                logger.error(e);
            }
            String ei = "TKTSConnection.invalidPortError.fmt";
            LocalizedErrorHandler.throwLocalizedException("TKTSConnection.invalidPortError.fmt", logger, portNumber);
        }
        if (AbstractLogger.isTrace) {
            logger.exit("getPortNumber(url)", portNumber);
        }
        return portNumber;
    }

    public static String getHostName(String url) throws SQLException {
        int hostNameEndsAt;
        int portNumberEndsAt = url.indexOf(63);
        if (portNumberEndsAt == -1) {
            portNumberEndsAt = url.length();
        }
        if ((hostNameEndsAt = url.lastIndexOf(58, portNumberEndsAt)) == -1 || "jdbc:sastkts://".length() > hostNameEndsAt) {
            String ei = "TKTSConnection.urlError.txt";
            LocalizedErrorHandler.throwLocalizedException("TKTSConnection.urlError.txt", logger);
        }
        String hostName = url.substring("jdbc:sastkts://".length(), hostNameEndsAt);
        return hostName;
    }

    public static Properties urlToProperties(String url) {
        String t;
        Properties out = new Properties();
        int qIdx = url.indexOf(63);
        if (qIdx >= 0) {
            String query = url.substring(++qIdx, url.length());
            StringTokenizer pairOff = new StringTokenizer(query, "&", false);
            while (pairOff.hasMoreTokens()) {
                int pi;
                String pair = pairOff.nextToken();
                char last = pair.charAt(pair.length() - 1);
                if (last == '\\') {
                    String realPair;
                    pair = realPair = pair.substring(0, pair.length() - 1) + "&" + pairOff.nextToken();
                }
                if ((pi = pair.indexOf(61)) <= 0) continue;
                String propN = pair.substring(0, pi);
                String propV = pair.substring(pi + 1, pair.length());
                out.put(propN, propV);
            }
        }
        if ((t = out.getProperty("user")) != null) {
            out.remove("user");
            out.put("userName", t);
        }
        return out;
    }

    public static void attemptStringClear(int sl) {
        byte[] b = new byte[sl];
        String s = new String(b);
        if (s.length() == sl) {
            b = null;
            s = null;
        } else {
            s = null;
            b = null;
        }
    }
}

