/*
 * Decompiled with CFR 0.152.
 */
package com.sas.tkts.util;

import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;

public class TimeRepresentation {
    private static String setDate = "Date";
    private static String setTime = "Time";
    private static String setTimestamp = "Timestamp";
    private transient int _YEAR;
    private transient int _MONTH;
    private transient int _DAY_OF_MONTH;
    private transient int _HOUR_OF_DAY;
    private transient int _MINUTES;
    private transient int _SECONDS;
    private transient int _MILLISECONDS;
    private transient int _NANOSECONDS;
    private transient Date dateValue;
    private transient Time timeValue;
    private transient Timestamp timeStampValue;
    private transient Object rawDateTimeValue;

    public TimeRepresentation(Date inDateValue, Calendar calendar) {
        if (calendar == null) {
            calendar = Calendar.getInstance();
        }
        this.dateValue = inDateValue;
        long ms = this.dateValue.getTime();
        calendar.setTime(this.dateValue);
        this.setAllValues(calendar, 0);
        this.rawDateTimeValue = this.dateValue;
        this.timeValue = null;
        this.timeStampValue = new Timestamp(ms);
    }

    public TimeRepresentation(Time inTimeValue, Calendar calendar) {
        if (calendar == null) {
            calendar = Calendar.getInstance();
        }
        this.timeValue = inTimeValue;
        long ms = this.timeValue.getTime();
        calendar.setTimeInMillis(ms);
        this.setAllValues(calendar, 0);
        this.rawDateTimeValue = this.timeValue;
        this.dateValue = null;
        this.timeStampValue = new Timestamp(ms);
    }

    public TimeRepresentation(Timestamp inTimeStampValue, Calendar calendar) {
        if (calendar == null) {
            calendar = Calendar.getInstance();
        }
        this.timeStampValue = inTimeStampValue;
        long ms = this.timeStampValue.getTime();
        calendar.setTimeInMillis(ms);
        int xNanos = this.timeStampValue.getNanos();
        this.setAllValues(calendar, xNanos);
        this.rawDateTimeValue = this.timeStampValue;
        this.timeValue = new Time(ms);
        this.dateValue = new Date(ms);
    }

    private void setAllValues(Calendar calendar, int nanoSeconds) {
        this._YEAR = calendar.get(1);
        this._MONTH = calendar.get(2) + 1;
        this._DAY_OF_MONTH = calendar.get(5);
        this._HOUR_OF_DAY = calendar.get(11);
        this._MINUTES = calendar.get(12);
        this._SECONDS = calendar.get(13);
        this._MILLISECONDS = calendar.get(14);
        this._NANOSECONDS = nanoSeconds;
    }

    public int get_YEAR() {
        return this._YEAR;
    }

    public int get_MONTH() {
        return this._MONTH;
    }

    public int get_DAY_OF_MONTH() {
        return this._DAY_OF_MONTH;
    }

    public int get_HOUR_OF_DAY() {
        return this._HOUR_OF_DAY;
    }

    public int get_MINUTES() {
        return this._MINUTES;
    }

    public int get_SECONDS() {
        return this._SECONDS;
    }

    public int get_MILLISECONDS() {
        return this._MILLISECONDS;
    }

    public int get_NANOSECONDS() {
        return this._NANOSECONDS;
    }

    public Date getDateValue() {
        return this.dateValue;
    }

    public Time getTimeValue() {
        return this.timeValue;
    }

    public Timestamp getTimeStampValue() {
        return this.timeStampValue;
    }

    public Object getRawDateTimeValue() {
        return this.rawDateTimeValue;
    }

    public String toString() {
        String out = null;
        out = this.rawDateTimeValue instanceof Date ? this.dateValue.toString() : (this.rawDateTimeValue instanceof Timestamp ? this.timeStampValue.toString() : (this.rawDateTimeValue instanceof Time ? this.timeValue.toString() : ""));
        return out;
    }

    public String getSetClassName() {
        String out = null;
        if (this.rawDateTimeValue instanceof Date) {
            out = setDate;
        } else if (this.rawDateTimeValue instanceof Timestamp) {
            out = setTime;
        } else if (this.rawDateTimeValue instanceof Time) {
            out = setTimestamp;
        }
        return out;
    }
}

