/*
 * Decompiled with CFR 0.152.
 */
package com.sas.tkts.util;

import com.sas.tkts.logging.AbstractLogger;
import com.sas.tkts.logging.LoggerFactory;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class RegExp {
    private static String thisClassName = RegExp.class.getName();
    private static AbstractLogger logger = LoggerFactory.getLogger(thisClassName);
    private transient String o;
    private transient Pattern p;
    private transient Matcher m;
    private transient String r;
    private transient String d;

    public static String escapeAsteriskChar(String inStr) {
        String outStr;
        String regEx = "(?<!\\\\)\\*";
        String regRep = "\\\\*";
        try {
            outStr = inStr.replaceAll("(?<!\\\\)\\*", "\\\\*");
        }
        catch (Exception ex) {
            if (AbstractLogger.isError) {
                logger.error("escapeAsteriskChar: " + inStr);
                logger.error(ex);
            }
            outStr = inStr;
        }
        return outStr;
    }

    private String sqlPatternToRegExp(String inStr) {
        String escape = "\\";
        String wildCard = "%";
        String placeHolder = "_";
        String wcPattern = "(.*)";
        String wcPlaceholder = ".";
        String emptyString = "";
        int inStrLen = inStr.length();
        int iWC = inStr.indexOf("%");
        int iPH = inStr.indexOf("_");
        if (iWC == -1 && iPH == -1) {
            String outStr = Pattern.quote(inStr);
            return outStr;
        }
        boolean isEscaped = false;
        String outStr = "";
        String quoteStr = "";
        for (int ti = 0; ti < inStrLen; ++ti) {
            String s = inStr.substring(ti, ti + 1);
            String regPattern = null;
            if (s.equals("%")) {
                regPattern = "(.*)";
            } else if (s.equals("_")) {
                regPattern = ".";
            }
            if (regPattern == null) {
                quoteStr = quoteStr + s;
            } else if (isEscaped) {
                int qi = quoteStr.length();
                quoteStr = quoteStr.substring(0, qi - 1);
                quoteStr = quoteStr + s;
            } else {
                if (quoteStr.length() > 0) {
                    outStr = outStr + Pattern.quote(quoteStr);
                }
                outStr = outStr + regPattern;
                quoteStr = "";
            }
            isEscaped = s.equals("\\");
        }
        if (quoteStr.length() > 0) {
            outStr = outStr + Pattern.quote(quoteStr);
        }
        return outStr;
    }

    public RegExp(boolean pva, boolean cs, String inPattern) {
        this.o = inPattern;
        int flags = 64;
        if (!cs) {
            flags += 2;
        }
        this.d = pva ? "flags: patternValueArgument, " : "flags: LiteralIdentifier, ";
        this.d = cs ? this.d + "Case Sensitive " : this.d + "Case Insensitive ";
        this.d = this.d + "\n \"" + inPattern + "\"=>\"";
        if (this.o == null) {
            this.r = null;
            this.p = null;
        } else if (pva) {
            this.r = this.sqlPatternToRegExp(inPattern);
            this.p = Pattern.compile(this.r, flags);
        } else {
            this.r = Pattern.quote(inPattern);
            this.p = Pattern.compile(this.r, flags);
        }
        this.d = this.d + this.r + "\"";
    }

    public boolean matches(String t) {
        if (this.o == null || t == null) {
            return false;
        }
        this.m = this.p.matcher(t);
        boolean match = this.m.matches();
        this.m = null;
        return match;
    }

    public void reset() {
        this.p = null;
        this.m = null;
        this.r = null;
        this.d = "";
    }

    public String toString() {
        return this.d;
    }
}

