/*
 * Decompiled with CFR 0.152.
 */
package com.sas.tkts.util;

public class Counts {
    private boolean COLLECT_HITS;
    private String title;
    private int entriesMax;
    private int[] counts;

    public Counts(String title, int entries, boolean enable) {
        this.title = title;
        this.COLLECT_HITS = enable;
        this.entriesMax = entries;
        this.counts = new int[entries];
    }

    public void update(long ms) {
        if (!this.COLLECT_HITS) {
            return;
        }
        if (ms >= (long)this.entriesMax) {
            ms = this.entriesMax - 1;
        }
        int n = (int)ms;
        this.counts[n] = this.counts[n] + 1;
    }

    public void log() {
        long sum = 0L;
        long cnt = 0L;
        if (!this.COLLECT_HITS) {
            return;
        }
        String o = String.format("%20s Counts:", this.title);
        System.out.println(o);
        for (int i = 0; i < this.entriesMax; ++i) {
            int c = this.counts[i];
            if (c <= 0) continue;
            o = String.format("%20s %5d %12d", this.title, i, c);
            System.out.println(o);
            sum += (long)(c * i);
            cnt += (long)c;
        }
        if (cnt > 0L) {
            o = String.format("%20s Average: %5d ", this.title, sum / cnt);
            System.out.println(o);
        }
    }
}

