/*
 * Decompiled with CFR 0.152.
 */
package com.sas.tkts.types;

import com.sas.tkts.types.NumberColumn;
import com.sas.tkts.util.ParameterInfoHelper;
import com.sas.tkts.util.UtilityFunctions;
import java.math.BigDecimal;
import java.sql.SQLException;

public class NumberColumnShort
extends NumberColumn {
    private short data;

    public NumberColumnShort(short value) {
        short z = 0;
        Short s = new Short(z);
        dataClass = s.getClass();
        this.data = value;
        this.setUpdated(true);
    }

    @Override
    public final NumberColumnShort clone() {
        NumberColumnShort out = new NumberColumnShort(this.data);
        return out;
    }

    @Override
    public BigDecimal getBigDecimal() {
        if (this.isNull()) {
            return null;
        }
        BigDecimal out = new BigDecimal((long)this.data);
        return out;
    }

    @Override
    public boolean getBoolean() {
        return this.booleanLong(this.data);
    }

    @Override
    public byte getByte() {
        return this.rangedLongToByte(this.data);
    }

    @Override
    public Class getDataTypeClass() {
        return dataClass;
    }

    @Override
    public double getDouble() throws SQLException {
        return this.data;
    }

    @Override
    public float getFloat() {
        return this.data;
    }

    @Override
    public int getInt() {
        return this.data;
    }

    @Override
    public long getLong() {
        return this.data;
    }

    @Override
    public Object getObject() throws SQLException {
        Short outObj = null;
        if (!this.isNull()) {
            outObj = new Short(this.data);
        }
        return outObj;
    }

    @Override
    public short getShort() {
        return this.data;
    }

    @Override
    public int getSQLType() {
        return 5;
    }

    @Override
    public String getString() {
        if (this.isNull()) {
            return null;
        }
        return Short.toString(this.data);
    }

    @Override
    public void setBigDecimal(BigDecimal value) {
        if (value == null) {
            this.data = 0;
            this.setUpdated(false);
        } else {
            this.data = value.shortValue();
            this.setUpdated(true);
        }
    }

    @Override
    public void setByte(byte value) {
        this.data = value;
        this.setUpdated(true);
    }

    @Override
    public void setDouble(double value) {
        this.data = this.rangedDoubleToShort(value);
    }

    @Override
    public void setFloat(float value) {
        this.data = this.rangedDoubleToShort(value);
    }

    @Override
    public void setInt(int value) {
        this.data = this.rangedLongToShort(value);
    }

    @Override
    public void setLong(long value) {
        this.data = this.rangedLongToShort(value);
    }

    @Override
    public void setNull() {
        this.data = 0;
        this.setUpdated(false);
    }

    @Override
    public void setObject(Object value) {
        Number inNumber = null;
        if (value == null) {
            this.data = 0;
            this.setUpdated(false);
        } else {
            int sqlType = UtilityFunctions.getObjectSQLType(value);
            inNumber = (Number)ParameterInfoHelper.coerceObject(value, sqlType, false);
            this.data = inNumber.shortValue();
            this.setUpdated(true);
        }
    }

    @Override
    public void setShort(short value) {
        this.data = value;
    }

    @Override
    public String toString() {
        String out = this.isNull() ? "NULL" : Short.toString(this.data);
        return out;
    }
}

