/*
 * Decompiled with CFR 0.152.
 */
package com.sas.tkts.types;

import com.sas.tkts.types.NumberColumn;
import com.sas.tkts.util.ParameterInfoHelper;
import com.sas.tkts.util.UtilityFunctions;
import java.math.BigDecimal;
import java.sql.SQLException;

public class NumberColumnDouble
extends NumberColumn {
    static final double P_DOUBLE_ZERO = 0.0;
    static final double P_DOUBLE_ONE = 1.0;
    static final double P_DOUBLE_NEG_ONE = -1.0;
    private double data;

    public NumberColumnDouble(double value) {
        Double d = new Double(0.0);
        dataClass = d.getClass();
        this.data = value;
        if (Double.isNaN(this.data)) {
            this.setUpdated(false);
        } else {
            this.setUpdated(true);
        }
    }

    @Override
    public void cleanup() {
    }

    @Override
    public final NumberColumnDouble clone() {
        NumberColumnDouble out = new NumberColumnDouble(this.data);
        return out;
    }

    @Override
    public BigDecimal getBigDecimal() {
        return new BigDecimal(this.data);
    }

    @Override
    public boolean getBoolean() {
        return this.booleanDouble(this.data);
    }

    @Override
    public byte getByte() {
        return this.rangedDoubleToByte(this.data);
    }

    @Override
    public Class getDataTypeClass() {
        return dataClass;
    }

    @Override
    public double getDouble() throws SQLException {
        return this.data;
    }

    @Override
    public float getFloat() {
        return this.rangedDoubleToFloat(this.data);
    }

    @Override
    public int getInt() {
        return this.rangedDoubleToInt(this.data);
    }

    @Override
    public long getLong() {
        return this.rangedDoubleToLong(this.data);
    }

    @Override
    public Object getObject() throws SQLException {
        Double outObj = null;
        if (!this.isNull()) {
            outObj = new Double(this.data);
        }
        return outObj;
    }

    @Override
    public Object getRawData() throws SQLException {
        return this.getObject();
    }

    @Override
    public short getShort() {
        return this.rangedDoubleToShort(this.data);
    }

    @Override
    public int getSQLType() {
        return 8;
    }

    @Override
    public String getString() {
        if (this.isNull()) {
            return null;
        }
        return Double.toString(this.data);
    }

    @Override
    public void setBigDecimal(BigDecimal value) {
        if (value == null) {
            this.data = 0.0;
            this.setUpdated(false);
        } else {
            this.data = value.doubleValue();
            this.setUpdated(true);
        }
    }

    @Override
    public void setByte(byte value) {
        this.data = value;
        this.setUpdated(true);
    }

    @Override
    public void setDouble(double value) {
        this.data = value;
        this.setUpdated(true);
    }

    @Override
    public void setFloat(float value) {
        this.data = value;
        this.setUpdated(true);
    }

    @Override
    public void setInt(int value) {
        this.data = value;
        this.setUpdated(true);
    }

    @Override
    public void setLong(long value) {
        this.data = value;
        this.setUpdated(true);
    }

    @Override
    public void setNull() {
        this.data = 0.0;
        this.setUpdated(false);
    }

    public void setNull(double d) {
        this.data = d;
        this.setUpdated(false);
    }

    @Override
    public void setObject(Object value) {
        Number inNumber = null;
        if (value == null) {
            this.data = 0.0;
            this.setUpdated(false);
        } else {
            int sqlType = UtilityFunctions.getObjectSQLType(value);
            inNumber = (Number)ParameterInfoHelper.coerceObject(value, sqlType, false);
            this.data = inNumber.doubleValue();
            this.setUpdated(true);
        }
    }

    @Override
    public void setShort(short value) {
        this.data = value;
    }

    @Override
    public String toString() {
        String out;
        if (this.isNull()) {
            if (Double.isNaN(this.data)) {
                String desc = ParameterInfoHelper.missingDescription(this.data);
                out = String.format("NaN:'%s'", desc);
            } else {
                out = "NULL";
            }
        } else {
            out = this.data == Double.POSITIVE_INFINITY ? "POSITIVE_INFINITY" : (this.data == Double.NEGATIVE_INFINITY ? "NEGATIVE_INFINITY" : Double.toString(this.data));
        }
        return out;
    }
}

