/*
 * Decompiled with CFR 0.152.
 */
package com.sas.tkts.types;

import com.sas.tkts.types.AbstractColumn;
import java.math.BigDecimal;
import java.sql.SQLException;

public abstract class NumberColumn
extends AbstractColumn {
    protected static Class dataClass;

    protected BigDecimal bigDecimalLong(long value) {
        if (this.isNull()) {
            return null;
        }
        BigDecimal out = new BigDecimal(value);
        return out;
    }

    protected BigDecimal bigDecimalDouble(long value) {
        if (this.isNull()) {
            return null;
        }
        BigDecimal out = new BigDecimal(value);
        return out;
    }

    protected boolean booleanDouble(double inTrunc) {
        int truncType;
        boolean out;
        if (this.isNull()) {
            inTrunc = 0.0;
        }
        if (inTrunc == 0.0) {
            out = false;
            truncType = 0;
        } else {
            out = true;
            truncType = inTrunc > 1.0 ? 1 : -1;
        }
        this.setDataTruncation((byte)truncType);
        return out;
    }

    protected boolean booleanLong(long inTrunc) {
        int truncType;
        boolean out;
        if (this.isNull()) {
            inTrunc = 0L;
        }
        if (inTrunc == 0L) {
            out = false;
            truncType = 0;
        } else {
            out = true;
            truncType = inTrunc > 1L ? 1 : -1;
        }
        this.setDataTruncation((byte)truncType);
        return out;
    }

    @Override
    public void cleanup() {
    }

    @Override
    public Object getRawData() throws SQLException {
        return this.getObject();
    }

    @Override
    public boolean isNull() {
        return !this.isUpdated();
    }

    private double rangedDouble(double dblIn, double min, double max) {
        if (dblIn < min) {
            this.setDataTruncation((byte)-1);
            double dblOut = min;
            return dblOut;
        }
        if (dblIn > max) {
            this.setDataTruncation((byte)1);
            double dblOut = max;
            return dblOut;
        }
        this.setDataTruncation((byte)0);
        return dblIn;
    }

    protected byte rangedDoubleToByte(double inValue) {
        double dblOut = this.rangedDouble(inValue, -128.0, 127.0);
        return (byte)dblOut;
    }

    protected short rangedDoubleToShort(double inValue) {
        double dblOut = this.rangedDouble(inValue, -32768.0, 32767.0);
        return (short)dblOut;
    }

    protected int rangedDoubleToInt(double inValue) {
        double dblOut = this.rangedDouble(inValue, -2.147483648E9, 2.147483647E9);
        return (int)dblOut;
    }

    protected long rangedDoubleToLong(double inValue) {
        double dblOut = this.rangedDouble(inValue, -9.223372036854776E18, 9.223372036854776E18);
        return (long)dblOut;
    }

    protected float rangedDoubleToFloat(double inValue) {
        double dblOut = this.rangedDouble(inValue, -3.4028234663852886E38, 3.4028234663852886E38);
        byte trunType = this.getDataTruncationType();
        float out = trunType == 0 ? (float)dblOut : (trunType == 1 ? Float.POSITIVE_INFINITY : Float.NEGATIVE_INFINITY);
        return out;
    }

    private long rangedLong(long value, long min, long max) {
        long out;
        this.setUpdated(true);
        if (value < min) {
            this.setDataTruncation((byte)-1);
            out = min;
        } else if (value > max) {
            this.setDataTruncation((byte)1);
            out = max;
        } else {
            this.setDataTruncation((byte)0);
            out = value;
        }
        return out;
    }

    protected byte rangedLongToByte(long inValue) {
        long dblOut = this.rangedLong(inValue, -128L, 127L);
        return (byte)dblOut;
    }

    protected short rangedLongToShort(long inValue) {
        long dblOut = this.rangedLong(inValue, -32768L, 32767L);
        return (short)dblOut;
    }

    protected int rangedLongToInt(long inValue) {
        long dblOut = this.rangedLong(inValue, Integer.MIN_VALUE, Integer.MAX_VALUE);
        return (int)dblOut;
    }
}

